from dataclasses import dataclass


@dataclass(frozen=True)
class ActionsEnum:
    BALANCE_HISTORY: str = "balancehistory"
    BALANCE_MULTI: str = "balancemulti"
    BALANCE: str = "balance"
    CHAIN_SIZE: str = "chainsize"
    DAILY_AVG_BLOCK_SIZE: str = "dailyavgblocksize"
    DAILY_AVG_BLOCK_TIME: str = "dailyavgblocktime"
    DAILY_AVG_GAS_LIMIT: str = "dailyavggaslimit"
    DAILY_AVG_GAS_PRICE: str = "dailyavggasprice"
    DAILY_AVG_HASH_RATE: str = "dailyavghashrate"
    DAILY_AVG_NET_DIFFICULTY: str = "dailyavgnetdifficulty"
    DAILY_BLK_COUNT: str = "dailyblkcount"
    DAILY_BLOCK_REWARDS: str = "dailyblockrewards"
    DAILY_GAS_USED: str = "dailygasused"
    DAILY_NET_UTILIZATION: str = "dailynetutilization"
    DAILY_NEW_ADDRESS: str = "dailynewaddress"
    DAILY_TX: str = "dailytx"
    DAILY_TXN_FEE: str = "dailytxnfee"
    DAILY_UNCLE_BLK_COUNT: str = "dailyuncleblkcount"
    ETH2_SUPPLY: str = "ethsupply2"
    ETH_BLOCK_NUMBER: str = "eth_blockNumber"
    ETH_CALL: str = "eth_call"
    ETH_DAILY_MARKET_CAP: str = "ethdailymarketcap"
    ETH_DAILY_PRICE: str = "ethdailyprice"
    ETH_ESTIMATE_GAS: str = "eth_estimateGas"
    ETH_GAS_PRICE: str = "eth_gasPrice"
    ETH_GET_BLOCK_BY_NUMBER: str = "eth_getBlockByNumber"
    ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER: str = (
        "eth_getBlockTransactionCountByNumber"
    )
    ETH_GET_CODE: str = "eth_getCode"
    ETH_GET_STORAGE_AT: str = "eth_getStorageAt"
    ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX: str = (
        "eth_getTransactionByBlockNumberAndIndex"
    )
    ETH_GET_TRANSACTION_BY_HASH: str = "eth_getTransactionByHash"
    ETH_GET_TRANSACTION_COUNT: str = "eth_getTransactionCount"
    ETH_GET_TRANSACTION_RECEIPT: str = "eth_getTransactionReceipt"
    ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX: str = "eth_getUncleByBlockNumberAndIndex"
    GAS_ESTIMATE: str = "gasestimate"
    GAS_ORACLE: str = "gasoracle"
    GET_ABI: str = "getabi"
    GET_BLOCK_COUNTDOWN: str = "getblockcountdown"
    GET_BLOCK_NUMBER_BY_TIME: str = "getblocknobytime"
    GET_BLOCK_REWARD: str = "getblockreward"
    GET_LOGS: str = "getLogs"
    GET_MINED_BLOCKS: str = "getminedblocks"
    GET_SOURCE_CODE: str = "getsourcecode"
    GET_STATUS: str = "getstatus"
    GET_TX_RECEIPT_STATUS: str = "gettxreceiptstatus"
    TOKEN_BALANCE_HISTORY: str = "tokenbalancehistory"
    TOKEN_BALANCE: str = "tokenbalance"
    TOKEN_CSUPPLY: str = "tokenCsupply"
    TOKEN_INFO: str = "tokeninfo"
    TOKEN_SUPPLY_HISTORY: str = "tokensupplyhistory"
    TOKEN_SUPPLY: str = "tokensupply"
    TOKENNFTTX: str = "tokennfttx"
    TOKENTX: str = "tokentx"
    TXLIST_INTERNAL: str = "txlistinternal"
    TXLIST: str = "txlist"
    VALIDATORS: str = "validators"
