"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticAstroSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const construct_1 = require("./construct");
class StaticAstroSite extends construct_1.AstroSiteConstruct {
    constructor(scope, id, props) {
        super(scope, id);
        const cfEnabled = props.cfOptions != undefined;
        const domains = [];
        this.bucket = this.newBucket(this, !cfEnabled, {
            indexhtml: props.indexhtml,
            errorhtml: props.errorhtml,
            cors: props.cors,
        });
        if (!cfEnabled) {
            domains.push(`http://${this.bucket.bucketWebsiteDomainName}`);
        }
        else {
            // add index.html in uri by default for subpaths
            const fn = new aws_cloudfront_1.Function(this, "RedirectToIndexFunction", {
                code: aws_cloudfront_1.FunctionCode.fromInline(`
          function handler(event) {
            var request = event.request
            if (request.uri.endsWith("/")) {
              request.uri += "${props.indexhtml ?? "index.html"}"
            } else if (!request.uri.includes(".")) {
              request.uri += "/${props.indexhtml ?? "index.html"}"
            }
            return request
          }
        `),
            });
            const defaultBehavior = {
                origin: this.newS3Origin(this, this.bucket),
                functionAssociations: [
                    {
                        eventType: aws_cloudfront_1.FunctionEventType.VIEWER_REQUEST,
                        function: fn,
                    },
                ],
            };
            this.distribution = this.newDistribution(this, defaultBehavior, props.cfOptions);
            domains.push(`https://${this.distribution.distributionDomainName}`);
            domains.push(`https://${props.cfOptions?.domain ?? ""}`);
        }
        new aws_s3_deployment_1.BucketDeployment(this, "BucketDeployment", {
            sources: [aws_s3_deployment_1.Source.asset(props.siteDir)],
            destinationBucket: this.bucket,
            distribution: this.distribution,
            distributionPaths: this.distribution == undefined ? undefined : ["/*"],
        });
        this.bucketArn = this.bucket.bucketArn;
        this.bucketName = this.bucket.bucketName;
        this.distributionId = this.distribution?.distributionId ?? "";
        this.domains = domains;
    }
}
exports.StaticAstroSite = StaticAstroSite;
_a = JSII_RTTI_SYMBOL_1;
StaticAstroSite[_a] = { fqn: "@astrojs-aws/construct.StaticAstroSite", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhdGljLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3RhdGljLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBTW1DO0FBRW5DLHFFQUF3RTtBQUd4RSwyQ0FBZ0Q7QUFHaEQsTUFBYSxlQUFnQixTQUFRLDhCQUFrQjtJQVFyRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUE7UUFFaEIsTUFBTSxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsSUFBSSxTQUFTLENBQUE7UUFDOUMsTUFBTSxPQUFPLEdBQUcsRUFBRSxDQUFBO1FBRWxCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxTQUFTLEVBQUU7WUFDN0MsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDakIsQ0FBQyxDQUFBO1FBRUYsSUFBSSxDQUFDLFNBQVMsRUFBRTtZQUNkLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsTUFBTSxDQUFDLHVCQUF1QixFQUFFLENBQUMsQ0FBQTtTQUM5RDthQUFNO1lBQ0wsZ0RBQWdEO1lBQ2hELE1BQU0sRUFBRSxHQUFHLElBQUkseUJBQVEsQ0FBQyxJQUFJLEVBQUUseUJBQXlCLEVBQUU7Z0JBQ3ZELElBQUksRUFBRSw2QkFBWSxDQUFDLFVBQVUsQ0FBQzs7OztnQ0FJTixLQUFLLENBQUMsU0FBUyxJQUFJLFlBQVk7O2lDQUU5QixLQUFLLENBQUMsU0FBUyxJQUFJLFlBQVk7Ozs7U0FJdkQsQ0FBQzthQUNILENBQUMsQ0FBQTtZQUVGLE1BQU0sZUFBZSxHQUFvQjtnQkFDdkMsTUFBTSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUM7Z0JBQzNDLG9CQUFvQixFQUFFO29CQUNwQjt3QkFDRSxTQUFTLEVBQUUsa0NBQWlCLENBQUMsY0FBYzt3QkFDM0MsUUFBUSxFQUFFLEVBQUU7cUJBQ2I7aUJBQ0Y7YUFDRixDQUFBO1lBQ0QsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsZUFBZSxDQUN0QyxJQUFJLEVBQ0osZUFBZSxFQUNmLEtBQUssQ0FBQyxTQUFTLENBQ2hCLENBQUE7WUFFRCxPQUFPLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxDQUFDLFlBQVksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDLENBQUE7WUFDbkUsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLEtBQUssQ0FBQyxTQUFTLEVBQUUsTUFBTSxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUE7U0FDekQ7UUFFRCxJQUFJLG9DQUFnQixDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUM3QyxPQUFPLEVBQUUsQ0FBQywwQkFBTSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDdEMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDOUIsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGlCQUFpQixFQUFFLElBQUksQ0FBQyxZQUFZLElBQUksU0FBUyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1NBQ3ZFLENBQUMsQ0FBQTtRQUVGLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUE7UUFDdEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQTtRQUN4QyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxZQUFZLEVBQUUsY0FBYyxJQUFJLEVBQUUsQ0FBQTtRQUM3RCxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQTtJQUN4QixDQUFDOztBQXBFSCwwQ0FxRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBCZWhhdmlvck9wdGlvbnMsXG4gIERpc3RyaWJ1dGlvbixcbiAgRnVuY3Rpb24sXG4gIEZ1bmN0aW9uQ29kZSxcbiAgRnVuY3Rpb25FdmVudFR5cGUsXG59IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWRmcm9udFwiXG5pbXBvcnQgeyBCdWNrZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXMzXCJcbmltcG9ydCB7IEJ1Y2tldERlcGxveW1lbnQsIFNvdXJjZSB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtczMtZGVwbG95bWVudFwiXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiXG5cbmltcG9ydCB7IEFzdHJvU2l0ZUNvbnN0cnVjdCB9IGZyb20gXCIuL2NvbnN0cnVjdFwiXG5pbXBvcnQgeyBTdGF0aWNBc3Ryb1NpdGVQcm9wcyB9IGZyb20gXCIuL3R5cGVzXCJcblxuZXhwb3J0IGNsYXNzIFN0YXRpY0FzdHJvU2l0ZSBleHRlbmRzIEFzdHJvU2l0ZUNvbnN0cnVjdCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgYnVja2V0OiBCdWNrZXRcbiAgcHJpdmF0ZSByZWFkb25seSBkaXN0cmlidXRpb24/OiBEaXN0cmlidXRpb25cbiAgcmVhZG9ubHkgYnVja2V0QXJuOiBzdHJpbmdcbiAgcmVhZG9ubHkgYnVja2V0TmFtZTogc3RyaW5nXG4gIHJlYWRvbmx5IGRpc3RyaWJ1dGlvbklkOiBzdHJpbmdcbiAgcmVhZG9ubHkgZG9tYWluczogc3RyaW5nW11cblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3RhdGljQXN0cm9TaXRlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpXG5cbiAgICBjb25zdCBjZkVuYWJsZWQgPSBwcm9wcy5jZk9wdGlvbnMgIT0gdW5kZWZpbmVkXG4gICAgY29uc3QgZG9tYWlucyA9IFtdXG5cbiAgICB0aGlzLmJ1Y2tldCA9IHRoaXMubmV3QnVja2V0KHRoaXMsICFjZkVuYWJsZWQsIHtcbiAgICAgIGluZGV4aHRtbDogcHJvcHMuaW5kZXhodG1sLFxuICAgICAgZXJyb3JodG1sOiBwcm9wcy5lcnJvcmh0bWwsXG4gICAgICBjb3JzOiBwcm9wcy5jb3JzLFxuICAgIH0pXG5cbiAgICBpZiAoIWNmRW5hYmxlZCkge1xuICAgICAgZG9tYWlucy5wdXNoKGBodHRwOi8vJHt0aGlzLmJ1Y2tldC5idWNrZXRXZWJzaXRlRG9tYWluTmFtZX1gKVxuICAgIH0gZWxzZSB7XG4gICAgICAvLyBhZGQgaW5kZXguaHRtbCBpbiB1cmkgYnkgZGVmYXVsdCBmb3Igc3VicGF0aHNcbiAgICAgIGNvbnN0IGZuID0gbmV3IEZ1bmN0aW9uKHRoaXMsIFwiUmVkaXJlY3RUb0luZGV4RnVuY3Rpb25cIiwge1xuICAgICAgICBjb2RlOiBGdW5jdGlvbkNvZGUuZnJvbUlubGluZShgXG4gICAgICAgICAgZnVuY3Rpb24gaGFuZGxlcihldmVudCkge1xuICAgICAgICAgICAgdmFyIHJlcXVlc3QgPSBldmVudC5yZXF1ZXN0XG4gICAgICAgICAgICBpZiAocmVxdWVzdC51cmkuZW5kc1dpdGgoXCIvXCIpKSB7XG4gICAgICAgICAgICAgIHJlcXVlc3QudXJpICs9IFwiJHtwcm9wcy5pbmRleGh0bWwgPz8gXCJpbmRleC5odG1sXCJ9XCJcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoIXJlcXVlc3QudXJpLmluY2x1ZGVzKFwiLlwiKSkge1xuICAgICAgICAgICAgICByZXF1ZXN0LnVyaSArPSBcIi8ke3Byb3BzLmluZGV4aHRtbCA/PyBcImluZGV4Lmh0bWxcIn1cIlxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHJlcXVlc3RcbiAgICAgICAgICB9XG4gICAgICAgIGApLFxuICAgICAgfSlcblxuICAgICAgY29uc3QgZGVmYXVsdEJlaGF2aW9yOiBCZWhhdmlvck9wdGlvbnMgPSB7XG4gICAgICAgIG9yaWdpbjogdGhpcy5uZXdTM09yaWdpbih0aGlzLCB0aGlzLmJ1Y2tldCksXG4gICAgICAgIGZ1bmN0aW9uQXNzb2NpYXRpb25zOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgZXZlbnRUeXBlOiBGdW5jdGlvbkV2ZW50VHlwZS5WSUVXRVJfUkVRVUVTVCxcbiAgICAgICAgICAgIGZ1bmN0aW9uOiBmbixcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgfVxuICAgICAgdGhpcy5kaXN0cmlidXRpb24gPSB0aGlzLm5ld0Rpc3RyaWJ1dGlvbihcbiAgICAgICAgdGhpcyxcbiAgICAgICAgZGVmYXVsdEJlaGF2aW9yLFxuICAgICAgICBwcm9wcy5jZk9wdGlvbnMsXG4gICAgICApXG5cbiAgICAgIGRvbWFpbnMucHVzaChgaHR0cHM6Ly8ke3RoaXMuZGlzdHJpYnV0aW9uLmRpc3RyaWJ1dGlvbkRvbWFpbk5hbWV9YClcbiAgICAgIGRvbWFpbnMucHVzaChgaHR0cHM6Ly8ke3Byb3BzLmNmT3B0aW9ucz8uZG9tYWluID8/IFwiXCJ9YClcbiAgICB9XG5cbiAgICBuZXcgQnVja2V0RGVwbG95bWVudCh0aGlzLCBcIkJ1Y2tldERlcGxveW1lbnRcIiwge1xuICAgICAgc291cmNlczogW1NvdXJjZS5hc3NldChwcm9wcy5zaXRlRGlyKV0sXG4gICAgICBkZXN0aW5hdGlvbkJ1Y2tldDogdGhpcy5idWNrZXQsXG4gICAgICBkaXN0cmlidXRpb246IHRoaXMuZGlzdHJpYnV0aW9uLFxuICAgICAgZGlzdHJpYnV0aW9uUGF0aHM6IHRoaXMuZGlzdHJpYnV0aW9uID09IHVuZGVmaW5lZCA/IHVuZGVmaW5lZCA6IFtcIi8qXCJdLFxuICAgIH0pXG5cbiAgICB0aGlzLmJ1Y2tldEFybiA9IHRoaXMuYnVja2V0LmJ1Y2tldEFyblxuICAgIHRoaXMuYnVja2V0TmFtZSA9IHRoaXMuYnVja2V0LmJ1Y2tldE5hbWVcbiAgICB0aGlzLmRpc3RyaWJ1dGlvbklkID0gdGhpcy5kaXN0cmlidXRpb24/LmRpc3RyaWJ1dGlvbklkID8/IFwiXCJcbiAgICB0aGlzLmRvbWFpbnMgPSBkb21haW5zXG4gIH1cbn1cbiJdfQ==