"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAstroSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const construct_1 = require("./construct");
class LambdaAstroSite extends construct_1.AstroSiteConstruct {
    constructor(scope, id, props) {
        super(scope, id);
        const cfEnabled = props.cfOptions != undefined;
        const domains = [];
        this.bucket = this.newBucket(this, !cfEnabled);
        this.function = this.newFunction(this, props.serverEntry, props.serverOptions);
        this.httpApi = this.newHttpApiGw(this, this.function, props.gwOptions);
        if (!cfEnabled) {
            domains.push(`http://${this.bucket.bucketWebsiteDomainName}`);
            // add http integration routes
            const routes = this.parseRoutesFromDir(props.staticDir);
            for (const [path, route] of Object.entries(routes)) {
                this.httpApi.addRoutes({
                    path: path,
                    methods: [aws_apigatewayv2_alpha_1.HttpMethod.GET],
                    integration: new aws_apigatewayv2_integrations_alpha_1.HttpUrlIntegration(path, `http://${this.bucket.bucketWebsiteDomainName}${route}`),
                });
            }
        }
        else {
            const defaultBehavior = {
                origin: this.newHttpApiGatewayOrigin(this.httpApi),
                cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_DISABLED,
            };
            this.distribution = this.newDistribution(this, defaultBehavior, props.cfOptions);
            const routes = this.parseRoutesFromDir(props.staticDir, true);
            for (const [path] of Object.entries(routes)) {
                this.distribution.addBehavior(path, this.newS3Origin(this, this.bucket));
            }
            domains.push(`https://${this.distribution.distributionDomainName}`);
            domains.push(`https://${props.cfOptions?.domain ?? ""}`);
        }
        new aws_s3_deployment_1.BucketDeployment(this, "BucketDeployment", {
            sources: [aws_s3_deployment_1.Source.asset(props.staticDir)],
            destinationBucket: this.bucket,
            distribution: this.distribution,
        });
        this.bucketArn = this.bucket.bucketArn;
        this.bucketName = this.bucket.bucketName;
        this.functionArn = this.function.functionArn;
        this.functionName = this.function.functionName;
        this.distributionId = this.distribution?.distributionId ?? "";
        this.domains = domains;
    }
}
exports.LambdaAstroSite = LambdaAstroSite;
_a = JSII_RTTI_SYMBOL_1;
LambdaAstroSite[_a] = { fqn: "@astrojs-aws/construct.LambdaAstroSite", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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