"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeAstroSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const construct_1 = require("./construct");
class EdgeAstroSite extends construct_1.AstroSiteConstruct {
    constructor(scope, id, props) {
        super(scope, id);
        const domains = [];
        this.function = this.newFunction(this, props.serverEntry, props.serverOptions);
        if (!(props.onlyLambda ?? false)) {
            this.bucket = this.newBucket(this, false);
            const defaultBehavior = {
                origin: this.newS3Origin(this, this.bucket),
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_ALL,
                edgeLambdas: [
                    {
                        eventType: aws_cloudfront_1.LambdaEdgeEventType.ORIGIN_REQUEST,
                        functionVersion: this.function.currentVersion,
                        includeBody: true,
                    },
                ],
            };
            this.distribution = this.newDistribution(this, defaultBehavior, props.cfOptions);
            new aws_s3_deployment_1.BucketDeployment(this, "BucketDeployment", {
                sources: [aws_s3_deployment_1.Source.asset(props.staticDir)],
                destinationBucket: this.bucket,
                distribution: this.distribution,
            });
            domains.push(`https://${this.distribution.distributionDomainName}`);
            domains.push(`https://${props.cfOptions?.domain ?? ""}`);
        }
        this.bucketArn = this.bucket?.bucketArn ?? "";
        this.bucketName = this.bucket?.bucketName ?? "";
        this.functionArn = this.function.functionArn;
        this.functionName = this.function.functionName;
        this.distributionId = this.distribution?.distributionId ?? "";
        this.domains = domains;
    }
}
exports.EdgeAstroSite = EdgeAstroSite;
_a = JSII_RTTI_SYMBOL_1;
EdgeAstroSite[_a] = { fqn: "@astrojs-aws/construct.EdgeAstroSite", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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