import { HttpApi } from "@aws-cdk/aws-apigatewayv2-alpha";
import { BehaviorOptions, Distribution } from "aws-cdk-lib/aws-cloudfront";
import { HttpOrigin, S3Origin } from "aws-cdk-lib/aws-cloudfront-origins";
import { Runtime } from "aws-cdk-lib/aws-lambda";
import { NodejsFunction } from "aws-cdk-lib/aws-lambda-nodejs";
import { Bucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
import { AssetsOptions, CfOptions, GwOptions, ServerOptions } from "./types";
/**
 * The base class for all constructs.
 */
export declare class AstroSiteConstruct extends Construct {
    constructor(scope: Construct, id: string);
    /**
     * New bucket.
     *
     * @param scope
     * @param whEnabled
     * @param props
     * @returns
     */
    newBucket(scope: Construct, whEnabled: boolean, props?: AssetsOptions): Bucket;
    /**
     * New nodejs function.
     *
     * @param scope
     * @param serverEntry
     * @param props
     * @returns
     */
    newFunction(scope: Construct, serverEntry: string, props?: ServerOptions): NodejsFunction;
    /**
     * New HttpApi Gateway.
     *
     * @param scope
     * @param fn
     * @param props
     * @returns
     */
    newHttpApiGw(scope: Construct, fn: NodejsFunction, props?: GwOptions): HttpApi;
    /**
     * New S3 origin.
     * @param scope
     * @param bucket
     * @returns
     */
    newS3Origin(scope: Construct, bucket: Bucket): S3Origin;
    /**
     * New HttpApi Gateway origin.
     *
     * @param httpApi
     * @returns
     */
    newHttpApiGatewayOrigin(httpApi: HttpApi): HttpOrigin;
    /**
     * New CloudFront distribution.
     *
     * @param scope
     * @param defaultBehavior
     * @param props
     */
    newDistribution(scope: Construct, defaultBehavior: BehaviorOptions, props?: CfOptions): Distribution;
    /**
     * Transform string to Runtime.
     *
     * @param str
     * @returns
     * @default Runtime.NODEJS_18_X
     */
    strToRuntime(str?: string): Runtime;
    /**
     * Parse routes from directory.
     * if the item is directory will parse to {"/item/*": "/item/*"} or {"/item/{proxy+}": "/item/{proxy}"}
     * if the item is file will parse to {"/item": "/item"}
     *
     * @param dir
     * @param isCf CloudFront route or not, HttpApi Gateway route by defauly, default false
     * @returns
     */
    parseRoutesFromDir(dir: string, isCf?: boolean): {
        [key: string]: string;
    };
}
