# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
AgentKit Client Module

Provides base client infrastructure for all AgentKit and Volcengine services.
"""

from agentkit.client.base_service_client import BaseServiceClient, ApiConfig
from agentkit.client.base_agentkit_client import BaseAgentkitClient
from agentkit.client.base_iam_client import BaseIAMClient

__all__ = [
    'BaseServiceClient',
    'BaseAgentkitClient',
    'BaseIAMClient',
    'ApiConfig',
]
