# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-04-26 16:45
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Keyword',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=50, verbose_name='Keywords')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=50, verbose_name='Resource Title')),
                ('shortdesc', models.TextField(blank=True, null=True)),
                ('longdesc', models.TextField(blank=True, null=True)),
                ('img', models.URLField(blank=True, null=True, verbose_name='Illustration')),
                ('document', models.URLField(blank=True, null=True, verbose_name='Document')),
                ('link', models.CharField(blank=True, max_length=150, null=True, verbose_name='Internet link')),
                ('keywords', models.ManyToManyField(blank=True, to='djangoldp_resource.Keyword')),
            ],
        ),
        migrations.CreateModel(
            name='Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('name', models.CharField(max_length=50, verbose_name='Resource type')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.AddField(
            model_name='resource',
            name='type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='djangoldp_resource.Type', verbose_name='Resource type'),
        ),
    ]
