SITUATION_TEMPLATES = {
    "hiring": {
        "name": "AI Hiring System",
        "questions": {
            "G": [
                "Who is responsible for overseeing this AI hiring system?",
                "What governance policies are in place for AI decisions?",
                "How often are hiring algorithms audited?"
            ],
            "U": [
                "Can candidates understand why they were rejected?",
                "Are the hiring criteria clearly explained to applicants?",
                "How transparent is the AI decision-making process?"
            ],
            "I": [
                "How do you ensure data quality in candidate assessments?",
                "What measures prevent manipulation of the hiring system?",
                "How consistent is the AI across different hiring managers?"
            ],
            "D": [
                "Are candidates informed when AI is used in hiring?",
                "What information is disclosed about the AI system?",
                "How are system limitations communicated?"
            ],
            "E": [
                "How do you test for gender/racial bias in hiring?",
                "What safeguards ensure fair treatment of all candidates?",
                "How do you handle appeals from rejected candidates?"
            ]
        }
    },
    "healthcare": {
        "name": "AI Medical Diagnosis",
        "questions": {
            "G": [
                "Who oversees the AI medical diagnosis system?",
                "What regulatory compliance measures are in place?",
                "How are medical AI errors handled and reported?"
            ],
            "U": [
                "Can doctors understand the AI's diagnostic reasoning?",
                "How are diagnosis explanations provided to medical staff?",
                "What training do healthcare providers receive about the AI?"
            ],
            "I": [
                "How is patient data quality ensured?",
                "What validation processes verify diagnosis accuracy?",
                "How do you maintain system reliability in emergencies?"
            ],
            "D": [
                "Are patients informed when AI assists in diagnosis?",
                "What diagnostic confidence levels are disclosed?",
                "How are system limitations communicated to patients?"
            ],
            "E": [
                "How do you ensure the AI works for diverse patient populations?",
                "What testing ensures no demographic bias in diagnoses?",
                "How is equitable access to AI diagnostics maintained?"
            ]
        }
    },
    "finance": {
        "name": "AI Loan Approval",
        "questions": {
            "G": [
                "What governance framework oversees loan approval AI?",
                "How are financial regulatory requirements implemented?",
                "What escalation process exists for disputed decisions?"
            ],
            "U": [
                "Can applicants understand loan rejection reasons?",
                "How transparent are the credit scoring criteria?",
                "What explanations are provided for borderline cases?"
            ],
            "I": [
                "How is financial data accuracy verified?",
                "What prevents gaming of the loan approval system?",
                "How consistent is the AI across different regions?"
            ],
            "D": [
                "Are applicants clearly informed about AI involvement?",
                "What loan criteria and weightings are disclosed?",
                "How are approval probabilities communicated?"
            ],
            "E": [
                "How do you test for bias across income levels?",
                "What ensures fair access to credit for marginalized groups?",
                "How are algorithmic fairness metrics monitored?"
            ]
        }
    },
    "custom": {
        "name": "Custom AI System",
        "questions": {
            "G": [
                "What governance structure oversees your AI system?",
                "Who is accountable for AI decisions and outcomes?",
                "What audit processes ensure ongoing compliance?"
            ],
            "U": [
                "How do users understand the AI's decision process?",
                "What explanations are provided for AI outcomes?",
                "How transparent is the system to stakeholders?"
            ],
            "I": [
                "How do you ensure data quality and system reliability?",
                "What prevents manipulation or gaming of the system?",
                "How consistent is the AI across different scenarios?"
            ],
            "D": [
                "How do you inform users about AI involvement?",
                "What system capabilities and limitations are disclosed?",
                "How transparent are the decision criteria?"
            ],
            "E": [
                "How do you test for bias across user groups?",
                "What ensures fair treatment of all users?",
                "How do you monitor for disparate impacts?"
            ]
        }
    }
}