﻿"""
GUIDE AI Ethics Framework

G - Governance
U - Understanding
I - Integrity
D - Disclosure
E - Equity

This package provides:
- Ethical AI Audit Tools
- Governance + Compliance Auditing
- Explainability (XAI) & Transparency Tools
"""

__version__ = "1.0.8"
__author__ = "GUIDE Ethics Team"

# Ethical AI Audit Tools
from .auditor import EthicalAIAudit

# Explainability (XAI)
from .xai_meaning import ExplainabilityGuide

__all__ = [
    "EthicalAIAudit",
    "ExplainabilityGuide",
]
