"""
Sphinx Directives to process Robotframework doc strings
"""
from pathlib import Path
from typing import List

from sphinx.application import Sphinx
from sphinx.builders import Builder
from sphinx.util.fileutil import copy_asset_file
from sphinx.util.typing import ExtensionMetadata

from .rf_test_doc import RfTestDoc

__version__ = "0.0.7"


def copy_asset_files(app: Sphinx, builder: Builder):
    """_summary_

    Args:
        app (Sphinx): _description_
        exc (Exception): _description_
    """
    if builder.format == 'html':
        css_file = "rf2s.css"
        src_css = Path(__file__).parent.absolute() / "static" / css_file
        # In outdir this is always '_static'!
        # Independant of html_static_path in conf.py
        dst_css = Path(app.outdir) / "_static" / css_file
        dst_css.parent.mkdir(parents=True, exist_ok=True)
        copy_asset_file(src_css, dst_css, force=True)


def setup(app: Sphinx) -> ExtensionMetadata:
    """_summary_

    Args:
        app (Sphinx): _description_

    Returns:
        ExtensionMetadata: _description_
    """

    app.connect('write-started', copy_asset_files)

    app.add_directive('rf-testdoc', RfTestDoc)
    app.add_config_value('rf_test_doc_root', str, '')
    app.add_config_value('rf_test_doc_root_url', str, '')
    app.add_config_value('rf_test_highligth_tags', list, '')
    app.add_css_file("rf2s.css")

    return {
        'version': '0.1',
        'parallel_read_safe': True,
        'parallel_write_safe': True,
    }
