# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union, Iterable, Optional
from typing_extensions import Literal, Required, Annotated, TypeAlias, TypedDict

from .._utils import PropertyInfo

__all__ = [
    "PromptCreateParams",
    "Message",
    "MessageContent",
    "MessageContentTextContentBlock",
    "MessageContentImageBase64ContentBlock",
    "MessageContentToolCallContentBlock",
    "MessageContentToolCallContentBlockToolCall",
    "MessageContentToolCallContentBlockToolCallFunction",
    "MessageContentToolResultContentBlock",
    "Parameters",
    "Tool",
]


class PromptCreateParams(TypedDict, total=False):
    messages: Required[Iterable[Message]]

    name: Required[str]

    parameters: Required[Parameters]

    tools: Required[Iterable[Tool]]


class MessageContentTextContentBlock(TypedDict, total=False):
    text: Required[str]

    type: Required[Literal["TEXT"]]


class MessageContentImageBase64ContentBlock(TypedDict, total=False):
    image_base64: Required[Annotated[str, PropertyInfo(alias="imageBase64")]]

    media_type: Required[Annotated[str, PropertyInfo(alias="mediaType")]]

    type: Required[Literal["IMAGE_BASE64"]]


class MessageContentToolCallContentBlockToolCallFunction(TypedDict, total=False):
    arguments: Required[str]
    """
    The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """

    name: Required[str]
    """The name of the function to call."""


class MessageContentToolCallContentBlockToolCall(TypedDict, total=False):
    function: Required[MessageContentToolCallContentBlockToolCallFunction]

    tool_call_id: Required[Annotated[str, PropertyInfo(alias="toolCallId")]]
    """TOOL_CALL_1"""

    type: Required[Literal["function"]]
    """The type of the tool. Currently, only `function` is supported."""


class MessageContentToolCallContentBlock(TypedDict, total=False):
    tool_call: Required[Annotated[MessageContentToolCallContentBlockToolCall, PropertyInfo(alias="toolCall")]]

    type: Required[Literal["TOOL_CALL"]]


class MessageContentToolResultContentBlock(TypedDict, total=False):
    result: Required[str]

    tool_call_id: Required[Annotated[str, PropertyInfo(alias="toolCallId")]]

    type: Required[Literal["TOOL_RESULT"]]


MessageContent: TypeAlias = Union[
    MessageContentTextContentBlock,
    MessageContentImageBase64ContentBlock,
    MessageContentToolCallContentBlock,
    MessageContentToolResultContentBlock,
]


class Message(TypedDict, total=False):
    content: Required[Iterable[MessageContent]]

    prompt_message_id: Required[Annotated[str, PropertyInfo(alias="promptMessageId")]]

    role: Required[Literal["assistant", "system", "tool", "user"]]


class Parameters(TypedDict, total=False):
    frequency_penalty: Required[Annotated[float, PropertyInfo(alias="frequencyPenalty")]]
    """Example: 0"""

    max_tokens: Required[Annotated[Optional[float], PropertyInfo(alias="maxTokens")]]
    """Example: 100"""

    name: Required[str]
    """The name of the model for the provider."""

    parallel_tool_calls: Required[Annotated[bool, PropertyInfo(alias="parallelToolCalls")]]

    presence_penalty: Required[Annotated[float, PropertyInfo(alias="presencePenalty")]]
    """Example: 0"""

    provider: Required[Literal["ANTHROPIC", "OPENAI"]]
    """The LLM model provider."""

    response_format: Required[Annotated[Literal["JSON", "TEXT"], PropertyInfo(alias="responseFormat")]]
    """Example: PromptResponseFormat.TEXT"""

    seed: Required[Optional[float]]
    """Example: 97946543"""

    stream: Required[bool]

    temperature: Required[float]
    """Example: 1"""

    tool_choice: Required[Annotated[Optional[str], PropertyInfo(alias="toolChoice")]]

    top_k: Required[Annotated[Optional[float], PropertyInfo(alias="topK")]]
    """Example: 50"""

    top_p: Required[Annotated[float, PropertyInfo(alias="topP")]]
    """Example: 1"""


class Tool(TypedDict, total=False):
    tool_id: Required[Annotated[str, PropertyInfo(alias="toolId")]]
