# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union, Iterable, Optional
from typing_extensions import Literal, Required, Annotated, TypeAlias, TypedDict

from .._utils import PropertyInfo

__all__ = [
    "EvaluationCreateParams",
    "AppendedMessage",
    "AppendedMessageContent",
    "AppendedMessageContentTextContentBlock",
    "AppendedMessageContentImageBase64ContentBlock",
    "AppendedMessageContentToolCallContentBlock",
    "AppendedMessageContentToolCallContentBlockToolCall",
    "AppendedMessageContentToolCallContentBlockToolCallFunction",
    "AppendedMessageContentToolResultContentBlock",
]


class EvaluationCreateParams(TypedDict, total=False):
    appended_messages: Required[Annotated[Iterable[AppendedMessage], PropertyInfo(alias="appendedMessages")]]
    """The messages to append to the completion messages when running the evaluation."""

    prompt_id: Required[Annotated[str, PropertyInfo(alias="promptId")]]

    variables: Required[Dict[str, Optional[str]]]
    """The template variables added to the prompt when executing the prompt."""

    threshold: float
    """What percentage of assertions must pass for the evaluation to pass."""

    weight: float
    """How heavily to weigh the evaluation within the prompt."""


class AppendedMessageContentTextContentBlock(TypedDict, total=False):
    text: Required[str]

    type: Required[Literal["TEXT"]]


class AppendedMessageContentImageBase64ContentBlock(TypedDict, total=False):
    image_base64: Required[Annotated[str, PropertyInfo(alias="imageBase64")]]

    media_type: Required[Annotated[str, PropertyInfo(alias="mediaType")]]

    type: Required[Literal["IMAGE_BASE64"]]


class AppendedMessageContentToolCallContentBlockToolCallFunction(TypedDict, total=False):
    arguments: Required[str]
    """
    The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """

    name: Required[str]
    """The name of the function to call."""


class AppendedMessageContentToolCallContentBlockToolCall(TypedDict, total=False):
    function: Required[AppendedMessageContentToolCallContentBlockToolCallFunction]

    tool_call_id: Required[Annotated[str, PropertyInfo(alias="toolCallId")]]
    """TOOL_CALL_1"""

    type: Required[Literal["function"]]
    """The type of the tool. Currently, only `function` is supported."""


class AppendedMessageContentToolCallContentBlock(TypedDict, total=False):
    tool_call: Required[Annotated[AppendedMessageContentToolCallContentBlockToolCall, PropertyInfo(alias="toolCall")]]

    type: Required[Literal["TOOL_CALL"]]


class AppendedMessageContentToolResultContentBlock(TypedDict, total=False):
    result: Required[str]

    tool_call_id: Required[Annotated[str, PropertyInfo(alias="toolCallId")]]

    type: Required[Literal["TOOL_RESULT"]]


AppendedMessageContent: TypeAlias = Union[
    AppendedMessageContentTextContentBlock,
    AppendedMessageContentImageBase64ContentBlock,
    AppendedMessageContentToolCallContentBlock,
    AppendedMessageContentToolResultContentBlock,
]


class AppendedMessage(TypedDict, total=False):
    content: Required[Iterable[AppendedMessageContent]]

    role: Required[Literal["assistant", "system", "tool", "user"]]
