# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Dict, List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from pydantic import Field as FieldInfo

from .._utils import PropertyInfo
from .._models import BaseModel

__all__ = [
    "Evaluation",
    "AppendedMessage",
    "AppendedMessageContent",
    "AppendedMessageContentTextContentBlock",
    "AppendedMessageContentImageBase64ContentBlock",
    "AppendedMessageContentToolCallContentBlock",
    "AppendedMessageContentToolCallContentBlockToolCall",
    "AppendedMessageContentToolCallContentBlockToolCallFunction",
    "AppendedMessageContentToolResultContentBlock",
]


class AppendedMessageContentTextContentBlock(BaseModel):
    text: str

    type: Literal["TEXT"]


class AppendedMessageContentImageBase64ContentBlock(BaseModel):
    image_base64: str = FieldInfo(alias="imageBase64")

    media_type: str = FieldInfo(alias="mediaType")

    type: Literal["IMAGE_BASE64"]


class AppendedMessageContentToolCallContentBlockToolCallFunction(BaseModel):
    arguments: str
    """
    The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """

    name: str
    """The name of the function to call."""


class AppendedMessageContentToolCallContentBlockToolCall(BaseModel):
    function: AppendedMessageContentToolCallContentBlockToolCallFunction

    tool_call_id: str = FieldInfo(alias="toolCallId")
    """TOOL_CALL_1"""

    type: Literal["function"]
    """The type of the tool. Currently, only `function` is supported."""


class AppendedMessageContentToolCallContentBlock(BaseModel):
    tool_call: AppendedMessageContentToolCallContentBlockToolCall = FieldInfo(alias="toolCall")

    type: Literal["TOOL_CALL"]


class AppendedMessageContentToolResultContentBlock(BaseModel):
    result: str

    tool_call_id: str = FieldInfo(alias="toolCallId")

    type: Literal["TOOL_RESULT"]


AppendedMessageContent: TypeAlias = Annotated[
    Union[
        AppendedMessageContentTextContentBlock,
        AppendedMessageContentImageBase64ContentBlock,
        AppendedMessageContentToolCallContentBlock,
        AppendedMessageContentToolResultContentBlock,
    ],
    PropertyInfo(discriminator="type"),
]


class AppendedMessage(BaseModel):
    content: List[AppendedMessageContent]

    role: Literal["assistant", "system", "tool", "user"]


class Evaluation(BaseModel):
    id: str

    appended_messages: List[AppendedMessage] = FieldInfo(alias="appendedMessages")
    """The messages to append to the completion messages when running the evaluation."""

    prompt_id: str = FieldInfo(alias="promptId")

    variables: Dict[str, Optional[str]]
    """The template variables added to the prompt when executing the prompt."""

    threshold: Optional[float] = None
    """What percentage of assertions must pass for the evaluation to pass."""

    weight: Optional[float] = None
    """How heavily to weigh the evaluation within the prompt."""
