from psql_partition.compiler import (
    SQLAggregateCompiler,
    SQLCompiler,
    SQLDeleteCompiler,
    SQLInsertCompiler,
    SQLUpdateCompiler,
)

from . import base_impl


class PostgresOperations(base_impl.operations()):  # type: ignore[misc]
    """Simple operations specific to PostgreSQL."""

    compiler_module = "psql_partition.compiler"

    compiler_classes = [
        SQLCompiler,
        SQLDeleteCompiler,
        SQLAggregateCompiler,
        SQLUpdateCompiler,
        SQLInsertCompiler,
    ]
