/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.tm;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.n3.l8;
import com.aspose.slides.internal.tm.av;
import com.aspose.slides.internal.tm.i5;
import com.aspose.slides.internal.tm.se;
import com.aspose.slides.ms.System.eh;
import com.aspose.slides.ms.System.gv;
import com.aspose.slides.ms.System.q5;
import java.io.File;

public class ry
extends i5 {
    private boolean ua = false;
    private boolean yg;
    private boolean qa;
    private boolean l8;
    private l8 lx;
    private final String ec;

    public ry(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private ry(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.ec = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (gv.yg(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.qa = false;
            this.yg = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.qa = true;
            this.yg = false;
            string2 = "rw";
        } else {
            this.qa = true;
            this.yg = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(gv.ua("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{eh.getName(av.class, n10), eh.getName(se.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(gv.ua("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{eh.getName(av.class, n10), eh.getName(se.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.lx = bl2 ? new l8(file, string2, n) : new l8(file, string2);
            if (n10 == 6) {
                this.lx.ua(this.lx.l8());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.lx = new l8(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.lx = new l8(file, string2);
                this.lx.ua(true);
            } else {
                this.lx = new l8(file, string2);
            }
        }
        this.l8 = true;
    }

    public ry(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public ry(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public ry(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.yg;
    }

    @Override
    public boolean canSeek() {
        return this.l8;
    }

    @Override
    public boolean canWrite() {
        return this.qa;
    }

    @Override
    public long getLength() {
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.lx.l8();
    }

    @Override
    public long getPosition() {
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.lx.qa();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.lx.ua(position);
    }

    @Override
    public void flush() {
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.lx.lx();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.lx.ua(offset);
                break;
            }
            case 1: {
                this.lx.ua(this.lx.qa() + offset);
                break;
            }
            case 2: {
                this.lx.ua(this.lx.l8() + offset);
            }
        }
        return this.lx.qa();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.lx != null && !this.lx.yg()) {
                this.lx.ua();
            }
        }
        finally {
            this.yg = false;
            this.qa = false;
            this.l8 = false;
            super.dispose(disposing);
            this.ua = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.qa) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lx.qa(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.yg) {
            int n = this.lx.yg(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.yg) {
            return this.lx.ec();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.qa) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lx.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.qa) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.lx.write(value);
    }

    public String ua() {
        return this.ec;
    }

    @Override
    public q5 beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.se callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(q5 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public q5 beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.se userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.ua) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(q5 asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

