/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IChartDataPoint;
import com.aspose.slides.IChartDataPointCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.IPieSplitCustomPointCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.m1.qa;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.gv;

public class PieSplitCustomPointCollection
implements IPieSplitCustomPointCollection {
    private final IChartSeriesGroup ua;
    private final List<IChartDataPoint> yg;

    @Override
    public final IChartDataPoint get_Item(int index) {
        return this.yg.get_Item(index);
    }

    @Override
    public final void add(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.ua.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(gv.ua("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        IChartDataPoint iChartDataPoint = iChartDataPointCollection.get_Item(dataPointIndex);
        if (this.yg.containsItem(iChartDataPoint)) {
            throw new ArgumentException("Data point is already added");
        }
        this.yg.addItem(iChartDataPoint);
    }

    @Override
    public void addItem(IChartDataPoint dataPoint) {
        this.ua(dataPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ua(IChartDataPoint iChartDataPoint) {
        IChartDataPointCollection iChartDataPointCollection = this.ua.get_Item(0).getDataPoints();
        IGenericEnumerator iGenericEnumerator = iChartDataPointCollection.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataPoint iChartDataPoint2 = (IChartDataPoint)iGenericEnumerator.next();
                if (iChartDataPoint2 != iChartDataPoint) continue;
                this.yg.addItem(iChartDataPoint);
                return;
            }
        }
        finally {
            if (qa.ua(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException("Coudn't find dataPoint in parent series. Allowed adding dataPoint only from same chart and parent series");
    }

    @Override
    public boolean removeItem(IChartDataPoint dataPoint) {
        return this.yg(dataPoint);
    }

    final boolean yg(IChartDataPoint iChartDataPoint) {
        return this.yg.removeItem(iChartDataPoint);
    }

    @Override
    public final void remove(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.ua.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(gv.ua("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        this.yg.removeItem(iChartDataPointCollection.get_Item(dataPointIndex));
    }

    @Override
    public final void clear() {
        this.yg.clear();
    }

    @Override
    public boolean containsItem(IChartDataPoint item) {
        return this.qa(item);
    }

    final boolean qa(IChartDataPoint iChartDataPoint) {
        return this.yg.containsItem(iChartDataPoint);
    }

    public void copyToTArray(IChartDataPoint[] array, int arrayIndex) {
        this.ua(array, arrayIndex);
    }

    final void ua(IChartDataPoint[] iChartDataPointArray, int n) {
        this.yg.copyToTArray((IChartDataPoint[])iChartDataPointArray, n);
    }

    @Override
    public final int size() {
        return this.yg.size();
    }

    @Override
    public final boolean isReadOnly() {
        return this.yg.isReadOnly();
    }

    public final boolean isSynchronized() {
        return false;
    }

    public final Object getSyncRoot() {
        return this;
    }

    @Override
    public final IGenericEnumerator<IChartDataPoint> iterator() {
        return this.yg.iterator();
    }

    public final IGenericEnumerator<IChartDataPoint> iteratorJava() {
        return this.yg.iteratorJava();
    }

    PieSplitCustomPointCollection(IChartSeriesGroup parentSeriesGroup) {
        this.ua = parentSeriesGroup;
        this.yg = new List();
    }
}

