/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.FontFallBackRulesCollection;
import com.aspose.slides.IFontFallBackRule;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.m1.qa;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.gv;
import com.aspose.slides.np;

public class FontFallBackRule
implements IFontFallBackRule {
    private long ua;
    private long yg = 0L;
    private long qa = 0L;
    private List<np> l8 = null;
    private List<FontFallBackRulesCollection> lx = new List();

    FontFallBackRule(long startIndex, long endIndex) {
        this.yg = startIndex;
        this.qa = endIndex;
        this.lx();
        this.l8 = new List();
        this.ua(0L);
    }

    public FontFallBackRule(long startIndex, long endIndex, String fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    public FontFallBackRule(long startIndex, long endIndex, String[] fontNames) {
        this(startIndex, endIndex);
        this.addFallBackFonts(fontNames);
    }

    @Override
    public final void addFallBackFonts(String fontName) {
        String[] stringArray;
        if (gv.ua(gv.yg(fontName))) {
            throw new ArgumentException("Empty name of the font can't be added to list!");
        }
        for (String string : stringArray = gv.ec(fontName, ',')) {
            np np2 = new np(gv.yg(string));
            this.l8.addItem(np2);
            this.ec();
        }
    }

    @Override
    public final void addFallBackFonts(String[] fontNames) {
        if (fontNames == null) {
            throw new ArgumentNullException("fontNames", "Any fonts weren't defined for fall back range!");
        }
        for (String string : fontNames) {
            this.addFallBackFonts(string);
        }
    }

    @Override
    public final long getRangeStartIndex() {
        return this.yg;
    }

    public final void setRangeStartIndex(long value) {
        if ((this.yg & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.yg = value;
            this.lx();
            this.ec();
        }
    }

    @Override
    public final long getRangeEndIndex() {
        return this.qa;
    }

    public final void setRangeEndIndex(long value) {
        if ((this.qa & 0xFFFFFFFFL) != (value & 0xFFFFFFFFL)) {
            this.qa = value;
            this.lx();
            this.ec();
        }
    }

    @Override
    public final int getCount() {
        return this.l8.size();
    }

    @Override
    public final String get_Item(int index) {
        return this.l8.get_Item(index).ua();
    }

    @Override
    public final void clear() {
        if (this.l8.size() == 0) {
            return;
        }
        this.l8.clear();
        this.ec();
    }

    @Override
    public final void remove(String fontName) {
        int n = this.indexOf(fontName);
        if (n < 0) {
            return;
        }
        this.l8.removeAt(n);
        this.ec();
    }

    @Override
    public final void removeAt(int index) {
        if (index < 0 || index >= this.l8.size()) {
            throw new ArgumentOutOfRangeException("index", "The target index is out of range!");
        }
        this.l8.removeAt(index);
        this.ec();
    }

    @Override
    public final String[] toArray() {
        int n = this.l8.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.l8.get_Item(i).ua();
        }
        return stringArray;
    }

    @Override
    public final String[] toArray(int startIndex, int count) {
        int n = this.l8.size();
        if (startIndex < 0 || startIndex >= n) {
            throw new ArgumentOutOfRangeException("startIndex", "The startIndex index is out of range!");
        }
        if (count < 1) {
            throw new ArgumentOutOfRangeException("count", "The defined length of the out array must be greater then zero!");
        }
        if (startIndex + count > n) {
            throw new ArgumentException("The demanded part of fonts is out of range!");
        }
        String[] stringArray = new String[count];
        for (int i = 0; i < count; ++i) {
            stringArray[i] = this.l8.get_Item(startIndex + i).ua();
        }
        return stringArray;
    }

    @Override
    public final int indexOf(String fontName) {
        if (gv.ua(fontName)) {
            throw new ArgumentException("Font's name doesn't specified!");
        }
        String string = gv.yg(fontName);
        for (int i = 0; i < this.l8.size(); ++i) {
            if (!gv.lx(this.l8.get_Item(i).ua(), string)) continue;
            return i;
        }
        return -1;
    }

    FontFallBackRule(long startIndex, long endIndex, FontFallBackRule sourceFallBackRule) {
        this(startIndex, endIndex);
        if (sourceFallBackRule.l8.size() > 0) {
            this.l8.addRange(sourceFallBackRule.l8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ua(np np2, boolean bl2) {
        if (np2 == null) {
            throw new ArgumentNullException("sourceFallBackFontContext", "Font's context doesn't specified!");
        }
        if (bl2) {
            IGenericEnumerator iGenericEnumerator = this.l8.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    np np3 = (np)iGenericEnumerator.next();
                    if (np2 != np3) continue;
                    return;
                }
            }
            finally {
                if (com.aspose.slides.internal.m1.qa.ua(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        this.l8.addItem(np2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ua(FontFallBackRule fontFallBackRule, boolean bl2) {
        if (fontFallBackRule == null) {
            return;
        }
        IGenericEnumerator iGenericEnumerator = fontFallBackRule.l8.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                np np2 = (np)iGenericEnumerator.next();
                this.ua(np2, bl2);
            }
        }
        finally {
            if (com.aspose.slides.internal.m1.qa.ua(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private void lx() {
        if ((this.yg & 0xFFFFFFFFL) > (this.qa & 0xFFFFFFFFL)) {
            throw new ArgumentException("End index must be equal or greater than start index!");
        }
    }

    final List<np> ua() {
        return this.l8;
    }

    final long yg() {
        return this.ua;
    }

    final void ua(long l) {
        this.ua = l;
    }

    private void ec() {
        IGenericEnumerator iGenericEnumerator = this.lx.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                FontFallBackRulesCollection fontFallBackRulesCollection = (FontFallBackRulesCollection)iGenericEnumerator.next();
                fontFallBackRulesCollection.ua();
            }
        }
        finally {
            if (com.aspose.slides.internal.m1.qa.ua(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    final void ua(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (!this.lx.containsItem(fontFallBackRulesCollection)) {
            this.lx.addItem(fontFallBackRulesCollection);
        }
    }

    final void yg(FontFallBackRulesCollection fontFallBackRulesCollection) {
        if (fontFallBackRulesCollection == null) {
            return;
        }
        if (this.lx.containsItem(fontFallBackRulesCollection)) {
            this.lx.removeItem(fontFallBackRulesCollection);
        }
    }

    final void qa() {
        this.lx.clear();
        this.lx = null;
        this.l8.clear();
        this.l8 = null;
    }

    final void l8() {
        IGenericEnumerator iGenericEnumerator = this.l8.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                np np2 = (np)iGenericEnumerator.next();
                np2.ua(false);
            }
        }
        finally {
            if (com.aspose.slides.internal.m1.qa.ua(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

