/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import com.aspose.slides.ms.System.pb;
import java.util.Arrays;

@nz
public class Stack
implements ICollection,
IEnumerable,
az {
    private Object[] ua;
    private int yg = -1;
    private int qa;
    private int l8;
    private int lx;

    private void ua(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, objectArray, 0, this.qa);
        this.l8 = n;
        this.ua = objectArray;
    }

    public Stack() {
        this.ua = new Object[16];
        this.l8 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.l8 = initialCapacity;
        this.ua = new Object[this.l8];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.qa;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.lx;
        for (int i = 0; i < this.qa; ++i) {
            this.ua[i] = null;
        }
        this.qa = 0;
        this.yg = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.l8.ua(this.ua));
        stack.yg = this.yg;
        stack.qa = this.qa;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.qa == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.qa; ++i) {
                if (this.ua[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.qa; ++i) {
                if (!obj.equals(this.ua[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(l8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.l8() > 1 || array.lx() > 0 && index >= array.lx() || this.qa > array.lx() - index) {
            throw new ArgumentException();
        }
        for (int i = this.yg; i != -1; --i) {
            array.qa(this.ua[i], this.qa - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.yg == -1) {
            throw new InvalidOperationException();
        }
        return this.ua[this.yg];
    }

    public Object pop() {
        if (this.yg == -1) {
            throw new InvalidOperationException();
        }
        ++this.lx;
        Object object = this.ua[this.yg];
        this.ua[this.yg] = null;
        --this.qa;
        --this.yg;
        if (this.qa <= this.l8 / 4 && this.qa > 16) {
            this.ua(this.l8 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.lx;
        if (this.l8 == this.qa) {
            this.ua(this.l8 * 2);
        }
        ++this.qa;
        ++this.yg;
        this.ua[this.yg] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.qa) {
            a = Arrays.copyOf(this.ua, this.qa, a.getClass());
            pb.ua(a);
            return a;
        }
        System.arraycopy(this.ua, 0, a, 0, this.qa);
        if (a.length > this.qa) {
            a[this.qa] = null;
        }
        pb.ua(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    az,
    Cloneable {
        private Stack ua;
        private int yg;
        private int qa;

        Enumerator(Stack s) {
            this.ua = s;
            this.yg = s.lx;
            this.qa = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.ua();
        }

        @Override
        public Object next() {
            if (this.yg != this.ua.lx || this.qa == -2 || this.qa == -1 || this.qa > this.ua.qa) {
                throw new InvalidOperationException();
            }
            return this.ua.ua[this.qa];
        }

        @Override
        public boolean hasNext() {
            if (this.yg != this.ua.lx) {
                throw new InvalidOperationException();
            }
            switch (this.qa) {
                case -2: {
                    this.qa = this.ua.yg;
                    return this.qa != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.qa;
            return this.qa != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.yg != this.ua.lx) {
                throw new InvalidOperationException();
            }
            this.qa = -2;
        }

        protected Object ua() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.ua = this.ua;
            enumerator.yg = this.yg;
            enumerator.qa = this.qa;
            return enumerator;
        }
    }

    @nz
    private static class SyncStack
    extends Stack {
        private final Stack ua;

        SyncStack(Stack s) {
            this.ua = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.ua;
            synchronized (stack) {
                return this.ua.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.ua;
            synchronized (stack) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.ua;
            synchronized (stack) {
                return Stack.sync((Stack)this.ua.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.ua;
            synchronized (stack) {
                return this.ua.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int index) {
            Stack stack = this.ua;
            synchronized (stack) {
                this.ua.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.ua;
            synchronized (stack) {
                return new Enumerator(this.ua);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.ua;
            synchronized (stack) {
                return this.ua.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.ua;
            synchronized (stack) {
                return this.ua.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.ua;
            synchronized (stack) {
                this.ua.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.ua;
            synchronized (stack) {
                return this.ua.toArray(a);
            }
        }
    }
}

