/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.lr.bk;
import com.aspose.slides.internal.m1.qa;
import com.aspose.slides.internal.m1.se;
import com.aspose.slides.ms.System.am;
import com.aspose.slides.ms.System.i8;

public class BitVector32
extends se<BitVector32> {
    private int ua;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.ua = value.ua;
    }

    public BitVector32(int data) {
        this.ua = data;
    }

    public int getData() {
        return this.ua;
    }

    public int get_Item(Section section) {
        return this.ua >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.ua &= ~(section.getMask() << section.getOffset());
        this.ua |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.ua & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.ua = value ? (this.ua |= bit) : (this.ua &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.ua(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.ua(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(qa.yg((Object)n10, 9), qa.yg((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return qa.yg(o, BitVector32.class) && this.ua == qa.l8((Object)o, BitVector32.class).ua;
    }

    public int hashCode() {
        return i8.ua(this.ua);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        bk bk2 = new bk();
        bk2.ua("BitVector32{");
        for (long i = qa.ec((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            bk2.ua(((long)value.ua & i) == 0L ? (char)'0' : '1');
        }
        bk2.ua('}');
        return bk2.toString();
    }

    private static int ua(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.ua = this.ua;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends se<Section> {
        private short ua;
        private short yg;

        public Section() {
        }

        Section(short mask, short offset) {
            this.ua = mask;
            this.yg = offset;
        }

        public short getMask() {
            return this.ua;
        }

        public short getOffset() {
            return this.yg;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.ua == b.ua && a.yg == b.yg;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.ua != b.ua || a.yg != b.yg;
        }

        public boolean equals(Section obj) {
            return this.ua == obj.ua && this.yg == obj.yg;
        }

        public boolean equals(Object o) {
            if (!qa.yg(o, Section.class)) {
                return false;
            }
            Section section = qa.l8(o, Section.class).Clone();
            return this.ua == section.ua && this.yg == section.yg;
        }

        public int hashCode() {
            return this.ua << this.yg;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            bk bk2 = new bk();
            bk2.ua("Section{0x");
            bk2.ua(am.ua(value.getMask(), 16));
            bk2.ua(", 0x");
            bk2.ua(am.ua(value.getOffset(), 16));
            bk2.ua("}");
            return bk2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.ua = this.ua;
            that.yg = this.yg;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

