/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.m1.se;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.eh;
import com.aspose.slides.ms.System.gv;
import com.aspose.slides.ms.System.kn;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import java.util.Comparator;

@nz
public class SortedList
implements IDictionary,
az {
    private final Object ua = new Object();
    private Slot[] yg;
    private Comparator qa;
    private int l8;
    private int lx;
    private int ec;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.ec = capacity == 0 ? 0 : 16;
        this.qa = comparer;
        this.yg(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.qa = comparer;
        this.yg(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.yg(d.size(), true);
        this.qa = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.l8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.ua;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.ua(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.yg(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.ua(key, value, true);
    }

    public int getCapacity() {
        return this.yg.length;
    }

    public void setCapacity(int value) {
        int n = this.yg.length;
        if (this.l8 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.ua(this.ec);
            SortedList.ua(this.yg, 0, slotArray, 0, this.l8);
            this.yg = slotArray;
        } else if (value > this.l8) {
            Slot[] slotArray = SortedList.ua(value);
            SortedList.ua(this.yg, 0, slotArray, 0, this.l8);
            this.yg = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.ua(value);
            SortedList.ua(this.yg, 0, slotArray, 0, n);
            this.yg = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.ua(key, value, false);
    }

    @Override
    public void clear() {
        this.ec = 16;
        this.yg = SortedList.ua(this.ec);
        this.l8 = 0;
        ++this.lx;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.yg(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(l8 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.l8() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.lx()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.lx() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.qa(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.qa);
        sortedList.lx = this.lx;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.yg;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.ua(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].ua = null;
                slotArray[index].yg = null;
            }
            --this.l8;
            ++this.lx;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.yg(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.l8 == 0) {
            return -1;
        }
        for (int i = 0; i < this.l8; ++i) {
            Slot slot = this.yg[i].Clone();
            if (!kn.ua(value, slot.yg)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.yg[index].yg;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.yg[index].yg = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.yg[index].ua;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.ua(this.ec, false);
        } else {
            this.ua(this.size(), true);
        }
    }

    private void ua(int n, boolean bl2) {
        Slot[] slotArray = this.yg;
        Slot[] slotArray2 = SortedList.ua(n);
        if (bl2) {
            SortedList.ua(slotArray, 0, slotArray2, 0, n);
        }
        this.yg = slotArray2;
    }

    private void ua(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.yg;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.ua(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.ua(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.ua(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.ua(slotArray, 0, slotArray2, 0, this.size());
            }
            this.yg = slotArray2;
        } else if (bl2) {
            SortedList.ua(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void ua(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.yg;
        int n = -1;
        try {
            n = this.yg(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = gv.ua("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].yg = object2;
            ++this.lx;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(gv.ua(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.ua(this.size() + 1, n);
        slotArray = this.yg;
        slotArray[n].ua = object;
        slotArray[n].yg = object2;
        ++this.l8;
        ++this.lx;
    }

    private Object ua(Object object) {
        int n = this.yg(object);
        if (n >= 0) {
            return this.yg[n].yg;
        }
        return null;
    }

    private void yg(int n, boolean bl2) {
        if (!bl2 && n < this.ec) {
            n = this.ec;
        }
        this.yg = SortedList.ua(n);
        this.l8 = 0;
        this.lx = 0;
    }

    private void ua(l8 l82, int n, int n10) {
        if (l82 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > l82.lx()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            l82.qa(enumerator.next(), n++);
        }
    }

    private int yg(Object object) {
        Slot[] slotArray = this.yg;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.qa == null ? Comparer.Default : this.qa;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].ua, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] ua(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean ua(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void ua(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.ua(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList ua;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.ua = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.ua.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.ua.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                iCollection = this.ua.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                iCollection = this.ua.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.ua(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.ua(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int arrayIndex) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.ua(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.yg(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.ua);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.ua);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.trimToSize();
            }
        }
    }

    @nz
    private static class ListValues
    implements IList {
        private SortedList ua;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.ua = host;
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            this.ua.ua(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.ua.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.ua.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.ua, 1);
        }
    }

    @nz
    private static class ListKeys
    implements IList {
        private SortedList ua;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.ua = host;
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            this.ua.ua(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.ua.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.ua.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.ua, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    az {
        private SortedList ua;
        private Object yg;
        private Object qa;
        private int l8;
        private int lx;
        private int ec;
        private int se;
        private boolean r3 = false;
        private static String r6 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.ua = host;
            this.l8 = host.lx;
            this.ec = host.size();
            this.se = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.ua.lx != this.l8 || this.r3) {
                throw new IllegalStateException(r6);
            }
            this.lx = -1;
            this.yg = null;
            this.qa = null;
        }

        @Override
        public boolean hasNext() {
            if (this.ua.lx != this.l8 || this.r3) {
                throw new InvalidOperationException(r6);
            }
            return ++this.lx < this.ec;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return new DictionaryEntry(this.yg, this.qa);
        }

        @Override
        public Object getKey() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return this.yg;
        }

        @Override
        public Object getValue() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return this.qa;
        }

        @Override
        public Object next() {
            if (this.ua.lx != this.l8 || this.r3) {
                throw new InvalidOperationException(r6);
            }
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                if (this.lx >= this.ec) {
                    this.yg = null;
                    this.qa = null;
                }
                throw new IllegalStateException(r6);
            }
            Slot[] slotArray = this.ua.yg;
            Slot slot = slotArray[this.lx].Clone();
            this.yg = slot.ua;
            this.qa = slot.yg;
            switch (this.se) {
                case 0: {
                    return this.yg;
                }
                case 1: {
                    return this.qa;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(gv.ua(new String[]{eh.getName(EnumeratorMode.class, this.se), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.ua, this.se);
            enumeratorJava.l8 = this.l8;
            enumeratorJava.lx = this.lx;
            enumeratorJava.ec = this.ec;
            enumeratorJava.yg = this.yg;
            enumeratorJava.qa = this.qa;
            enumeratorJava.r3 = this.r3;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    az {
        private SortedList ua;
        private Object yg;
        private Object qa;
        private int l8;
        private int lx;
        private int ec;
        private int se;
        private boolean r3 = false;
        private static String r6 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.ua = host;
            this.l8 = host.lx;
            this.ec = host.size();
            this.se = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.ua.lx != this.l8 || this.r3) {
                throw new IllegalStateException(r6);
            }
            this.lx = -1;
            this.yg = null;
            this.qa = null;
        }

        @Override
        public boolean hasNext() {
            if (this.ua.lx != this.l8 || this.r3) {
                throw new InvalidOperationException(r6);
            }
            Slot[] slotArray = this.ua.yg;
            if (++this.lx < this.ec) {
                Slot slot = slotArray[this.lx].Clone();
                this.yg = slot.ua;
                this.qa = slot.yg;
                return true;
            }
            this.yg = null;
            this.qa = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return new DictionaryEntry(this.yg, this.qa);
        }

        @Override
        public Object getKey() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return this.yg;
        }

        @Override
        public Object getValue() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            return this.qa;
        }

        @Override
        public Object next() {
            if (this.r3 || this.lx >= this.ec || this.lx == -1) {
                throw new IllegalStateException(r6);
            }
            switch (this.se) {
                case 0: {
                    return this.yg;
                }
                case 1: {
                    return this.qa;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(gv.ua(new String[]{eh.getName(EnumeratorMode.class, this.se), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.ua, this.se);
            enumerator.l8 = this.l8;
            enumerator.lx = this.lx;
            enumerator.ec = this.ec;
            enumerator.yg = this.yg;
            enumerator.qa = this.qa;
            enumerator.r3 = this.r3;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends eh {
        private EnumeratorMode() {
        }

        static {
            eh.register(new eh.lx(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @nz
    public static class Slot
    extends se<Slot> {
        Object ua;
        Object yg;

        @Override
        public void CloneTo(Slot that) {
            that.ua = this.ua;
            that.yg = this.yg;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ua(Slot slot) {
            return kn.ua(slot.ua, this.ua) && kn.ua(slot.yg, this.yg);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.ua((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ua != null ? this.ua.hashCode() : 0;
            n = 31 * n + (this.yg != null ? this.yg.hashCode() : 0);
            return n;
        }
    }
}

