/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import java.util.Arrays;

@nz
public class Queue
implements ICollection,
IEnumerable,
az {
    private Object[] ua;
    private int yg = 0;
    private int qa = 0;
    private int l8 = 0;
    private int lx;
    private int ec = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.ua = new Object[capacity];
        this.lx = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.qa;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(l8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.l8() > 1 || index != 0 && index >= array.lx() || this.qa > array.lx() - index) {
            throw new ArgumentException();
        }
        int n = this.ua.length;
        int n10 = n - this.yg;
        com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), this.yg, array, index, Math.min(this.qa, n10));
        if (this.qa > n10) {
            com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), 0, array, index + n10, this.qa - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.ua.length);
        queue.lx = this.lx;
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, queue.ua, 0, this.ua.length);
        queue.yg = this.yg;
        queue.qa = this.qa;
        queue.l8 = this.l8;
        return queue;
    }

    public void clear() {
        ++this.ec;
        this.yg = 0;
        this.qa = 0;
        this.l8 = 0;
        for (int i = this.ua.length - 1; i >= 0; --i) {
            this.ua[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.yg + this.qa;
        if (obj == null) {
            for (int i = this.yg; i < n; ++i) {
                if (this.ua[i % this.ua.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.yg; i < n; ++i) {
                if (!obj.equals(this.ua[i % this.ua.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.ec;
        if (this.qa < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.ua[this.yg];
        this.ua[this.yg] = null;
        this.yg = (this.yg + 1) % this.ua.length;
        --this.qa;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.ec;
        if (this.qa == this.ua.length) {
            this.ua();
        }
        this.ua[this.l8] = obj;
        this.l8 = (this.l8 + 1) % this.ua.length;
        ++this.qa;
    }

    public Object peek() {
        if (this.qa < 1) {
            throw new InvalidOperationException();
        }
        return this.ua[this.yg];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.qa) {
            return Arrays.copyOf(this.ua, this.qa, a.getClass());
        }
        System.arraycopy(this.ua, 0, a, 0, this.qa);
        if (a.length > this.qa) {
            a[this.qa] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.ec;
        Object[] objectArray = new Object[this.qa];
        this.copyTo(com.aspose.slides.ms.System.l8.ua(objectArray), 0);
        this.ua = objectArray;
        this.yg = 0;
        this.l8 = 0;
    }

    private void ua() {
        int n = this.ua.length * this.lx / 100;
        if (n < this.ua.length + 1) {
            n = this.ua.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.l8.ua(objectArray), 0);
        this.ua = objectArray;
        this.yg = 0;
        this.l8 = this.yg + this.qa;
    }

    @nz
    private static class QueueEnumerator
    implements IEnumerator,
    az {
        private Queue ua;
        private int yg;
        private int qa;

        QueueEnumerator(Queue q) {
            this.ua = q;
            this.yg = q.ec;
            this.qa = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.ua);
            queueEnumerator.yg = this.yg;
            queueEnumerator.qa = this.qa;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.yg != this.ua.ec || this.qa < 0 || this.qa >= this.ua.qa) {
                throw new InvalidOperationException();
            }
            return this.ua.ua[(this.ua.yg + this.qa) % this.ua.ua.length];
        }

        @Override
        public boolean hasNext() {
            if (this.yg != this.ua.ec) {
                throw new InvalidOperationException();
            }
            if (this.qa >= this.ua.qa - 1) {
                this.qa = Integer.MAX_VALUE;
                return false;
            }
            ++this.qa;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.yg != this.ua.ec) {
                throw new InvalidOperationException();
            }
            this.qa = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue ua;

        SyncQueue(Queue queue) {
            this.ua = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int index) {
            Queue queue = this.ua;
            synchronized (queue) {
                this.ua.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.ua;
            synchronized (queue) {
                return new SyncQueue((Queue)this.ua.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.ua;
            synchronized (queue) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.ua;
            synchronized (queue) {
                this.ua.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.ua;
            synchronized (queue) {
                this.ua.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.ua;
            synchronized (queue) {
                return this.ua.toArray(a);
            }
        }
    }
}

