/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.nz;

@nz
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> ua;
    private IGenericEqualityComparer<TKey> yg;
    private int qa;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.yg = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.qa = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.ua = new Dictionary(this.yg);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.ua != null) {
            return this.ua.containsKey(key);
        }
        return this.ua(key) >= 0;
    }

    private int ua(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.yg.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.ua != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.ua.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.ua(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.yg;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.ua != null && ((Dictionary.KeyCollection)this.ua.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.ua.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.ua != null) {
            return this.ua.get_Item(key);
        }
        int n = this.ua(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.yg.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.ua != null) {
            if (!this.ua.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.ua.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.ua != null) {
            this.ua.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.ua != null && this.ua.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.ua == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.yg.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.ua != null) {
            this.ua.addItem(TKey, item);
        } else if (this.qa != -1 && this.size() > this.qa) {
            this.ua = new Dictionary(this.yg);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.ua.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.ua != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.ua.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.ua != null) {
            this.ua.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.ua.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.ua;
    }
}

