/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.m1.ec;
import com.aspose.slides.internal.m1.qa;
import com.aspose.slides.internal.p6.av;
import com.aspose.slides.internal.p6.j0;
import com.aspose.slides.internal.p6.se;
import com.aspose.slides.internal.p6.um;
import com.aspose.slides.internal.p6.w8;
import com.aspose.slides.internal.qj.r6;
import com.aspose.slides.internal.r4.ua;
import com.aspose.slides.internal.r4.yg;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.gv;
import com.aspose.slides.ms.System.kn;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@nz
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
av,
se,
az,
Map {
    private IGenericEqualityComparer ua;
    private final Object yg = new Object();
    private Bucket[] qa;
    private int l8;
    private volatile boolean lx;
    private ICollection ec;
    private float se;
    private int r3;
    private um r6;
    private int av;
    private ICollection e9;
    private volatile int ry;
    private static final ec zt = new ec("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", gv.ua("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.se = 0.72f * loadFactor;
        double d = (float)capacity / this.se;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.r4.ua.ua((int)d) : 11;
        this.qa = this.yg(n);
        this.r3 = (int)(this.se * (float)n);
        this.lx = false;
    }

    protected Hashtable(um info, j0 context) {
        this.r6 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.ua = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.ua = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.ua(key, value, true);
    }

    @Override
    public void clear() {
        if (this.l8 != 0) {
            this.lx = true;
            for (int i = 0; i < this.qa.length; ++i) {
                this.qa[i].qa = 0;
                this.qa[i].ua = null;
                this.qa[i].yg = null;
            }
            this.l8 = 0;
            this.av = 0;
            this.l8();
            this.lx = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.qa;
        Hashtable hashtable = new Hashtable(this.l8, this.ua);
        hashtable.ry = this.ry;
        hashtable.se = this.se;
        hashtable.l8 = 0;
        int n = this.qa.length;
        while (n > 0) {
            Object object = bucketArray[--n].ua;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].yg);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.qa;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.ua(key, this.qa.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.qa.length);
        do {
            bucketArray[n10].ua(bucket);
            if (bucket.ua == null) {
                return false;
            }
            if ((long)(bucket.qa & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.ua, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.qa.length);
        } while (bucket.qa < 0 && ++n < this.qa.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.qa.length;
            while (--n >= 0) {
                if (this.qa[n].ua == null || this.qa[n].ua == this.qa || this.qa[n].yg != null) continue;
                return true;
            }
        } else {
            int n = this.qa.length;
            while (--n >= 0) {
                Object object = this.qa[n].yg;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void qa(l8 l82, int n) {
        Bucket[] bucketArray = this.qa;
        int n10 = this.qa.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].ua;
            if (object == null || object == this.qa) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].yg);
            l82.qa(dictionaryEntry.Clone(), n++);
        }
    }

    void ua(l8 l82, int n) {
        Bucket[] bucketArray = this.qa;
        int n10 = this.qa.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].ua;
            if (object == null || object == this.qa) continue;
            l82.qa(object, n++);
        }
    }

    @Override
    public void copyTo(l8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.l8() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.lx() - arrayIndex < this.l8) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.qa(array, arrayIndex);
    }

    void yg(l8 l82, int n) {
        Bucket[] bucketArray = this.qa;
        int n10 = this.qa.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].ua;
            if (object == null || object == this.qa) continue;
            l82.qa(bucketArray[n10].yg, n++);
        }
    }

    private void yg() {
        int n = com.aspose.slides.internal.r4.ua.ua(this.qa.length * 2);
        this.ua(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.ua != null) {
            return this.ua.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(um info, j0 context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.ua("LoadFactor", this.se);
        info.ua("Version", this.ry);
        if (this.ua == null) {
            info.ua("Comparer", null, com.aspose.slides.internal.m1.qa.ua(Comparator.class));
            info.ua("HashCodeProvider", null, com.aspose.slides.internal.m1.qa.ua(IHashCodeProvider.class));
        } else if (this.ua instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.m1.qa.ua(this.ua, CompatibleComparer.class);
            info.ua("Comparer", objectArray.ua(), com.aspose.slides.internal.m1.qa.ua(Comparator.class));
            info.ua("HashCodeProvider", objectArray.yg(), com.aspose.slides.internal.m1.qa.ua(IHashCodeProvider.class));
        } else {
            info.ua("KeyComparer", this.ua, com.aspose.slides.internal.m1.qa.ua(IGenericEqualityComparer.class));
        }
        info.ua("HashSize", this.qa.length);
        objectArray = new Object[this.l8];
        Object[] objectArray2 = new Object[this.l8];
        this.ua(com.aspose.slides.ms.System.l8.ua(objectArray), 0);
        this.yg(com.aspose.slides.ms.System.l8.ua(objectArray2), 0);
        info.ua("Keys", objectArray, com.aspose.slides.internal.m1.qa.ua(Object[].class));
        info.ua("Values", objectArray2, com.aspose.slides.internal.m1.qa.ua(Object[].class));
    }

    private long ua(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void ua(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.l8 >= this.r3) {
                this.yg();
            } else if (this.av > this.r3 && this.l8 > 100) {
                this.qa();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.ua(object, this.qa.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.qa.length);
            do {
                if (n10 == -1 && this.qa[n11].ua == this.qa && this.qa[n11].qa < 0) {
                    n10 = n11;
                }
                if (this.qa[n11].ua == null || this.qa[n11].ua == this.qa && ((long)this.qa[n11].qa & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.lx = true;
                    this.qa[n11].yg = object2;
                    this.qa[n11].ua = object;
                    this.qa[n11].qa |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.l8;
                    this.l8();
                    this.lx = false;
                    break block12;
                }
                if ((long)(this.qa[n11].qa & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.qa[n11].ua, object)) {
                    if (bl2) {
                        throw new ArgumentException(gv.ua("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.qa[n11].ua, object));
                    }
                    this.lx = true;
                    this.qa[n11].yg = object2;
                    this.l8();
                    this.lx = false;
                    break block12;
                }
                if (n10 == -1 && this.qa[n11].qa >= 0) {
                    this.qa[n11].qa = (int)((long)this.qa[n11].qa | Integer.MIN_VALUE);
                    ++this.av;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.qa.length);
            } while (++n < this.qa.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.lx = true;
            this.qa[n10].yg = object2;
            this.qa[n10].ua = object;
            this.qa[n10].qa |= (int)(l11 & 0xFFFFFFFFL);
            ++this.l8;
            this.l8();
            this.lx = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (kn.yg(this.qa, item)) {
            return false;
        }
        if (this.ua != null) {
            return this.ua.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.qa == null) {
            if (this.r6 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            w8 w82 = this.r6.l8();
            while (w82.hasNext()) {
                switch (zt.ua(w82.yg())) {
                    case 0: {
                        this.se = this.r6.yg("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.r6.ua("HashSize");
                        break;
                    }
                    case 2: {
                        this.ua = (IGenericEqualityComparer)this.r6.ua("KeyComparer", com.aspose.slides.internal.m1.qa.ua(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.r6.ua("Comparer", com.aspose.slides.internal.m1.qa.ua(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.r6.ua("HashCodeProvider", com.aspose.slides.internal.m1.qa.ua(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.r6.ua("Keys", com.aspose.slides.internal.m1.qa.ua(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.r6.ua("Values", com.aspose.slides.internal.m1.qa.ua(Object[].class));
                    }
                }
            }
            this.r3 = (int)(this.se * (float)n);
            if (this.ua == null && (comparator != null || iHashCodeProvider != null)) {
                this.ua = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.qa = this.yg(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.ua(objectArray[i], objectArray2[i], true);
            }
            this.ry = this.r6.ua("Version");
            this.r6 = null;
        }
    }

    private void ua(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].ua == null || bucketArray[n10].ua == this.qa) {
                bucketArray[n10].yg = object2;
                bucketArray[n10].ua = object;
                bucketArray[n10].qa |= n;
                break;
            }
            if (bucketArray[n10].qa >= 0) {
                bucketArray[n10].qa = (int)((long)bucketArray[n10].qa | Integer.MIN_VALUE);
                ++this.av;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void qa() {
        this.ua(this.qa.length);
    }

    private void ua(int n) {
        this.av = 0;
        Bucket[] bucketArray = this.yg(n);
        for (int i = 0; i < this.qa.length; ++i) {
            Bucket bucket = this.qa[i].ua();
            if (bucket.ua == null || bucket.ua == this.qa) continue;
            this.ua(bucketArray, bucket.ua, bucket.yg, bucket.qa & Integer.MAX_VALUE);
        }
        this.lx = true;
        this.qa = bucketArray;
        this.r3 = (int)(this.se * (float)n);
        this.l8();
        this.lx = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.ua(key, this.qa.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.qa.length);
        do {
            this.qa[n10].ua(bucket);
            if ((long)(bucket.qa & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.ua, key)) {
                this.lx = true;
                this.qa[n10].qa = (int)((long)this.qa[n10].qa & Integer.MIN_VALUE);
                this.qa[n10].ua = this.qa[n10].qa != 0 ? this.qa : null;
                this.qa[n10].yg = null;
                --this.l8;
                this.l8();
                this.lx = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.qa.length);
        } while (bucket.qa < 0 && ++n < this.qa.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] ua() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.l8];
        int n = 0;
        Bucket[] bucketArray = this.qa;
        int n10 = this.qa.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].ua;
            if (object == null || object == this.qa) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].yg);
        }
        return keyValuePairsArray;
    }

    private void l8() {
        ++this.ry;
    }

    private Bucket[] yg(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.l8;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.ua;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.qa;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.ua(key, this.qa.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.qa.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.ry;
                bucketArray[n10].ua(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.qj.r6.yg(1);
            } while (this.lx || n11 != this.ry);
            if (bucket.ua == null) break;
            if ((long)(bucket.qa & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.ua, key)) {
                return bucket.yg;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.qa.length);
        } while (bucket.qa < 0 && ++n < this.qa.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.ua(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.ec == null) {
            this.ec = new KeyCollection(this);
        }
        return this.ec;
    }

    @Override
    public Object getSyncRoot() {
        return this.yg;
    }

    @Override
    public ICollection getValues() {
        if (this.e9 == null) {
            this.e9 = new ValueCollection(this);
        }
        return this.e9;
    }

    @Override
    public boolean isEmpty() {
        return this.l8 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        l8 l82 = com.aspose.slides.ms.System.l8.ua(objectArray);
        this.getKeys().copyTo(l82, 0);
        return new ReadOnlyItemCollection(l82);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        l8 l82 = com.aspose.slides.ms.System.l8.ua(objectArray);
        this.getValues().copyTo(l82, 0);
        return new ReadOnlyItemCollection(l82);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.ua();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].ua(), keyValuePairsArray[i].yg());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.l8.ua(entryArray));
    }

    public int getVersion() {
        return this.ry;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new yg(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private l8 yg;

        ReadOnlyItemCollection(l8 items) {
            this.yg = items;
        }

        @Override
        public int size() {
            return this.yg.size();
        }

        @Override
        public boolean isEmpty() {
            return this.yg.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.yg.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.yg.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            l8 l82 = com.aspose.slides.ms.System.l8.ua(objectArray);
            this.yg.copyTo(l82, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.yg.copyTo(com.aspose.slides.ms.System.l8.ua(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @nz
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable ua;

        SyncHashtable(Hashtable table) {
            super(false);
            this.ua = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.ua.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.ua.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.ua.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int arrayIndex) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.ua.iterator();
        }

        @Override
        public void getObjectData(um info, j0 context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.ua("ParentTable", this.ua, com.aspose.slides.internal.m1.qa.ua(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] ua() {
            return this.ua.ua();
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.ua.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.ua.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.ua.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                this.ua.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.ua.getSyncRoot();
            synchronized (object) {
                return this.ua.getValues();
            }
        }
    }

    @nz
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable ua;

        ValueCollection(Hashtable hashtable) {
            this.ua = hashtable;
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.l8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.lx() - arrayIndex < this.ua.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.ua.yg(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.ua, 2);
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }
    }

    @nz
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable ua;

        KeyCollection(Hashtable hashtable) {
            this.ua = hashtable;
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.l8() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.lx() - arrayIndex < this.ua.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.ua.ua(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.ua, 1);
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }
    }

    @nz
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int ua;
        private boolean yg;
        private Object qa;
        private Object l8;
        private int lx;
        private Hashtable ec;
        private int se;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.ec = hashtable;
            this.ua = hashtable.qa.length;
            this.se = hashtable.ry;
            this.yg = false;
            this.lx = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.se != this.ec.ry) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.ua > 0) {
                --this.ua;
                Object object = ((Hashtable)this.ec).qa[this.ua].ua;
                if (object == null || object == this.ec.qa) continue;
                this.qa = object;
                this.l8 = ((Hashtable)this.ec).qa[this.ua].yg;
                this.yg = true;
                return true;
            }
            this.yg = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.se != this.ec.ry) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.yg = false;
            this.ua = this.ec.qa.length;
            this.qa = null;
            this.l8 = null;
        }

        @Override
        public Object next() {
            if (!this.yg) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.lx == 1) {
                return this.qa;
            }
            if (this.lx == 2) {
                return this.l8;
            }
            return new DictionaryEntry(this.qa, this.l8);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.yg) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.qa, this.l8);
        }

        @Override
        public Object getKey() {
            if (!this.yg) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.qa;
        }

        @Override
        public Object getValue() {
            if (!this.yg) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.l8;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object ua;
        private Object yg;

        public KeyValuePairs(Object key, Object value) {
            this.yg = value;
            this.ua = key;
        }

        public Object ua() {
            return this.ua;
        }

        public Object yg() {
            return this.yg;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.m1.se<Bucket> {
        public Object ua;
        public Object yg;
        public int qa;

        public void ua(Bucket bucket) {
            bucket.ua = this.ua;
            bucket.yg = this.yg;
            bucket.qa = this.qa;
        }

        public Bucket ua() {
            Bucket bucket = new Bucket();
            this.ua(bucket);
            return bucket;
        }

        public Object clone() {
            return this.ua();
        }

        private boolean yg(Bucket bucket) {
            return kn.ua(bucket.ua, this.ua) && kn.ua(bucket.yg, this.yg) && bucket.qa == this.qa;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.yg((Bucket)obj);
        }

        public int hashCode() {
            int n = this.ua != null ? this.ua.hashCode() : 0;
            n = 31 * n + (this.yg != null ? this.yg.hashCode() : 0);
            n = 31 * n + this.qa;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.ua();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.ua((Bucket)object);
        }
    }

    @nz
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator ua;
        private IHashCodeProvider yg;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.ua = comparer;
            this.yg = hashCodeProvider;
        }

        public int ua(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.ua != null) {
                return this.ua.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.m1.qa.ua(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.ua(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.yg != null) {
                return this.yg.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator ua() {
            return this.ua;
        }

        IHashCodeProvider yg() {
            return this.yg;
        }
    }
}

