/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.m1.qa;
import com.aspose.slides.internal.m1.se;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.kn;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import com.aspose.slides.ms.System.pb;
import java.util.Arrays;

@nz
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] ua;
    private int yg;
    private int qa;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.ua = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.yg = collection.size();
            this.ua = new Object[this.yg];
            collection.copyToTArray(this.ua, 0);
        }
    }

    public void clear() {
        if (this.ua != null) {
            l8.ua(this.ua, 0, this.ua.length);
        }
        this.yg = 0;
        ++this.qa;
    }

    public boolean contains(T item) {
        return this.ua != null && l8.ua(this.ua, item, 0, this.yg) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.yg - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.ua != null) {
            l8.ua(this.ua, 0, array, arrayIndex, this.yg);
            pb.ua(array, arrayIndex, this.yg);
        }
    }

    public T peek() {
        if (this.yg == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.ua[this.yg - 1];
    }

    public T pop() {
        if (this.yg == 0) {
            throw new InvalidOperationException();
        }
        ++this.qa;
        Object object = this.ua[--this.yg];
        this.ua[this.yg] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.ua == null || this.yg == this.ua.length) {
            if (this.ua == null) {
                this.ua = new Object[16];
            }
            this.ua = Arrays.copyOf(this.ua, this.yg == 0 ? 16 : 2 * this.yg);
        }
        ++this.qa;
        this.ua[this.yg++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.yg) {
            this.copyTo(l8.ua(array), 0);
            return array;
        }
        l8 l82 = l8.ua(com.aspose.slides.internal.m1.qa.ua(array.getClass().getComponentType()), this.yg);
        this.copyTo(l82, 0);
        return (Object[])l8.ua(l82);
    }

    public void trimExcess() {
        if (this.ua != null && (double)this.yg < (double)this.ua.length * 0.9) {
            this.ua = Arrays.copyOf(this.ua, this.yg);
        }
        ++this.qa;
    }

    @Override
    public int size() {
        return this.yg;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(l8 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.ua != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.yg) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.yg - idx > dest.lx()) {
                    throw new ArgumentException("idx");
                }
                l8.ua(l8.ua(this.ua), 0, dest, idx, this.yg);
                l8.yg(dest, idx, this.yg);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @nz
    public static class Enumerator<T>
    extends se<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> yg;
        private int qa;
        private int l8;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.yg = t;
            this.qa = -2;
            this.l8 = ((Stack)t).qa;
        }

        @Override
        public void dispose() {
            this.qa = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.l8 != ((Stack)this.yg).qa) {
                throw new IllegalStateException();
            }
            if (this.qa == -2) {
                this.qa = ((Stack)this.yg).yg;
            }
            return this.qa != -1 && --this.qa != -1;
        }

        @Override
        public T next() {
            if (this.qa < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.yg).ua[this.qa];
        }

        @Override
        public void reset() {
            if (this.l8 != ((Stack)this.yg).qa) {
                throw new IllegalStateException();
            }
            this.qa = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.yg = this.yg;
            that.qa = this.qa;
            that.l8 = this.l8;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ua(Enumerator enumerator) {
            return kn.ua(enumerator.yg, this.yg) && enumerator.qa == this.qa && enumerator.l8 == this.l8;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.ua((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.yg != null ? this.yg.hashCode() : 0;
            n = 31 * n + this.qa;
            n = 31 * n + this.l8;
            return n;
        }
    }
}

