/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.m1.se;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.kn;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import java.util.Arrays;

@nz
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] ua;
    private int yg;
    private int qa;
    private int l8;
    private int lx;
    private final Object ec;

    public Queue() {
        this.ua = new Object[0];
        this.ec = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.ua = new Object[capacity];
        this.ec = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.ua = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.ec = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, this.ua.length);
        this.l8 = 0;
        this.qa = 0;
        this.yg = 0;
        ++this.lx;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(l8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.lx() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.lx() - arrayIndex < this.l8) {
            throw new ArgumentException();
        }
        if (this.l8 == 0) {
            return;
        }
        try {
            int n = this.ua.length;
            int n10 = n - this.yg;
            com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), this.yg, array, arrayIndex, i2.yg(this.l8, n10));
            if (this.l8 > n10) {
                com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), 0, array, arrayIndex + n10, this.l8 - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.ua[this.yg] = null;
        if (++this.yg == this.ua.length) {
            this.yg = 0;
        }
        --this.l8;
        ++this.lx;
        return t;
    }

    public T peek() {
        if (this.l8 == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.ua[this.yg];
    }

    public void enqueue(T item) {
        if (this.l8 == this.ua.length || this.qa == this.ua.length) {
            this.ua(i2.ua(i2.ua(this.l8, this.qa) * 2, 4));
        }
        this.ua[this.qa] = item;
        if (++this.qa == this.ua.length) {
            this.qa = 0;
        }
        ++this.l8;
        ++this.lx;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.l8) {
            return Arrays.copyOf(this.ua, this.l8, a.getClass());
        }
        System.arraycopy(this.ua, 0, a, 0, this.l8);
        if (a.length > this.l8) {
            a[this.l8] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.l8 < (double)this.ua.length * 0.9) {
            this.ua(this.l8);
        }
    }

    private void ua(int n) {
        if (n == this.ua.length) {
            return;
        }
        if (n < this.l8) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.l8 > 0) {
            this.copyTo(com.aspose.slides.ms.System.l8.ua(objectArray), 0);
        }
        this.ua = objectArray;
        this.qa = this.l8;
        this.yg = 0;
        ++this.lx;
    }

    @Override
    public int size() {
        return this.l8;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.ec;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @nz
    public static class Enumerator<T>
    extends se<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> yg;
        private int qa;
        private int l8;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.yg = q;
            this.qa = -2;
            this.l8 = ((Queue)q).lx;
        }

        @Override
        public void dispose() {
            this.qa = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.l8 != ((Queue)this.yg).lx) {
                throw new InvalidOperationException();
            }
            if (this.qa == -2) {
                this.qa = ((Queue)this.yg).l8;
            }
            return this.qa != -1 && --this.qa != -1;
        }

        @Override
        public T next() {
            if (this.qa < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.yg).ua[(((Queue)this.yg).l8 - 1 - this.qa + ((Queue)this.yg).yg) % ((Queue)this.yg).ua.length];
        }

        @Override
        public void reset() {
            if (this.l8 != ((Queue)this.yg).lx) {
                throw new InvalidOperationException();
            }
            this.qa = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.yg = this.yg;
            that.qa = this.qa;
            that.l8 = this.l8;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ua(Enumerator enumerator) {
            return kn.ua(enumerator.yg, this.yg) && enumerator.qa == this.qa && enumerator.l8 == this.l8;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.ua((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.yg != null ? this.yg.hashCode() : 0;
            n = 31 * n + this.qa;
            n = 31 * n + this.l8;
            return n;
        }
    }
}

