/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.m1.se;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.h1;
import com.aspose.slides.ms.System.hd;
import com.aspose.slides.ms.System.kn;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;
import com.aspose.slides.ms.System.pb;
import com.aspose.slides.ms.System.s6;
import com.aspose.slides.ms.System.ua;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@nz
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] ua;
    private int yg;
    private int qa;
    private final Object l8 = new Object();
    static Object[] ec = new Object[0];

    public List() {
        this.ua = ec;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.ua = ec;
        this.ua(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.ua = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.ua = data;
        this.yg = size;
    }

    protected int getVersion() {
        return this.qa;
    }

    @Override
    public void addItem(T item) {
        if (this.yg == this.ua.length) {
            this.ua(1);
        }
        this.ua[this.yg++] = item;
        ++this.qa;
    }

    private void ua(int n) {
        int n10 = this.yg + n;
        if (n10 > this.ua.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void ua(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void ua(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.ua(new List<T>(collection));
        ++this.qa;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.qa;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return pb.ua(this.ua, 0, this.yg, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return pb.ua(this.ua, 0, this.yg, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.ua(index, count);
        return pb.ua(this.ua, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, this.ua.length);
        this.yg = 0;
        ++this.qa;
    }

    public <TOutput> List<TOutput> convertAll(hd<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.yg);
        for (int i = 0; i < this.yg; ++i) {
            list.ua[i] = converter.ua(this.ua[i]);
        }
        list.yg = this.yg;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, array, 0, this.yg);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, array, arrayIndex, this.yg);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.ua(index, count);
        com.aspose.slides.ms.System.l8.ua(this.ua, index, array, arrayIndex, count);
    }

    public boolean exists(s6<T> match) {
        List.ua(match);
        return this.ua(0, this.yg, match) != -1;
    }

    public T find(s6<T> match) {
        List.ua(match);
        int n = this.ua(0, this.yg, match);
        return (T)(n != -1 ? this.ua[n] : null);
    }

    static <T> void ua(s6<T> s62) {
        if (s62 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(s6<T> match) {
        List.ua(match);
        return this.yg(match);
    }

    private List<T> yg(s6<T> s62) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.yg; ++i) {
            if (!s62.invoke(this.ua[i])) continue;
            list.addItem(this.ua[i]);
        }
        return list;
    }

    public int findIndex(s6<T> match) {
        List.ua(match);
        return this.ua(0, this.yg, match);
    }

    public int findIndex(int startIndex, s6<T> match) {
        List.ua(match);
        this.yg(startIndex);
        return this.ua(startIndex, this.yg - startIndex, match);
    }

    public int findIndex(int startIndex, int count, s6<T> match) {
        List.ua(match);
        this.ua(startIndex, count);
        return this.ua(startIndex, count, match);
    }

    private int ua(int n, int n10, s6<T> s62) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!s62.invoke(this.ua[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(s6<T> match) {
        List.ua(match);
        int n = this.yg(0, this.yg, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(s6<T> match) {
        List.ua(match);
        return this.yg(0, this.yg, match);
    }

    public int findLastIndex(int startIndex, s6<T> match) {
        List.ua(match);
        this.yg(startIndex);
        return this.yg(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, s6<T> match) {
        List.ua(match);
        int n = startIndex - count + 1;
        this.ua(n, count);
        return this.yg(n, count, match);
    }

    private int yg(int n, int n10, s6<T> s62) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!s62.invoke(this.ua[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(ua<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.yg; ++i) {
            action.invoke(this.ua[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.ua(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.l8.ua(this.ua, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.l8.ua(this.ua, item, 0, this.yg);
    }

    public int indexOf(T item, int index) {
        this.yg(index);
        return com.aspose.slides.ms.System.l8.ua(this.ua, item, index, this.yg - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.l8.ua(this.ua, item, index, count);
    }

    private void yg(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.yg) {
            com.aspose.slides.ms.System.l8.ua(this.ua, n, this.ua, n + n10, this.yg - n);
        }
        this.yg += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.l8.ua(this.ua, this.yg, -n10);
        }
    }

    private void yg(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.yg(index);
        if (this.yg == this.ua.length) {
            this.ua(1);
        }
        this.yg(index, 1);
        this.ua[index] = item;
        ++this.qa;
    }

    void qa(int n) {
        Object[] objectArray = new Object[this.yg];
        this.copyToTArray(objectArray, 0);
        this.ua(this.yg);
        this.yg(n, objectArray.length);
        com.aspose.slides.ms.System.l8.ua(objectArray, 0, this.ua, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.yg(index);
        if (collection == this) {
            this.qa(index);
        } else {
            this.ua(index, collection);
        }
        ++this.qa;
    }

    private void ua(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.yg == 0) {
            return -1;
        }
        return pb.ua(this.ua, item, this.yg - 1, this.yg);
    }

    public int lastIndexOf(T item, int index) {
        this.yg(index);
        return pb.ua(this.ua, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return pb.ua(this.ua, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(s6<T> match) {
        List.ua(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.yg && !match.invoke(this.ua[n]); ++n) {
        }
        if (n == this.yg) {
            return 0;
        }
        ++this.qa;
        for (n10 = n + 1; n10 < this.yg; ++n10) {
            if (match.invoke(this.ua[n10])) continue;
            this.ua[n++] = this.ua[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.l8.ua(this.ua, n, n10 - n);
        }
        this.yg = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.yg(index, -1);
        com.aspose.slides.ms.System.l8.ua(this.ua, this.yg, 1);
        ++this.qa;
    }

    public void removeRange(int index, int count) {
        this.ua(index, count);
        if (count > 0) {
            this.yg(index, -count);
            com.aspose.slides.ms.System.l8.ua(this.ua, this.yg, count);
            ++this.qa;
        }
    }

    public void reverse() {
        pb.ua(this.ua, 0, this.yg);
        ++this.qa;
    }

    public void reverse(int index, int count) {
        this.ua(index, count);
        pb.ua(this.ua, index, count);
        ++this.qa;
    }

    public void sort() {
        Arrays.sort(this.ua, 0, this.yg);
        ++this.qa;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.ua, 0, this.yg, comparer);
        ++this.qa;
    }

    @Override
    public void sort(h1<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.ua, 0, this.yg, new pb.ua<T>(comparison));
        ++this.qa;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.ua(index, count);
        Arrays.sort(this.ua, index, index + count, comparer);
        ++this.qa;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.yg) {
            return Arrays.copyOf(this.ua, this.yg, a.getClass());
        }
        System.arraycopy(this.ua, 0, a, 0, this.yg);
        if (a.length > this.yg) {
            a[this.yg] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.yg);
    }

    public boolean trueForAll(s6<T> match) {
        List.ua(match);
        for (int i = 0; i < this.yg; ++i) {
            if (match.invoke(this.ua[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.ua.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.ua = Arrays.copyOf(this.ua, value);
    }

    @Override
    public int size() {
        return this.yg;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.yg & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.ua[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.yg(index);
        if ((long)index == (long)this.yg) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.ua[index] = value;
        ++this.qa;
    }

    public void copyTo(l8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.l8() > 1 || array.yg(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), 0, array, arrayIndex, this.yg);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.l8;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.yg == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.yg; ++i) {
                if (this.ua[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.yg; ++i) {
            if (!this.ua[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.yg; ++i) {
                if (this.ua[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.yg; ++i) {
            if (!this.ua[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.yg];
        System.arraycopy(this.ua, 0, objectArray, 0, this.yg);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.yg;
        this.addItem(t);
        return n != this.yg;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.yg;
        this.removeItem(o);
        return n != this.yg;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.yg; ++i) {
                if (this.ua[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.yg; ++i) {
            if (!o.equals(this.ua[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> ua;
        private int yg;

        public ListInternalized() {
            this.ua = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.ua = list;
        }

        @Override
        protected int getVersion() {
            return this.yg;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.ua(collection);
            ++this.yg;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.yg;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return pb.ua(this.ua.toArray(), 0, this.ua.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return pb.ua(this.ua.toArray(), 0, this.ua.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.ua(index, count);
            return pb.ua(this.ua.toArray(), index, count, item, comparer);
        }

        @Override
        private void ua(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(hd<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.ua.size());
            for (int i = 0; i < this.ua.size(); ++i) {
                list.ua[i] = converter.ua(this.get_Item(i));
            }
            list.yg = this.ua.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), 0, array, 0, this.ua.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), 0, array, arrayIndex, this.ua.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.ua(index, count);
            com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(s6<T> match) {
            ListInternalized.yg(match);
            return this.ua(0, this.ua.size(), match) != -1;
        }

        @Override
        private int ua(int n, int n10, s6<T> s62) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!s62.invoke(this.ua.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void yg(s6<T> s62) {
            if (s62 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(s6<T> match) {
            ListInternalized.yg(match);
            int n = this.ua(0, this.ua.size(), match);
            return n != -1 ? (T)this.ua.get(n) : null;
        }

        @Override
        public List<T> findAll(s6<T> match) {
            ListInternalized.yg(match);
            return this.qa(match);
        }

        private List<T> qa(s6<T> s62) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!s62.invoke(this.ua.get(i))) continue;
                list.addItem(this.ua.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(s6<T> match) {
            ListInternalized.yg(match);
            return this.ua(0, this.ua.size(), match);
        }

        @Override
        public int findIndex(int startIndex, s6<T> match) {
            ListInternalized.yg(match);
            this.ua(startIndex);
            return this.ua(startIndex, this.ua.size() - startIndex, match);
        }

        @Override
        private void ua(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, s6<T> match) {
            ListInternalized.yg(match);
            this.ua(startIndex, count);
            return this.ua(startIndex, count, match);
        }

        @Override
        public T findLast(s6<T> match) {
            ListInternalized.yg(match);
            int n = this.yg(0, this.ua.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int yg(int n, int n10, s6<T> s62) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!s62.invoke(this.ua.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(s6<T> match) {
            ListInternalized.yg(match);
            return this.yg(0, this.ua.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, s6<T> match) {
            ListInternalized.yg(match);
            this.ua(startIndex);
            return this.yg(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, s6<T> match) {
            ListInternalized.yg(match);
            int n = startIndex - count + 1;
            this.ua(n, count);
            return this.yg(n, count, match);
        }

        @Override
        public void forEach(ua<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.ua.size(); ++i) {
                action.invoke(this.ua.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.ua(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.ua.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.ua(index);
            return com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), item, index, this.ua.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.ua.size() == 0) {
                return -1;
            }
            return pb.ua(this.ua.toArray(), item, this.ua.size() - 1, this.ua.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.ua(index);
            return pb.ua(this.ua.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return pb.ua(this.ua.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.ua.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.ua.size());
        }

        @Override
        public boolean trueForAll(s6<T> match) {
            ListInternalized.yg(match);
            for (int i = 0; i < this.ua.size(); ++i) {
                if (match.invoke(this.ua.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.ua.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.ua.size(); ++i) {
                this.ua.add(null);
            }
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public T get_Item(int index) {
            return this.ua.get(index);
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.l8() > 1 || array.yg(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua.toArray()), 0, array, arrayIndex, this.ua.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.ua.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.ua.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.ua.size(); ++i) {
                    if (this.ua.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.ua.size(); ++i) {
                if (!this.ua.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.ua.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.yg;
            return this.ua.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.yg;
            return this.ua.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.ua.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.yg;
            return this.ua.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.yg;
            return this.ua.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.yg;
            return this.ua.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.yg;
            return this.ua.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.ua.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.yg;
            return this.ua.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.yg;
            this.ua.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.yg;
            return this.ua.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.ua.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.ua.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.ua.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.ua.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.ua.add(item);
            ++this.yg;
        }

        @Override
        public void clear() {
            this.ua.clear();
            ++this.yg;
        }

        @Override
        public void insertItem(int index, T item) {
            this.ua.add(index, item);
            ++this.yg;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.ua.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.ua.add(n++, e);
                }
            }
            ++this.yg;
        }

        @Override
        public int removeAll(s6<T> match) {
            ListInternalized.yg(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.ua.size() && !match.invoke(this.ua.get(n)); ++n) {
            }
            if (n == this.ua.size()) {
                return 0;
            }
            ++this.yg;
            for (n10 = n + 1; n10 < this.ua.size(); ++n10) {
                if (match.invoke(this.ua.get(n10))) continue;
                this.ua.set(n++, this.ua.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.ua.remove(this.ua.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.ua.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.ua.remove(index);
            ++this.yg;
        }

        @Override
        public void removeRange(int index, int count) {
            this.ua(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.ua.remove(index);
                }
                ++this.yg;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.ua(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.ua.get(n);
                this.ua.set(n, this.ua.get(i));
                this.ua.set(i, t);
            }
            ++this.yg;
        }

        @Override
        public void sort() {
            Collections.sort(this.ua, null);
            ++this.yg;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.ua, comparer);
            ++this.yg;
        }

        @Override
        public void sort(final h1<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.ua, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.ua(o12, o22);
                }
            });
            ++this.yg;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.ua(index, count);
            java.util.List<T> list = this.ua.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.ua.set(index + i, list.get(i));
            }
            ++this.yg;
        }

        @Override
        public void set_Item(int index, T value) {
            this.ua(index);
            if ((long)index == (long)this.ua.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.ua.set(index, value);
            ++this.yg;
        }

        @Override
        private void ua(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @nz
    public static class EnumeratorJava<T>
    extends se<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> yg = new List();
        private int qa;
        private int l8;
        private T lx;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.yg = l;
            this.l8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void ua() {
            if (this.l8 != this.yg.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.qa < 0 || this.qa >= this.yg.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.l8 != this.yg.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.lx = this.yg.get_Item(this.qa++);
            return this.lx;
        }

        @Override
        public boolean hasNext() {
            if (this.l8 == this.yg.getVersion()) {
                if (this.qa < 0) {
                    return false;
                }
                return this.qa < this.yg.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.ua();
            this.qa = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.yg = this.yg;
            that.qa = this.qa;
            that.l8 = this.l8;
            that.lx = this.lx;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ua(EnumeratorJava enumeratorJava) {
            return kn.ua(enumeratorJava.yg, this.yg) && enumeratorJava.qa == this.qa && enumeratorJava.l8 == this.l8 && kn.ua(enumeratorJava.lx, this.lx);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.ua((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.yg != null ? this.yg.hashCode() : 0;
            n = 31 * n + this.qa;
            n = 31 * n + this.l8;
            n = 31 * n + (this.lx != null ? this.lx.hashCode() : 0);
            return n;
        }
    }

    @nz
    public static class Enumerator<T>
    extends se<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> yg = new List();
        private int qa;
        private int l8;
        private T lx;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.yg = l;
            this.l8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void ua() {
            if (this.l8 != this.yg.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.l8 == this.yg.getVersion()) {
                if (this.qa < 0) {
                    return false;
                }
                if (this.qa < this.yg.size()) {
                    this.lx = this.yg.get_Item(this.qa++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.qa = this.yg.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.ua();
            this.qa = 0;
        }

        @Override
        public T next() {
            if (this.qa < 0 || this.qa >= this.yg.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.lx;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.yg = this.yg;
            that.qa = this.qa;
            that.l8 = this.l8;
            that.lx = this.lx;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ua(Enumerator enumerator) {
            return kn.ua(enumerator.yg, this.yg) && enumerator.qa == this.qa && enumerator.l8 == this.l8 && kn.ua(enumerator.lx, this.lx);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (kn.yg(null, obj)) {
                return false;
            }
            if (kn.yg(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.ua((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.yg != null ? this.yg.hashCode() : 0;
            n = 31 * n + this.qa;
            n = 31 * n + this.l8;
            n = 31 * n + (this.lx != null ? this.lx.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.ua = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.ua != 0;
        }

        @Override
        public int nextIndex() {
            return this.ua;
        }

        @Override
        public int previousIndex() {
            return this.ua - 1;
        }

        public T previous() {
            int n = this.ua - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.ua;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.ua = n;
            this.yg = n;
            return objectArray[this.yg];
        }

        public void set(T e) {
            if (this.yg < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.yg, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.ua;
                List.this.add(n, e);
                this.ua = n + 1;
                this.yg = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int ua;
        int yg = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.ua != List.this.yg;
        }

        @Override
        public T next() {
            int n = this.ua;
            if (n >= List.this.yg) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.ua;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.ua = n + 1;
            this.yg = n;
            return (T)objectArray[this.yg];
        }

        @Override
        public void remove() {
            if (this.yg < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.yg);
                this.ua = this.yg;
                this.yg = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

