/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.nz;

@nz
public final class BitArray
implements ICollection,
az {
    private int[] ua;
    private int yg;
    private int qa = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.yg = bits.yg;
        this.ua = new int[(this.yg + 31) / 32];
        if (this.ua.length == 1) {
            this.ua[0] = bits.ua[0];
        } else {
            l8.ua(bits.ua, 0, this.ua, 0, this.ua.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.yg = values.length;
        this.ua = new int[(this.yg + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.yg = bytes.length * 8;
        this.ua = new int[(this.yg + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.ua(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.yg = n * 32;
        this.ua = new int[n];
        l8.ua(values, 0, this.ua, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.yg = length;
        this.ua = new int[(this.yg + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.ua.length; ++i) {
                this.ua[i] = -1;
            }
        }
    }

    private byte ua(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.ua[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void ua(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.ua[n12] = this.ua[n12] & ~(255 << n11);
        int n13 = n10;
        this.ua[n13] = this.ua[n13] | (by2 & 0xFF) << n11;
        ++this.qa;
    }

    private void yg(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.yg != this.yg) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.yg;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.yg;
    }

    public void setLength(int value) {
        if (this.yg == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.yg) {
            int n = (value + 31) / 32;
            int n10 = (this.yg + 31) / 32;
            if (n > this.ua.length) {
                int[] nArray = new int[n];
                l8.ua(this.ua, 0, nArray, 0, this.ua.length);
                this.ua = nArray;
            } else {
                l8.ua(l8.ua((Object)this.ua), n10, n - n10);
            }
            int n11 = this.yg % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.ua[n12] = this.ua[n12] & (1 << n11) - 1;
            }
        }
        this.yg = value;
        ++this.qa;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(l8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.l8() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.lx() && this.yg > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = l8.ua(array);
        if (object instanceof Boolean[]) {
            if (array.lx() - index < this.yg) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.yg; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.lx() - index < this.yg) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.yg; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.yg + 7) / 8;
            if (array.lx() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.ua(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.yg + 7) / 8;
            if (array.lx() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.ua(i);
            }
        } else if (object instanceof Integer[]) {
            l8.ua(l8.ua((Object)this.ua), 0, array, index, (this.yg + 31) / 32);
        } else if (object instanceof int[]) {
            l8.ua(l8.ua((Object)this.ua), 0, array, index, (this.yg + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.yg + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.ua[i] = ~this.ua[i];
        }
        ++this.qa;
        return this;
    }

    public BitArray and(BitArray value) {
        this.yg(value);
        int n = (this.yg + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.ua[n10] = this.ua[n10] & value.ua[i];
        }
        ++this.qa;
        return this;
    }

    public BitArray or(BitArray value) {
        this.yg(value);
        int n = (this.yg + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.ua[n10] = this.ua[n10] | value.ua[i];
        }
        ++this.qa;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.yg(value);
        int n = (this.yg + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.ua[n10] = this.ua[n10] ^ value.ua[i];
        }
        ++this.qa;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.yg) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.ua[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.yg) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.ua[n] = this.ua[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.ua[n] = this.ua[n] & ~(1 << (index & 0x1F));
        }
        ++this.qa;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.ua.length; ++i) {
                this.ua[i] = -1;
            }
        } else {
            l8.ua(l8.ua((Object)this.ua), 0, this.ua.length);
        }
        ++this.qa;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @nz
    private static class BitArrayEnumerator
    implements IEnumerator,
    az,
    Cloneable {
        private BitArray ua;
        private boolean yg;
        private int qa;
        private int l8;

        @Override
        public Object deepClone() {
            return this.ua();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.qa = -1;
            this.ua = ba2;
            this.l8 = ba2.qa;
        }

        @Override
        public Object next() {
            if (this.qa == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.qa >= this.ua.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.yg;
        }

        @Override
        public boolean hasNext() {
            this.yg();
            if (this.qa < this.ua.size() - 1) {
                this.yg = this.ua.get_Item(++this.qa);
                return true;
            }
            this.qa = this.ua.size();
            return false;
        }

        @Override
        public void reset() {
            this.yg();
            this.qa = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void yg() {
            if (this.l8 != this.ua.qa) {
                throw new InvalidOperationException();
            }
        }

        protected Object ua() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.ua = this.ua;
            bitArrayEnumerator.yg = this.yg;
            bitArrayEnumerator.qa = this.qa;
            bitArrayEnumerator.l8 = this.l8;
            return bitArrayEnumerator;
        }
    }
}

