/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.az;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.ms.System.no;
import com.aspose.slides.ms.System.nz;
import com.aspose.slides.ms.System.pb;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@nz
public class ArrayList
implements IList,
List {
    private Object[] ua;
    private int yg;
    private int qa;
    private static Object[] l8 = new Object[0];

    protected int getVersion() {
        return this.qa;
    }

    public ArrayList() {
        this.ua = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.ua = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.ua("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.ua = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.ua = null;
    }

    private ArrayList(l8 array, int index, int count) {
        this.ua = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.l8.ua(array, index, com.aspose.slides.ms.System.l8.ua(this.ua), 0, count);
        this.yg = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.yg) {
            ArrayList.ua("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.ua[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.yg) {
            ArrayList.ua("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.ua[index] = value;
        ++this.qa;
    }

    @Override
    public int size() {
        return this.yg;
    }

    public int getCapacity() {
        return this.ua.length;
    }

    public void setCapacity(int value) {
        if (value < this.yg) {
            ArrayList.ua("Capacity", (Object)value, "Must be more than count.");
        }
        this.ua = value > 0 ? Arrays.copyOf(this.ua, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void ua(int n) {
        int n10;
        if (n <= this.ua.length) {
            return;
        }
        int n11 = n10 = this.ua.length == 0 ? 4 : this.ua.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void ua(int n, int n10) {
        if (n10 > 0) {
            if (this.yg + n10 > this.ua.length) {
                int n11;
                int n12 = n11 = this.ua.length > 0 ? this.ua.length << 1 : 1;
                while (n11 < this.yg + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.l8.ua(this.ua, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.l8.ua(this.ua, n, objectArray, n + n10, this.yg - n);
                this.ua = objectArray;
            } else {
                com.aspose.slides.ms.System.l8.ua(this.ua, n, this.ua, n + n10, this.yg - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.l8.ua(this.ua, n13, this.ua, n, this.yg - n13);
            com.aspose.slides.ms.System.l8.ua(this.ua, this.yg + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.ua.length <= this.yg) {
            this.ua(this.yg + 1);
        }
        this.ua[this.yg] = value;
        ++this.qa;
        return this.yg++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.l8.ua(this.ua, 0, this.yg);
        this.yg = 0;
        ++this.qa;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.yg) > -1;
    }

    boolean ua(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.yg - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.yg) {
            ArrayList.ua("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.ua("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.yg - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.l8.ua(this.ua, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.yg - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return pb.ua(this.ua, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.yg) {
            ArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.ua(index, 1);
        this.ua[index] = value;
        ++this.yg;
        ++this.qa;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.yg) {
            ArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.ua.length < this.yg + n) {
                this.ua(this.yg + n);
            }
            if (index < this.yg) {
                com.aspose.slides.ms.System.l8.ua(this.ua, index, this.ua, index + n, this.yg - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.l8.ua(this.ua, 0, this.ua, index, index);
                com.aspose.slides.ms.System.l8.ua(this.ua, index + n, this.ua, index << 1, this.yg - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.l8.ua(this.ua), index);
            }
            this.yg += c.size();
            ++this.qa;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.yg) {
            ArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.ua.length < this.yg + n) {
                this.ua(this.yg + n);
            }
            if (index < this.yg) {
                com.aspose.slides.ms.System.l8.ua(this.ua, index, this.ua, index + n, this.yg - index);
            }
            com.aspose.slides.ms.System.l8.ua(c).copyTo(com.aspose.slides.ms.System.l8.ua(this.ua), index);
            this.yg += c.length;
            ++this.qa;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.qa;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.yg) {
            ArrayList.ua("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.ua(index, -1);
        --this.yg;
        ++this.qa;
    }

    public void removeRange(int index, int count) {
        ArrayList.ua(index, count, this.yg);
        this.ua(index, -count);
        this.yg -= count;
        ++this.qa;
    }

    public void reverse() {
        pb.ua(this.ua, 0, this.yg);
        ++this.qa;
    }

    public void reverse(int index, int count) {
        ArrayList.ua(index, count, this.yg);
        pb.ua(this.ua, index, count);
        ++this.qa;
    }

    public void copyTo(l8 array) {
        com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), 0, array, 0, this.yg);
    }

    @Override
    public void copyTo(l8 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.yg);
    }

    public void copyTo(int index, l8 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.l8() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.ua(index, count, this.yg);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.yg, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.yg, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return pb.ua(this.ua, 0, this.yg, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return pb.ua(this.ua, 0, this.yg, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return pb.ua(this.ua, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.ua(index, count, this.yg);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.yg) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.l8.ua(this.ua), index);
        ++this.qa;
    }

    public void trimToSize() {
        this.setCapacity(this.yg);
    }

    public void sort() {
        Arrays.sort(this.ua, 0, this.yg, Comparer.Default);
        ++this.qa;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.ua, 0, this.yg, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.ua(index, count, this.yg);
        Arrays.sort(this.ua, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.yg];
        this.copyTo(com.aspose.slides.ms.System.l8.ua(objectArray));
        return objectArray;
    }

    public l8 toArray(no type) {
        l8 l82 = com.aspose.slides.ms.System.l8.ua(type, this.yg);
        this.copyTo(l82);
        return l82;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.l8.ua(this.ua), 0, this.yg);
    }

    static void ua(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.ua("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.ua("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void ua(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.l8.ua(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.yg, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List ua;
        private int yg;

        @Override
        protected int getVersion() {
            return this.ua instanceof ArrayList ? ((ArrayList)this.ua).getVersion() : this.yg;
        }

        public ArrayListInternalized(List internal) {
            this.ua = internal;
            if (internal instanceof ArrayList) {
                this.yg = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.ua.set(index, value);
            ++this.yg;
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.ua.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.ua.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.ua.size(); ++i) {
                this.ua.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.ua.size();
            this.ua.add(value);
            ++this.yg;
            return n;
        }

        @Override
        public void clear() {
            this.ua.clear();
            ++this.yg;
        }

        @Override
        public boolean contains(Object item) {
            return this.ua.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.ua.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.ua.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.ua.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.ua.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.ua.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return pb.ua(this.ua.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.ua.add(index, value);
            ++this.yg;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.ua.add(index++, e);
            }
            ++this.yg;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.ua.add(index++, object);
            }
            ++this.yg;
        }

        @Override
        public void removeItem(Object obj) {
            this.ua.remove(obj);
            ++this.yg;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.ua.remove(index);
            ++this.yg;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.ua.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.ua.remove(index);
            }
            ++this.yg;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.ua.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.ua.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.ua.size() - 1; n < i; ++n, --i) {
                Object e = this.ua.get(n);
                this.ua.set(n, this.ua.get(i));
                this.ua.set(i, e);
            }
            ++this.yg;
        }

        @Override
        public void copyTo(l8 array) {
            com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua.toArray()), 0, array, 0, this.ua.size());
        }

        @Override
        public void copyTo(l8 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.ua.size());
        }

        @Override
        public void copyTo(int index, l8 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.l8() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.l8.ua(com.aspose.slides.ms.System.l8.ua(this.ua.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.ua(index, count, this.ua.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.ua.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return pb.ua(this.ua.toArray(), 0, this.ua.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return pb.ua(this.ua.toArray(), 0, this.ua.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return pb.ua(this.ua.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.ua(index, count, this.ua.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.ua.set(index++, e);
            }
            ++this.yg;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.ua, null);
            ++this.yg;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.ua, comparer);
            ++this.yg;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.ua.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.ua.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.ua.set(i, list.get(i - index));
            }
            ++this.yg;
        }

        @Override
        public Object[] toArray() {
            return this.ua.toArray();
        }

        @Override
        public l8 toArray(no type) {
            l8 l82 = com.aspose.slides.ms.System.l8.ua(type, this.ua.size());
            this.copyTo(l82);
            return l82;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.ua.size()];
            com.aspose.slides.ms.System.l8.ua(this.ua.toArray(), 0, objectArray, 0, this.ua.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.ua.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.ua.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.yg;
            return this.ua.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.yg;
            return this.ua.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.ua.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.yg;
            return this.ua.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.yg;
            return this.ua.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.yg;
            return this.ua.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.yg;
            return this.ua.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.ua.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.yg;
            return this.ua.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.ua.add(index, element);
            ++this.yg;
        }

        @Override
        public Object remove(int index) {
            ++this.yg;
            return this.ua.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.ua.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.ua.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.ua.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.ua = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.ua != 0;
        }

        @Override
        public int nextIndex() {
            return this.ua;
        }

        @Override
        public int previousIndex() {
            return this.ua - 1;
        }

        public Object previous() {
            int n = this.ua - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.ua;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.ua = n;
            this.yg = n;
            return objectArray[this.yg];
        }

        public void set(Object e) {
            if (this.yg < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).ua[this.yg] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.ua;
                ArrayList.this.add(n, e);
                this.ua = n + 1;
                this.yg = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int ua;
        int yg = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.ua != ArrayList.this.size();
        }

        public Object next() {
            int n = this.ua;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.ua;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.ua = n + 1;
            this.yg = n;
            return objectArray[this.yg];
        }

        @Override
        public void remove() {
            if (this.yg < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.yg);
                this.ua = this.yg;
                this.yg = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @nz
    private static class ListWrapper
    implements IList {
        protected IList ua;

        public ListWrapper(IList innerList) {
            this.ua = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.ua.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.ua.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.ua.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.ua.addItem(value);
        }

        @Override
        public void clear() {
            this.ua.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.ua.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.ua.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.ua.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.ua.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.ua.removeAt(index);
        }

        @Override
        public void copyTo(l8 array, int index) {
            this.ua.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.ua.iterator();
        }
    }

    @nz
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String ua() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.ua());
        }
    }

    @nz
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String ua() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.ua());
        }
    }

    @nz
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object yg;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.yg = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.yg;
            synchronized (object) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int index) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.iterator();
            }
        }
    }

    @nz
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int yg;
        private int qa;
        private int l8;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.yg = index;
            this.qa = count;
            this.l8 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.qa) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.ua.get_Item(this.yg + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.qa) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.ua.set_Item(this.yg + index, value);
        }

        @Override
        public int size() {
            this.ua();
            return this.qa;
        }

        @Override
        public int getCapacity() {
            return this.ua.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.qa) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void ua() {
            if (this.l8 != this.ua.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.ua();
            this.ua.insertItem(this.yg + this.qa, value);
            this.l8 = this.ua.getVersion();
            return ++this.qa;
        }

        @Override
        public void clear() {
            this.ua();
            this.ua.removeRange(this.yg, this.qa);
            this.qa = 0;
            this.l8 = this.ua.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.ua.ua(value, this.yg, this.qa);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.qa - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.qa) {
                RangedArrayList.ua("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.ua("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.qa - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.ua.indexOf(value, this.yg + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.yg;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.qa - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.ua("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.ua("count", (Object)count, "count is negative.");
            }
            if ((n = this.ua.lastIndexOf(value, this.yg + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.yg;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.ua();
            if (index < 0 || index > this.qa) {
                RangedArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.ua.insertItem(this.yg + index, value);
            ++this.qa;
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.ua();
            if (index < 0 || index > this.qa) {
                RangedArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.ua.insertRange(this.yg + index, c);
            this.qa += c.size();
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.ua();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.ua();
            if (index < 0 || index > this.qa) {
                RangedArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.ua.removeAt(this.yg + index);
            --this.qa;
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.ua();
            RangedArrayList.ua(index, count, this.qa);
            this.ua.removeRange(this.yg + index, count);
            this.qa -= count;
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.qa);
        }

        @Override
        public void reverse(int index, int count) {
            this.ua();
            RangedArrayList.ua(index, count, this.qa);
            this.ua.reverse(this.yg + index, count);
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.ua();
            if (index < 0 || index > this.qa) {
                RangedArrayList.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.ua.setRange(this.yg + index, c);
            this.l8 = this.ua.getVersion();
        }

        @Override
        public void copyTo(l8 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(l8 array, int index) {
            this.copyTo(0, array, index, this.qa);
        }

        @Override
        public void copyTo(int index, l8 array, int arrayIndex, int count) {
            RangedArrayList.ua(index, count, this.qa);
            this.ua.copyTo(this.yg + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.qa);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.ua(index, count, this.qa);
            return this.ua.iterator(this.yg + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.ua();
            this.ua.insertRange(this.qa, c);
            this.qa += c.size();
            this.l8 = this.ua.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.qa, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.qa, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.ua(index, count, this.qa);
            return this.ua.binarySearch(this.yg + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.ua.deepClone(), this.yg, this.qa);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.ua(index, count, this.qa);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.qa, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.ua();
            RangedArrayList.ua(index, count, this.qa);
            this.ua.sort(this.yg + index, count, comparer);
            this.l8 = this.ua.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.qa];
            this.ua.copyTo(this.yg, com.aspose.slides.ms.System.l8.ua(objectArray), 0, this.qa);
            return objectArray;
        }

        @Override
        public l8 toArray(no elementType) {
            l8 l82 = com.aspose.slides.ms.System.l8.ua(elementType, this.qa);
            this.ua.copyTo(this.yg, l82, 0, this.qa);
            return l82;
        }
    }

    @nz
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String ua() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.ua());
        }
    }

    @nz
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String ua() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.ua());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.ua());
        }
    }

    @nz
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object yg;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.yg = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.yg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.yg;
            synchronized (object) {
                this.ua.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.yg;
            synchronized (object) {
                this.ua.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(l8 array, int index) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, l8 array, int arrayIndex, int count) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.yg;
            synchronized (object) {
                this.ua.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.yg;
            synchronized (object) {
                this.ua.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.yg;
            synchronized (object) {
                this.ua.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public l8 toArray(no elementType) {
            Object object = this.yg;
            synchronized (object) {
                return this.ua.toArray(elementType);
            }
        }
    }

    @nz
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList ua;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.ua = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.ua.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public int getCapacity() {
            return this.ua.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.ua.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.ua.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.ua.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.ua.addItem(value);
        }

        @Override
        public void clear() {
            this.ua.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.ua.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.ua.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.ua.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.ua.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.ua.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.ua.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.ua.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.ua.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.ua.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.ua.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.ua.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.ua.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.ua.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.ua.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.ua.setRange(index, c);
        }

        @Override
        public void copyTo(l8 array) {
            this.ua.copyTo(array);
        }

        @Override
        public void copyTo(l8 array, int index) {
            this.ua.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, l8 array, int arrayIndex, int count) {
            this.ua.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.ua.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.ua.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.ua.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.ua.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.ua.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.ua.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.ua.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.ua.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.ua.trimToSize();
        }

        @Override
        public void sort() {
            this.ua.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.ua.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.ua.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.ua.toArray();
        }

        @Override
        public l8 toArray(no elementType) {
            return this.ua.toArray(elementType);
        }
    }

    @nz
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList ua;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.ua = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.ua.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.ua.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.ua.size();
        }

        @Override
        public int getCapacity() {
            return this.ua.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.ua.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.ua.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.ua.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.ua.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.ua.addItem(value);
        }

        @Override
        public void clear() {
            this.ua.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.ua.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.ua.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.ua.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.ua.size()) {
                ArrayListAdapter.ua("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.ua("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.ua.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.ua.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.ua.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.ua.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.ua("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.ua("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.ua("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.ua.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.ua.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.ua.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.ua.size()) {
                ArrayListAdapter.ua("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.ua.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.ua.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.ua.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            for (int i = 0; i < count; ++i) {
                this.ua.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.ua.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.ua.get_Item(i + index);
                this.ua.set_Item(i + index, this.ua.get_Item(index + count - i + index - 1));
                this.ua.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.ua.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.ua.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(l8 array) {
            this.ua.copyTo(array, 0);
        }

        @Override
        public void copyTo(l8 array, int index) {
            this.ua.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, l8 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.ua("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.ua("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.ua("index", (Object)index, "Can't be less than zero.");
            }
            if (array.l8() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.lx() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.ua.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.qa(this.ua.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.ua.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.ua.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            return new EnumeratorWithRange(this.ua.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.ua.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.ua.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.ua.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.ua);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.ua.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.ua(index, count, this.ua.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.ua(this.ua, index, index + count - 1, comparer);
        }

        private static void ua(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void ua(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.ua(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.ua(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.ua(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.ua(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.ua(iList, n12, n13);
            }
            ArrayListAdapter.ua(iList, n10 - 1, n12);
            ArrayListAdapter.ua(iList, n, n12 - 1, comparator);
            ArrayListAdapter.ua(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.ua.size()];
            this.ua.copyTo(com.aspose.slides.ms.System.l8.ua(objectArray), 0);
            return objectArray;
        }

        @Override
        public l8 toArray(no elementType) {
            l8 l82 = com.aspose.slides.ms.System.l8.ua(elementType, this.ua.size());
            this.ua.copyTo(l82, 0);
            return l82;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        az,
        Cloneable {
            private int ua;
            private int yg;
            private int qa;
            private IEnumerator l8;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.yg = 0;
                this.ua = index;
                this.qa = count;
                this.l8 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.ua();
            }

            @Override
            public Object next() {
                return this.l8.next();
            }

            @Override
            public boolean hasNext() {
                if (this.yg >= this.qa) {
                    return false;
                }
                ++this.yg;
                return this.l8.hasNext();
            }

            @Override
            public void reset() {
                this.yg = 0;
                this.l8.reset();
                for (int i = 0; i < this.ua; ++i) {
                    this.l8.hasNext();
                }
            }

            protected Object ua() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.ua = this.ua;
                enumeratorWithRange.yg = this.yg;
                enumeratorWithRange.qa = this.qa;
                enumeratorWithRange.l8 = this.l8;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    az,
    Cloneable {
        private ArrayList yg;
        private Object qa;
        private int l8;
        private int lx;
        static Object ua = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.yg = list;
            this.l8 = -1;
            this.lx = list.getVersion();
            this.qa = ua;
        }

        @Override
        public Object deepClone() {
            return this.ua();
        }

        @Override
        public boolean hasNext() {
            if (this.lx != this.yg.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.l8 < this.yg.size()) {
                this.qa = this.yg.get_Item(this.l8);
                return true;
            }
            this.qa = ua;
            return false;
        }

        @Override
        public Object next() {
            if (this.qa == ua) {
                if (this.l8 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.qa;
        }

        @Override
        public void reset() {
            if (this.lx != this.yg.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.qa = ua;
            this.l8 = -1;
        }

        protected Object ua() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.yg = this.yg;
            simpleEnumerator.qa = this.qa;
            simpleEnumerator.l8 = this.l8;
            simpleEnumerator.lx = this.lx;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    az,
    Cloneable {
        private Object ua;
        private ArrayList yg;
        private int qa;
        private int l8;
        private int lx;
        private int ec;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.ua();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.yg = list;
            this.l8 = index;
            this.lx = count;
            this.qa = this.l8 - 1;
            this.ua = null;
            this.ec = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.qa == this.l8 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.ua;
        }

        @Override
        public boolean hasNext() {
            if (this.yg.getVersion() != this.ec) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.qa;
            if (this.qa - this.l8 < this.lx) {
                this.ua = this.yg.get_Item(this.qa);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.ua = null;
            this.qa = this.l8 - 1;
        }

        protected Object ua() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.ua = this.ua;
            arrayListEnumerator.yg = this.yg;
            arrayListEnumerator.qa = this.qa;
            arrayListEnumerator.l8 = this.l8;
            arrayListEnumerator.lx = this.lx;
            arrayListEnumerator.ec = this.ec;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

