/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.AxesCompositionNotCombinableException;
import com.aspose.slides.AxesManager;
import com.aspose.slides.CannotCombine2DAnd3DChartsException;
import com.aspose.slides.Chart;
import com.aspose.slides.ChartData;
import com.aspose.slides.ChartDataCell;
import com.aspose.slides.ChartDataWorkbook;
import com.aspose.slides.ChartSeries;
import com.aspose.slides.ChartTypeCharacterizer;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.DomObject;
import com.aspose.slides.IChart;
import com.aspose.slides.IChartCellCollection;
import com.aspose.slides.IChartDataCell;
import com.aspose.slides.IChartSeries;
import com.aspose.slides.IChartSeriesCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.cf9;
import com.aspose.slides.ea3;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.jo;
import com.aspose.slides.ms.System.gv;
import com.aspose.slides.ms.System.l8;
import com.aspose.slides.vu;
import com.aspose.slides.yt;

public class ChartSeriesCollection
extends DomObject<ChartData>
implements IChartSeriesCollection {
    private Chart ua;
    private final cf9<IChartSeries> yg;

    ChartSeriesCollection(ChartData parentImmediate) {
        super(parentImmediate);
        this.yg = new cf9(parentImmediate);
    }

    @Override
    public final IChartSeries get_Item(int index) {
        return (IChartSeries)this.yg.get_Item(index);
    }

    @Override
    public final int size() {
        return this.yg.size();
    }

    @Override
    public final IChartSeries add(int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.ua(chartSeries);
        chartSeries.yg(bl2);
        this.yg.addItem(chartSeries);
        chartSeries.qa();
        return chartSeries;
    }

    @Override
    public final IChartSeries insert(int index, int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.ua(chartSeries);
        chartSeries.yg(bl2);
        this.yg.insertItem(index, chartSeries);
        chartSeries.qa();
        return chartSeries;
    }

    private boolean ua(ChartSeries chartSeries) {
        if (this.yg.size() > 0) {
            IChartSeries iChartSeries = (IChartSeries)this.yg.get_Item(0);
            boolean bl2 = ChartTypeCharacterizer.is3DChart(iChartSeries.getType());
            for (int i = 1; i < this.yg.size(); ++i) {
                iChartSeries = (IChartSeries)this.yg.get_Item(i);
            }
            if (bl2 != ChartTypeCharacterizer.is3DChart(chartSeries.getType())) {
                if (bl2) {
                    throw new CannotCombine2DAnd3DChartsException(gv.ua(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 2D and present series is/are 3D)."}));
                }
                throw new CannotCombine2DAnd3DChartsException(gv.ua(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 3D and present series is/are 2D)."}));
            }
        }
        if (((AxesManager)this.ua().getAxes()).ua(chartSeries.getType(), false)) {
            return false;
        }
        if (((AxesManager)this.ua().getAxes()).ua(chartSeries.getType(), true)) {
            return true;
        }
        throw new AxesCompositionNotCombinableException(gv.ua("Some chart types cannot be combined with other chart types. Select a different chart type. ", "Details: axes composition of the series to be added is not combinable with present ", "axes composition in chart. So series of this type cannot be added to this chart. ", "Preferred axes composition for the series to be added is \"", ChartTypeCharacterizer.qa(ChartTypeCharacterizer.ua(chartSeries.getType())), "\"."));
    }

    final void ua(int n, IChartSeries iChartSeries) {
        if (this.yg.containsItem(iChartSeries)) {
            this.yg.removeItem(iChartSeries);
            this.yg.insertItem(n, iChartSeries);
        }
    }

    @Override
    public final IChartSeries add(IChartDataCell cellWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.yg) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != 1 || !iChartSeries.getName().getAsCells().get_Item(0).equals(cellWithSeriesName)) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        ((ChartData)this.ec).yg().ua(cellWithSeriesName);
        iChartSeries.getName().setFromOneCell(cellWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(IChartCellCollection cellsWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.yg) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != cellsWithSeriesName.getCount() || !gv.lx(iChartSeries.getName().getAsCells().getConcatenatedValuesFromCells(), cellsWithSeriesName.getConcatenatedValuesFromCells())) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        iChartSeries.getName().setAsCells(cellsWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(String name, int type) {
        ChartDataCell chartDataCell = ((ChartDataWorkbook)this.ua().getChartData().getChartDataWorkbook()).r3();
        chartDataCell.setValue(name);
        return this.add(chartDataCell, type);
    }

    final IChartSeries ua(int n, IChartSeriesGroup iChartSeriesGroup, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.yg(bl2);
        this.yg.addItem(chartSeries);
        ((AxesManager)this.ua().getAxes()).yg();
        ((vu)iChartSeriesGroup.getSeries()).ua(chartSeries);
        return chartSeries;
    }

    final IChartSeries ua(int n, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.yg(bl2);
        this.yg.addItem(chartSeries);
        ((AxesManager)this.ua().getAxes()).yg();
        ((yt)this.ua().getChartData().getSeriesGroups()).qa(chartSeries);
        return chartSeries;
    }

    @Override
    public final int indexOf(IChartSeries value) {
        return this.yg.indexOf(value);
    }

    @Override
    public final void remove(IChartSeries value) {
        if (this.yg.indexOf(value) == -1) {
            throw new ArgumentException("The value parameter was not found in the collection.");
        }
        this.yg.removeItem(value);
        ((AxesManager)this.ua().getAxes()).yg();
        ((yt)this.ua().getChartData().getSeriesGroups()).yg((ChartSeries)value);
    }

    @Override
    public final void removeAt(int index) {
        this.remove((IChartSeries)this.yg.get_Item(index));
    }

    @Override
    public final void clear() {
        while (this.yg.size() > 0) {
            this.removeAt(this.yg.size() - 1);
        }
    }

    final IChart ua() {
        if (this.ua == null) {
            Chart[] chartArray = new Chart[]{this.ua};
            ea3.ua(Chart.class, (jo)this.ec, chartArray);
            this.ua = chartArray[0];
        }
        return this.ua;
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iterator() {
        return this.yg.iterator();
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iteratorJava() {
        return this.yg.iteratorJava();
    }

    @Override
    public final void copyTo(l8 array, int index) {
        this.yg.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

