import unittest

from code_wallet.library.kin import Kin
from code_wallet.library.payment_request import PaymentRequestIntent

class TestProtoSerialization(unittest.TestCase):

    def test_proto_serialization_1(self):
        destination = "11111111111111111111111111111111"

        options = {
            'destination': destination,
            'amount': 10,
            'currency': 'usd'
        }

        intent = PaymentRequestIntent(options)
        actual = intent.to_proto()

        expected = bytearray([
            0x2A, 0x34, 0x0A, 0x22, 0x0A, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x1A, 0x0E, 0x0A, 0x03, 0x75, 0x73, 0x64, 0x11, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x24, 0x40
        ])

        self.assertEqual(actual, expected)

    def test_proto_serialization_2(self):
        destination = "11111111111111111111111111111111"

        kinAmount = Kin.from_decimal(10)
        options = {
            'destination': destination,
            'amount': kinAmount.whole,
            'currency': 'kin'
        }
        intent = PaymentRequestIntent(options)
        actual = intent.to_proto()

        expected = bytearray([
            0x2a, 0x40, 0x0a, 0x22, 0x0a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x69,
            0x6e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x19,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x20, 0xe8, 0x07
        ])

        self.assertEqual(actual, expected)
    
    def test_proto_serialization_3(self):
        destination = "2q7pyhPwAwZ3QMfZrnAbDhnh9mDUqycszcpf86VgQxhF"

        kinAmount = Kin.from_decimal(10.12345)
        options = {
            'destination': destination,
            'amount': kinAmount.whole,
            'currency': 'kin'
        }
        intent = PaymentRequestIntent(options)
        actual = intent.to_proto()

        expected = bytearray([
            0x2a, 0x40, 0x0a, 0x22, 0x0a, 0x20, 0x1b, 0x2f, 0x49, 0x09, 0x6e,
            0x3e, 0x5d, 0xbd, 0x0f, 0xcf, 0xa9, 0xc0, 0xc0, 0xcd, 0x92, 0xd9,
            0xab, 0x3b, 0x21, 0x54, 0x4b, 0x34, 0xd5, 0xdd, 0x4a, 0x65, 0xd9,
            0x8b, 0x87, 0x8b, 0x99, 0x22, 0x12, 0x1a, 0x0a, 0x03, 0x6b, 0x69,
            0x6e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x19,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x20, 0xe8, 0x07
        ])

        self.assertEqual(actual, expected)

if __name__ == "__main__":
    unittest.main()