from netbox.views import generic
from . import forms, models, tables

#Create four view for each object
#1. Detail view for a single object
#2. List view for all existing instances of the model
#3. Edit view for adding/modifying objects
#4. Delete view for deleting objects

#detail view
class BFDConfigView(generic.ObjectView):
    queryset = models.BFDConfig.objects.all()

#list view
class BFDConfigListView(generic.ObjectListView):
    queryset = models.BFDConfig.objects.all()
    table = tables.BFDConfigTable

#edit/modification view
class BFDConfigEditView(generic.ObjectEditView):
    queryset = models.BFDConfig.objects.all()
    form = forms.BFDConfigForm

#delete view
class BFDConfigDeleteView(generic.ObjectDeleteView):
    queryset = models.BFDConfig.objects.all()



# BGP Session Config Views
class BGPSessionConfigView(generic.ObjectView):
    queryset = models.BGPSessionConfig.objects.all()

class BGPSessionConfigListView(generic.ObjectListView):
    queryset = models.BGPSessionConfig.objects.all()
    table = tables.BGPSessionConfigTable

class BGPSessionConfigEditView(generic.ObjectEditView):
    queryset = models.BGPSessionConfig.objects.all()
    form = forms.BGPSessionConfigForm

class BGPSessionConfigDeleteView(generic.ObjectDeleteView):
    queryset = models.BGPSessionConfig.objects.all()


# BGP Peer Views
class BGPPeerView(generic.ObjectView):
    queryset = models.BGPPeer.objects.all()

class BGPPeerListView(generic.ObjectListView):
    queryset = models.BGPPeer.objects.all()
    table = tables.BGPPeerTable

class BGPPeerEditView(generic.ObjectEditView):
    queryset = models.BGPPeer.objects.all()
    form = forms.BGPPeerForm

class BGPPeerDeleteView(generic.ObjectDeleteView):
    queryset = models.BGPPeer.objects.all()



# BGP Peer Group Views
class BGPPeerGroupView(generic.ObjectView):
    queryset = models.BGPPeerGroup.objects.all()

class BGPPeerGroupListView(generic.ObjectListView):
    queryset = models.BGPPeerGroup.objects.all()
    table = tables.BGPPeerGroupTable

class BGPPeerGroupEditView(generic.ObjectEditView):
    queryset = models.BGPPeerGroup.objects.all()
    form = forms.BGPPeerGroupForm

class BGPPeerGroupDeleteView(generic.ObjectDeleteView):
    queryset = models.BGPPeerGroup.objects.all()