from django.urls import path
from netbox.views.generic import ObjectChangeLogView

from .constants import APP_LABEL
from . import models, views

urlpatterns = [
    # BFD Config URLs
    path('bfd-configs/',                 views.BFDConfigListView.as_view(),   name='bfdconfig_list'),
    path('bfd-configs/add/',             views.BFDConfigEditView.as_view(),   name='bfdconfig_add'),
    path('bfd-configs/<int:pk>/',        views.BFDConfigView.as_view(),       name='bfdconfig'),
    path('bfd-configs/<int:pk>/edit/',   views.BFDConfigEditView.as_view(),   name='bfdconfig_edit'),
    path('bfd-configs/<int:pk>/delete/', views.BFDConfigDeleteView.as_view(), name='bfdconfig_delete'),
    path('bfd-configs/<int:pk>/changelog/', ObjectChangeLogView.as_view(), name='bfdconfig_changelog', kwargs={
        'model': models.BFDConfig
    }),

    # BGP Session Config URLs
    path('bgp-session-configs/',                 views.BGPSessionConfigListView.as_view(),   name='bgpsessionconfig_list'),
    path('bgp-session-configs/add/',             views.BGPSessionConfigEditView.as_view(),   name='bgpsessionconfig_add'),
    path('bgp-session-configs/<int:pk>/',        views.BGPSessionConfigView.as_view(),       name='bgpsessionconfig'),
    path('bgp-session-configs/<int:pk>/edit/',   views.BGPSessionConfigEditView.as_view(),   name='bgpsessionconfig_edit'),
    path('bgp-session-configs/<int:pk>/delete/', views.BGPSessionConfigDeleteView.as_view(), name='bgpsessionconfig_delete'),
    path('bgp-session-configs/<int:pk>/changelog/', ObjectChangeLogView.as_view(),           name='bgpsessionconfig_changelog', kwargs={
        'model': models.BGPSessionConfig
    }),

    # BGP Peer URLs
    path('bgp-peers/',                 views.BGPPeerListView.as_view(),   name='bgppeer_list'),
    path('bgp-peers/add/',             views.BGPPeerEditView.as_view(),   name='bgppeer_add'),
    path('bgp-peers/<int:pk>/',        views.BGPPeerView.as_view(),       name='bgppeer'),
    path('bgp-peers/<int:pk>/edit/',   views.BGPPeerEditView.as_view(),   name='bgppeer_edit'),
    path('bgp-peers/<int:pk>/delete/', views.BGPPeerDeleteView.as_view(), name='bgppeer_delete'),
    path('bgp-peers/<int:pk>/changelog/', ObjectChangeLogView.as_view(), name='bgppeer_changelog', kwargs={
        'model': models.BGPPeer
    }),

    # BGP Peer Group URLs
    path('bgp-peer-groups/',                 views.BGPPeerGroupListView.as_view(),   name='bgppeergroup_list'),
    path('bgp-peer-groups/add/',             views.BGPPeerGroupEditView.as_view(),   name='bgppeergroup_add'),
    path('bgp-peer-groups/<int:pk>/',        views.BGPPeerGroupView.as_view(),       name='bgppeergroup'),
    path('bgp-peer-groups/<int:pk>/edit/',   views.BGPPeerGroupEditView.as_view(),   name='bgppeergroup_edit'),
    path('bgp-peer-groups/<int:pk>/delete/', views.BGPPeerGroupDeleteView.as_view(), name='bgppeergroup_delete'),
    path('bgp-peer-groups/<int:pk>/changelog/', ObjectChangeLogView.as_view(), name='bgppeergroup_changelog', kwargs={
        'model': models.BGPPeerGroup
    }),
]

#this is where we link views to URLs
#<int:pk> is a path converter which allows the user to enter an integer to get a specific object from the database by its id



