# Generated by Django 5.2.6 on 2025-09-24 21:55

import django.db.models.deletion
import netbox.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('dcim', '0215_rackreservation_status'),
        ('extras', '0133_make_cf_minmax_decimal'),
        ('netbox_routing_complex', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BGPPeerGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, max_length=100)),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bgp_peer_groups', to='dcim.device')),
                ('peers', models.ManyToManyField(blank=True, related_name='peer_groups', to='netbox_routing_complex.bgppeer')),
                ('session_config', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='netbox_routing_complex.bgpsessionconfig')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('name',),
                'unique_together': {('device', 'name')},
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
    ]
