# Generated by Django 5.2.6 on 2025-09-24 21:03

import django.contrib.postgres.fields
import django.db.models.deletion
import netbox.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0215_rackreservation_status'),
        ('extras', '0133_make_cf_minmax_decimal'),
        ('ipam', '0082_add_prefix_network_containment_indexes'),
    ]

    operations = [
        migrations.CreateModel(
            name='BFDConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('hello_interval', models.PositiveIntegerField()),
                ('multiplier', models.PositiveIntegerField()),
                ('description', models.CharField(blank=True, max_length=256)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('hello_interval', 'multiplier', 'description'),
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BGPSessionConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('address_families', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=30), blank=True, null=True, size=None)),
                ('peer_asn', models.BigIntegerField(blank=True, null=True)),
                ('import_policy', models.CharField(blank=True, max_length=100, null=True)),
                ('export_policy', models.CharField(blank=True, max_length=100, null=True)),
                ('next_hop_self', models.BooleanField(default=False)),
                ('hardcoded_description', models.CharField(blank=True, max_length=200, null=True)),
                ('hello_interval', models.PositiveIntegerField(blank=True, null=True)),
                ('keepalive_interval', models.PositiveIntegerField(blank=True, null=True)),
                ('ebgp_multihop', models.PositiveIntegerField(blank=True, null=True)),
                ('unencrypted_password', models.CharField(blank=True, max_length=100, null=True)),
                ('encrypted_password', models.CharField(blank=True, max_length=100, null=True)),
                ('local_asn', models.BigIntegerField(blank=True, null=True)),
                ('bfd_config', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='netbox_routing_complex.bfdconfig')),
                ('source_interface', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='dcim.interface')),
                ('source_ip', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='ipam.ipaddress')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('name',),
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BGPPeer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(blank=True, max_length=100)),
                ('peer_ip', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='bgp_peer', to='ipam.ipaddress')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('session_config', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='netbox_routing_complex.bgpsessionconfig')),
            ],
            options={
                'verbose_name': 'BGP Peer',
                'verbose_name_plural': 'BGP Peers',
                'ordering': ('name', 'peer_ip'),
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
    ]
