# Generated by Django 5.2.6 on 2025-09-28 14:31

import django.db.models.deletion
import wagtail.contrib.forms.models
import wagtail.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("docs_pages", "0004_alter_docspage_content"),
        ("wagtailcore", "0095_groupsitepermission"),
    ]

    operations = [
        migrations.CreateModel(
            name="FormField",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "clean_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Safe name of the form field, the label converted to ascii_snake_case",
                        max_length=255,
                        verbose_name="name",
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        help_text="The label of the form field",
                        max_length=255,
                        verbose_name="label",
                    ),
                ),
                (
                    "field_type",
                    models.CharField(
                        choices=[
                            ("singleline", "Single line text"),
                            ("multiline", "Multi-line text"),
                            ("email", "Email"),
                            ("number", "Number"),
                            ("url", "URL"),
                            ("checkbox", "Checkbox"),
                            ("checkboxes", "Checkboxes"),
                            ("dropdown", "Drop down"),
                            ("multiselect", "Multiple select"),
                            ("radio", "Radio buttons"),
                            ("date", "Date"),
                            ("datetime", "Date/time"),
                            ("hidden", "Hidden field"),
                        ],
                        max_length=16,
                        verbose_name="field type",
                    ),
                ),
                (
                    "required",
                    models.BooleanField(default=True, verbose_name="required"),
                ),
                (
                    "choices",
                    models.TextField(
                        blank=True,
                        help_text="Comma or new line separated list of choices. Only applicable in checkboxes, radio and dropdown.",
                        verbose_name="choices",
                    ),
                ),
                (
                    "default_value",
                    models.TextField(
                        blank=True,
                        help_text="Default value. Comma or new line separated values supported for checkboxes.",
                        verbose_name="default value",
                    ),
                ),
                (
                    "help_text",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="help text"
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="FromPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "to_address",
                    models.CharField(
                        blank=True,
                        help_text="Optional - form submissions will be emailed to these addresses. Separate multiple addresses by comma.",
                        max_length=255,
                        validators=[wagtail.contrib.forms.models.validate_to_address],
                        verbose_name="to address",
                    ),
                ),
                (
                    "from_address",
                    models.EmailField(
                        blank=True, max_length=255, verbose_name="from address"
                    ),
                ),
                (
                    "subject",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="subject"
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="Page description",
                        max_length=256,
                        verbose_name="description",
                    ),
                ),
                (
                    "content",
                    wagtail.fields.StreamField(
                        [
                            ("quote", 0),
                            ("paragraph", 1),
                            ("video", 2),
                            ("image", 6),
                            ("document", 7),
                            ("code", 14),
                            ("accordion", 23),
                            ("alert", 35),
                            ("carousel", 42),
                            ("hover_gallery", 46),
                            ("diff", 49),
                            ("fab", 54),
                            ("list", 63),
                            ("tabs", 75),
                            ("steps", 81),
                            ("timeline", 89),
                            ("toast", 92),
                            ("browser", 96),
                            ("code_mockup", 97),
                            ("phone", 100),
                        ],
                        block_lookup={
                            0: (
                                "wagtail.blocks.BlockQuoteBlock",
                                (),
                                {"help_text": "Quote"},
                            ),
                            1: (
                                "wagtail.blocks.RichTextBlock",
                                (),
                                {"help_text": "Rich Text"},
                            ),
                            2: (
                                "wagtail.embeds.blocks.EmbedBlock",
                                (),
                                {"help_text": "Video"},
                            ),
                            3: (
                                "wagtail.images.blocks.ImageBlock",
                                [],
                                {"help_text": "Image"},
                            ),
                            4: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Image caption",
                                    "max_length": 128,
                                    "required": False,
                                },
                            ),
                            5: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Image attribution",
                                    "max_length": 128,
                                    "required": False,
                                },
                            ),
                            6: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Image"},
                            ),
                            7: (
                                "wagtail.documents.blocks.DocumentChooserBlock",
                                (),
                                {"help_text": "Document"},
                            ),
                            8: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": True,
                                    "help_text": "Wether to show or hide which programming language is used",
                                    "required": False,
                                },
                            ),
                            9: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": True,
                                    "help_text": "Wether to show or hide copy buttons",
                                    "required": False,
                                },
                            ),
                            10: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": True,
                                    "help_text": "Wether to show or hide window buttons",
                                    "required": False,
                                },
                            ),
                            11: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "default": "Untitled",
                                    "help_text": "File name",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            12: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("auto", "Auto"),
                                        ("bash", "Bash"),
                                        ("c", "C"),
                                        ("cpp", "C++"),
                                        ("csharp", "C#"),
                                        ("css", "CSS"),
                                        ("dart", "Dart"),
                                        ("dockerfile", "Dockerfile"),
                                        ("go", "Go"),
                                        ("html", "HTML"),
                                        ("java", "Java"),
                                        ("javascript", "JavaScript"),
                                        ("json", "JSON"),
                                        ("kotlin", "Kotlin"),
                                        ("lua", "Lua"),
                                        ("markdown", "Markdown"),
                                        ("php", "PHP"),
                                        ("python", "Python"),
                                        ("ruby", "Ruby"),
                                        ("rust", "Rust"),
                                        ("scss", "SCSS"),
                                        ("shell", "Shell"),
                                        ("sql", "SQL"),
                                        ("swift", "Swift"),
                                        ("typescript", "TypeScript"),
                                        ("xml", "XML"),
                                        ("yaml", "YAML"),
                                        ("plaintext", "Plain text"),
                                    ],
                                    "help_text": "Programming language",
                                },
                            ),
                            13: (
                                "wagtail.blocks.TextBlock",
                                (),
                                {"help_text": "Code content", "required": True},
                            ),
                            14: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("show_language", 8),
                                        ("show_copy_btn", 9),
                                        ("show_window_btns", 10),
                                        ("file_name", 11),
                                        ("language", 12),
                                        ("code", 13),
                                    ]
                                ],
                                {"help_text": "Code"},
                            ),
                            15: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Accordion name",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            16: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [("plus", "Plus"), ("arrow", "Arrow")],
                                    "help_text": "Accordion style",
                                    "required": False,
                                },
                            ),
                            17: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "default": "check-circle2",
                                    "help_text": "Icon name (lucide icons)",
                                    "max_length": 32,
                                    "required": False,
                                },
                            ),
                            18: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Wether to show or hide item content",
                                    "required": False,
                                },
                            ),
                            19: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Item title",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            20: (
                                "wagtail.blocks.RichTextBlock",
                                (),
                                {"help_text": "Item content", "required": True},
                            ),
                            21: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 17),
                                        ("is_expanded", 18),
                                        ("title", 19),
                                        ("content", 20),
                                    ]
                                ],
                                {},
                            ),
                            22: (
                                "wagtail.blocks.ListBlock",
                                (21,),
                                {"help_text": "Accordion items", "required": True},
                            ),
                            23: (
                                "wagtail.blocks.StructBlock",
                                [[("name", 15), ("style", 16), ("items", 22)]],
                                {"help_text": "Accordion"},
                            ),
                            24: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "default": "alert-triangle",
                                    "help_text": "Icon name (lucide icons)",
                                    "max_length": 32,
                                    "required": False,
                                },
                            ),
                            25: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if alert is vertical or horizontal (default)",
                                    "required": False,
                                },
                            ),
                            26: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("soft", "Soft"),
                                        ("outline", "Outline"),
                                        ("dash", "Dash"),
                                    ],
                                    "help_text": "Alert style",
                                    "required": False,
                                },
                            ),
                            27: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("info", "Info"),
                                        ("success", "Success"),
                                        ("warning", "Warning"),
                                        ("error", "Error"),
                                    ],
                                    "help_text": "Alert level",
                                },
                            ),
                            28: (
                                "wagtail.blocks.RichTextBlock",
                                (),
                                {
                                    "features": [
                                        "bold",
                                        "italic",
                                        "link",
                                        "document-link",
                                        "code",
                                        "superscript",
                                        "subscript",
                                        "strikethrough",
                                    ],
                                    "help_text": "Alert message",
                                    "required": True,
                                },
                            ),
                            29: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Action label",
                                    "max_length": 32,
                                    "required": False,
                                },
                            ),
                            30: (
                                "wagtail.blocks.PageChooserBlock",
                                (),
                                {
                                    "help_text": "Action internal link",
                                    "required": False,
                                },
                            ),
                            31: (
                                "wagtail.blocks.URLBlock",
                                (),
                                {
                                    "help_text": "Action external link",
                                    "required": False,
                                },
                            ),
                            32: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("primary", "Primary"),
                                        ("secondary", "Secondary"),
                                        ("accent", "Accent"),
                                        ("success", "Success"),
                                        ("info", "Info"),
                                        ("warning", "Warning"),
                                        ("error", "Error"),
                                    ],
                                    "help_text": "Action button color",
                                    "required": False,
                                },
                            ),
                            33: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 17),
                                        ("label", 29),
                                        ("page", 30),
                                        ("url", 31),
                                        ("color", 32),
                                    ]
                                ],
                                {},
                            ),
                            34: (
                                "wagtail.blocks.ListBlock",
                                (33,),
                                {"help_text": "Alert actions", "required": False},
                            ),
                            35: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 24),
                                        ("is_vertical", 25),
                                        ("style", 26),
                                        ("level", 27),
                                        ("message", 28),
                                        ("actions", 34),
                                    ]
                                ],
                                {"help_text": "Alert"},
                            ),
                            36: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if carousel is vertical or horizontal (default)",
                                    "required": False,
                                },
                            ),
                            37: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Image", "required": False},
                            ),
                            38: (
                                "wagtail.embeds.blocks.EmbedBlock",
                                (),
                                {"help_text": "Video", "required": False},
                            ),
                            39: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Caption",
                                    "max_length": 128,
                                    "required": False,
                                },
                            ),
                            40: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 37), ("video", 38), ("caption", 39)]],
                                {},
                            ),
                            41: (
                                "wagtail.blocks.ListBlock",
                                (40,),
                                {"help_text": "Carousel items", "required": True},
                            ),
                            42: (
                                "wagtail.blocks.StructBlock",
                                [[("is_vertical", 36), ("items", 41)]],
                                {"help_text": "Carousel"},
                            ),
                            43: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Image", "required": True},
                            ),
                            44: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 43), ("caption", 39)]],
                                {},
                            ),
                            45: (
                                "wagtail.blocks.ListBlock",
                                (44,),
                                {"help_text": "Gallery items", "required": True},
                            ),
                            46: (
                                "wagtail.blocks.StructBlock",
                                [[("items", 45)]],
                                {"help_text": "Hover gallery"},
                            ),
                            47: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Diff Item 1", "required": True},
                            ),
                            48: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Diff Item 2", "required": True},
                            ),
                            49: (
                                "wagtail.blocks.StructBlock",
                                [[("item_1", 47), ("item_2", 48)]],
                                {"help_text": "Diff"},
                            ),
                            50: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if FAB is vertical or flower shaped (quarter circle)",
                                    "required": False,
                                },
                            ),
                            51: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 17),
                                        ("label", 29),
                                        ("page", 30),
                                        ("url", 31),
                                        ("color", 32),
                                    ]
                                ],
                                {"help_text": "FAB toggle btn", "required": True},
                            ),
                            52: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 17),
                                        ("label", 29),
                                        ("page", 30),
                                        ("url", 31),
                                        ("color", 32),
                                    ]
                                ],
                                {"help_text": "FAB main action", "required": False},
                            ),
                            53: (
                                "wagtail.blocks.ListBlock",
                                (33,),
                                {"help_text": "FAB items", "required": True},
                            ),
                            54: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("is_flower", 50),
                                        ("toggle", 51),
                                        ("main", 52),
                                        ("items", 53),
                                    ]
                                ],
                                {"help_text": "FAB"},
                            ),
                            55: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "List title",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            56: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Item image", "required": False},
                            ),
                            57: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Item description",
                                    "max_length": 128,
                                    "required": False,
                                },
                            ),
                            58: (
                                "wagtail.blocks.PageChooserBlock",
                                (),
                                {"help_text": "Item internal link", "required": False},
                            ),
                            59: (
                                "wagtail.blocks.URLBlock",
                                (),
                                {"help_text": "Item external link", "required": False},
                            ),
                            60: (
                                "wagtail.blocks.ListBlock",
                                (33,),
                                {"help_text": "Actions", "required": False},
                            ),
                            61: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("image", 56),
                                        ("title", 19),
                                        ("description", 57),
                                        ("page", 58),
                                        ("url", 59),
                                        ("actions", 60),
                                    ]
                                ],
                                {},
                            ),
                            62: (
                                "wagtail.blocks.ListBlock",
                                (61,),
                                {"help_text": "List items", "required": True},
                            ),
                            63: (
                                "wagtail.blocks.StructBlock",
                                [[("title", 55), ("items", 62)]],
                                {"help_text": "List"},
                            ),
                            64: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Tab name",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            65: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if tab buttons position is reversed",
                                    "required": False,
                                },
                            ),
                            66: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("border", "Border"),
                                        ("box", "Box"),
                                        ("lift", "Lift"),
                                    ],
                                    "help_text": "Tab style",
                                },
                            ),
                            67: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if tab is selected",
                                    "required": False,
                                },
                            ),
                            68: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 24),
                                        ("is_vertical", 25),
                                        ("style", 26),
                                        ("level", 27),
                                        ("message", 28),
                                        ("actions", 34),
                                    ]
                                ],
                                {"help_text": "Alert", "required": True},
                            ),
                            69: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("show_language", 8),
                                        ("show_copy_btn", 9),
                                        ("show_window_btns", 10),
                                        ("file_name", 11),
                                        ("language", 12),
                                        ("code", 13),
                                    ]
                                ],
                                {"help_text": "Code", "required": True},
                            ),
                            70: (
                                "wagtail.embeds.blocks.EmbedBlock",
                                (),
                                {"help_text": "Video", "required": True},
                            ),
                            71: (
                                "wagtail.blocks.RichTextBlock",
                                (),
                                {"help_text": "Rich text", "required": True},
                            ),
                            72: (
                                "wagtail.blocks.StreamBlock",
                                [
                                    [
                                        ("alert", 68),
                                        ("code", 69),
                                        ("image", 43),
                                        ("video", 70),
                                        ("text", 71),
                                    ]
                                ],
                                {"help_text": "Tab Content", "required": True},
                            ),
                            73: (
                                "wagtail.blocks.StructBlock",
                                [[("title", 19), ("is_selected", 67), ("content", 72)]],
                                {},
                            ),
                            74: (
                                "wagtail.blocks.ListBlock",
                                (73,),
                                {"help_text": "Tab items", "required": True},
                            ),
                            75: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("name", 64),
                                        ("is_reversed", 65),
                                        ("style", 66),
                                        ("items", 74),
                                    ]
                                ],
                                {"help_text": "Tabs"},
                            ),
                            76: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if Steps is vertical or horizontal (default)",
                                    "required": False,
                                },
                            ),
                            77: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Item name",
                                    "max_length": 64,
                                    "required": True,
                                },
                            ),
                            78: (
                                "wagtail.blocks.ChoiceBlock",
                                [],
                                {
                                    "choices": [
                                        ("primary", "Primary"),
                                        ("secondary", "Secondary"),
                                        ("accent", "Accent"),
                                        ("success", "Success"),
                                        ("info", "Info"),
                                        ("warning", "Warning"),
                                        ("error", "Error"),
                                    ],
                                    "help_text": "Item color",
                                    "required": False,
                                },
                            ),
                            79: (
                                "wagtail.blocks.StructBlock",
                                [[("name", 77), ("icon", 17), ("color", 78)]],
                                {},
                            ),
                            80: (
                                "wagtail.blocks.ListBlock",
                                (79,),
                                {"help_text": "Steps items", "required": True},
                            ),
                            81: (
                                "wagtail.blocks.StructBlock",
                                [[("is_vertical", 76), ("items", 80)]],
                                {"help_text": "Steps"},
                            ),
                            82: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if timeline is compact",
                                    "required": False,
                                },
                            ),
                            83: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if timeline is vertical or horizontal (default)",
                                    "required": False,
                                },
                            ),
                            84: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": False,
                                    "help_text": "Designates if dates should snap to icons",
                                    "required": False,
                                },
                            ),
                            85: (
                                "wagtail.blocks.DateBlock",
                                (),
                                {"help_text": "Item date", "required": True},
                            ),
                            86: (
                                "wagtail.blocks.CharBlock",
                                (),
                                {
                                    "help_text": "Item content",
                                    "max_length": 128,
                                    "required": True,
                                },
                            ),
                            87: (
                                "wagtail.blocks.StructBlock",
                                [[("date", 85), ("icon", 17), ("content", 86)]],
                                {},
                            ),
                            88: (
                                "wagtail.blocks.ListBlock",
                                (87,),
                                {"help_text": "Timeline items", "required": True},
                            ),
                            89: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("is_compact", 82),
                                        ("is_vertical", 83),
                                        ("snap_to_icon", 84),
                                        ("items", 88),
                                    ]
                                ],
                                {"help_text": "Timeline"},
                            ),
                            90: (
                                "wagtail.blocks.StructBlock",
                                [
                                    [
                                        ("icon", 24),
                                        ("is_vertical", 25),
                                        ("style", 26),
                                        ("level", 27),
                                        ("message", 28),
                                        ("actions", 34),
                                    ]
                                ],
                                {},
                            ),
                            91: (
                                "wagtail.blocks.ListBlock",
                                (90,),
                                {"help_text": "Toast items", "required": True},
                            ),
                            92: (
                                "wagtail.blocks.StructBlock",
                                [[("items", 91)]],
                                {"help_text": "Toast"},
                            ),
                            93: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": True,
                                    "help_text": "Wether to show or hide toolbar",
                                    "required": False,
                                },
                            ),
                            94: (
                                "wagtail.blocks.URLBlock",
                                (),
                                {"help_text": "Browser URL", "required": True},
                            ),
                            95: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Browser wallpaper", "required": True},
                            ),
                            96: (
                                "wagtail.blocks.StructBlock",
                                [[("show_url", 93), ("url", 94), ("wallpaper", 95)]],
                                {"help_text": "Browser mockup"},
                            ),
                            97: (
                                "wagtail.blocks.StructBlock",
                                [[("language", 12), ("code", 13)]],
                                {"help_text": "Code mockup"},
                            ),
                            98: (
                                "wagtail.blocks.BooleanBlock",
                                (),
                                {
                                    "default": True,
                                    "help_text": "Wether to show or hide camera",
                                    "required": False,
                                },
                            ),
                            99: (
                                "wagtail.blocks.StructBlock",
                                [[("image", 3), ("caption", 4), ("attribution", 5)]],
                                {"help_text": "Phone wallpaper", "required": True},
                            ),
                            100: (
                                "wagtail.blocks.StructBlock",
                                [[("show_camera", 98), ("wallpaper", 99)]],
                                {"help_text": "Phone mockup"},
                            ),
                        },
                        help_text="Page content",
                        verbose_name="content",
                    ),
                ),
                (
                    "message",
                    wagtail.fields.RichTextField(
                        help_text="Message to show after submitting form",
                        verbose_name="message",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                wagtail.contrib.forms.models.FormMixin,
                "wagtailcore.page",
                models.Model,
            ),
        ),
        migrations.AlterField(
            model_name="docspage",
            name="content",
            field=wagtail.fields.StreamField(
                [
                    ("quote", 0),
                    ("paragraph", 1),
                    ("video", 2),
                    ("image", 6),
                    ("document", 7),
                    ("code", 14),
                    ("accordion", 23),
                    ("alert", 35),
                    ("carousel", 42),
                    ("hover_gallery", 46),
                    ("diff", 49),
                    ("fab", 54),
                    ("list", 63),
                    ("tabs", 75),
                    ("steps", 81),
                    ("timeline", 89),
                    ("toast", 92),
                    ("browser", 96),
                    ("code_mockup", 97),
                    ("phone", 100),
                ],
                block_lookup={
                    0: ("wagtail.blocks.BlockQuoteBlock", (), {"help_text": "Quote"}),
                    1: ("wagtail.blocks.RichTextBlock", (), {"help_text": "Rich Text"}),
                    2: ("wagtail.embeds.blocks.EmbedBlock", (), {"help_text": "Video"}),
                    3: ("wagtail.images.blocks.ImageBlock", [], {"help_text": "Image"}),
                    4: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Image caption",
                            "max_length": 128,
                            "required": False,
                        },
                    ),
                    5: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Image attribution",
                            "max_length": 128,
                            "required": False,
                        },
                    ),
                    6: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Image"},
                    ),
                    7: (
                        "wagtail.documents.blocks.DocumentChooserBlock",
                        (),
                        {"help_text": "Document"},
                    ),
                    8: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": True,
                            "help_text": "Wether to show or hide which programming language is used",
                            "required": False,
                        },
                    ),
                    9: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": True,
                            "help_text": "Wether to show or hide copy buttons",
                            "required": False,
                        },
                    ),
                    10: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": True,
                            "help_text": "Wether to show or hide window buttons",
                            "required": False,
                        },
                    ),
                    11: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "default": "Untitled",
                            "help_text": "File name",
                            "max_length": 64,
                            "required": True,
                        },
                    ),
                    12: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("auto", "Auto"),
                                ("bash", "Bash"),
                                ("c", "C"),
                                ("cpp", "C++"),
                                ("csharp", "C#"),
                                ("css", "CSS"),
                                ("dart", "Dart"),
                                ("dockerfile", "Dockerfile"),
                                ("go", "Go"),
                                ("html", "HTML"),
                                ("java", "Java"),
                                ("javascript", "JavaScript"),
                                ("json", "JSON"),
                                ("kotlin", "Kotlin"),
                                ("lua", "Lua"),
                                ("markdown", "Markdown"),
                                ("php", "PHP"),
                                ("python", "Python"),
                                ("ruby", "Ruby"),
                                ("rust", "Rust"),
                                ("scss", "SCSS"),
                                ("shell", "Shell"),
                                ("sql", "SQL"),
                                ("swift", "Swift"),
                                ("typescript", "TypeScript"),
                                ("xml", "XML"),
                                ("yaml", "YAML"),
                                ("plaintext", "Plain text"),
                            ],
                            "help_text": "Programming language",
                        },
                    ),
                    13: (
                        "wagtail.blocks.TextBlock",
                        (),
                        {"help_text": "Code content", "required": True},
                    ),
                    14: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("show_language", 8),
                                ("show_copy_btn", 9),
                                ("show_window_btns", 10),
                                ("file_name", 11),
                                ("language", 12),
                                ("code", 13),
                            ]
                        ],
                        {"help_text": "Code"},
                    ),
                    15: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Accordion name",
                            "max_length": 64,
                            "required": True,
                        },
                    ),
                    16: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [("plus", "Plus"), ("arrow", "Arrow")],
                            "help_text": "Accordion style",
                            "required": False,
                        },
                    ),
                    17: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "default": "check-circle2",
                            "help_text": "Icon name (lucide icons)",
                            "max_length": 32,
                            "required": False,
                        },
                    ),
                    18: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Wether to show or hide item content",
                            "required": False,
                        },
                    ),
                    19: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {"help_text": "Item title", "max_length": 64, "required": True},
                    ),
                    20: (
                        "wagtail.blocks.RichTextBlock",
                        (),
                        {"help_text": "Item content", "required": True},
                    ),
                    21: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 17),
                                ("is_expanded", 18),
                                ("title", 19),
                                ("content", 20),
                            ]
                        ],
                        {},
                    ),
                    22: (
                        "wagtail.blocks.ListBlock",
                        (21,),
                        {"help_text": "Accordion items", "required": True},
                    ),
                    23: (
                        "wagtail.blocks.StructBlock",
                        [[("name", 15), ("style", 16), ("items", 22)]],
                        {"help_text": "Accordion"},
                    ),
                    24: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "default": "alert-triangle",
                            "help_text": "Icon name (lucide icons)",
                            "max_length": 32,
                            "required": False,
                        },
                    ),
                    25: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if alert is vertical or horizontal (default)",
                            "required": False,
                        },
                    ),
                    26: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("soft", "Soft"),
                                ("outline", "Outline"),
                                ("dash", "Dash"),
                            ],
                            "help_text": "Alert style",
                            "required": False,
                        },
                    ),
                    27: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("info", "Info"),
                                ("success", "Success"),
                                ("warning", "Warning"),
                                ("error", "Error"),
                            ],
                            "help_text": "Alert level",
                        },
                    ),
                    28: (
                        "wagtail.blocks.RichTextBlock",
                        (),
                        {
                            "features": [
                                "bold",
                                "italic",
                                "link",
                                "document-link",
                                "code",
                                "superscript",
                                "subscript",
                                "strikethrough",
                            ],
                            "help_text": "Alert message",
                            "required": True,
                        },
                    ),
                    29: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Action label",
                            "max_length": 32,
                            "required": False,
                        },
                    ),
                    30: (
                        "wagtail.blocks.PageChooserBlock",
                        (),
                        {"help_text": "Action internal link", "required": False},
                    ),
                    31: (
                        "wagtail.blocks.URLBlock",
                        (),
                        {"help_text": "Action external link", "required": False},
                    ),
                    32: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("primary", "Primary"),
                                ("secondary", "Secondary"),
                                ("accent", "Accent"),
                                ("success", "Success"),
                                ("info", "Info"),
                                ("warning", "Warning"),
                                ("error", "Error"),
                            ],
                            "help_text": "Action button color",
                            "required": False,
                        },
                    ),
                    33: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 17),
                                ("label", 29),
                                ("page", 30),
                                ("url", 31),
                                ("color", 32),
                            ]
                        ],
                        {},
                    ),
                    34: (
                        "wagtail.blocks.ListBlock",
                        (33,),
                        {"help_text": "Alert actions", "required": False},
                    ),
                    35: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 24),
                                ("is_vertical", 25),
                                ("style", 26),
                                ("level", 27),
                                ("message", 28),
                                ("actions", 34),
                            ]
                        ],
                        {"help_text": "Alert"},
                    ),
                    36: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if carousel is vertical or horizontal (default)",
                            "required": False,
                        },
                    ),
                    37: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Image", "required": False},
                    ),
                    38: (
                        "wagtail.embeds.blocks.EmbedBlock",
                        (),
                        {"help_text": "Video", "required": False},
                    ),
                    39: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {"help_text": "Caption", "max_length": 128, "required": False},
                    ),
                    40: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 37), ("video", 38), ("caption", 39)]],
                        {},
                    ),
                    41: (
                        "wagtail.blocks.ListBlock",
                        (40,),
                        {"help_text": "Carousel items", "required": True},
                    ),
                    42: (
                        "wagtail.blocks.StructBlock",
                        [[("is_vertical", 36), ("items", 41)]],
                        {"help_text": "Carousel"},
                    ),
                    43: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Image", "required": True},
                    ),
                    44: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 43), ("caption", 39)]],
                        {},
                    ),
                    45: (
                        "wagtail.blocks.ListBlock",
                        (44,),
                        {"help_text": "Gallery items", "required": True},
                    ),
                    46: (
                        "wagtail.blocks.StructBlock",
                        [[("items", 45)]],
                        {"help_text": "Hover gallery"},
                    ),
                    47: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Diff Item 1", "required": True},
                    ),
                    48: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Diff Item 2", "required": True},
                    ),
                    49: (
                        "wagtail.blocks.StructBlock",
                        [[("item_1", 47), ("item_2", 48)]],
                        {"help_text": "Diff"},
                    ),
                    50: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if FAB is vertical or flower shaped (quarter circle)",
                            "required": False,
                        },
                    ),
                    51: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 17),
                                ("label", 29),
                                ("page", 30),
                                ("url", 31),
                                ("color", 32),
                            ]
                        ],
                        {"help_text": "FAB toggle btn", "required": True},
                    ),
                    52: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 17),
                                ("label", 29),
                                ("page", 30),
                                ("url", 31),
                                ("color", 32),
                            ]
                        ],
                        {"help_text": "FAB main action", "required": False},
                    ),
                    53: (
                        "wagtail.blocks.ListBlock",
                        (33,),
                        {"help_text": "FAB items", "required": True},
                    ),
                    54: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("is_flower", 50),
                                ("toggle", 51),
                                ("main", 52),
                                ("items", 53),
                            ]
                        ],
                        {"help_text": "FAB"},
                    ),
                    55: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {"help_text": "List title", "max_length": 64, "required": True},
                    ),
                    56: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Item image", "required": False},
                    ),
                    57: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Item description",
                            "max_length": 128,
                            "required": False,
                        },
                    ),
                    58: (
                        "wagtail.blocks.PageChooserBlock",
                        (),
                        {"help_text": "Item internal link", "required": False},
                    ),
                    59: (
                        "wagtail.blocks.URLBlock",
                        (),
                        {"help_text": "Item external link", "required": False},
                    ),
                    60: (
                        "wagtail.blocks.ListBlock",
                        (33,),
                        {"help_text": "Actions", "required": False},
                    ),
                    61: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("image", 56),
                                ("title", 19),
                                ("description", 57),
                                ("page", 58),
                                ("url", 59),
                                ("actions", 60),
                            ]
                        ],
                        {},
                    ),
                    62: (
                        "wagtail.blocks.ListBlock",
                        (61,),
                        {"help_text": "List items", "required": True},
                    ),
                    63: (
                        "wagtail.blocks.StructBlock",
                        [[("title", 55), ("items", 62)]],
                        {"help_text": "List"},
                    ),
                    64: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {"help_text": "Tab name", "max_length": 64, "required": True},
                    ),
                    65: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if tab buttons position is reversed",
                            "required": False,
                        },
                    ),
                    66: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("border", "Border"),
                                ("box", "Box"),
                                ("lift", "Lift"),
                            ],
                            "help_text": "Tab style",
                        },
                    ),
                    67: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if tab is selected",
                            "required": False,
                        },
                    ),
                    68: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 24),
                                ("is_vertical", 25),
                                ("style", 26),
                                ("level", 27),
                                ("message", 28),
                                ("actions", 34),
                            ]
                        ],
                        {"help_text": "Alert", "required": True},
                    ),
                    69: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("show_language", 8),
                                ("show_copy_btn", 9),
                                ("show_window_btns", 10),
                                ("file_name", 11),
                                ("language", 12),
                                ("code", 13),
                            ]
                        ],
                        {"help_text": "Code", "required": True},
                    ),
                    70: (
                        "wagtail.embeds.blocks.EmbedBlock",
                        (),
                        {"help_text": "Video", "required": True},
                    ),
                    71: (
                        "wagtail.blocks.RichTextBlock",
                        (),
                        {"help_text": "Rich text", "required": True},
                    ),
                    72: (
                        "wagtail.blocks.StreamBlock",
                        [
                            [
                                ("alert", 68),
                                ("code", 69),
                                ("image", 43),
                                ("video", 70),
                                ("text", 71),
                            ]
                        ],
                        {"help_text": "Tab Content", "required": True},
                    ),
                    73: (
                        "wagtail.blocks.StructBlock",
                        [[("title", 19), ("is_selected", 67), ("content", 72)]],
                        {},
                    ),
                    74: (
                        "wagtail.blocks.ListBlock",
                        (73,),
                        {"help_text": "Tab items", "required": True},
                    ),
                    75: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("name", 64),
                                ("is_reversed", 65),
                                ("style", 66),
                                ("items", 74),
                            ]
                        ],
                        {"help_text": "Tabs"},
                    ),
                    76: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if Steps is vertical or horizontal (default)",
                            "required": False,
                        },
                    ),
                    77: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {"help_text": "Item name", "max_length": 64, "required": True},
                    ),
                    78: (
                        "wagtail.blocks.ChoiceBlock",
                        [],
                        {
                            "choices": [
                                ("primary", "Primary"),
                                ("secondary", "Secondary"),
                                ("accent", "Accent"),
                                ("success", "Success"),
                                ("info", "Info"),
                                ("warning", "Warning"),
                                ("error", "Error"),
                            ],
                            "help_text": "Item color",
                            "required": False,
                        },
                    ),
                    79: (
                        "wagtail.blocks.StructBlock",
                        [[("name", 77), ("icon", 17), ("color", 78)]],
                        {},
                    ),
                    80: (
                        "wagtail.blocks.ListBlock",
                        (79,),
                        {"help_text": "Steps items", "required": True},
                    ),
                    81: (
                        "wagtail.blocks.StructBlock",
                        [[("is_vertical", 76), ("items", 80)]],
                        {"help_text": "Steps"},
                    ),
                    82: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if timeline is compact",
                            "required": False,
                        },
                    ),
                    83: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if timeline is vertical or horizontal (default)",
                            "required": False,
                        },
                    ),
                    84: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": False,
                            "help_text": "Designates if dates should snap to icons",
                            "required": False,
                        },
                    ),
                    85: (
                        "wagtail.blocks.DateBlock",
                        (),
                        {"help_text": "Item date", "required": True},
                    ),
                    86: (
                        "wagtail.blocks.CharBlock",
                        (),
                        {
                            "help_text": "Item content",
                            "max_length": 128,
                            "required": True,
                        },
                    ),
                    87: (
                        "wagtail.blocks.StructBlock",
                        [[("date", 85), ("icon", 17), ("content", 86)]],
                        {},
                    ),
                    88: (
                        "wagtail.blocks.ListBlock",
                        (87,),
                        {"help_text": "Timeline items", "required": True},
                    ),
                    89: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("is_compact", 82),
                                ("is_vertical", 83),
                                ("snap_to_icon", 84),
                                ("items", 88),
                            ]
                        ],
                        {"help_text": "Timeline"},
                    ),
                    90: (
                        "wagtail.blocks.StructBlock",
                        [
                            [
                                ("icon", 24),
                                ("is_vertical", 25),
                                ("style", 26),
                                ("level", 27),
                                ("message", 28),
                                ("actions", 34),
                            ]
                        ],
                        {},
                    ),
                    91: (
                        "wagtail.blocks.ListBlock",
                        (90,),
                        {"help_text": "Toast items", "required": True},
                    ),
                    92: (
                        "wagtail.blocks.StructBlock",
                        [[("items", 91)]],
                        {"help_text": "Toast"},
                    ),
                    93: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": True,
                            "help_text": "Wether to show or hide toolbar",
                            "required": False,
                        },
                    ),
                    94: (
                        "wagtail.blocks.URLBlock",
                        (),
                        {"help_text": "Browser URL", "required": True},
                    ),
                    95: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Browser wallpaper", "required": True},
                    ),
                    96: (
                        "wagtail.blocks.StructBlock",
                        [[("show_url", 93), ("url", 94), ("wallpaper", 95)]],
                        {"help_text": "Browser mockup"},
                    ),
                    97: (
                        "wagtail.blocks.StructBlock",
                        [[("language", 12), ("code", 13)]],
                        {"help_text": "Code mockup"},
                    ),
                    98: (
                        "wagtail.blocks.BooleanBlock",
                        (),
                        {
                            "default": True,
                            "help_text": "Wether to show or hide camera",
                            "required": False,
                        },
                    ),
                    99: (
                        "wagtail.blocks.StructBlock",
                        [[("image", 3), ("caption", 4), ("attribution", 5)]],
                        {"help_text": "Phone wallpaper", "required": True},
                    ),
                    100: (
                        "wagtail.blocks.StructBlock",
                        [[("show_camera", 98), ("wallpaper", 99)]],
                        {"help_text": "Phone mockup"},
                    ),
                },
                help_text="Page content",
                verbose_name="content",
            ),
        ),
    ]
