# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddProjectUserRoleRequest(AbstractModel):
    """AddProjectUserRole请求参数结构体

    """


class AddProjectUserRoleResponse(AbstractModel):
    """AddProjectUserRole返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AdhocDetail(AbstractModel):
    """子任务记录

    """

    def __init__(self):
        r"""
        :param _Id: 子任务记录Id
        :type Id: int
        :param _ScriptContent: 脚本内容
        :type ScriptContent: str
        :param _StartTime: 任务启动时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _Status: 当前任务状态
        :type Status: str
        :param _RecordId: 提交任务id
        :type RecordId: int
        """
        self._Id = None
        self._ScriptContent = None
        self._StartTime = None
        self._EndTime = None
        self._Status = None
        self._RecordId = None

    @property
    def Id(self):
        """子任务记录Id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        """脚本内容
        :rtype: str
        """
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def StartTime(self):
        """任务启动时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Status(self):
        """当前任务状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RecordId(self):
        """提交任务id
        :rtype: int
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Status = params.get("Status")
        self._RecordId = params.get("RecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdhocRecord(AbstractModel):
    """任务提交记录

    """

    def __init__(self):
        r"""
        :param _Id: 任务提交记录id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _ScriptContent: 脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type ScriptContent: str
        :param _CreateTime: 任务提交时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _Status: 任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _InstanceId: 实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._Id = None
        self._ScriptContent = None
        self._CreateTime = None
        self._Status = None
        self._InstanceId = None

    @property
    def Id(self):
        """任务提交记录id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        """脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def CreateTime(self):
        """任务提交时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        """任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceId(self):
        """实例id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentStatus(AbstractModel):
    """Agent采集器状态统计

    """

    def __init__(self):
        r"""
        :param _Running: 运行中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type Running: int
        :param _Abnormal: 异常的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type Abnormal: int
        :param _InOperation: 操作中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type InOperation: int
        """
        self._Running = None
        self._Abnormal = None
        self._InOperation = None

    @property
    def Running(self):
        """运行中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Abnormal(self):
        """异常的数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Abnormal

    @Abnormal.setter
    def Abnormal(self, Abnormal):
        self._Abnormal = Abnormal

    @property
    def InOperation(self):
        """操作中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InOperation

    @InOperation.setter
    def InOperation(self, InOperation):
        self._InOperation = InOperation


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Abnormal = params.get("Abnormal")
        self._InOperation = params.get("InOperation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiOpsEventListenerDTO(AbstractModel):
    """监听事件

    """

    def __init__(self):
        r"""
        :param _EventName: 事件名
注意：此字段可能返回 null，表示取不到有效值。
        :type EventName: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ProjectDisplayName: 项目展示名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectDisplayName: str
        :param _EventSubType: 事件周期
注意：此字段可能返回 null，表示取不到有效值。
        :type EventSubType: str
        :param _ProjectId: 事件项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _PropertiesList: 扩展名
注意：此字段可能返回 null，表示取不到有效值。
        :type PropertiesList: list of ParamInfoDs
        :param _EventBroadcastType: 事件广播类型
注意：此字段可能返回 null，表示取不到有效值。
        :type EventBroadcastType: str
        """
        self._EventName = None
        self._CreateTime = None
        self._ProjectDisplayName = None
        self._EventSubType = None
        self._ProjectId = None
        self._PropertiesList = None
        self._EventBroadcastType = None

    @property
    def EventName(self):
        """事件名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ProjectDisplayName(self):
        """项目展示名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def EventSubType(self):
        """事件周期
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def ProjectId(self):
        """事件项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PropertiesList(self):
        """扩展名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ParamInfoDs
        """
        return self._PropertiesList

    @PropertiesList.setter
    def PropertiesList(self, PropertiesList):
        self._PropertiesList = PropertiesList

    @property
    def EventBroadcastType(self):
        """事件广播类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        self._EventBroadcastType = EventBroadcastType


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._CreateTime = params.get("CreateTime")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._EventSubType = params.get("EventSubType")
        self._ProjectId = params.get("ProjectId")
        if params.get("PropertiesList") is not None:
            self._PropertiesList = []
            for item in params.get("PropertiesList"):
                obj = ParamInfoDs()
                obj._deserialize(item)
                self._PropertiesList.append(obj)
        self._EventBroadcastType = params.get("EventBroadcastType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiopsDLCResourceConfigDto(AbstractModel):
    """DLC资源配置信息

    """

    def __init__(self):
        r"""
        :param _DriverSize: Driver资源
注意：此字段可能返回 null，表示取不到有效值。
        :type DriverSize: str
        :param _ExecutorSize: Executor资源
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorSize: str
        :param _ExecutorNumbers: Executor数量
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorNumbers: str
        :param _IsInherit: 资源配置方式
注意：此字段可能返回 null，表示取不到有效值。
        :type IsInherit: str
        """
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._IsInherit = None

    @property
    def DriverSize(self):
        """Driver资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        """Executor资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        """Executor数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def IsInherit(self):
        """资源配置方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit


    def _deserialize(self, params):
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        self._IsInherit = params.get("IsInherit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiopsScriptInfo(AbstractModel):
    """数据运维脚本信息

    """

    def __init__(self):
        r"""
        :param _ScriptContent: 脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type ScriptContent: str
        :param _CosPath: 脚本所在COS的路径
注意：此字段可能返回 null，表示取不到有效值。
        :type CosPath: str
        :param _CosRegion: 脚本所在COS的地域
注意：此字段可能返回 null，表示取不到有效值。
        :type CosRegion: str
        :param _CosBucketName: 脚本所在COS的桶名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CosBucketName: str
        """
        self._ScriptContent = None
        self._CosPath = None
        self._CosRegion = None
        self._CosBucketName = None

    @property
    def ScriptContent(self):
        """脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def CosPath(self):
        """脚本所在COS的路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosPath

    @CosPath.setter
    def CosPath(self, CosPath):
        self._CosPath = CosPath

    @property
    def CosRegion(self):
        """脚本所在COS的地域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def CosBucketName(self):
        """脚本所在COS的桶名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosBucketName

    @CosBucketName.setter
    def CosBucketName(self, CosBucketName):
        self._CosBucketName = CosBucketName


    def _deserialize(self, params):
        self._ScriptContent = params.get("ScriptContent")
        self._CosPath = params.get("CosPath")
        self._CosRegion = params.get("CosRegion")
        self._CosBucketName = params.get("CosBucketName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiopsSimpleTaskDto(AbstractModel):
    """父任务simple信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _Status: 任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _CycleType: 周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleType: str
        :param _Creator: 任务创建人
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _WorkflowId: 工作流id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _WorkflowName: 工作流名称
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowName: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _ProjectIdent: 项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _ConfigType: 配置策略
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigType: str
        :param _TimeDimension: 时间维度
注意：此字段可能返回 null，表示取不到有效值。
        :type TimeDimension: str
        :param _InstanceScope: 实例范围
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceScope: str
        :param _ExectuorPolicy: 执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type ExectuorPolicy: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Status = None
        self._CycleType = None
        self._Creator = None
        self._WorkflowId = None
        self._WorkflowName = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._ConfigType = None
        self._TimeDimension = None
        self._InstanceScope = None
        self._ExectuorPolicy = None

    @property
    def TaskId(self):
        """任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """任务名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Status(self):
        """任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CycleType(self):
        """周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def Creator(self):
        """任务创建人
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def WorkflowId(self):
        """工作流id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        """工作流名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def ProjectId(self):
        """项目id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        """项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        """项目名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ConfigType(self):
        """配置策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def TimeDimension(self):
        """时间维度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TimeDimension

    @TimeDimension.setter
    def TimeDimension(self, TimeDimension):
        self._TimeDimension = TimeDimension

    @property
    def InstanceScope(self):
        """实例范围
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceScope

    @InstanceScope.setter
    def InstanceScope(self, InstanceScope):
        self._InstanceScope = InstanceScope

    @property
    def ExectuorPolicy(self):
        """执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExectuorPolicy

    @ExectuorPolicy.setter
    def ExectuorPolicy(self, ExectuorPolicy):
        self._ExectuorPolicy = ExectuorPolicy


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Status = params.get("Status")
        self._CycleType = params.get("CycleType")
        self._Creator = params.get("Creator")
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._ConfigType = params.get("ConfigType")
        self._TimeDimension = params.get("TimeDimension")
        self._InstanceScope = params.get("InstanceScope")
        self._ExectuorPolicy = params.get("ExectuorPolicy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmEventInfo(AbstractModel):
    """告警事件详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _RegularName: 规则名称
        :type RegularName: str
        :param _AlarmLevel: 告警级别,0表示普通，1表示重要，2表示紧急
        :type AlarmLevel: int
        :param _AlarmWay: 告警方式,多个用逗号隔开（1:邮件，2:短信，3:微信，4:语音，5:代表企业微信，6:http）
        :type AlarmWay: int
        :param _AlarmRecipientId: 告警接收人Id，多个用逗号隔开
        :type AlarmRecipientId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _AlarmIndicator: 告警指标,0表示任务失败，1表示任务运行超时，2表示任务停止，3表示任务暂停
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _IsSendSuccess: 0：部分成功，1：全部成功，2：全部失败
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSendSuccess: int
        :param _InQuitePeriods: 是否在免打扰时间内，0:否, 1:是
注意：此字段可能返回 null，表示取不到有效值。
        :type InQuitePeriods: int
        :param _RecordId: 告警记录id
注意：此字段可能返回 null，表示取不到有效值。
        :type RecordId: int
        :param _MessageId: 消息ID
注意：此字段可能返回 null，表示取不到有效值。
        :type MessageId: str
        :param _Operator: 阈值计算算子，1 : 大于 2 ：小于
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _RegularId: 告警规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RegularId: str
        :param _AlarmRecipientName: 告警接收人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipientName: str
        :param _TaskType: 告警任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskType: int
        :param _SendResult: 发送结果
注意：此字段可能返回 null，表示取不到有效值。
        :type SendResult: str
        :param _MonitorObjectId: 监控对象id
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorObjectId: str
        :param _MonitorObjectName: 监控对象名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorObjectName: str
        :param _Threshold: 指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        :param _AlarmReason: 告警原因
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmReason: str
        :param _IndicatorTimeRangeValue: 近范围值
注意：此字段可能返回 null，表示取不到有效值。
        :type IndicatorTimeRangeValue: int
        :param _IndicatorTimeRangeUnit: 近范围单位
注意：此字段可能返回 null，表示取不到有效值。
        :type IndicatorTimeRangeUnit: str
        :param _SyncType: 同步类型
注意：此字段可能返回 null，表示取不到有效值。
        :type SyncType: int
        """
        self._AlarmId = None
        self._AlarmTime = None
        self._TaskId = None
        self._RegularName = None
        self._AlarmLevel = None
        self._AlarmWay = None
        self._AlarmRecipientId = None
        self._ProjectId = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._InstanceId = None
        self._TaskName = None
        self._IsSendSuccess = None
        self._InQuitePeriods = None
        self._RecordId = None
        self._MessageId = None
        self._Operator = None
        self._RegularId = None
        self._AlarmRecipientName = None
        self._TaskType = None
        self._SendResult = None
        self._MonitorObjectId = None
        self._MonitorObjectName = None
        self._Threshold = None
        self._AlarmReason = None
        self._IndicatorTimeRangeValue = None
        self._IndicatorTimeRangeUnit = None
        self._SyncType = None

    @property
    def AlarmId(self):
        """告警ID
        :rtype: str
        """
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmTime(self):
        """告警时间
        :rtype: str
        """
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RegularName(self):
        """规则名称
        :rtype: str
        """
        return self._RegularName

    @RegularName.setter
    def RegularName(self, RegularName):
        self._RegularName = RegularName

    @property
    def AlarmLevel(self):
        """告警级别,0表示普通，1表示重要，2表示紧急
        :rtype: int
        """
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmWay(self):
        """告警方式,多个用逗号隔开（1:邮件，2:短信，3:微信，4:语音，5:代表企业微信，6:http）
        :rtype: int
        """
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipientId(self):
        """告警接收人Id，多个用逗号隔开
        :rtype: str
        """
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmIndicator(self):
        """告警指标,0表示任务失败，1表示任务运行超时，2表示任务停止，3表示任务暂停
        :rtype: int
        """
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        """告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        """指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        """预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def InstanceId(self):
        """实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TaskName(self):
        """任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def IsSendSuccess(self):
        """0：部分成功，1：全部成功，2：全部失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IsSendSuccess

    @IsSendSuccess.setter
    def IsSendSuccess(self, IsSendSuccess):
        self._IsSendSuccess = IsSendSuccess

    @property
    def InQuitePeriods(self):
        """是否在免打扰时间内，0:否, 1:是
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InQuitePeriods

    @InQuitePeriods.setter
    def InQuitePeriods(self, InQuitePeriods):
        self._InQuitePeriods = InQuitePeriods

    @property
    def RecordId(self):
        """告警记录id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def MessageId(self):
        """消息ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def Operator(self):
        """阈值计算算子，1 : 大于 2 ：小于
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def RegularId(self):
        """告警规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegularId

    @RegularId.setter
    def RegularId(self, RegularId):
        self._RegularId = RegularId

    @property
    def AlarmRecipientName(self):
        """告警接收人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def TaskType(self):
        """告警任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def SendResult(self):
        """发送结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SendResult

    @SendResult.setter
    def SendResult(self, SendResult):
        self._SendResult = SendResult

    @property
    def MonitorObjectId(self):
        """监控对象id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MonitorObjectId

    @MonitorObjectId.setter
    def MonitorObjectId(self, MonitorObjectId):
        self._MonitorObjectId = MonitorObjectId

    @property
    def MonitorObjectName(self):
        """监控对象名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MonitorObjectName

    @MonitorObjectName.setter
    def MonitorObjectName(self, MonitorObjectName):
        self._MonitorObjectName = MonitorObjectName

    @property
    def Threshold(self):
        """指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold

    @property
    def AlarmReason(self):
        """告警原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmReason

    @AlarmReason.setter
    def AlarmReason(self, AlarmReason):
        self._AlarmReason = AlarmReason

    @property
    def IndicatorTimeRangeValue(self):
        """近范围值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IndicatorTimeRangeValue

    @IndicatorTimeRangeValue.setter
    def IndicatorTimeRangeValue(self, IndicatorTimeRangeValue):
        self._IndicatorTimeRangeValue = IndicatorTimeRangeValue

    @property
    def IndicatorTimeRangeUnit(self):
        """近范围单位
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IndicatorTimeRangeUnit

    @IndicatorTimeRangeUnit.setter
    def IndicatorTimeRangeUnit(self, IndicatorTimeRangeUnit):
        self._IndicatorTimeRangeUnit = IndicatorTimeRangeUnit

    @property
    def SyncType(self):
        """同步类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmTime = params.get("AlarmTime")
        self._TaskId = params.get("TaskId")
        self._RegularName = params.get("RegularName")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._ProjectId = params.get("ProjectId")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._InstanceId = params.get("InstanceId")
        self._TaskName = params.get("TaskName")
        self._IsSendSuccess = params.get("IsSendSuccess")
        self._InQuitePeriods = params.get("InQuitePeriods")
        self._RecordId = params.get("RecordId")
        self._MessageId = params.get("MessageId")
        self._Operator = params.get("Operator")
        self._RegularId = params.get("RegularId")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._TaskType = params.get("TaskType")
        self._SendResult = params.get("SendResult")
        self._MonitorObjectId = params.get("MonitorObjectId")
        self._MonitorObjectName = params.get("MonitorObjectName")
        self._Threshold = params.get("Threshold")
        self._AlarmReason = params.get("AlarmReason")
        self._IndicatorTimeRangeValue = params.get("IndicatorTimeRangeValue")
        self._IndicatorTimeRangeUnit = params.get("IndicatorTimeRangeUnit")
        self._SyncType = params.get("SyncType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmIndicatorInfo(AbstractModel):
    """告警指标

    """

    def __init__(self):
        r"""
        :param _Id: 指标id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _AlarmIndicator: 告警指标,0任务失败,1任务运行超时,2任务停止,3任务暂停, 4读取速度,5写入速度,6读取吞吐 7写入吞吐, 8脏数据字节数,9脏数据条数,10任务异常,11任务检测异常, 12重启次数, 13任务延时, 14近20分内的重启次数 15传输延迟,16业务延迟, 50离线包CPU使用率, 51离线包内存使用率, 52离线包并行度使用率, 53离线包排队中的实例数, 54实时包资源使用率, 55实时包运行中的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _Operator: 告警阈值的算子,1 大于,2 小于
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _AlarmIndicatorUnit: 告警指标阈值单位：ms(毫秒)、s(秒)、min(分钟)
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorUnit: str
        :param _Duration: 告警周期
        :type Duration: int
        :param _DurationUnit: 告警周期单位:hour,minute,day
        :type DurationUnit: str
        :param _MaxTimes: 周期内最多告警次数
        :type MaxTimes: int
        :param _Threshold: 指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        :param _IndicatorTimeRangeUnit: 时间范围单位
注意：此字段可能返回 null，表示取不到有效值。
        :type IndicatorTimeRangeUnit: str
        :param _IndicatorTimeRangeValue: 时间范围值
注意：此字段可能返回 null，表示取不到有效值。
        :type IndicatorTimeRangeValue: int
        """
        self._Id = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._Operator = None
        self._AlarmIndicatorUnit = None
        self._Duration = None
        self._DurationUnit = None
        self._MaxTimes = None
        self._Threshold = None
        self._IndicatorTimeRangeUnit = None
        self._IndicatorTimeRangeValue = None

    @property
    def Id(self):
        """指标id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AlarmIndicator(self):
        """告警指标,0任务失败,1任务运行超时,2任务停止,3任务暂停, 4读取速度,5写入速度,6读取吞吐 7写入吞吐, 8脏数据字节数,9脏数据条数,10任务异常,11任务检测异常, 12重启次数, 13任务延时, 14近20分内的重启次数 15传输延迟,16业务延迟, 50离线包CPU使用率, 51离线包内存使用率, 52离线包并行度使用率, 53离线包排队中的实例数, 54实时包资源使用率, 55实时包运行中的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        """告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        """指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        """预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def Operator(self):
        """告警阈值的算子,1 大于,2 小于
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def AlarmIndicatorUnit(self):
        """告警指标阈值单位：ms(毫秒)、s(秒)、min(分钟)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmIndicatorUnit

    @AlarmIndicatorUnit.setter
    def AlarmIndicatorUnit(self, AlarmIndicatorUnit):
        self._AlarmIndicatorUnit = AlarmIndicatorUnit

    @property
    def Duration(self):
        """告警周期
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def DurationUnit(self):
        """告警周期单位:hour,minute,day
        :rtype: str
        """
        return self._DurationUnit

    @DurationUnit.setter
    def DurationUnit(self, DurationUnit):
        self._DurationUnit = DurationUnit

    @property
    def MaxTimes(self):
        """周期内最多告警次数
        :rtype: int
        """
        return self._MaxTimes

    @MaxTimes.setter
    def MaxTimes(self, MaxTimes):
        self._MaxTimes = MaxTimes

    @property
    def Threshold(self):
        """指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold

    @property
    def IndicatorTimeRangeUnit(self):
        """时间范围单位
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IndicatorTimeRangeUnit

    @IndicatorTimeRangeUnit.setter
    def IndicatorTimeRangeUnit(self, IndicatorTimeRangeUnit):
        self._IndicatorTimeRangeUnit = IndicatorTimeRangeUnit

    @property
    def IndicatorTimeRangeValue(self):
        """时间范围值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IndicatorTimeRangeValue

    @IndicatorTimeRangeValue.setter
    def IndicatorTimeRangeValue(self, IndicatorTimeRangeValue):
        self._IndicatorTimeRangeValue = IndicatorTimeRangeValue


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._Operator = params.get("Operator")
        self._AlarmIndicatorUnit = params.get("AlarmIndicatorUnit")
        self._Duration = params.get("Duration")
        self._DurationUnit = params.get("DurationUnit")
        self._MaxTimes = params.get("MaxTimes")
        self._Threshold = params.get("Threshold")
        self._IndicatorTimeRangeUnit = params.get("IndicatorTimeRangeUnit")
        self._IndicatorTimeRangeValue = params.get("IndicatorTimeRangeValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmInfo(AbstractModel):
    """任务告警信息

    """

    def __init__(self):
        r"""
        :param _TaskIds: 关联任务id
        :type TaskIds: str
        :param _AlarmType: 告警类别；failure表示失败告警；overtime表示超时告警
        :type AlarmType: str
        :param _AlarmWay: 告警方式；SMS表示短信；Email表示邮件；HTTP 表示接口方式；Wechat表示微信方式
        :type AlarmWay: str
        :param _AlarmRecipient: 告警接收人，多个告警接收人以;分割
        :type AlarmRecipient: str
        :param _AlarmRecipientId: 告警接收人id，多个告警接收人id以;分割
        :type AlarmRecipientId: str
        :param _Hours: 预计运行的小时，取值范围0-23
        :type Hours: int
        :param _Minutes: 预计运行分钟，取值范围0-59
        :type Minutes: int
        :param _TriggerType: 告警出发时机；1表示第一次运行失败；2表示所有重试完成后失败；
        :type TriggerType: int
        :param _AlarmId: 告警信息id
        :type AlarmId: str
        :param _Status: 告警状态设置；1表示可用；0表示不可用，默认可用
        :type Status: int
        """
        self._TaskIds = None
        self._AlarmType = None
        self._AlarmWay = None
        self._AlarmRecipient = None
        self._AlarmRecipientId = None
        self._Hours = None
        self._Minutes = None
        self._TriggerType = None
        self._AlarmId = None
        self._Status = None

    @property
    def TaskIds(self):
        """关联任务id
        :rtype: str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def AlarmType(self):
        """告警类别；failure表示失败告警；overtime表示超时告警
        :rtype: str
        """
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def AlarmWay(self):
        """告警方式；SMS表示短信；Email表示邮件；HTTP 表示接口方式；Wechat表示微信方式
        :rtype: str
        """
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipient(self):
        """告警接收人，多个告警接收人以;分割
        :rtype: str
        """
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientId(self):
        """告警接收人id，多个告警接收人id以;分割
        :rtype: str
        """
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def Hours(self):
        """预计运行的小时，取值范围0-23
        :rtype: int
        """
        return self._Hours

    @Hours.setter
    def Hours(self, Hours):
        self._Hours = Hours

    @property
    def Minutes(self):
        """预计运行分钟，取值范围0-59
        :rtype: int
        """
        return self._Minutes

    @Minutes.setter
    def Minutes(self, Minutes):
        self._Minutes = Minutes

    @property
    def TriggerType(self):
        """告警出发时机；1表示第一次运行失败；2表示所有重试完成后失败；
        :rtype: int
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def AlarmId(self):
        """告警信息id
        :rtype: str
        """
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        """告警状态设置；1表示可用；0表示不可用，默认可用
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._AlarmType = params.get("AlarmType")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._Hours = params.get("Hours")
        self._Minutes = params.get("Minutes")
        self._TriggerType = params.get("TriggerType")
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmReceiverInfo(AbstractModel):
    """告警接收人详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmReceiver: 告警接收人ID
        :type AlarmReceiver: str
        :param _Email: 邮件，0：未设置，1：成功，2：失败
        :type Email: int
        :param _Sms: 短信，0：未设置，1：成功，2：失败
        :type Sms: int
        :param _Wechat: 微信，0：未设置，1：成功，2：失败
        :type Wechat: int
        :param _Voice: 电话，0：未设置，1：成功，2：失败
        :type Voice: int
        :param _Wecom: 企业微信，0：未设置，1：成功，2：失败
        :type Wecom: int
        :param _Http: http，0：未设置，1：成功，2：失败
        :type Http: int
        :param _WecomGroup: 企业微信群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type WecomGroup: int
        :param _LarkGroup: 飞书群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type LarkGroup: int
        """
        self._AlarmId = None
        self._AlarmReceiver = None
        self._Email = None
        self._Sms = None
        self._Wechat = None
        self._Voice = None
        self._Wecom = None
        self._Http = None
        self._WecomGroup = None
        self._LarkGroup = None

    @property
    def AlarmId(self):
        """告警ID
        :rtype: str
        """
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmReceiver(self):
        """告警接收人ID
        :rtype: str
        """
        return self._AlarmReceiver

    @AlarmReceiver.setter
    def AlarmReceiver(self, AlarmReceiver):
        self._AlarmReceiver = AlarmReceiver

    @property
    def Email(self):
        """邮件，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Sms(self):
        """短信，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Sms

    @Sms.setter
    def Sms(self, Sms):
        self._Sms = Sms

    @property
    def Wechat(self):
        """微信，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Wechat

    @Wechat.setter
    def Wechat(self, Wechat):
        self._Wechat = Wechat

    @property
    def Voice(self):
        """电话，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Voice

    @Voice.setter
    def Voice(self, Voice):
        self._Voice = Voice

    @property
    def Wecom(self):
        """企业微信，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Wecom

    @Wecom.setter
    def Wecom(self, Wecom):
        self._Wecom = Wecom

    @property
    def Http(self):
        """http，0：未设置，1：成功，2：失败
        :rtype: int
        """
        return self._Http

    @Http.setter
    def Http(self, Http):
        self._Http = Http

    @property
    def WecomGroup(self):
        """企业微信群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._WecomGroup

    @WecomGroup.setter
    def WecomGroup(self, WecomGroup):
        self._WecomGroup = WecomGroup

    @property
    def LarkGroup(self):
        """飞书群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LarkGroup

    @LarkGroup.setter
    def LarkGroup(self, LarkGroup):
        self._LarkGroup = LarkGroup


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmReceiver = params.get("AlarmReceiver")
        self._Email = params.get("Email")
        self._Sms = params.get("Sms")
        self._Wechat = params.get("Wechat")
        self._Voice = params.get("Voice")
        self._Wecom = params.get("Wecom")
        self._Http = params.get("Http")
        self._WecomGroup = params.get("WecomGroup")
        self._LarkGroup = params.get("LarkGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Apply(AbstractModel):
    """审批列表信息

    """

    def __init__(self):
        r"""
        :param _ApplicantId: 申请人id
        :type ApplicantId: str
        :param _ApplicantName: 申请人名称
        :type ApplicantName: str
        :param _Remark: 审批备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _ApproveClassification: 审批分类key
        :type ApproveClassification: str
        :param _ApproveId: 审批单id
        :type ApproveId: str
        :param _ApproveType: 审批类型key
        :type ApproveType: str
        :param _Reason: 申请原因
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ApproveTime: 审批时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproveTime: str
        :param _ApproveClassificationName: 审批分类名称
        :type ApproveClassificationName: str
        :param _Status: 状态
        :type Status: str
        :param _ApproveTypeName: 审批类型名称
        :type ApproveTypeName: str
        :param _ErrorMessage: 审批异常或者失败信息
        :type ErrorMessage: str
        :param _ApplyName: 申请名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplyName: str
        :param _ApproverId: 审批人id
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproverId: str
        :param _ApproverName: 审批人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproverName: str
        :param _ApproveProjectName: 审批所属项目
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproveProjectName: str
        :param _ApplyId: 审批id
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplyId: str
        """
        self._ApplicantId = None
        self._ApplicantName = None
        self._Remark = None
        self._ApproveClassification = None
        self._ApproveId = None
        self._ApproveType = None
        self._Reason = None
        self._CreateTime = None
        self._ApproveTime = None
        self._ApproveClassificationName = None
        self._Status = None
        self._ApproveTypeName = None
        self._ErrorMessage = None
        self._ApplyName = None
        self._ApproverId = None
        self._ApproverName = None
        self._ApproveProjectName = None
        self._ApplyId = None

    @property
    def ApplicantId(self):
        """申请人id
        :rtype: str
        """
        return self._ApplicantId

    @ApplicantId.setter
    def ApplicantId(self, ApplicantId):
        self._ApplicantId = ApplicantId

    @property
    def ApplicantName(self):
        """申请人名称
        :rtype: str
        """
        return self._ApplicantName

    @ApplicantName.setter
    def ApplicantName(self, ApplicantName):
        self._ApplicantName = ApplicantName

    @property
    def Remark(self):
        """审批备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ApproveClassification(self):
        """审批分类key
        :rtype: str
        """
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def ApproveId(self):
        """审批单id
        :rtype: str
        """
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def ApproveType(self):
        """审批类型key
        :rtype: str
        """
        return self._ApproveType

    @ApproveType.setter
    def ApproveType(self, ApproveType):
        self._ApproveType = ApproveType

    @property
    def Reason(self):
        """申请原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ApproveTime(self):
        """审批时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApproveTime

    @ApproveTime.setter
    def ApproveTime(self, ApproveTime):
        self._ApproveTime = ApproveTime

    @property
    def ApproveClassificationName(self):
        """审批分类名称
        :rtype: str
        """
        return self._ApproveClassificationName

    @ApproveClassificationName.setter
    def ApproveClassificationName(self, ApproveClassificationName):
        self._ApproveClassificationName = ApproveClassificationName

    @property
    def Status(self):
        """状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ApproveTypeName(self):
        """审批类型名称
        :rtype: str
        """
        return self._ApproveTypeName

    @ApproveTypeName.setter
    def ApproveTypeName(self, ApproveTypeName):
        self._ApproveTypeName = ApproveTypeName

    @property
    def ErrorMessage(self):
        """审批异常或者失败信息
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def ApplyName(self):
        """申请名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplyName

    @ApplyName.setter
    def ApplyName(self, ApplyName):
        self._ApplyName = ApplyName

    @property
    def ApproverId(self):
        """审批人id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApproverId

    @ApproverId.setter
    def ApproverId(self, ApproverId):
        self._ApproverId = ApproverId

    @property
    def ApproverName(self):
        """审批人名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApproverName

    @ApproverName.setter
    def ApproverName(self, ApproverName):
        self._ApproverName = ApproverName

    @property
    def ApproveProjectName(self):
        """审批所属项目
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApproveProjectName

    @ApproveProjectName.setter
    def ApproveProjectName(self, ApproveProjectName):
        self._ApproveProjectName = ApproveProjectName

    @property
    def ApplyId(self):
        """审批id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplyId

    @ApplyId.setter
    def ApplyId(self, ApplyId):
        self._ApplyId = ApplyId


    def _deserialize(self, params):
        self._ApplicantId = params.get("ApplicantId")
        self._ApplicantName = params.get("ApplicantName")
        self._Remark = params.get("Remark")
        self._ApproveClassification = params.get("ApproveClassification")
        self._ApproveId = params.get("ApproveId")
        self._ApproveType = params.get("ApproveType")
        self._Reason = params.get("Reason")
        self._CreateTime = params.get("CreateTime")
        self._ApproveTime = params.get("ApproveTime")
        self._ApproveClassificationName = params.get("ApproveClassificationName")
        self._Status = params.get("Status")
        self._ApproveTypeName = params.get("ApproveTypeName")
        self._ErrorMessage = params.get("ErrorMessage")
        self._ApplyName = params.get("ApplyName")
        self._ApproverId = params.get("ApproverId")
        self._ApproverName = params.get("ApproverName")
        self._ApproveProjectName = params.get("ApproveProjectName")
        self._ApplyId = params.get("ApplyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveModify(AbstractModel):
    """修改审批单状态

    """

    def __init__(self):
        r"""
        :param _ApproveId: 审批单id
        :type ApproveId: str
        :param _Success: 是否修改成功
        :type Success: bool
        """
        self._ApproveId = None
        self._Success = None

    @property
    def ApproveId(self):
        """审批单id
        :rtype: str
        """
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def Success(self):
        """是否修改成功
        :rtype: bool
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success


    def _deserialize(self, params):
        self._ApproveId = params.get("ApproveId")
        self._Success = params.get("Success")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveType(AbstractModel):
    """审批分类

    """

    def __init__(self):
        r"""
        :param _Type: 申请分类key
        :type Type: str
        :param _TypeName: 类型名称
        :type TypeName: str
        :param _Classification: 申请类型key
        :type Classification: str
        """
        self._Type = None
        self._TypeName = None
        self._Classification = None

    @property
    def Type(self):
        """申请分类key
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TypeName(self):
        """类型名称
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def Classification(self):
        """申请类型key
        :rtype: str
        """
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TypeName = params.get("TypeName")
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttributeItemDTO(AbstractModel):
    """aiops基础信息

    """

    def __init__(self):
        r"""
        :param _Key: key
注意：此字段可能返回 null，表示取不到有效值。
        :type Key: str
        :param _Value: value
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Key = None
        self._Value = None
        self._Description = None

    @property
    def Key(self):
        """key
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        """value
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Description(self):
        """描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseClusterInfo(AbstractModel):
    """集群基础信息

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterType: 集群类型，EMR/CDW等
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterType: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _RegionCn: 地域中文
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionCn: str
        :param _RegionEn: 地域英文
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionEn: str
        :param _RegionArea: 地区
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionArea: str
        :param _Used: 集群是否使用
注意：此字段可能返回 null，表示取不到有效值。
        :type Used: bool
        :param _Status: 集群状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _StatusInfo: 集群状态信息
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusInfo: str
        :param _StorageType: 集群存储类型
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageType: str
        :param _ComputeType: 集群计算类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ComputeType: str
        :param _ClusterResource: 集群资源量
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterResource: str
        :param _ChargeType: 集群付费方式
注意：此字段可能返回 null，表示取不到有效值。
        :type ChargeType: str
        :param _CreateTime: 集群创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ExtraConf: 额外配置
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtraConf: str
        :param _RangerUserName: ranger账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :type RangerUserName: str
        :param _CdwUserName: cdw账号（用于展示）
注意：此字段可能返回 null，表示取不到有效值。
        :type CdwUserName: str
        """
        self._ClusterId = None
        self._ClusterType = None
        self._ClusterName = None
        self._RegionCn = None
        self._RegionEn = None
        self._RegionArea = None
        self._Used = None
        self._Status = None
        self._StatusInfo = None
        self._StorageType = None
        self._ComputeType = None
        self._ClusterResource = None
        self._ChargeType = None
        self._CreateTime = None
        self._ExtraConf = None
        self._RangerUserName = None
        self._CdwUserName = None

    @property
    def ClusterId(self):
        """集群id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterType(self):
        """集群类型，EMR/CDW等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def RegionCn(self):
        """地域中文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegionCn

    @RegionCn.setter
    def RegionCn(self, RegionCn):
        self._RegionCn = RegionCn

    @property
    def RegionEn(self):
        """地域英文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegionEn

    @RegionEn.setter
    def RegionEn(self, RegionEn):
        self._RegionEn = RegionEn

    @property
    def RegionArea(self):
        """地区
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegionArea

    @RegionArea.setter
    def RegionArea(self, RegionArea):
        self._RegionArea = RegionArea

    @property
    def Used(self):
        """集群是否使用
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Status(self):
        """集群状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusInfo(self):
        """集群状态信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StatusInfo

    @StatusInfo.setter
    def StatusInfo(self, StatusInfo):
        self._StatusInfo = StatusInfo

    @property
    def StorageType(self):
        """集群存储类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def ComputeType(self):
        """集群计算类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ComputeType

    @ComputeType.setter
    def ComputeType(self, ComputeType):
        self._ComputeType = ComputeType

    @property
    def ClusterResource(self):
        """集群资源量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterResource

    @ClusterResource.setter
    def ClusterResource(self, ClusterResource):
        self._ClusterResource = ClusterResource

    @property
    def ChargeType(self):
        """集群付费方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def CreateTime(self):
        """集群创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExtraConf(self):
        """额外配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExtraConf

    @ExtraConf.setter
    def ExtraConf(self, ExtraConf):
        self._ExtraConf = ExtraConf

    @property
    def RangerUserName(self):
        """ranger账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RangerUserName

    @RangerUserName.setter
    def RangerUserName(self, RangerUserName):
        self._RangerUserName = RangerUserName

    @property
    def CdwUserName(self):
        """cdw账号（用于展示）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CdwUserName

    @CdwUserName.setter
    def CdwUserName(self, CdwUserName):
        self._CdwUserName = CdwUserName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterName = params.get("ClusterName")
        self._RegionCn = params.get("RegionCn")
        self._RegionEn = params.get("RegionEn")
        self._RegionArea = params.get("RegionArea")
        self._Used = params.get("Used")
        self._Status = params.get("Status")
        self._StatusInfo = params.get("StatusInfo")
        self._StorageType = params.get("StorageType")
        self._ComputeType = params.get("ComputeType")
        self._ClusterResource = params.get("ClusterResource")
        self._ChargeType = params.get("ChargeType")
        self._CreateTime = params.get("CreateTime")
        self._ExtraConf = params.get("ExtraConf")
        self._RangerUserName = params.get("RangerUserName")
        self._CdwUserName = params.get("CdwUserName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseTenant(AbstractModel):
    """租户基础信息

    """

    def __init__(self):
        r"""
        :param _TenantId: 租户id
注意：此字段可能返回 null，表示取不到有效值。
        :type TenantId: str
        :param _TenantName: 租户标识
注意：此字段可能返回 null，表示取不到有效值。
        :type TenantName: str
        :param _DisplayName: 租户显示名称，一般是中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type DisplayName: str
        :param _Description: 备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _OwnerUserId: 租户主账号
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUserId: str
        :param _Params: 租户的额外配置参数, json格式字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        """
        self._TenantId = None
        self._TenantName = None
        self._DisplayName = None
        self._Description = None
        self._OwnerUserId = None
        self._Params = None

    @property
    def TenantId(self):
        """租户id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def TenantName(self):
        """租户标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TenantName

    @TenantName.setter
    def TenantName(self, TenantName):
        self._TenantName = TenantName

    @property
    def DisplayName(self):
        """租户显示名称，一般是中文名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        """备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OwnerUserId(self):
        """租户主账号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerUserId

    @OwnerUserId.setter
    def OwnerUserId(self, OwnerUserId):
        self._OwnerUserId = OwnerUserId

    @property
    def Params(self):
        """租户的额外配置参数, json格式字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params


    def _deserialize(self, params):
        self._TenantId = params.get("TenantId")
        self._TenantName = params.get("TenantName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._OwnerUserId = params.get("OwnerUserId")
        self._Params = params.get("Params")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseUser(AbstractModel):
    """基础用户信息

    """

    def __init__(self):
        r"""
        :param _UserId: 有云的UIN，全局唯一
注意：此字段可能返回 null，表示取不到有效值。
        :type UserId: str
        :param _UserName: 用户全局唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _DisplayName: 用户显示名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DisplayName: str
        :param _PhoneNum: 电话号码
注意：此字段可能返回 null，表示取不到有效值。
        :type PhoneNum: str
        :param _Email: 邮箱
注意：此字段可能返回 null，表示取不到有效值。
        :type Email: str
        """
        self._UserId = None
        self._UserName = None
        self._DisplayName = None
        self._PhoneNum = None
        self._Email = None

    @property
    def UserId(self):
        """有云的UIN，全局唯一
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        """用户全局唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def DisplayName(self):
        """用户显示名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def PhoneNum(self):
        """电话号码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PhoneNum

    @PhoneNum.setter
    def PhoneNum(self, PhoneNum):
        self._PhoneNum = PhoneNum

    @property
    def Email(self):
        """邮箱
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._DisplayName = params.get("DisplayName")
        self._PhoneNum = params.get("PhoneNum")
        self._Email = params.get("Email")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsRequest(AbstractModel):
    """BatchCreateIntegrationTaskAlarms请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskAlarmInfo(self):
        """告警配置信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        """
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsResponse(AbstractModel):
    """BatchCreateIntegrationTaskAlarms返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchCreateTaskVersionAsyncRequest(AbstractModel):
    """BatchCreateTaskVersionAsync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Tasks: 任务信息
        :type Tasks: list of BatchCreateTaskVersionDTO
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _AutoRun: 是否自动运行
        :type AutoRun: bool
        :param _AlarmWays: 告警方式:email-邮件;sms-短信;wecom-企业微信
        :type AlarmWays: str
        :param _AlarmRecipientTypes: 告警对象:1-项目管理员，2-任务责任人
        :type AlarmRecipientTypes: str
        :param _NeedCheckParentSubmitted: 是否需要校验父任务已经提交到调度
        :type NeedCheckParentSubmitted: bool
        """
        self._Tasks = None
        self._ProjectId = None
        self._AutoRun = None
        self._AlarmWays = None
        self._AlarmRecipientTypes = None
        self._NeedCheckParentSubmitted = None

    @property
    def Tasks(self):
        """任务信息
        :rtype: list of BatchCreateTaskVersionDTO
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AutoRun(self):
        """是否自动运行
        :rtype: bool
        """
        return self._AutoRun

    @AutoRun.setter
    def AutoRun(self, AutoRun):
        self._AutoRun = AutoRun

    @property
    def AlarmWays(self):
        """告警方式:email-邮件;sms-短信;wecom-企业微信
        :rtype: str
        """
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientTypes(self):
        """告警对象:1-项目管理员，2-任务责任人
        :rtype: str
        """
        return self._AlarmRecipientTypes

    @AlarmRecipientTypes.setter
    def AlarmRecipientTypes(self, AlarmRecipientTypes):
        self._AlarmRecipientTypes = AlarmRecipientTypes

    @property
    def NeedCheckParentSubmitted(self):
        """是否需要校验父任务已经提交到调度
        :rtype: bool
        """
        return self._NeedCheckParentSubmitted

    @NeedCheckParentSubmitted.setter
    def NeedCheckParentSubmitted(self, NeedCheckParentSubmitted):
        self._NeedCheckParentSubmitted = NeedCheckParentSubmitted


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = BatchCreateTaskVersionDTO()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._ProjectId = params.get("ProjectId")
        self._AutoRun = params.get("AutoRun")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientTypes = params.get("AlarmRecipientTypes")
        self._NeedCheckParentSubmitted = params.get("NeedCheckParentSubmitted")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateTaskVersionAsyncResponse(AbstractModel):
    """BatchCreateTaskVersionAsync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 批量操作返回
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchTaskOperateNew`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """批量操作返回
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.BatchTaskOperateNew`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchTaskOperateNew()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchCreateTaskVersionDTO(AbstractModel):
    """BatchCreateTaskVersion使用，描述任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _VersionRemark: VersionRemark
注意：此字段可能返回 null，表示取不到有效值。
        :type VersionRemark: str
        :param _FolderId: 文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderId: str
        """
        self._TaskId = None
        self._VersionRemark = None
        self._FolderId = None

    @property
    def TaskId(self):
        """任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VersionRemark(self):
        """VersionRemark
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def FolderId(self):
        """文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._VersionRemark = params.get("VersionRemark")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksRequest(AbstractModel):
    """BatchDeleteIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DeleteKFFlag: 是否删除开发态任务。默认不删除开发态，为 0 不删除 , 为 1 删除
        :type DeleteKFFlag: int
        :param _Name: 操作名称
        :type Name: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._DeleteKFFlag = None
        self._Name = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteKFFlag(self):
        """是否删除开发态任务。默认不删除开发态，为 0 不删除 , 为 1 删除
        :rtype: int
        """
        return self._DeleteKFFlag

    @DeleteKFFlag.setter
    def DeleteKFFlag(self, DeleteKFFlag):
        self._DeleteKFFlag = DeleteKFFlag

    @property
    def Name(self):
        """操作名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TaskNames(self):
        """本次批量操作涉及任务，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._DeleteKFFlag = params.get("DeleteKFFlag")
        self._Name = params.get("Name")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksResponse(AbstractModel):
    """BatchDeleteIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchDeleteOpsTasksRequest(AbstractModel):
    """BatchDeleteOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量删除的任务TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        """批量删除的任务TaskId
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        """true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :rtype: bool
        """
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        """true：通知下游任务责任人
false:  不通知下游任务责任人
        :rtype: bool
        """
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteOpsTasksResponse(AbstractModel):
    """BatchDeleteOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """返回批量操作成功个数、失败个数、操作总数
        :rtype: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchForceSuccessIntegrationTaskInstancesRequest(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        """实例信息
        :rtype: list of SchedulerTaskInstanceInfo
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchForceSuccessIntegrationTaskInstancesResponse(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchKillIntegrationTaskInstancesRequest(AbstractModel):
    """BatchKillIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        """实例信息
        :rtype: list of SchedulerTaskInstanceInfo
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchKillIntegrationTaskInstancesResponse(AbstractModel):
    """BatchKillIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 实际传的为taskId
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        """实际传的为taskId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchMakeUpIntegrationTasksRequest(AbstractModel):
    """BatchMakeUpIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        :param _StartTime: 补数据开始时间
        :type StartTime: str
        :param _EndTime: 补数据结束时间
        :type EndTime: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        """补数据开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """补数据结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchMakeUpIntegrationTasksResponse(AbstractModel):
    """BatchMakeUpIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchModifyOpsOwnersRequest(AbstractModel):
    """BatchModifyOpsOwners请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 需要更新责任人的TaskId数组
        :type TaskIdList: list of str
        :param _Owners: 需要更新的责任人userId信息，多个责任人用;连接
        :type Owners: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._Owners = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        """需要更新责任人的TaskId数组
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def Owners(self):
        """需要更新的责任人userId信息，多个责任人用;连接
        :rtype: str
        """
        return self._Owners

    @Owners.setter
    def Owners(self, Owners):
        self._Owners = Owners

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._Owners = params.get("Owners")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyOpsOwnersResponse(AbstractModel):
    """BatchModifyOpsOwners返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """返回批量操作成功个数、失败个数、操作总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchOperateResult(AbstractModel):
    """批量操作的结果返回

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 批量操作成功数
        :type SuccessCount: int
        :param _FailedCount: 批量操作失败数
        :type FailedCount: int
        :param _TotalCount: 批量操作的总数
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        """批量操作成功数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """批量操作失败数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """批量操作的总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateResultOpsDto(AbstractModel):
    """实例批量操作结果类

    """

    def __init__(self):
        r"""
        :param _Result: 结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: bool
        :param _ErrorId: 错误id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        :param _ErrorDesc: 错误说明
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        :param _AsyncActionId: 异步操作id
注意：此字段可能返回 null，表示取不到有效值。
        :type AsyncActionId: str
        """
        self._Result = None
        self._ErrorId = None
        self._ErrorDesc = None
        self._AsyncActionId = None

    @property
    def Result(self):
        """结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorId(self):
        """错误id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId

    @property
    def ErrorDesc(self):
        """错误说明
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def AsyncActionId(self):
        """异步操作id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsyncActionId

    @AsyncActionId.setter
    def AsyncActionId(self, AsyncActionId):
        self._AsyncActionId = AsyncActionId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorId = params.get("ErrorId")
        self._ErrorDesc = params.get("ErrorDesc")
        self._AsyncActionId = params.get("AsyncActionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperationOpsDto(AbstractModel):
    """批量操作的结果返回

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 批量操作成功数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 批量操作失败数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 批量操作的总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _AsyncActionId: 异步操作记录的唯一id
注意：此字段可能返回 null，表示取不到有效值。
        :type AsyncActionId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._AsyncActionId = None

    @property
    def SuccessCount(self):
        """批量操作成功数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """批量操作失败数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """批量操作的总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AsyncActionId(self):
        """异步操作记录的唯一id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsyncActionId

    @AsyncActionId.setter
    def AsyncActionId(self, AsyncActionId):
        self._AsyncActionId = AsyncActionId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._AsyncActionId = params.get("AsyncActionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOpsDTO(AbstractModel):
    """批量操作结果，带失败原因

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _SuccessCount: 成功数量
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailCount: 失败数量
注意：此字段可能返回 null，表示取不到有效值。
        :type FailCount: int
        :param _FailMessageList: 失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailMessageList: list of FailMessage
        """
        self._TotalCount = None
        self._SuccessCount = None
        self._FailCount = None
        self._FailMessageList = None

    @property
    def TotalCount(self):
        """总数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SuccessCount(self):
        """成功数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailCount(self):
        """失败数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def FailMessageList(self):
        """失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FailMessage
        """
        return self._FailMessageList

    @FailMessageList.setter
    def FailMessageList(self, FailMessageList):
        self._FailMessageList = FailMessageList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SuccessCount = params.get("SuccessCount")
        self._FailCount = params.get("FailCount")
        if params.get("FailMessageList") is not None:
            self._FailMessageList = []
            for item in params.get("FailMessageList"):
                obj = FailMessage()
                obj._deserialize(item)
                self._FailMessageList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesRequest(AbstractModel):
    """BatchRerunIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        """实例信息
        :rtype: list of SchedulerTaskInstanceInfo
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesResponse(AbstractModel):
    """BatchRerunIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 实际传的为taskId
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        """实际传的为taskId
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchResult(AbstractModel):
    """批量操作结果

    """

    def __init__(self):
        r"""
        :param _Running: 正在运行的任务数
        :type Running: int
        :param _Success: 执行成功的任务数
        :type Success: int
        :param _Failed: 执行失败的任务数
        :type Failed: int
        :param _Total: 总任务数
        :type Total: int
        """
        self._Running = None
        self._Success = None
        self._Failed = None
        self._Total = None

    @property
    def Running(self):
        """正在运行的任务数
        :rtype: int
        """
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Success(self):
        """执行成功的任务数
        :rtype: int
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Failed(self):
        """执行失败的任务数
        :rtype: int
        """
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def Total(self):
        """总任务数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Success = params.get("Success")
        self._Failed = params.get("Failed")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResultDs(AbstractModel):
    """批量执行结果

    """

    def __init__(self):
        r"""
        :param _Success: 成功数
注意：此字段可能返回 null，表示取不到有效值。
        :type Success: int
        :param _Failed: 失败数
注意：此字段可能返回 null，表示取不到有效值。
        :type Failed: int
        :param _Total: 总计
注意：此字段可能返回 null，表示取不到有效值。
        :type Total: int
        """
        self._Success = None
        self._Failed = None
        self._Total = None

    @property
    def Success(self):
        """成功数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Failed(self):
        """失败数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def Total(self):
        """总计
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Success = params.get("Success")
        self._Failed = params.get("Failed")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksRequest(AbstractModel):
    """BatchResumeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型, 201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        """任务类型, 201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksResponse(AbstractModel):
    """BatchResumeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        """本次批量操作涉及任务，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchReturn(AbstractModel):
    """操作结果

    """

    def __init__(self):
        r"""
        :param _Result: 执行结果
        :type Result: bool
        :param _ErrorDesc: 执行情况备注
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        :param _ErrorId: 执行情况id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        """
        self._Result = None
        self._ErrorDesc = None
        self._ErrorId = None

    @property
    def Result(self):
        """执行结果
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorDesc(self):
        """执行情况备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorId(self):
        """执行情况id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorId = params.get("ErrorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskRequest(AbstractModel):
    """BatchRunOpsTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _EnableMakeUp: 是否补录中间实例,0不补录;1补录
        :type EnableMakeUp: int
        :param _Tasks: 任务id列表
        :type Tasks: list of str
        """
        self._ProjectId = None
        self._EnableMakeUp = None
        self._Tasks = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EnableMakeUp(self):
        """是否补录中间实例,0不补录;1补录
        :rtype: int
        """
        return self._EnableMakeUp

    @EnableMakeUp.setter
    def EnableMakeUp(self, EnableMakeUp):
        self._EnableMakeUp = EnableMakeUp

    @property
    def Tasks(self):
        """任务id列表
        :rtype: list of str
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EnableMakeUp = params.get("EnableMakeUp")
        self._Tasks = params.get("Tasks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskResponse(AbstractModel):
    """BatchRunOpsTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """操作结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class BatchStartIntegrationTasksRequest(AbstractModel):
    """BatchStartIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _StartTaskInfoSet: 批量运行集成任务，目前仅实时集成用到了这个参数
        :type StartTaskInfoSet: list of StartTaskInfo
        """
        self._TaskType = None
        self._ProjectId = None
        self._TaskIds = None
        self._StartTaskInfoSet = None

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def StartTaskInfoSet(self):
        """批量运行集成任务，目前仅实时集成用到了这个参数
        :rtype: list of StartTaskInfo
        """
        return self._StartTaskInfoSet

    @StartTaskInfoSet.setter
    def StartTaskInfoSet(self, StartTaskInfoSet):
        self._StartTaskInfoSet = StartTaskInfoSet


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._TaskIds = params.get("TaskIds")
        if params.get("StartTaskInfoSet") is not None:
            self._StartTaskInfoSet = []
            for item in params.get("StartTaskInfoSet"):
                obj = StartTaskInfo()
                obj._deserialize(item)
                self._StartTaskInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartIntegrationTasksResponse(AbstractModel):
    """BatchStartIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作成功任务id，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        """本次批量操作成功任务id，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopIntegrationTasksRequest(AbstractModel):
    """BatchStopIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopIntegrationTasksResponse(AbstractModel):
    """BatchStopIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作涉及成功任务，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        """本次批量操作涉及成功任务，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopOpsTasksRequest(AbstractModel):
    """BatchStopOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量停止任务的TaskId
        :type TaskIdList: list of str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _KillInstance: 是否终止已生成的实例
        :type KillInstance: bool
        :param _AsyncMode: 是否异步模式
        :type AsyncMode: bool
        """
        self._TaskIdList = None
        self._ProjectId = None
        self._KillInstance = None
        self._AsyncMode = None

    @property
    def TaskIdList(self):
        """批量停止任务的TaskId
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def KillInstance(self):
        """是否终止已生成的实例
        :rtype: bool
        """
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance

    @property
    def AsyncMode(self):
        """是否异步模式
        :rtype: bool
        """
        return self._AsyncMode

    @AsyncMode.setter
    def AsyncMode(self, AsyncMode):
        self._AsyncMode = AsyncMode


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._ProjectId = params.get("ProjectId")
        self._KillInstance = params.get("KillInstance")
        self._AsyncMode = params.get("AsyncMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopOpsTasksResponse(AbstractModel):
    """BatchStopOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """返回批量操作成功个数、失败个数、操作总数
        :rtype: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchStopWorkflowsByIdsRequest(AbstractModel):
    """BatchStopWorkflowsByIds请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: 工作流id列表
        :type WorkflowIds: list of str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _KillInstance: 是否终止已生成的实例
        :type KillInstance: bool
        :param _AsyncMode: 是否异步模式
        :type AsyncMode: bool
        """
        self._WorkflowIds = None
        self._ProjectId = None
        self._KillInstance = None
        self._AsyncMode = None

    @property
    def WorkflowIds(self):
        """工作流id列表
        :rtype: list of str
        """
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def KillInstance(self):
        """是否终止已生成的实例
        :rtype: bool
        """
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance

    @property
    def AsyncMode(self):
        """是否异步模式
        :rtype: bool
        """
        return self._AsyncMode

    @AsyncMode.setter
    def AsyncMode(self, AsyncMode):
        self._AsyncMode = AsyncMode


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._ProjectId = params.get("ProjectId")
        self._KillInstance = params.get("KillInstance")
        self._AsyncMode = params.get("AsyncMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopWorkflowsByIdsResponse(AbstractModel):
    """BatchStopWorkflowsByIds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """操作返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchSuspendIntegrationTasksRequest(AbstractModel):
    """BatchSuspendIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Event: 事件类型(START, STOP, SUSPEND, SUSPEND_WITHOUT_SP,RESUME, COMMIT, TIMESTAMP)	
        :type Event: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._Event = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Event(self):
        """事件类型(START, STOP, SUSPEND, SUSPEND_WITHOUT_SP,RESUME, COMMIT, TIMESTAMP)	
        :rtype: str
        """
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def TaskNames(self):
        """本次批量操作涉及任务，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._Event = params.get("Event")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSuspendIntegrationTasksResponse(AbstractModel):
    """BatchSuspendIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchTaskOperateNew(AbstractModel):
    """批量操作出参

    """

    def __init__(self):
        r"""
        :param _JobId: 操作Id
注意：此字段可能返回 null，表示取不到有效值。
        :type JobId: int
        """
        self._JobId = None

    @property
    def JobId(self):
        """操作Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchUpdateIntegrationTasksRequest(AbstractModel):
    """BatchUpdateIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _Incharge: 责任人（多个责任人用小写分号隔开；离线任务传入的是账号名，实时任务传入的是账号id）
        :type Incharge: str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _InchargeIds: 责任人Id（多个责任人用小写分号隔开）
        :type InchargeIds: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._Incharge = None
        self._TaskType = None
        self._ProjectId = None
        self._InchargeIds = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        """任务id
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Incharge(self):
        """责任人（多个责任人用小写分号隔开；离线任务传入的是账号名，实时任务传入的是账号id）
        :rtype: str
        """
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def TaskType(self):
        """任务类型
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InchargeIds(self):
        """责任人Id（多个责任人用小写分号隔开）
        :rtype: str
        """
        return self._InchargeIds

    @InchargeIds.setter
    def InchargeIds(self, InchargeIds):
        self._InchargeIds = InchargeIds

    @property
    def TaskNames(self):
        """本次批量操作涉及任务，用于审计
        :rtype: list of str
        """
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._Incharge = params.get("Incharge")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._InchargeIds = params.get("InchargeIds")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchUpdateIntegrationTasksResponse(AbstractModel):
    """BatchUpdateIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        """操作成功的任务数
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """操作失败的任务数
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        """任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BytesSpeed(AbstractModel):
    """实时任务同步速度 字节/s

    """

    def __init__(self):
        r"""
        :param _NodeType: 节点类型
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _NodeName: 节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeName: str
        :param _Values: 速度值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of SpeedValue
        """
        self._NodeType = None
        self._NodeName = None
        self._Values = None

    @property
    def NodeType(self):
        """节点类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        """节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Values(self):
        """速度值列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SpeedValue
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SpeedValue()
                obj._deserialize(item)
                self._Values.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistRequest(AbstractModel):
    """CheckAlarmRegularNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目名称
        :type ProjectId: str
        :param _AlarmRegularName: 规则名称
        :type AlarmRegularName: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Id: 主键ID
        :type Id: str
        :param _TaskType: 任务类型:201.实时,202.离线
        :type TaskType: int
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._AlarmRegularName = None
        self._TaskId = None
        self._Id = None
        self._TaskType = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmRegularName(self):
        """规则名称
        :rtype: str
        """
        return self._AlarmRegularName

    @AlarmRegularName.setter
    def AlarmRegularName(self, AlarmRegularName):
        self._AlarmRegularName = AlarmRegularName

    @property
    def TaskId(self):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        self._TaskId = TaskId

    @property
    def Id(self):
        """主键ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskType(self):
        """任务类型:201.实时,202.离线
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def MonitorType(self):
        """监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :rtype: int
        """
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AlarmRegularName = params.get("AlarmRegularName")
        self._TaskId = params.get("TaskId")
        self._Id = params.get("Id")
        self._TaskType = params.get("TaskType")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistResponse(AbstractModel):
    """CheckAlarmRegularNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否重名
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否重名
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationNodeNameExistsRequest(AbstractModel):
    """CheckIntegrationNodeNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Name: 节点名称
        :type Name: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Id: 节点ID
        :type Id: int
        """
        self._TaskId = None
        self._Name = None
        self._ProjectId = None
        self._Id = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Name(self):
        """节点名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Id(self):
        """节点ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationNodeNameExistsResponse(AbstractModel):
    """CheckIntegrationNodeNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回true代表存在，返回false代表不存在
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """返回true代表存在，返回false代表不存在
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationTaskNameExistsRequest(AbstractModel):
    """CheckIntegrationTaskNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _SyncType: 同步类型1.单表同步，2.解决方案
        :type SyncType: int
        """
        self._TaskName = None
        self._ProjectId = None
        self._TaskId = None
        self._SyncType = None

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SyncType(self):
        """同步类型1.单表同步，2.解决方案
        :rtype: int
        """
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._SyncType = params.get("SyncType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationTaskNameExistsResponse(AbstractModel):
    """CheckIntegrationTaskNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true表示存在，false表示不存在
        :type Data: bool
        :param _ExistsType: 任务名重复类型（0:未重复, 1:开发态重复, 2:生产态重复）
        :type ExistsType: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._ExistsType = None
        self._RequestId = None

    @property
    def Data(self):
        """true表示存在，false表示不存在
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def ExistsType(self):
        """任务名重复类型（0:未重复, 1:开发态重复, 2:生产态重复）
        :rtype: int
        """
        return self._ExistsType

    @ExistsType.setter
    def ExistsType(self, ExistsType):
        self._ExistsType = ExistsType

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._ExistsType = params.get("ExistsType")
        self._RequestId = params.get("RequestId")


class CheckTaskNameExistRequest(AbstractModel):
    """CheckTaskNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id/工作空间id
        :type ProjectId: str
        :param _TypeId: 任务类型（跟调度传参保持一致27）
        :type TypeId: int
        :param _TaskName: 任务名
        :type TaskName: str
        """
        self._ProjectId = None
        self._TypeId = None
        self._TaskName = None

    @property
    def ProjectId(self):
        """项目id/工作空间id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TypeId(self):
        """任务类型（跟调度传参保持一致27）
        :rtype: int
        """
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskName(self):
        """任务名
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TypeId = params.get("TypeId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckTaskNameExistResponse(AbstractModel):
    """CheckTaskNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CollectionFolderOpsDto(AbstractModel):
    """文件夹列表

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPage: 总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _PageCount: 当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _PageNumber: 页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Items: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of FolderOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        """总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        """当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        """页码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        """任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FolderOpsDto
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = FolderOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CollectionInstanceOpsDto(AbstractModel):
    """实例列表结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPage: 总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _PageCount: 当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _PageNumber: 页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Items: 实例信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of InstanceOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        """总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        """当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        """页码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        """实例信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceOpsDto
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnAggregationLineage(AbstractModel):
    """列血缘聚合信息

    """

    def __init__(self):
        r"""
        :param _TableName: 表名
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _ParentId: 父节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: str
        :param _MetastoreType: 元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _ParentSet: 字符串类型的父节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentSet: str
        :param _ChildSet: 字符串类型的子节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ChildSet: str
        :param _ColumnInfoSet: 列信息集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnInfoSet: list of SimpleColumnInfo
        """
        self._TableName = None
        self._ParentId = None
        self._MetastoreType = None
        self._ParentSet = None
        self._ChildSet = None
        self._ColumnInfoSet = None

    @property
    def TableName(self):
        """表名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ParentId(self):
        """父节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        """元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def ParentSet(self):
        """字符串类型的父节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        """字符串类型的子节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ColumnInfoSet(self):
        """列信息集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SimpleColumnInfo
        """
        return self._ColumnInfoSet

    @ColumnInfoSet.setter
    def ColumnInfoSet(self, ColumnInfoSet):
        self._ColumnInfoSet = ColumnInfoSet


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ColumnInfoSet") is not None:
            self._ColumnInfoSet = []
            for item in params.get("ColumnInfoSet"):
                obj = SimpleColumnInfo()
                obj._deserialize(item)
                self._ColumnInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnBasicInfo(AbstractModel):
    """表的元数据信息

    """

    def __init__(self):
        r"""
        :param _TableId: 表的全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _DatasourceId: 数据源全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceName: 数据源名
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatabaseId: 数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatabaseName: 数据库名
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _TableName: 表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _ColumnName: 字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnName: str
        :param _DataType: 数据类型,string/int等
注意：此字段可能返回 null，表示取不到有效值。
        :type DataType: str
        :param _ColumnType: 字段类型, varchar(32)/int(10)等
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnType: str
        :param _ColumnDefault: 字段默认值
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnDefault: str
        :param _ColumnKey: 索引类型, PRI/MUL/PARTITION等,普通字段该值为空串
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnKey: str
        :param _ColumnPosition: 字段顺序标识
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnPosition: int
        :param _ColumnComment: 字段注释
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnComment: str
        :param _StoreType: 数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type StoreType: str
        :param _ProjectId: 所属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _ProjectName: 所属项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _ProjectDisplayName: 所属项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectDisplayName: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _Scale: 精度
注意：此字段可能返回 null，表示取不到有效值。
        :type Scale: int
        """
        self._TableId = None
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._TableName = None
        self._ColumnName = None
        self._DataType = None
        self._ColumnType = None
        self._ColumnDefault = None
        self._ColumnKey = None
        self._ColumnPosition = None
        self._ColumnComment = None
        self._StoreType = None
        self._ProjectId = None
        self._ProjectName = None
        self._ProjectDisplayName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Scale = None

    @property
    def TableId(self):
        """表的全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def DatasourceId(self):
        """数据源全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        """数据源名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatabaseId(self):
        """数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        """数据库名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        """表名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ColumnName(self):
        """字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def DataType(self):
        """数据类型,string/int等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def ColumnType(self):
        """字段类型, varchar(32)/int(10)等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def ColumnDefault(self):
        """字段默认值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnDefault

    @ColumnDefault.setter
    def ColumnDefault(self, ColumnDefault):
        self._ColumnDefault = ColumnDefault

    @property
    def ColumnKey(self):
        """索引类型, PRI/MUL/PARTITION等,普通字段该值为空串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnKey

    @ColumnKey.setter
    def ColumnKey(self, ColumnKey):
        self._ColumnKey = ColumnKey

    @property
    def ColumnPosition(self):
        """字段顺序标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ColumnPosition

    @ColumnPosition.setter
    def ColumnPosition(self, ColumnPosition):
        self._ColumnPosition = ColumnPosition

    @property
    def ColumnComment(self):
        """字段注释
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnComment

    @ColumnComment.setter
    def ColumnComment(self, ColumnComment):
        self._ColumnComment = ColumnComment

    @property
    def StoreType(self):
        """数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StoreType

    @StoreType.setter
    def StoreType(self, StoreType):
        self._StoreType = StoreType

    @property
    def ProjectId(self):
        """所属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        """所属项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDisplayName(self):
        """所属项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Scale(self):
        """精度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._ColumnName = params.get("ColumnName")
        self._DataType = params.get("DataType")
        self._ColumnType = params.get("ColumnType")
        self._ColumnDefault = params.get("ColumnDefault")
        self._ColumnKey = params.get("ColumnKey")
        self._ColumnPosition = params.get("ColumnPosition")
        self._ColumnComment = params.get("ColumnComment")
        self._StoreType = params.get("StoreType")
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Scale = params.get("Scale")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnData(AbstractModel):
    """ColumnItem

    """

    def __init__(self):
        r"""
        :param _EventName: ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :type EventName: str
        :param _EventProjectName: ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :type EventProjectName: str
        :param _Type: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _CurRunDate: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type CurRunDate: str
        :param _TaskId: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _State: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type State: str
        :param _EventType: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type EventType: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _ProjectName: 项目名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _ProjectId: 项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        """
        self._EventName = None
        self._EventProjectName = None
        self._Type = None
        self._CurRunDate = None
        self._TaskId = None
        self._State = None
        self._EventType = None
        self._TaskName = None
        self._ProjectName = None
        self._ProjectId = None

    @property
    def EventName(self):
        """ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventProjectName(self):
        """ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventProjectName

    @EventProjectName.setter
    def EventProjectName(self, EventProjectName):
        self._EventProjectName = EventProjectName

    @property
    def Type(self):
        """1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CurRunDate(self):
        """1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def TaskId(self):
        """1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def State(self):
        """1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def EventType(self):
        """1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def TaskName(self):
        """任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectName(self):
        """项目名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectId(self):
        """项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._EventProjectName = params.get("EventProjectName")
        self._Type = params.get("Type")
        self._CurRunDate = params.get("CurRunDate")
        self._TaskId = params.get("TaskId")
        self._State = params.get("State")
        self._EventType = params.get("EventType")
        self._TaskName = params.get("TaskName")
        self._ProjectName = params.get("ProjectName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnItem(AbstractModel):
    """ColumnItem

    """

    def __init__(self):
        r"""
        :param _ColumnName: ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnName: str
        :param _ColumnRef: ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnRef: str
        """
        self._ColumnName = None
        self._ColumnRef = None

    @property
    def ColumnName(self):
        """ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def ColumnRef(self):
        """ColumnName1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnRef

    @ColumnRef.setter
    def ColumnRef(self, ColumnRef):
        self._ColumnRef = ColumnRef


    def _deserialize(self, params):
        self._ColumnName = params.get("ColumnName")
        self._ColumnRef = params.get("ColumnRef")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnLineageInfo(AbstractModel):
    """血缘字段信息

    """

    def __init__(self):
        r"""
        :param _Id: 血缘id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _ColumnName: 字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnName: str
        :param _ColumnNameCn: 字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnNameCn: str
        :param _ColumnType: 字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnType: str
        :param _RelationParams: 关系参数
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationParams: str
        :param _Params: 参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _ParentId: 父id
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: str
        :param _MetastoreType: 元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _MetastoreTypeName: 元数据类型名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreTypeName: str
        :param _TableName: 表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _QualifiedName: 字段全名称
注意：此字段可能返回 null，表示取不到有效值。
        :type QualifiedName: str
        :param _DownStreamCount: 下游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type DownStreamCount: int
        :param _UpStreamCount: 上游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type UpStreamCount: int
        :param _Description: 描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _PrefixPath: 由中心节点出发的路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PrefixPath: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ModifyTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _Tasks: 任务id列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: list of str
        :param _ParentSet: 父节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentSet: str
        :param _ChildSet: 子节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ChildSet: str
        :param _ExtParams: 额外参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtParams: list of LineageParamRecord
        :param _TableId: 表ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        """
        self._Id = None
        self._DatasourceId = None
        self._ColumnName = None
        self._ColumnNameCn = None
        self._ColumnType = None
        self._RelationParams = None
        self._Params = None
        self._ParentId = None
        self._MetastoreType = None
        self._MetastoreTypeName = None
        self._TableName = None
        self._QualifiedName = None
        self._DownStreamCount = None
        self._UpStreamCount = None
        self._Description = None
        self._PrefixPath = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Tasks = None
        self._ParentSet = None
        self._ChildSet = None
        self._ExtParams = None
        self._TableId = None

    @property
    def Id(self):
        """血缘id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def DatasourceId(self):
        """数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ColumnName(self):
        """字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def ColumnNameCn(self):
        """字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnNameCn

    @ColumnNameCn.setter
    def ColumnNameCn(self, ColumnNameCn):
        self._ColumnNameCn = ColumnNameCn

    @property
    def ColumnType(self):
        """字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def RelationParams(self):
        """关系参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelationParams

    @RelationParams.setter
    def RelationParams(self, RelationParams):
        self._RelationParams = RelationParams

    @property
    def Params(self):
        """参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def ParentId(self):
        """父id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        """元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def MetastoreTypeName(self):
        """元数据类型名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetastoreTypeName

    @MetastoreTypeName.setter
    def MetastoreTypeName(self, MetastoreTypeName):
        self._MetastoreTypeName = MetastoreTypeName

    @property
    def TableName(self):
        """表名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def QualifiedName(self):
        """字段全名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._QualifiedName

    @QualifiedName.setter
    def QualifiedName(self, QualifiedName):
        self._QualifiedName = QualifiedName

    @property
    def DownStreamCount(self):
        """下游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DownStreamCount

    @DownStreamCount.setter
    def DownStreamCount(self, DownStreamCount):
        self._DownStreamCount = DownStreamCount

    @property
    def UpStreamCount(self):
        """上游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpStreamCount

    @UpStreamCount.setter
    def UpStreamCount(self, UpStreamCount):
        self._UpStreamCount = UpStreamCount

    @property
    def Description(self):
        """描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PrefixPath(self):
        """由中心节点出发的路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PrefixPath

    @PrefixPath.setter
    def PrefixPath(self, PrefixPath):
        self._PrefixPath = PrefixPath

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Tasks(self):
        """任务id列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ParentSet(self):
        """父节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        """子节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ExtParams(self):
        """额外参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of LineageParamRecord
        """
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def TableId(self):
        """表ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._DatasourceId = params.get("DatasourceId")
        self._ColumnName = params.get("ColumnName")
        self._ColumnNameCn = params.get("ColumnNameCn")
        self._ColumnType = params.get("ColumnType")
        self._RelationParams = params.get("RelationParams")
        self._Params = params.get("Params")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._MetastoreTypeName = params.get("MetastoreTypeName")
        self._TableName = params.get("TableName")
        self._QualifiedName = params.get("QualifiedName")
        self._DownStreamCount = params.get("DownStreamCount")
        self._UpStreamCount = params.get("UpStreamCount")
        self._Description = params.get("Description")
        self._PrefixPath = params.get("PrefixPath")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Tasks = params.get("Tasks")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnMeta(AbstractModel):
    """列的元数据

    """

    def __init__(self):
        r"""
        :param _NameEn: 字段英文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NameEn: str
        :param _NameCn: 字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NameCn: str
        :param _Type: 字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Description: 字段描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Position: 字段序号
注意：此字段可能返回 null，表示取不到有效值。
        :type Position: int
        :param _IsPartition: 是否为分区字段
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPartition: bool
        :param _Name: 字段名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _ColumnFamiliesFieldSet: HBase列簇属性集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnFamiliesFieldSet: list of Pair
        :param _DictionaryId: 对应码表字典ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DictionaryId: str
        :param _DictionaryName: 对应码表字典名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DictionaryName: str
        :param _LevelName: 安全等级：名称
注意：此字段可能返回 null，表示取不到有效值。
        :type LevelName: str
        :param _LevelRank: 安全等级：值范围1-10
注意：此字段可能返回 null，表示取不到有效值。
        :type LevelRank: int
        :param _InfluxCategory: influxdb字段类别
注意：此字段可能返回 null，表示取不到有效值。
        :type InfluxCategory: str
        """
        self._NameEn = None
        self._NameCn = None
        self._Type = None
        self._Description = None
        self._Position = None
        self._IsPartition = None
        self._Name = None
        self._ColumnFamiliesFieldSet = None
        self._DictionaryId = None
        self._DictionaryName = None
        self._LevelName = None
        self._LevelRank = None
        self._InfluxCategory = None

    @property
    def NameEn(self):
        """字段英文名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NameEn

    @NameEn.setter
    def NameEn(self, NameEn):
        self._NameEn = NameEn

    @property
    def NameCn(self):
        """字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NameCn

    @NameCn.setter
    def NameCn(self, NameCn):
        self._NameCn = NameCn

    @property
    def Type(self):
        """字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Description(self):
        """字段描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Position(self):
        """字段序号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def IsPartition(self):
        """是否为分区字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition

    @property
    def Name(self):
        """字段名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ColumnFamiliesFieldSet(self):
        """HBase列簇属性集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Pair
        """
        return self._ColumnFamiliesFieldSet

    @ColumnFamiliesFieldSet.setter
    def ColumnFamiliesFieldSet(self, ColumnFamiliesFieldSet):
        self._ColumnFamiliesFieldSet = ColumnFamiliesFieldSet

    @property
    def DictionaryId(self):
        """对应码表字典ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DictionaryId

    @DictionaryId.setter
    def DictionaryId(self, DictionaryId):
        self._DictionaryId = DictionaryId

    @property
    def DictionaryName(self):
        """对应码表字典名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DictionaryName

    @DictionaryName.setter
    def DictionaryName(self, DictionaryName):
        self._DictionaryName = DictionaryName

    @property
    def LevelName(self):
        """安全等级：名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LevelName

    @LevelName.setter
    def LevelName(self, LevelName):
        self._LevelName = LevelName

    @property
    def LevelRank(self):
        """安全等级：值范围1-10
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LevelRank

    @LevelRank.setter
    def LevelRank(self, LevelRank):
        self._LevelRank = LevelRank

    @property
    def InfluxCategory(self):
        """influxdb字段类别
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InfluxCategory

    @InfluxCategory.setter
    def InfluxCategory(self, InfluxCategory):
        self._InfluxCategory = InfluxCategory


    def _deserialize(self, params):
        self._NameEn = params.get("NameEn")
        self._NameCn = params.get("NameCn")
        self._Type = params.get("Type")
        self._Description = params.get("Description")
        self._Position = params.get("Position")
        self._IsPartition = params.get("IsPartition")
        self._Name = params.get("Name")
        if params.get("ColumnFamiliesFieldSet") is not None:
            self._ColumnFamiliesFieldSet = []
            for item in params.get("ColumnFamiliesFieldSet"):
                obj = Pair()
                obj._deserialize(item)
                self._ColumnFamiliesFieldSet.append(obj)
        self._DictionaryId = params.get("DictionaryId")
        self._DictionaryName = params.get("DictionaryName")
        self._LevelName = params.get("LevelName")
        self._LevelRank = params.get("LevelRank")
        self._InfluxCategory = params.get("InfluxCategory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskRequest(AbstractModel):
    """CommitIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CommitType: 0.仅提交，1.立即启动，2.停止线上作业，丢弃作业状态数据，重新启动运行，3.暂停线上作业，保留作业状态数据，继续运行，4.保留作业状态数据，继续运行
        :type CommitType: int
        :param _TaskType: 实时任务 201   离线任务 202  默认实时任务
        :type TaskType: int
        :param _ExtConfig: 额外参数
        :type ExtConfig: list of RecordField
        :param _VersionDesc: 提交版本描述
        :type VersionDesc: str
        :param _InstanceVersion: 提交版本号
        :type InstanceVersion: int
        :param _EventDesc: 前端操作类型描述
        :type EventDesc: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._CommitType = None
        self._TaskType = None
        self._ExtConfig = None
        self._VersionDesc = None
        self._InstanceVersion = None
        self._EventDesc = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CommitType(self):
        """0.仅提交，1.立即启动，2.停止线上作业，丢弃作业状态数据，重新启动运行，3.暂停线上作业，保留作业状态数据，继续运行，4.保留作业状态数据，继续运行
        :rtype: int
        """
        return self._CommitType

    @CommitType.setter
    def CommitType(self, CommitType):
        self._CommitType = CommitType

    @property
    def TaskType(self):
        """实时任务 201   离线任务 202  默认实时任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ExtConfig(self):
        """额外参数
        :rtype: list of RecordField
        """
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def VersionDesc(self):
        """提交版本描述
        :rtype: str
        """
        return self._VersionDesc

    @VersionDesc.setter
    def VersionDesc(self, VersionDesc):
        self._VersionDesc = VersionDesc

    @property
    def InstanceVersion(self):
        """提交版本号
        :rtype: int
        """
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion

    @property
    def EventDesc(self):
        """前端操作类型描述
        :rtype: str
        """
        return self._EventDesc

    @EventDesc.setter
    def EventDesc(self, EventDesc):
        self._EventDesc = EventDesc


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._CommitType = params.get("CommitType")
        self._TaskType = params.get("TaskType")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        self._VersionDesc = params.get("VersionDesc")
        self._InstanceVersion = params.get("InstanceVersion")
        self._EventDesc = params.get("EventDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskResponse(AbstractModel):
    """CommitIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """操作成功与否标识
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupTaskRequest(AbstractModel):
    """CommitRuleGroupTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _TriggerType: 触发类型 1.手动触发 2.调度事中触发 3.周期调度触发
        :type TriggerType: int
        :param _ExecRuleConfig: 规则配置列表
        :type ExecRuleConfig: list of RuleConfig
        :param _ExecConfig: 执行配置
        :type ExecConfig: :class:`tencentcloud.wedata.v20210820.models.RuleExecConfig`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._RuleGroupId = None
        self._TriggerType = None
        self._ExecRuleConfig = None
        self._ExecConfig = None
        self._ProjectId = None
        self._EngineType = None

    @property
    def RuleGroupId(self):
        """规则组ID
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TriggerType(self):
        """触发类型 1.手动触发 2.调度事中触发 3.周期调度触发
        :rtype: int
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def ExecRuleConfig(self):
        """规则配置列表
        :rtype: list of RuleConfig
        """
        return self._ExecRuleConfig

    @ExecRuleConfig.setter
    def ExecRuleConfig(self, ExecRuleConfig):
        self._ExecRuleConfig = ExecRuleConfig

    @property
    def ExecConfig(self):
        """执行配置
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleExecConfig`
        """
        return self._ExecConfig

    @ExecConfig.setter
    def ExecConfig(self, ExecConfig):
        self._ExecConfig = ExecConfig

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EngineType(self):
        """该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._TriggerType = params.get("TriggerType")
        if params.get("ExecRuleConfig") is not None:
            self._ExecRuleConfig = []
            for item in params.get("ExecRuleConfig"):
                obj = RuleConfig()
                obj._deserialize(item)
                self._ExecRuleConfig.append(obj)
        if params.get("ExecConfig") is not None:
            self._ExecConfig = RuleExecConfig()
            self._ExecConfig._deserialize(params.get("ExecConfig"))
        self._ProjectId = params.get("ProjectId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupTaskResponse(AbstractModel):
    """CommitRuleGroupTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则组执行id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResult`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CommonContent(AbstractModel):
    """内容详情

    """

    def __init__(self):
        r"""
        :param _Content: 详情内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        """详情内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonId(AbstractModel):
    """Id包装对象

    """

    def __init__(self):
        r"""
        :param _Id: Id值
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """Id值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonIdOpsDto(AbstractModel):
    """返回命令id

    """

    def __init__(self):
        r"""
        :param _Id: 返回补录计划id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """返回补录计划id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResult(AbstractModel):
    """质量检查对比结果

    """

    def __init__(self):
        r"""
        :param _Items: 对比结果项列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareResultItem
        :param _TotalRows: 检测总行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalRows: int
        :param _PassRows: 检测通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type PassRows: int
        :param _TriggerRows: 检测不通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerRows: int
        """
        self._Items = None
        self._TotalRows = None
        self._PassRows = None
        self._TriggerRows = None

    @property
    def Items(self):
        """对比结果项列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CompareResultItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalRows(self):
        """检测总行数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalRows

    @TotalRows.setter
    def TotalRows(self, TotalRows):
        self._TotalRows = TotalRows

    @property
    def PassRows(self):
        """检测通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PassRows

    @PassRows.setter
    def PassRows(self, PassRows):
        self._PassRows = PassRows

    @property
    def TriggerRows(self):
        """检测不通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TriggerRows

    @TriggerRows.setter
    def TriggerRows(self, TriggerRows):
        self._TriggerRows = TriggerRows


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareResultItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalRows = params.get("TotalRows")
        self._PassRows = params.get("PassRows")
        self._TriggerRows = params.get("TriggerRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResultItem(AbstractModel):
    """对比结果项

    """

    def __init__(self):
        r"""
        :param _FixResult: 对比结果， 1为真 2为假
注意：此字段可能返回 null，表示取不到有效值。
        :type FixResult: int
        :param _ResultValue: 质量sql执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :type ResultValue: str
        :param _Values: 阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of ThresholdValue
        :param _Operator: 比较操作类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _CompareType: 比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _ValueComputeType: 值比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        """
        self._FixResult = None
        self._ResultValue = None
        self._Values = None
        self._Operator = None
        self._CompareType = None
        self._ValueComputeType = None

    @property
    def FixResult(self):
        """对比结果， 1为真 2为假
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FixResult

    @FixResult.setter
    def FixResult(self, FixResult):
        self._FixResult = FixResult

    @property
    def ResultValue(self):
        """质量sql执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResultValue

    @ResultValue.setter
    def ResultValue(self, ResultValue):
        self._ResultValue = ResultValue

    @property
    def Values(self):
        """阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ThresholdValue
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Operator(self):
        """比较操作类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CompareType(self):
        """比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def ValueComputeType(self):
        """值比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType


    def _deserialize(self, params):
        self._FixResult = params.get("FixResult")
        self._ResultValue = params.get("ResultValue")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._Values.append(obj)
        self._Operator = params.get("Operator")
        self._CompareType = params.get("CompareType")
        self._ValueComputeType = params.get("ValueComputeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRule(AbstractModel):
    """对比规则

    """

    def __init__(self):
        r"""
        :param _Items: 比较条件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareRuleItem
        :param _CycleStep: 周期性模板默认周期，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleStep: int
        :param _ComputeExpression: o 表示 或，a 表示 且，数字表示items下标
注意：此字段可能返回 null，表示取不到有效值。
        :type ComputeExpression: str
        """
        self._Items = None
        self._CycleStep = None
        self._ComputeExpression = None

    @property
    def Items(self):
        """比较条件列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CompareRuleItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def CycleStep(self):
        """周期性模板默认周期，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def ComputeExpression(self):
        """o 表示 或，a 表示 且，数字表示items下标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ComputeExpression

    @ComputeExpression.setter
    def ComputeExpression(self, ComputeExpression):
        self._ComputeExpression = ComputeExpression


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareRuleItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._CycleStep = params.get("CycleStep")
        self._ComputeExpression = params.get("ComputeExpression")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRuleItem(AbstractModel):
    """比较条件

    """

    def __init__(self):
        r"""
        :param _CompareType: 比较类型 1.固定值  2.波动值  3.数值范围比较  4.枚举范围比较  5.不用比较
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _Operator: 比较操作类型
<  <=  ==  =>  > !=
IRLCRO:在区间内(左闭右开)
IRLORC:在区间内(左开右闭)
IRLCRC:在区间内(左闭右闭)
IRLORO:在区间内(左开右开)
NRLCRO:不在区间内(左闭右开)
NRLORC:不在区间内(左开右闭)
NRLCRC:不在区间内(左闭右闭)
NRLORO:不在区间内(左开右开)
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _ValueComputeType: 质量统计值类型 1.绝对值  2.上升 3. 下降  4._C包含   5. N_C不包含
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        :param _ValueList: 比较阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueList: list of ThresholdValue
        """
        self._CompareType = None
        self._Operator = None
        self._ValueComputeType = None
        self._ValueList = None

    @property
    def CompareType(self):
        """比较类型 1.固定值  2.波动值  3.数值范围比较  4.枚举范围比较  5.不用比较
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def Operator(self):
        """比较操作类型
<  <=  ==  =>  > !=
IRLCRO:在区间内(左闭右开)
IRLORC:在区间内(左开右闭)
IRLCRC:在区间内(左闭右闭)
IRLORO:在区间内(左开右开)
NRLCRO:不在区间内(左闭右开)
NRLORC:不在区间内(左开右闭)
NRLCRC:不在区间内(左闭右闭)
NRLORO:不在区间内(左开右开)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def ValueComputeType(self):
        """质量统计值类型 1.绝对值  2.上升 3. 下降  4._C包含   5. N_C不包含
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType

    @property
    def ValueList(self):
        """比较阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ThresholdValue
        """
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._CompareType = params.get("CompareType")
        self._Operator = params.get("Operator")
        self._ValueComputeType = params.get("ValueComputeType")
        if params.get("ValueList") is not None:
            self._ValueList = []
            for item in params.get("ValueList"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._ValueList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Content(AbstractModel):
    """Content

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _Diagnose: 诊断
注意：此字段可能返回 null，表示取不到有效值。
        :type Diagnose: str
        :param _Reason: 理由
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _Operation: 操作
注意：此字段可能返回 null，表示取不到有效值。
        :type Operation: str
        :param _Url: 链接
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Diagnose = None
        self._Reason = None
        self._Operation = None
        self._Url = None

    @property
    def TaskId(self):
        """任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Diagnose(self):
        """诊断
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Diagnose

    @Diagnose.setter
    def Diagnose(self, Diagnose):
        self._Diagnose = Diagnose

    @property
    def Reason(self):
        """理由
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Operation(self):
        """操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def Url(self):
        """链接
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Diagnose = params.get("Diagnose")
        self._Reason = params.get("Reason")
        self._Operation = params.get("Operation")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosTokenResponse(AbstractModel):
    """cos token信息

    """

    def __init__(self):
        r"""
        :param _Id: token id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Token: token内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Token: str
        :param _SecretId: 密钥id
注意：此字段可能返回 null，表示取不到有效值。
        :type SecretId: str
        :param _SecretKey: 密钥内容
注意：此字段可能返回 null，表示取不到有效值。
        :type SecretKey: str
        :param _Response: 响应
注意：此字段可能返回 null，表示取不到有效值。
        :type Response: str
        :param _OwnerUin: 用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _ExpiredTime: 过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpiredTime: int
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        :param _OperatorUin: 操作者uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUin: str
        """
        self._Id = None
        self._Token = None
        self._SecretId = None
        self._SecretKey = None
        self._Response = None
        self._OwnerUin = None
        self._ExpiredTime = None
        self._CreateTime = None
        self._UpdateTime = None
        self._OperatorUin = None

    @property
    def Id(self):
        """token id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Token(self):
        """token内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def SecretId(self):
        """密钥id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SecretId

    @SecretId.setter
    def SecretId(self, SecretId):
        self._SecretId = SecretId

    @property
    def SecretKey(self):
        """密钥内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Response(self):
        """响应
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Response

    @Response.setter
    def Response(self, Response):
        self._Response = Response

    @property
    def OwnerUin(self):
        """用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def ExpiredTime(self):
        """过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def OperatorUin(self):
        """操作者uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OperatorUin

    @OperatorUin.setter
    def OperatorUin(self, OperatorUin):
        self._OperatorUin = OperatorUin


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Token = params.get("Token")
        self._SecretId = params.get("SecretId")
        self._SecretKey = params.get("SecretKey")
        self._Response = params.get("Response")
        self._OwnerUin = params.get("OwnerUin")
        self._ExpiredTime = params.get("ExpiredTime")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._OperatorUin = params.get("OperatorUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateRequest(AbstractModel):
    """CountOpsInstanceState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateResponse(AbstractModel):
    """CountOpsInstanceState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务对应实例的状态统计
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceCountDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务对应实例的状态统计
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceCountDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInstanceCountDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateAndDDLSupport(AbstractModel):
    """是否支持creat 或ddl

    """

    def __init__(self):
        r"""
        :param _SupportSelect: 是否支持select
注意：此字段可能返回 null，表示取不到有效值。
        :type SupportSelect: bool
        :param _SupportDdl: 是否支持ddl
注意：此字段可能返回 null，表示取不到有效值。
        :type SupportDdl: bool
        """
        self._SupportSelect = None
        self._SupportDdl = None

    @property
    def SupportSelect(self):
        """是否支持select
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SupportSelect

    @SupportSelect.setter
    def SupportSelect(self, SupportSelect):
        self._SupportSelect = SupportSelect

    @property
    def SupportDdl(self):
        """是否支持ddl
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SupportDdl

    @SupportDdl.setter
    def SupportDdl(self, SupportDdl):
        self._SupportDdl = SupportDdl


    def _deserialize(self, params):
        self._SupportSelect = params.get("SupportSelect")
        self._SupportDdl = params.get("SupportDdl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionRequest(AbstractModel):
    """CreateCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 枚举值：HIVE、SPARK、DLC
        :type Type: str
        :param _Kind: 枚举值：ANALYSIS(函数)、ENCRYPTION(加密函数)、AGGREGATE(聚合函数)、LOGIC(逻辑函数)、DATE_AND_TIME(日期与时间函数)、MATH(数学函数)、CONVERSION(转换函数)、STRING(字符串函数)、IP_AND_DOMAIN(IP和域名函数)、WINDOW(窗口函数)、OTHER(其他函数)
        :type Kind: str
        :param _Name: 函数名称
        :type Name: str
        :param _ClusterIdentifier: 集群实例引擎 ID
        :type ClusterIdentifier: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _FunctionResourceFileType: 函数资源文件类型
        :type FunctionResourceFileType: str
        """
        self._Type = None
        self._Kind = None
        self._Name = None
        self._ClusterIdentifier = None
        self._DbName = None
        self._ProjectId = None
        self._FunctionResourceFileType = None

    @property
    def Type(self):
        """枚举值：HIVE、SPARK、DLC
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        """枚举值：ANALYSIS(函数)、ENCRYPTION(加密函数)、AGGREGATE(聚合函数)、LOGIC(逻辑函数)、DATE_AND_TIME(日期与时间函数)、MATH(数学函数)、CONVERSION(转换函数)、STRING(字符串函数)、IP_AND_DOMAIN(IP和域名函数)、WINDOW(窗口函数)、OTHER(其他函数)
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        """函数名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ClusterIdentifier(self):
        """集群实例引擎 ID
        :rtype: str
        """
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def DbName(self):
        """数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FunctionResourceFileType(self):
        """函数资源文件类型
        :rtype: str
        """
        return self._FunctionResourceFileType

    @FunctionResourceFileType.setter
    def FunctionResourceFileType(self, FunctionResourceFileType):
        self._FunctionResourceFileType = FunctionResourceFileType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._DbName = params.get("DbName")
        self._ProjectId = params.get("ProjectId")
        self._FunctionResourceFileType = params.get("FunctionResourceFileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionResponse(AbstractModel):
    """CreateCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        """函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class CreateDataModelRequest(AbstractModel):
    """CreateDataModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CloudappId: 云应用的实例id
        :type CloudappId: str
        :param _UserId: 用户的子账号id
        :type UserId: str
        :param _TimeUnit: Wedata数据建模购买参数，包年包月类型单位，年：y，月：m，默认m
        :type TimeUnit: str
        :param _TimeSpan: Wedata数据建模购买参数，购买时长，默认1
        :type TimeSpan: int
        :param _AutoRenewFlag: Wedata数据建模购买参数，是否自动续费，是：1，否：0，默认0
        :type AutoRenewFlag: int
        :param _DataModelVersion: Wedata数据建模购买参数，标准版：DATA_MODEL_STANDARD，企业版：DATA_MODEL_PRO，默认DATA_MODEL_STANDARD
        :type DataModelVersion: str
        """
        self._CloudappId = None
        self._UserId = None
        self._TimeUnit = None
        self._TimeSpan = None
        self._AutoRenewFlag = None
        self._DataModelVersion = None

    @property
    def CloudappId(self):
        """云应用的实例id
        :rtype: str
        """
        return self._CloudappId

    @CloudappId.setter
    def CloudappId(self, CloudappId):
        self._CloudappId = CloudappId

    @property
    def UserId(self):
        """用户的子账号id
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def TimeUnit(self):
        """Wedata数据建模购买参数，包年包月类型单位，年：y，月：m，默认m
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        """Wedata数据建模购买参数，购买时长，默认1
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def AutoRenewFlag(self):
        """Wedata数据建模购买参数，是否自动续费，是：1，否：0，默认0
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def DataModelVersion(self):
        """Wedata数据建模购买参数，标准版：DATA_MODEL_STANDARD，企业版：DATA_MODEL_PRO，默认DATA_MODEL_STANDARD
        :rtype: str
        """
        return self._DataModelVersion

    @DataModelVersion.setter
    def DataModelVersion(self, DataModelVersion):
        self._DataModelVersion = DataModelVersion


    def _deserialize(self, params):
        self._CloudappId = params.get("CloudappId")
        self._UserId = params.get("UserId")
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._DataModelVersion = params.get("DataModelVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataModelResponse(AbstractModel):
    """CreateDataModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: “Wedata数据建模”的实例id
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """“Wedata数据建模”的实例id
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateDataSourceRequest(AbstractModel):
    """CreateDataSource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
        :type Category: str
        :param _Type: 数据源类型:枚举值
        :type Type: str
        :param _OwnerProjectId: 归属项目ID
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目Name中文
        :type OwnerProjectIdent: str
        :param _BizParams: 业务侧数据源的配置信息扩展
        :type BizParams: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
        :type Params: str
        :param _Description: 数据源描述信息
        :type Description: str
        :param _Display: 数据源展示名，为了可视化查看
        :type Display: str
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
        :type DatabaseName: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
        :type Instance: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
        :type Status: int
        :param _ClusterId: 数据源所属的业务空间名称
        :type ClusterId: str
        :param _Collect: 是否采集
        :type Collect: str
        :param _COSBucket: cos桶信息
        :type COSBucket: str
        :param _COSRegion: cos region
        :type COSRegion: str
        :param _ConnectResult: 连接测试结果
        :type ConnectResult: str
        :param _DevelopmentParams: 开发环境数据源配置
        :type DevelopmentParams: str
        :param _ProjectId: 新建数据源的项目ID
        :type ProjectId: str
        """
        self._Name = None
        self._Category = None
        self._Type = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._BizParams = None
        self._Params = None
        self._Description = None
        self._Display = None
        self._DatabaseName = None
        self._Instance = None
        self._Status = None
        self._ClusterId = None
        self._Collect = None
        self._COSBucket = None
        self._COSRegion = None
        self._ConnectResult = None
        self._DevelopmentParams = None
        self._ProjectId = None

    @property
    def Name(self):
        """数据源名称，在相同SpaceName下，数据源名称不能为空
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        """数据源类别：绑定引擎、绑定数据库
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        """数据源类型:枚举值
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OwnerProjectId(self):
        """归属项目ID
        :rtype: str
        """
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        """归属项目Name
        :rtype: str
        """
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        """归属项目Name中文
        :rtype: str
        """
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def BizParams(self):
        """业务侧数据源的配置信息扩展
        :rtype: str
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Params(self):
        """数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
        :rtype: str
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Description(self):
        """数据源描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Display(self):
        """数据源展示名，为了可视化查看
        :rtype: str
        """
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def DatabaseName(self):
        """若数据源列表为绑定数据库，则为db名称
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Instance(self):
        """数据源引擎的实例ID，如CDB实例ID
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Status(self):
        """数据源数据源的可见性，1为可见、0为不可见。默认为1
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterId(self):
        """数据源所属的业务空间名称
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Collect(self):
        """是否采集
        :rtype: str
        """
        return self._Collect

    @Collect.setter
    def Collect(self, Collect):
        self._Collect = Collect

    @property
    def COSBucket(self):
        """cos桶信息
        :rtype: str
        """
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def COSRegion(self):
        """cos region
        :rtype: str
        """
        return self._COSRegion

    @COSRegion.setter
    def COSRegion(self, COSRegion):
        self._COSRegion = COSRegion

    @property
    def ConnectResult(self):
        """连接测试结果
        :rtype: str
        """
        return self._ConnectResult

    @ConnectResult.setter
    def ConnectResult(self, ConnectResult):
        self._ConnectResult = ConnectResult

    @property
    def DevelopmentParams(self):
        """开发环境数据源配置
        :rtype: str
        """
        return self._DevelopmentParams

    @DevelopmentParams.setter
    def DevelopmentParams(self, DevelopmentParams):
        self._DevelopmentParams = DevelopmentParams

    @property
    def ProjectId(self):
        """新建数据源的项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._BizParams = params.get("BizParams")
        self._Params = params.get("Params")
        self._Description = params.get("Description")
        self._Display = params.get("Display")
        self._DatabaseName = params.get("DatabaseName")
        self._Instance = params.get("Instance")
        self._Status = params.get("Status")
        self._ClusterId = params.get("ClusterId")
        self._Collect = params.get("Collect")
        self._COSBucket = params.get("COSBucket")
        self._COSRegion = params.get("COSRegion")
        self._ConnectResult = params.get("ConnectResult")
        self._DevelopmentParams = params.get("DevelopmentParams")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataSourceResponse(AbstractModel):
    """CreateDataSource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 主键ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """主键ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateDsFolderRequest(AbstractModel):
    """CreateDsFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        """文件夹名称
        :rtype: str
        """
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def ParentsFolderId(self):
        """父文件夹ID
        :rtype: str
        """
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDsFolderResponse(AbstractModel):
    """CreateDsFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateHiveTableByDDLRequest(AbstractModel):
    """CreateHiveTableByDDL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源ID
        :type DatasourceId: str
        :param _Database: 数据库
        :type Database: str
        :param _DDLSql: 建hive表ddl的base64编码
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Type: 目标表类型(HIVE或GBASE)
        :type Type: str
        :param _Incharge: 责任人
        :type Incharge: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _Async: 是否异步建表
        :type Async: bool
        :param _DataOptimizationResource: 数据优化使用的资源
        :type DataOptimizationResource: str
        :param _SmartOptimizerWritten: 是否开启数据优化
        :type SmartOptimizerWritten: str
        :param _TableName: 数据优化表名
        :type TableName: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Type = None
        self._Incharge = None
        self._SchemaName = None
        self._Async = None
        self._DataOptimizationResource = None
        self._SmartOptimizerWritten = None
        self._TableName = None

    @property
    def DatasourceId(self):
        """数据源ID
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        """数据库
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        """建hive表ddl的base64编码
        :rtype: str
        """
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        """表权限 ，默认为0:项目共享;1:仅个人与管理员
        :rtype: int
        """
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        """目标表类型(HIVE或GBASE)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Incharge(self):
        """责任人
        :rtype: str
        """
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def SchemaName(self):
        """schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Async(self):
        """是否异步建表
        :rtype: bool
        """
        return self._Async

    @Async.setter
    def Async(self, Async):
        self._Async = Async

    @property
    def DataOptimizationResource(self):
        """数据优化使用的资源
        :rtype: str
        """
        return self._DataOptimizationResource

    @DataOptimizationResource.setter
    def DataOptimizationResource(self, DataOptimizationResource):
        self._DataOptimizationResource = DataOptimizationResource

    @property
    def SmartOptimizerWritten(self):
        """是否开启数据优化
        :rtype: str
        """
        return self._SmartOptimizerWritten

    @SmartOptimizerWritten.setter
    def SmartOptimizerWritten(self, SmartOptimizerWritten):
        self._SmartOptimizerWritten = SmartOptimizerWritten

    @property
    def TableName(self):
        """数据优化表名
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._Incharge = params.get("Incharge")
        self._SchemaName = params.get("SchemaName")
        self._Async = params.get("Async")
        self._DataOptimizationResource = params.get("DataOptimizationResource")
        self._SmartOptimizerWritten = params.get("SmartOptimizerWritten")
        self._TableName = params.get("TableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableByDDLResponse(AbstractModel):
    """CreateHiveTableByDDL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回表名称，无论是否异步都有值
        :type Data: str
        :param _TaskId: 异步任务轮询 id，只有异步才有值
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Data(self):
        """返回表名称，无论是否异步都有值
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def TaskId(self):
        """异步任务轮询 id，只有异步才有值
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateHiveTableRequest(AbstractModel):
    """CreateHiveTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _Database: 数据库名称
        :type Database: str
        :param _DDLSql: base64转码之后的建表语句
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Incharge: 责任人
        :type Incharge: str
        :param _DataOptimizationResource: 数据优化引擎
        :type DataOptimizationResource: str
        :param _SmartOptimizerWritten: 是否开启数据优化
        :type SmartOptimizerWritten: str
        :param _TableName: 数据优化针对的表
        :type TableName: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Incharge = None
        self._DataOptimizationResource = None
        self._SmartOptimizerWritten = None
        self._TableName = None

    @property
    def DatasourceId(self):
        """数据源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        """数据库名称
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        """base64转码之后的建表语句
        :rtype: str
        """
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        """表权限 ，默认为0:项目共享;1:仅个人与管理员
        :rtype: int
        """
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Incharge(self):
        """责任人
        :rtype: str
        """
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def DataOptimizationResource(self):
        """数据优化引擎
        :rtype: str
        """
        return self._DataOptimizationResource

    @DataOptimizationResource.setter
    def DataOptimizationResource(self, DataOptimizationResource):
        self._DataOptimizationResource = DataOptimizationResource

    @property
    def SmartOptimizerWritten(self):
        """是否开启数据优化
        :rtype: str
        """
        return self._SmartOptimizerWritten

    @SmartOptimizerWritten.setter
    def SmartOptimizerWritten(self, SmartOptimizerWritten):
        self._SmartOptimizerWritten = SmartOptimizerWritten

    @property
    def TableName(self):
        """数据优化针对的表
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Incharge = params.get("Incharge")
        self._DataOptimizationResource = params.get("DataOptimizationResource")
        self._SmartOptimizerWritten = params.get("SmartOptimizerWritten")
        self._TableName = params.get("TableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableResponse(AbstractModel):
    """CreateHiveTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSuccess: 建表是否成功
        :type IsSuccess: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSuccess = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        """建表是否成功
        :rtype: bool
        """
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._RequestId = params.get("RequestId")


class CreateIntegrationNodeRequest(AbstractModel):
    """CreateIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 集成节点信息
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        """
        self._NodeInfo = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def NodeInfo(self):
        """集成节点信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        """
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationNodeResponse(AbstractModel):
    """CreateIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点
        :type Id: str
        :param _TaskId: 当前任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Id(self):
        """节点
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        """当前任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationTaskRequest(AbstractModel):
    """CreateIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskInfo = None
        self._ProjectId = None

    @property
    def TaskInfo(self):
        """任务信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationTaskResponse(AbstractModel):
    """CreateIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateMakeDatetimeInfo(AbstractModel):
    """补录计划日期范围

    """

    def __init__(self):
        r"""
        :param _StartDate: 开始日期
注意：此字段可能返回 null，表示取不到有效值。
        :type StartDate: str
        :param _EndDate: 结束日期
注意：此字段可能返回 null，表示取不到有效值。
        :type EndDate: str
        :param _StartTime: 开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        """
        self._StartDate = None
        self._EndDate = None
        self._StartTime = None
        self._EndTime = None

    @property
    def StartDate(self):
        """开始日期
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        """结束日期
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def StartTime(self):
        """开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskRequest(AbstractModel):
    """CreateOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _CycleStep: 间隔，可选，默认1。非空。默认 1
        :type CycleStep: int
        :param _DelayTime: 延时执行时间，单位分钟
        :type DelayTime: int
        :param _EndTime: 任务结束数据时间。非空。默认当前时间
        :type EndTime: str
        :param _Notes: 备注
        :type Notes: str
        :param _StartTime: 当前日期
        :type StartTime: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TypeId: 跟之前调用调度接口保持一致27
        :type TypeId: int
        :param _TaskAction: 时间指定，如月任务指定1，3号，则填入 1，3。非空。默认 "" 月任务：如具体1，3号则写 "1,3"，指定月末不可和具体号数一起输入，仅能为 "L"
        :type TaskAction: str
        :param _TaskMode: 区分画布和表单
        :type TaskMode: str
        :param _TaskImportInfo: 导入编排空间配置
        :type TaskImportInfo: :class:`tencentcloud.wedata.v20210820.models.TaskImportInfo`
        """
        self._ProjectId = None
        self._CycleStep = None
        self._DelayTime = None
        self._EndTime = None
        self._Notes = None
        self._StartTime = None
        self._TaskName = None
        self._TypeId = None
        self._TaskAction = None
        self._TaskMode = None
        self._TaskImportInfo = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleStep(self):
        """间隔，可选，默认1。非空。默认 1
        :rtype: int
        """
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def DelayTime(self):
        """延时执行时间，单位分钟
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def EndTime(self):
        """任务结束数据时间。非空。默认当前时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Notes(self):
        """备注
        :rtype: str
        """
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes

    @property
    def StartTime(self):
        """当前日期
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TypeId(self):
        """跟之前调用调度接口保持一致27
        :rtype: int
        """
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskAction(self):
        """时间指定，如月任务指定1，3号，则填入 1，3。非空。默认 "" 月任务：如具体1，3号则写 "1,3"，指定月末不可和具体号数一起输入，仅能为 "L"
        :rtype: str
        """
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def TaskMode(self):
        """区分画布和表单
        :rtype: str
        """
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode

    @property
    def TaskImportInfo(self):
        """导入编排空间配置
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskImportInfo`
        """
        return self._TaskImportInfo

    @TaskImportInfo.setter
    def TaskImportInfo(self, TaskImportInfo):
        self._TaskImportInfo = TaskImportInfo


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleStep = params.get("CycleStep")
        self._DelayTime = params.get("DelayTime")
        self._EndTime = params.get("EndTime")
        self._Notes = params.get("Notes")
        self._StartTime = params.get("StartTime")
        self._TaskName = params.get("TaskName")
        self._TypeId = params.get("TypeId")
        self._TaskAction = params.get("TaskAction")
        self._TaskMode = params.get("TaskMode")
        if params.get("TaskImportInfo") is not None:
            self._TaskImportInfo = TaskImportInfo()
            self._TaskImportInfo._deserialize(params.get("TaskImportInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskResponse(AbstractModel):
    """CreateOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _ArrangeSpaceTaskId: 导入到编排空间的任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type ArrangeSpaceTaskId: str
        :param _Data: 结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._ArrangeSpaceTaskId = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ArrangeSpaceTaskId(self):
        """导入到编排空间的任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ArrangeSpaceTaskId

    @ArrangeSpaceTaskId.setter
    def ArrangeSpaceTaskId(self, ArrangeSpaceTaskId):
        self._ArrangeSpaceTaskId = ArrangeSpaceTaskId

    @property
    def Data(self):
        """结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ArrangeSpaceTaskId = params.get("ArrangeSpaceTaskId")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateOpsMakePlanRequest(AbstractModel):
    """CreateOpsMakePlan请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _MakeName: 补录计划名称
        :type MakeName: str
        :param _TaskIdList: 补录任务集合
        :type TaskIdList: list of str
        :param _MakeDatetimeList: 补录计划日期范围
        :type MakeDatetimeList: list of CreateMakeDatetimeInfo
        :param _ProjectIdent: 项目标识
        :type ProjectIdent: str
        :param _CheckParent: 补录是否检查父任务状态，默认不检查。不推荐使用，后续会废弃，推荐使用 CheckParentType。
        :type CheckParent: bool
        :param _CheckParentType: 补录检查父任务类型。取值范围：
<li> NONE: 全部不检查 </li>
<li> ALL: 检查全部上游父任务 </li>
<li> MAKE_SCOPE: 只在（当前补录计划）选中任务中检查 </li>
        :type CheckParentType: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _SelfDependence: 已弃用。任务自依赖类型：parallel（并行），serial（无序串行），orderly（有序串行）
        :type SelfDependence: str
        :param _ParallelNum: 并行度
        :type ParallelNum: int
        :param _SameCycle: 补录实例生成周期是否和原周期相同，默认为true
        :type SameCycle: bool
        :param _TargetTaskCycle: 补录实例目标周期类型
        :type TargetTaskCycle: str
        :param _TargetTaskAction: 补录实例目标周期类型指定时间
        :type TargetTaskAction: int
        :param _MapParamList: 补录实例自定义参数
        :type MapParamList: list of StrToStrMap
        :param _CreatorId: 创建人id
        :type CreatorId: str
        :param _Creator: 创建人
        :type Creator: str
        :param _Remark: 补录计划说明
        :type Remark: str
        :param _SameSelfDependType: 是否使用任务原有自依赖配置，默认为true
        :type SameSelfDependType: bool
        :param _SourceTaskCycle: 补录实例原始周期类型
        :type SourceTaskCycle: str
        :param _SchedulerResourceGroup: 补录指定的调度资源组（ID） 为空则表示使用任务原有调度执行资源组
        :type SchedulerResourceGroup: str
        :param _IntegrationResourceGroup: 补录指定的集成资源组（ID） 为空则表示使用任务原有集成执行资源组
        :type IntegrationResourceGroup: str
        :param _SchedulerResourceGroupName: 补录指定的调度资源组名称 为空则表示使用任务原有调度执行资源组
        :type SchedulerResourceGroupName: str
        :param _IntegrationResourceGroupName: 补录指定的集成资源组名称 为空则表示使用任务原有集成执行资源组
        :type IntegrationResourceGroupName: str
        :param _MakeExtList: 补录扩展属性
        :type MakeExtList: list of StrToStrMap
        :param _SameSelfWorkflowDependType: 补录扩展属性
        :type SameSelfWorkflowDependType: bool
        :param _SelfWorkflowDependency: 补录扩展属性
        :type SelfWorkflowDependency: str
        """
        self._ProjectId = None
        self._MakeName = None
        self._TaskIdList = None
        self._MakeDatetimeList = None
        self._ProjectIdent = None
        self._CheckParent = None
        self._CheckParentType = None
        self._ProjectName = None
        self._SelfDependence = None
        self._ParallelNum = None
        self._SameCycle = None
        self._TargetTaskCycle = None
        self._TargetTaskAction = None
        self._MapParamList = None
        self._CreatorId = None
        self._Creator = None
        self._Remark = None
        self._SameSelfDependType = None
        self._SourceTaskCycle = None
        self._SchedulerResourceGroup = None
        self._IntegrationResourceGroup = None
        self._SchedulerResourceGroupName = None
        self._IntegrationResourceGroupName = None
        self._MakeExtList = None
        self._SameSelfWorkflowDependType = None
        self._SelfWorkflowDependency = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MakeName(self):
        """补录计划名称
        :rtype: str
        """
        return self._MakeName

    @MakeName.setter
    def MakeName(self, MakeName):
        self._MakeName = MakeName

    @property
    def TaskIdList(self):
        """补录任务集合
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def MakeDatetimeList(self):
        """补录计划日期范围
        :rtype: list of CreateMakeDatetimeInfo
        """
        return self._MakeDatetimeList

    @MakeDatetimeList.setter
    def MakeDatetimeList(self, MakeDatetimeList):
        self._MakeDatetimeList = MakeDatetimeList

    @property
    def ProjectIdent(self):
        """项目标识
        :rtype: str
        """
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def CheckParent(self):
        """补录是否检查父任务状态，默认不检查。不推荐使用，后续会废弃，推荐使用 CheckParentType。
        :rtype: bool
        """
        return self._CheckParent

    @CheckParent.setter
    def CheckParent(self, CheckParent):
        self._CheckParent = CheckParent

    @property
    def CheckParentType(self):
        """补录检查父任务类型。取值范围：
<li> NONE: 全部不检查 </li>
<li> ALL: 检查全部上游父任务 </li>
<li> MAKE_SCOPE: 只在（当前补录计划）选中任务中检查 </li>
        :rtype: str
        """
        return self._CheckParentType

    @CheckParentType.setter
    def CheckParentType(self, CheckParentType):
        self._CheckParentType = CheckParentType

    @property
    def ProjectName(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def SelfDependence(self):
        """已弃用。任务自依赖类型：parallel（并行），serial（无序串行），orderly（有序串行）
        :rtype: str
        """
        return self._SelfDependence

    @SelfDependence.setter
    def SelfDependence(self, SelfDependence):
        self._SelfDependence = SelfDependence

    @property
    def ParallelNum(self):
        """并行度
        :rtype: int
        """
        return self._ParallelNum

    @ParallelNum.setter
    def ParallelNum(self, ParallelNum):
        self._ParallelNum = ParallelNum

    @property
    def SameCycle(self):
        """补录实例生成周期是否和原周期相同，默认为true
        :rtype: bool
        """
        return self._SameCycle

    @SameCycle.setter
    def SameCycle(self, SameCycle):
        self._SameCycle = SameCycle

    @property
    def TargetTaskCycle(self):
        """补录实例目标周期类型
        :rtype: str
        """
        return self._TargetTaskCycle

    @TargetTaskCycle.setter
    def TargetTaskCycle(self, TargetTaskCycle):
        self._TargetTaskCycle = TargetTaskCycle

    @property
    def TargetTaskAction(self):
        """补录实例目标周期类型指定时间
        :rtype: int
        """
        return self._TargetTaskAction

    @TargetTaskAction.setter
    def TargetTaskAction(self, TargetTaskAction):
        self._TargetTaskAction = TargetTaskAction

    @property
    def MapParamList(self):
        """补录实例自定义参数
        :rtype: list of StrToStrMap
        """
        return self._MapParamList

    @MapParamList.setter
    def MapParamList(self, MapParamList):
        self._MapParamList = MapParamList

    @property
    def CreatorId(self):
        """创建人id
        :rtype: str
        """
        return self._CreatorId

    @CreatorId.setter
    def CreatorId(self, CreatorId):
        self._CreatorId = CreatorId

    @property
    def Creator(self):
        """创建人
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def Remark(self):
        """补录计划说明
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SameSelfDependType(self):
        """是否使用任务原有自依赖配置，默认为true
        :rtype: bool
        """
        return self._SameSelfDependType

    @SameSelfDependType.setter
    def SameSelfDependType(self, SameSelfDependType):
        self._SameSelfDependType = SameSelfDependType

    @property
    def SourceTaskCycle(self):
        """补录实例原始周期类型
        :rtype: str
        """
        return self._SourceTaskCycle

    @SourceTaskCycle.setter
    def SourceTaskCycle(self, SourceTaskCycle):
        self._SourceTaskCycle = SourceTaskCycle

    @property
    def SchedulerResourceGroup(self):
        """补录指定的调度资源组（ID） 为空则表示使用任务原有调度执行资源组
        :rtype: str
        """
        return self._SchedulerResourceGroup

    @SchedulerResourceGroup.setter
    def SchedulerResourceGroup(self, SchedulerResourceGroup):
        self._SchedulerResourceGroup = SchedulerResourceGroup

    @property
    def IntegrationResourceGroup(self):
        """补录指定的集成资源组（ID） 为空则表示使用任务原有集成执行资源组
        :rtype: str
        """
        return self._IntegrationResourceGroup

    @IntegrationResourceGroup.setter
    def IntegrationResourceGroup(self, IntegrationResourceGroup):
        self._IntegrationResourceGroup = IntegrationResourceGroup

    @property
    def SchedulerResourceGroupName(self):
        """补录指定的调度资源组名称 为空则表示使用任务原有调度执行资源组
        :rtype: str
        """
        return self._SchedulerResourceGroupName

    @SchedulerResourceGroupName.setter
    def SchedulerResourceGroupName(self, SchedulerResourceGroupName):
        self._SchedulerResourceGroupName = SchedulerResourceGroupName

    @property
    def IntegrationResourceGroupName(self):
        """补录指定的集成资源组名称 为空则表示使用任务原有集成执行资源组
        :rtype: str
        """
        return self._IntegrationResourceGroupName

    @IntegrationResourceGroupName.setter
    def IntegrationResourceGroupName(self, IntegrationResourceGroupName):
        self._IntegrationResourceGroupName = IntegrationResourceGroupName

    @property
    def MakeExtList(self):
        """补录扩展属性
        :rtype: list of StrToStrMap
        """
        return self._MakeExtList

    @MakeExtList.setter
    def MakeExtList(self, MakeExtList):
        self._MakeExtList = MakeExtList

    @property
    def SameSelfWorkflowDependType(self):
        """补录扩展属性
        :rtype: bool
        """
        return self._SameSelfWorkflowDependType

    @SameSelfWorkflowDependType.setter
    def SameSelfWorkflowDependType(self, SameSelfWorkflowDependType):
        self._SameSelfWorkflowDependType = SameSelfWorkflowDependType

    @property
    def SelfWorkflowDependency(self):
        """补录扩展属性
        :rtype: str
        """
        return self._SelfWorkflowDependency

    @SelfWorkflowDependency.setter
    def SelfWorkflowDependency(self, SelfWorkflowDependency):
        self._SelfWorkflowDependency = SelfWorkflowDependency


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MakeName = params.get("MakeName")
        self._TaskIdList = params.get("TaskIdList")
        if params.get("MakeDatetimeList") is not None:
            self._MakeDatetimeList = []
            for item in params.get("MakeDatetimeList"):
                obj = CreateMakeDatetimeInfo()
                obj._deserialize(item)
                self._MakeDatetimeList.append(obj)
        self._ProjectIdent = params.get("ProjectIdent")
        self._CheckParent = params.get("CheckParent")
        self._CheckParentType = params.get("CheckParentType")
        self._ProjectName = params.get("ProjectName")
        self._SelfDependence = params.get("SelfDependence")
        self._ParallelNum = params.get("ParallelNum")
        self._SameCycle = params.get("SameCycle")
        self._TargetTaskCycle = params.get("TargetTaskCycle")
        self._TargetTaskAction = params.get("TargetTaskAction")
        if params.get("MapParamList") is not None:
            self._MapParamList = []
            for item in params.get("MapParamList"):
                obj = StrToStrMap()
                obj._deserialize(item)
                self._MapParamList.append(obj)
        self._CreatorId = params.get("CreatorId")
        self._Creator = params.get("Creator")
        self._Remark = params.get("Remark")
        self._SameSelfDependType = params.get("SameSelfDependType")
        self._SourceTaskCycle = params.get("SourceTaskCycle")
        self._SchedulerResourceGroup = params.get("SchedulerResourceGroup")
        self._IntegrationResourceGroup = params.get("IntegrationResourceGroup")
        self._SchedulerResourceGroupName = params.get("SchedulerResourceGroupName")
        self._IntegrationResourceGroupName = params.get("IntegrationResourceGroupName")
        if params.get("MakeExtList") is not None:
            self._MakeExtList = []
            for item in params.get("MakeExtList"):
                obj = StrToStrMap()
                obj._deserialize(item)
                self._MakeExtList.append(obj)
        self._SameSelfWorkflowDependType = params.get("SameSelfWorkflowDependType")
        self._SelfWorkflowDependency = params.get("SelfWorkflowDependency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpsMakePlanResponse(AbstractModel):
    """CreateOpsMakePlan返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonIdOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CommonIdOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonIdOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    """CreateRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleTemplateId: 规则模板列表
        :type RuleTemplateId: int
        :param _Type: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
        :type Type: int
        :param _QualityDim: 规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :type QualityDim: int
        :param _SourceObjectDataTypeName: 源字段详细类型，int、string
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
        :type SourceObjectValue: str
        :param _ConditionType: 检测范围 1.全表   2.条件扫描
        :type ConditionType: int
        :param _ConditionExpression: 条件扫描WHERE条件表达式
        :type ConditionExpression: str
        :param _CustomSql: 自定义SQL
        :type CustomSql: str
        :param _CompareRule: 报警触发条件
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: 报警触发级别 1.低, 2.中, 3.高
        :type AlarmLevel: int
        :param _Description: 规则描述
        :type Description: str
        :param _DatasourceId: 数据源Id
        :type DatasourceId: str
        :param _DatabaseId: 数据库Id
        :type DatabaseId: str
        :param _TargetDatabaseId: 目标库Id
        :type TargetDatabaseId: str
        :param _TargetTableId: 目标表Id
        :type TargetTableId: str
        :param _TargetConditionExpr: 目标过滤条件表达式
        :type TargetConditionExpr: str
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
        :type RelConditionExpr: str
        :param _FieldConfig: 自定义模版sql表达式字段替换参数
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _TargetObjectValue: 目标字段名称  CITY
        :type TargetObjectValue: str
        :param _SourceEngineTypes: 该规则支持的执行引擎列表
        :type SourceEngineTypes: list of int non-negative
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._TableId = None
        self._RuleTemplateId = None
        self._Type = None
        self._QualityDim = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._DatasourceId = None
        self._DatabaseId = None
        self._TargetDatabaseId = None
        self._TargetTableId = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        """规则组Id
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        """规则名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TableId(self):
        """数据表ID
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleTemplateId(self):
        """规则模板列表
        :rtype: int
        """
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Type(self):
        """规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityDim(self):
        """规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :rtype: int
        """
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectDataTypeName(self):
        """源字段详细类型，int、string
        :rtype: str
        """
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        """源字段名称
        :rtype: str
        """
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        """检测范围 1.全表   2.条件扫描
        :rtype: int
        """
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        """条件扫描WHERE条件表达式
        :rtype: str
        """
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        """自定义SQL
        :rtype: str
        """
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        """报警触发条件
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        """
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        """报警触发级别 1.低, 2.中, 3.高
        :rtype: int
        """
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        """规则描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        """数据源Id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseId(self):
        """数据库Id
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def TargetDatabaseId(self):
        """目标库Id
        :rtype: str
        """
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetTableId(self):
        """目标表Id
        :rtype: str
        """
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetConditionExpr(self):
        """目标过滤条件表达式
        :rtype: str
        """
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        """源字段与目标字段关联条件on表达式
        :rtype: str
        """
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        """自定义模版sql表达式字段替换参数
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        """
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def TargetObjectValue(self):
        """目标字段名称  CITY
        :rtype: str
        """
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        """该规则支持的执行引擎列表
        :rtype: list of int non-negative
        """
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._TableId = params.get("TableId")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Type = params.get("Type")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseId = params.get("DatabaseId")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    """CreateRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.Rule`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleTemplateRequest(AbstractModel):
    """CreateRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模板类型  1.系统模板   2.自定义模板
        :type Type: int
        :param _Name: 模板名称
        :type Name: str
        :param _QualityDim: 质量检测维度 1.准确性 2.唯一性 3.完整性 4.一致性 5.及时性 6.有效性
        :type QualityDim: int
        :param _SourceObjectType: 源端数据对象类型 1.常量  2.离线表级   2.离线字段级
        :type SourceObjectType: int
        :param _Description: 模板描述
        :type Description: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        :param _MultiSourceFlag: 是否关联其它库表
        :type MultiSourceFlag: bool
        :param _SqlExpression: SQL 表达式
        :type SqlExpression: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WhereFlag: 是否添加where参数
        :type WhereFlag: bool
        """
        self._Type = None
        self._Name = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._Description = None
        self._SourceEngineTypes = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._ProjectId = None
        self._WhereFlag = None

    @property
    def Type(self):
        """模板类型  1.系统模板   2.自定义模板
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        """模板名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityDim(self):
        """质量检测维度 1.准确性 2.唯一性 3.完整性 4.一致性 5.及时性 6.有效性
        :rtype: int
        """
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        """源端数据对象类型 1.常量  2.离线表级   2.离线字段级
        :rtype: int
        """
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def Description(self):
        """模板描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourceEngineTypes(self):
        """源端对应的引擎类型
        :rtype: list of int non-negative
        """
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def MultiSourceFlag(self):
        """是否关联其它库表
        :rtype: bool
        """
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        """SQL 表达式
        :rtype: str
        """
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WhereFlag(self):
        """是否添加where参数
        :rtype: bool
        """
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._Description = params.get("Description")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._ProjectId = params.get("ProjectId")
        self._WhereFlag = params.get("WhereFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleTemplateResponse(AbstractModel):
    """CreateRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskAlarmRegularRequest(AbstractModel):
    """CreateTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskAlarmInfo(self):
        """告警配置信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        """
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskAlarmRegularResponse(AbstractModel):
    """CreateTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmId = None
        self._RequestId = None

    @property
    def AlarmId(self):
        """告警ID
        :rtype: int
        """
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._RequestId = params.get("RequestId")


class CreateTaskFolderRequest(AbstractModel):
    """CreateTaskFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ParentFolderId: 父文件夹ID
        :type ParentFolderId: str
        :param _TaskNodeType: 目录分类，该值必传，枚举值如下：
ETL：数据集成
EMR：EMR
TBDS：TBDS
DLC：DLC
TDSQL：TDSQL
TCHOUSE：TCHOUSE
GENERAL：通用
TI_ONE：TI-ONE机器学习
ACROSS_WORKFLOWS：跨工作流
        :type TaskNodeType: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._WorkflowId = None
        self._ParentFolderId = None
        self._TaskNodeType = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        """文件夹名称
        :rtype: str
        """
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ParentFolderId(self):
        """父文件夹ID
        :rtype: str
        """
        return self._ParentFolderId

    @ParentFolderId.setter
    def ParentFolderId(self, ParentFolderId):
        self._ParentFolderId = ParentFolderId

    @property
    def TaskNodeType(self):
        """目录分类，该值必传，枚举值如下：
ETL：数据集成
EMR：EMR
TBDS：TBDS
DLC：DLC
TDSQL：TDSQL
TCHOUSE：TCHOUSE
GENERAL：通用
TI_ONE：TI-ONE机器学习
ACROSS_WORKFLOWS：跨工作流
        :rtype: str
        """
        return self._TaskNodeType

    @TaskNodeType.setter
    def TaskNodeType(self, TaskNodeType):
        self._TaskNodeType = TaskNodeType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._WorkflowId = params.get("WorkflowId")
        self._ParentFolderId = params.get("ParentFolderId")
        self._TaskNodeType = params.get("TaskNodeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskFolderResponse(AbstractModel):
    """CreateTaskFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    """CreateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _TaskName: 任务名
        :type TaskName: str
        :param _TaskType: 26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40TCHouse-P，92MapReduce
        :type TaskType: int
        :param _TaskExt: 扩展属性
        :type TaskExt: list of TaskExtInfo
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._TaskName = None
        self._TaskType = None
        self._TaskExt = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        """工作流id
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskName(self):
        """任务名
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        """26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40TCHouse-P，92MapReduce
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskExt(self):
        """扩展属性
        :rtype: list of TaskExtInfo
        """
        return self._TaskExt

    @TaskExt.setter
    def TaskExt(self, TaskExt):
        self._TaskExt = TaskExt


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        if params.get("TaskExt") is not None:
            self._TaskExt = []
            for item in params.get("TaskExt"):
                obj = TaskExtInfo()
                obj._deserialize(item)
                self._TaskExt.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    """CreateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """返回任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTaskVersionDsRequest(AbstractModel):
    """CreateTaskVersionDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Task: 任务id
        :type Task: :class:`tencentcloud.wedata.v20210820.models.BatchCreateTaskVersionDTO`
        :param _NeedCheckParentSubmitted: 是否需要校验父任务已经提交到调度
        :type NeedCheckParentSubmitted: bool
        :param _AutoRun: 是否自动运行
        :type AutoRun: bool
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _AlarmWays: 告警方式:email-邮件;sms-短信;wecom-企业微信
        :type AlarmWays: str
        :param _AlarmRecipientTypes: 告警对象:1-项目管理员，2-任务责任人
        :type AlarmRecipientTypes: str
        :param _EnableCheckTaskCycleLink: 是否需要校验循环依赖，默认为 true，如果使用了 CheckTaskCycleLink 和 CheckTaskCycleConfiguration 两个接口校验成功可以传 false，后台服务器不再做校验
        :type EnableCheckTaskCycleLink: bool
        """
        self._Task = None
        self._NeedCheckParentSubmitted = None
        self._AutoRun = None
        self._ProjectId = None
        self._RequestFromSource = None
        self._AlarmWays = None
        self._AlarmRecipientTypes = None
        self._EnableCheckTaskCycleLink = None

    @property
    def Task(self):
        """任务id
        :rtype: :class:`tencentcloud.wedata.v20210820.models.BatchCreateTaskVersionDTO`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def NeedCheckParentSubmitted(self):
        """是否需要校验父任务已经提交到调度
        :rtype: bool
        """
        return self._NeedCheckParentSubmitted

    @NeedCheckParentSubmitted.setter
    def NeedCheckParentSubmitted(self, NeedCheckParentSubmitted):
        self._NeedCheckParentSubmitted = NeedCheckParentSubmitted

    @property
    def AutoRun(self):
        """是否自动运行
        :rtype: bool
        """
        return self._AutoRun

    @AutoRun.setter
    def AutoRun(self, AutoRun):
        self._AutoRun = AutoRun

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def AlarmWays(self):
        """告警方式:email-邮件;sms-短信;wecom-企业微信
        :rtype: str
        """
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientTypes(self):
        """告警对象:1-项目管理员，2-任务责任人
        :rtype: str
        """
        return self._AlarmRecipientTypes

    @AlarmRecipientTypes.setter
    def AlarmRecipientTypes(self, AlarmRecipientTypes):
        self._AlarmRecipientTypes = AlarmRecipientTypes

    @property
    def EnableCheckTaskCycleLink(self):
        """是否需要校验循环依赖，默认为 true，如果使用了 CheckTaskCycleLink 和 CheckTaskCycleConfiguration 两个接口校验成功可以传 false，后台服务器不再做校验
        :rtype: bool
        """
        return self._EnableCheckTaskCycleLink

    @EnableCheckTaskCycleLink.setter
    def EnableCheckTaskCycleLink(self, EnableCheckTaskCycleLink):
        self._EnableCheckTaskCycleLink = EnableCheckTaskCycleLink


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = BatchCreateTaskVersionDTO()
            self._Task._deserialize(params.get("Task"))
        self._NeedCheckParentSubmitted = params.get("NeedCheckParentSubmitted")
        self._AutoRun = params.get("AutoRun")
        self._ProjectId = params.get("ProjectId")
        self._RequestFromSource = params.get("RequestFromSource")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientTypes = params.get("AlarmRecipientTypes")
        self._EnableCheckTaskCycleLink = params.get("EnableCheckTaskCycleLink")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskVersionDsResponse(AbstractModel):
    """CreateTaskVersionDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 版本
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateWorkflowDsRequest(AbstractModel):
    """CreateWorkflowDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _WorkflowName: 工作流名称
        :type WorkflowName: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        :param _WorkflowDesc: 工作流描述
        :type WorkflowDesc: str
        :param _WorkflowType: 工作流类型,取值示例

- cycle 周期工作流
- manual 手动工作流

        :type WorkflowType: str
        """
        self._ProjectId = None
        self._WorkflowName = None
        self._FolderId = None
        self._WorkflowDesc = None
        self._WorkflowType = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowName(self):
        """工作流名称
        :rtype: str
        """
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def FolderId(self):
        """文件夹ID
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowDesc(self):
        """工作流描述
        :rtype: str
        """
        return self._WorkflowDesc

    @WorkflowDesc.setter
    def WorkflowDesc(self, WorkflowDesc):
        self._WorkflowDesc = WorkflowDesc

    @property
    def WorkflowType(self):
        """工作流类型,取值示例

- cycle 周期工作流
- manual 手动工作流

        :rtype: str
        """
        return self._WorkflowType

    @WorkflowType.setter
    def WorkflowType(self, WorkflowType):
        self._WorkflowType = WorkflowType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowName = params.get("WorkflowName")
        self._FolderId = params.get("FolderId")
        self._WorkflowDesc = params.get("WorkflowDesc")
        self._WorkflowType = params.get("WorkflowType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowDsResponse(AbstractModel):
    """CreateWorkflowDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 工作流ID
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """工作流ID
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DagInstancesRequest(AbstractModel):
    """DagInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件,当前接口需要把要查询的示例信息放在该字段
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        """实例列表
        :rtype: list of InstanceOpsDto
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        """检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :rtype: bool
        """
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        """重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :rtype: str
        """
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        """实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :rtype: str
        """
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        """重跑忽略事件监听与否 
        :rtype: bool
        """
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        """下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :rtype: str
        """
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        """查询条件,当前接口需要把要查询的示例信息放在该字段
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        """
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        """访问类型
        :rtype: str
        """
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        """操作者名称
        :rtype: str
        """
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        """操作者id
        :rtype: str
        """
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        """项目标志
        :rtype: str
        """
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        """索引页码
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        """页面大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        """数据总数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        """基础请求信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        """
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        """是否计算总数
        :rtype: bool
        """
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DagInstancesResponse(AbstractModel):
    """DagInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DailyScoreInfo(AbstractModel):
    """日评分信息

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticsDate: int
        :param _Score: 评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Score: float
        """
        self._StatisticsDate = None
        self._Score = None

    @property
    def StatisticsDate(self):
        """统计日期 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def Score(self):
        """评分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataCheckStat(AbstractModel):
    """数据监测情况结果

    """

    def __init__(self):
        r"""
        :param _TableTotal: 表总数
        :type TableTotal: int
        :param _ColumnTotal: 字段总数
        :type ColumnTotal: int
        :param _TableConfig: 表配置检测数
        :type TableConfig: int
        :param _ColumnConfig: 字段配置检测数
        :type ColumnConfig: int
        :param _TableExec: 表实际检测数
        :type TableExec: int
        :param _ColumnExec: 字段实际检测数
        :type ColumnExec: int
        """
        self._TableTotal = None
        self._ColumnTotal = None
        self._TableConfig = None
        self._ColumnConfig = None
        self._TableExec = None
        self._ColumnExec = None

    @property
    def TableTotal(self):
        """表总数
        :rtype: int
        """
        return self._TableTotal

    @TableTotal.setter
    def TableTotal(self, TableTotal):
        self._TableTotal = TableTotal

    @property
    def ColumnTotal(self):
        """字段总数
        :rtype: int
        """
        return self._ColumnTotal

    @ColumnTotal.setter
    def ColumnTotal(self, ColumnTotal):
        self._ColumnTotal = ColumnTotal

    @property
    def TableConfig(self):
        """表配置检测数
        :rtype: int
        """
        return self._TableConfig

    @TableConfig.setter
    def TableConfig(self, TableConfig):
        self._TableConfig = TableConfig

    @property
    def ColumnConfig(self):
        """字段配置检测数
        :rtype: int
        """
        return self._ColumnConfig

    @ColumnConfig.setter
    def ColumnConfig(self, ColumnConfig):
        self._ColumnConfig = ColumnConfig

    @property
    def TableExec(self):
        """表实际检测数
        :rtype: int
        """
        return self._TableExec

    @TableExec.setter
    def TableExec(self, TableExec):
        self._TableExec = TableExec

    @property
    def ColumnExec(self):
        """字段实际检测数
        :rtype: int
        """
        return self._ColumnExec

    @ColumnExec.setter
    def ColumnExec(self, ColumnExec):
        self._ColumnExec = ColumnExec


    def _deserialize(self, params):
        self._TableTotal = params.get("TableTotal")
        self._ColumnTotal = params.get("ColumnTotal")
        self._TableConfig = params.get("TableConfig")
        self._ColumnConfig = params.get("ColumnConfig")
        self._TableExec = params.get("TableExec")
        self._ColumnExec = params.get("ColumnExec")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataServicePublishedApiListFilter(AbstractModel):
    """获取数据服务API的发布态信息列表过滤条件

    """

    def __init__(self):
        r"""
        :param _PathUrl: 请求路径关键词筛选
        :type PathUrl: str
        :param _Keyword: Api名称关键词筛选
        :type Keyword: str
        :param _AuthTypes: Api认证方式筛选 0:免认证 1:应用认证
        :type AuthTypes: list of int non-negative
        :param _ApiStatus: 服务Api状态 1:已上线  3:已下线
        :type ApiStatus: list of int non-negative
        :param _ConfigTypes: API配置方式 0:向导、1、脚本、2、注册Api
        :type ConfigTypes: list of int non-negative
        """
        self._PathUrl = None
        self._Keyword = None
        self._AuthTypes = None
        self._ApiStatus = None
        self._ConfigTypes = None

    @property
    def PathUrl(self):
        """请求路径关键词筛选
        :rtype: str
        """
        return self._PathUrl

    @PathUrl.setter
    def PathUrl(self, PathUrl):
        self._PathUrl = PathUrl

    @property
    def Keyword(self):
        """Api名称关键词筛选
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def AuthTypes(self):
        """Api认证方式筛选 0:免认证 1:应用认证
        :rtype: list of int non-negative
        """
        return self._AuthTypes

    @AuthTypes.setter
    def AuthTypes(self, AuthTypes):
        self._AuthTypes = AuthTypes

    @property
    def ApiStatus(self):
        """服务Api状态 1:已上线  3:已下线
        :rtype: list of int non-negative
        """
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def ConfigTypes(self):
        """API配置方式 0:向导、1、脚本、2、注册Api
        :rtype: list of int non-negative
        """
        return self._ConfigTypes

    @ConfigTypes.setter
    def ConfigTypes(self, ConfigTypes):
        self._ConfigTypes = ConfigTypes


    def _deserialize(self, params):
        self._PathUrl = params.get("PathUrl")
        self._Keyword = params.get("Keyword")
        self._AuthTypes = params.get("AuthTypes")
        self._ApiStatus = params.get("ApiStatus")
        self._ConfigTypes = params.get("ConfigTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataServiceRequestListOrder(AbstractModel):
    """数据服务通用排序参数

    """

    def __init__(self):
        r"""
        :param _Name: 排序参数名称
取值： 
  CreateTime 表示按照创建时间排序
  ModifyTime 表示按照更新时间排序
        :type Name: str
        :param _Direction: 排序参数顺序
        :type Direction: str
        """
        self._Name = None
        self._Direction = None

    @property
    def Name(self):
        """排序参数名称
取值： 
  CreateTime 表示按照创建时间排序
  ModifyTime 表示按照更新时间排序
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Direction(self):
        """排序参数顺序
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Direction = params.get("Direction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataServiceRequestParam(AbstractModel):
    """数据服务入参

    """

    def __init__(self):
        r"""
        :param _ParamName: 参数名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamName: str
        :param _BindField: 绑定字段
注意：此字段可能返回 null，表示取不到有效值。
        :type BindField: str
        :param _ParamType: 参数类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamType: str
        :param _ParamPosition: 参数位置
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamPosition: str
        :param _Operator: 操作符
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _NonEmpty: 是否为空
注意：此字段可能返回 null，表示取不到有效值。
        :type NonEmpty: int
        :param _DefaultValue: 默认值
注意：此字段可能返回 null，表示取不到有效值。
        :type DefaultValue: str
        :param _ExampleValue: 示例值
注意：此字段可能返回 null，表示取不到有效值。
        :type ExampleValue: str
        :param _Description: 参数描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._ParamName = None
        self._BindField = None
        self._ParamType = None
        self._ParamPosition = None
        self._Operator = None
        self._NonEmpty = None
        self._DefaultValue = None
        self._ExampleValue = None
        self._Description = None

    @property
    def ParamName(self):
        """参数名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def BindField(self):
        """绑定字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BindField

    @BindField.setter
    def BindField(self, BindField):
        self._BindField = BindField

    @property
    def ParamType(self):
        """参数类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamType

    @ParamType.setter
    def ParamType(self, ParamType):
        self._ParamType = ParamType

    @property
    def ParamPosition(self):
        """参数位置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamPosition

    @ParamPosition.setter
    def ParamPosition(self, ParamPosition):
        self._ParamPosition = ParamPosition

    @property
    def Operator(self):
        """操作符
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def NonEmpty(self):
        """是否为空
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NonEmpty

    @NonEmpty.setter
    def NonEmpty(self, NonEmpty):
        self._NonEmpty = NonEmpty

    @property
    def DefaultValue(self):
        """默认值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DefaultValue

    @DefaultValue.setter
    def DefaultValue(self, DefaultValue):
        self._DefaultValue = DefaultValue

    @property
    def ExampleValue(self):
        """示例值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExampleValue

    @ExampleValue.setter
    def ExampleValue(self, ExampleValue):
        self._ExampleValue = ExampleValue

    @property
    def Description(self):
        """参数描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._BindField = params.get("BindField")
        self._ParamType = params.get("ParamType")
        self._ParamPosition = params.get("ParamPosition")
        self._Operator = params.get("Operator")
        self._NonEmpty = params.get("NonEmpty")
        self._DefaultValue = params.get("DefaultValue")
        self._ExampleValue = params.get("ExampleValue")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataServiceResponseParam(AbstractModel):
    """数据服务入参

    """

    def __init__(self):
        r"""
        :param _ParamName: 参数名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamName: str
        :param _BindField: 绑定字段
注意：此字段可能返回 null，表示取不到有效值。
        :type BindField: str
        :param _ParamType: 参数类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamType: str
        :param _ExampleValue: 示例值
注意：此字段可能返回 null，表示取不到有效值。
        :type ExampleValue: str
        :param _Description: 参数描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._ParamName = None
        self._BindField = None
        self._ParamType = None
        self._ExampleValue = None
        self._Description = None

    @property
    def ParamName(self):
        """参数名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def BindField(self):
        """绑定字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BindField

    @BindField.setter
    def BindField(self, BindField):
        self._BindField = BindField

    @property
    def ParamType(self):
        """参数类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamType

    @ParamType.setter
    def ParamType(self, ParamType):
        self._ParamType = ParamType

    @property
    def ExampleValue(self):
        """示例值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExampleValue

    @ExampleValue.setter
    def ExampleValue(self, ExampleValue):
        self._ExampleValue = ExampleValue

    @property
    def Description(self):
        """参数描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._BindField = params.get("BindField")
        self._ParamType = params.get("ParamType")
        self._ExampleValue = params.get("ExampleValue")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceConnectStatus(AbstractModel):
    """数据源云梯连接状态

    """

    def __init__(self):
        r"""
        :param _Id: id
        :type Id: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _ConnectResult: 连接结果
        :type ConnectResult: int
        :param _ConnectError: 错误信息
        :type ConnectError: str
        :param _Timestamp: 时间戳
        :type Timestamp: int
        """
        self._Id = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ConnectResult = None
        self._ConnectError = None
        self._Timestamp = None

    @property
    def Id(self):
        """id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        """数据源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ConnectResult(self):
        """连接结果
        :rtype: int
        """
        return self._ConnectResult

    @ConnectResult.setter
    def ConnectResult(self, ConnectResult):
        self._ConnectResult = ConnectResult

    @property
    def ConnectError(self):
        """错误信息
        :rtype: str
        """
        return self._ConnectError

    @ConnectError.setter
    def ConnectError(self, ConnectError):
        self._ConnectError = ConnectError

    @property
    def Timestamp(self):
        """时间戳
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ConnectResult = params.get("ConnectResult")
        self._ConnectError = params.get("ConnectError")
        self._Timestamp = params.get("Timestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceEnvInfo(AbstractModel):
    """数据源环境信息

    """

    def __init__(self):
        r"""
        :param _Env: 环境
注意：此字段可能返回 null，表示取不到有效值。
        :type Env: str
        :param _DataSourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceType: str
        :param _ClusterId: 集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _Params: 配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _DataSourceId: 数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceId: str
        :param _EnvDataSourceId: env环境的数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type EnvDataSourceId: str
        :param _BizParams: 配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParams: str
        """
        self._Env = None
        self._DataSourceType = None
        self._ClusterId = None
        self._Params = None
        self._ProjectId = None
        self._DataSourceId = None
        self._EnvDataSourceId = None
        self._BizParams = None

    @property
    def Env(self):
        """环境
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env

    @property
    def DataSourceType(self):
        """数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataSourceType

    @DataSourceType.setter
    def DataSourceType(self, DataSourceType):
        self._DataSourceType = DataSourceType

    @property
    def ClusterId(self):
        """集群id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Params(self):
        """配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def ProjectId(self):
        """项目id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DataSourceId(self):
        """数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataSourceId

    @DataSourceId.setter
    def DataSourceId(self, DataSourceId):
        self._DataSourceId = DataSourceId

    @property
    def EnvDataSourceId(self):
        """env环境的数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EnvDataSourceId

    @EnvDataSourceId.setter
    def EnvDataSourceId(self, EnvDataSourceId):
        self._EnvDataSourceId = EnvDataSourceId

    @property
    def BizParams(self):
        """配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams


    def _deserialize(self, params):
        self._Env = params.get("Env")
        self._DataSourceType = params.get("DataSourceType")
        self._ClusterId = params.get("ClusterId")
        self._Params = params.get("Params")
        self._ProjectId = params.get("ProjectId")
        self._DataSourceId = params.get("DataSourceId")
        self._EnvDataSourceId = params.get("EnvDataSourceId")
        self._BizParams = params.get("BizParams")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _AppId: 应用ID AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: int
        :param _BizParams: 业务侧数据源的配置信息扩展
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParams: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Display: 数据源展示名，为了可视化查看
注意：此字段可能返回 null，表示取不到有效值。
        :type Display: str
        :param _OwnerAccount: 数据源责任人账号ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccount: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _OwnerAccountName: 数据源责任人账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccountName: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _OwnerProjectId: 归属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectIdent: str
        :param _AuthorityProjectName: 授权项目
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityProjectName: str
        :param _AuthorityUserName: 授权用户
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityUserName: str
        :param _Edit: 是否有编辑权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Edit: bool
        :param _Author: 是否有授权权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Author: bool
        :param _Deliver: 是否有转交权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Deliver: bool
        :param _DataSourceStatus: 数据源状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceStatus: str
        :param _CreateTime: 时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _ParamsString: Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamsString: str
        :param _BizParamsString: BizParams json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParamsString: str
        :param _ModifiedTime: 修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifiedTime: int
        :param _ShowType: 数据源页面展示类型，与Type对应
注意：此字段可能返回 null，表示取不到有效值。
        :type ShowType: str
        :param _ProductId: 当前数据源生产源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProductId: int
        :param _DevelopmentId: 当前数据源开发源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DevelopmentId: int
        :param _DevelopmentParams: 同params 内容为开发数据源的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type DevelopmentParams: str
        :param _ConnectStatus: 数据源连接状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ConnectStatus: :class:`tencentcloud.wedata.v20210820.models.DataSourceConnectStatus`
        :param _DisplayType: 数据源展示类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DisplayType: str
        :param _Env: 数据源环境
注意：此字段可能返回 null，表示取不到有效值。
        :type Env: str
        :param _DatasourceUrn: 数据源唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceUrn: str
        :param _Model: 是否标准模式
注意：此字段可能返回 null，表示取不到有效值。
        :type Model: str
        :param _DataSourceEnvInfos:  数据源环境信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceEnvInfos: list of DataSourceEnvInfo
        """
        self._DatabaseName = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._AppId = None
        self._BizParams = None
        self._Category = None
        self._Display = None
        self._OwnerAccount = None
        self._Params = None
        self._Status = None
        self._OwnerAccountName = None
        self._ClusterName = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._AuthorityProjectName = None
        self._AuthorityUserName = None
        self._Edit = None
        self._Author = None
        self._Deliver = None
        self._DataSourceStatus = None
        self._CreateTime = None
        self._ParamsString = None
        self._BizParamsString = None
        self._ModifiedTime = None
        self._ShowType = None
        self._ProductId = None
        self._DevelopmentId = None
        self._DevelopmentParams = None
        self._ConnectStatus = None
        self._DisplayType = None
        self._Env = None
        self._DatasourceUrn = None
        self._Model = None
        self._DataSourceEnvInfos = None

    @property
    def DatabaseName(self):
        """若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Description(self):
        """数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        """数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        """数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        """数据源名称，在相同SpaceName下，数据源名称不能为空
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        """数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        """数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        """数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        """应用ID AppId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def BizParams(self):
        """业务侧数据源的配置信息扩展
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Category(self):
        """数据源类别：绑定引擎、绑定数据库
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Display(self):
        """数据源展示名，为了可视化查看
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def OwnerAccount(self):
        """数据源责任人账号ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def Params(self):
        """数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Status(self):
        """数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OwnerAccountName(self):
        """数据源责任人账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def ClusterName(self):
        """集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def OwnerProjectId(self):
        """归属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        """归属项目Name
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        """归属项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def AuthorityProjectName(self):
        """授权项目
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AuthorityProjectName

    @AuthorityProjectName.setter
    def AuthorityProjectName(self, AuthorityProjectName):
        self._AuthorityProjectName = AuthorityProjectName

    @property
    def AuthorityUserName(self):
        """授权用户
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AuthorityUserName

    @AuthorityUserName.setter
    def AuthorityUserName(self, AuthorityUserName):
        self._AuthorityUserName = AuthorityUserName

    @property
    def Edit(self):
        """是否有编辑权限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Edit

    @Edit.setter
    def Edit(self, Edit):
        self._Edit = Edit

    @property
    def Author(self):
        """是否有授权权限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def Deliver(self):
        """是否有转交权限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Deliver

    @Deliver.setter
    def Deliver(self, Deliver):
        self._Deliver = Deliver

    @property
    def DataSourceStatus(self):
        """数据源状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataSourceStatus

    @DataSourceStatus.setter
    def DataSourceStatus(self, DataSourceStatus):
        self._DataSourceStatus = DataSourceStatus

    @property
    def CreateTime(self):
        """时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ParamsString(self):
        """Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def BizParamsString(self):
        """BizParams json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BizParamsString

    @BizParamsString.setter
    def BizParamsString(self, BizParamsString):
        self._BizParamsString = BizParamsString

    @property
    def ModifiedTime(self):
        """修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def ShowType(self):
        """数据源页面展示类型，与Type对应
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ShowType

    @ShowType.setter
    def ShowType(self, ShowType):
        self._ShowType = ShowType

    @property
    def ProductId(self):
        """当前数据源生产源Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def DevelopmentId(self):
        """当前数据源开发源Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DevelopmentId

    @DevelopmentId.setter
    def DevelopmentId(self, DevelopmentId):
        self._DevelopmentId = DevelopmentId

    @property
    def DevelopmentParams(self):
        """同params 内容为开发数据源的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DevelopmentParams

    @DevelopmentParams.setter
    def DevelopmentParams(self, DevelopmentParams):
        self._DevelopmentParams = DevelopmentParams

    @property
    def ConnectStatus(self):
        """数据源连接状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DataSourceConnectStatus`
        """
        return self._ConnectStatus

    @ConnectStatus.setter
    def ConnectStatus(self, ConnectStatus):
        self._ConnectStatus = ConnectStatus

    @property
    def DisplayType(self):
        """数据源展示类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType

    @property
    def Env(self):
        """数据源环境
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env

    @property
    def DatasourceUrn(self):
        """数据源唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceUrn

    @DatasourceUrn.setter
    def DatasourceUrn(self, DatasourceUrn):
        self._DatasourceUrn = DatasourceUrn

    @property
    def Model(self):
        """是否标准模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def DataSourceEnvInfos(self):
        """ 数据源环境信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSourceEnvInfo
        """
        return self._DataSourceEnvInfos

    @DataSourceEnvInfos.setter
    def DataSourceEnvInfos(self, DataSourceEnvInfos):
        self._DataSourceEnvInfos = DataSourceEnvInfos


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._BizParams = params.get("BizParams")
        self._Category = params.get("Category")
        self._Display = params.get("Display")
        self._OwnerAccount = params.get("OwnerAccount")
        self._Params = params.get("Params")
        self._Status = params.get("Status")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._ClusterName = params.get("ClusterName")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._AuthorityProjectName = params.get("AuthorityProjectName")
        self._AuthorityUserName = params.get("AuthorityUserName")
        self._Edit = params.get("Edit")
        self._Author = params.get("Author")
        self._Deliver = params.get("Deliver")
        self._DataSourceStatus = params.get("DataSourceStatus")
        self._CreateTime = params.get("CreateTime")
        self._ParamsString = params.get("ParamsString")
        self._BizParamsString = params.get("BizParamsString")
        self._ModifiedTime = params.get("ModifiedTime")
        self._ShowType = params.get("ShowType")
        self._ProductId = params.get("ProductId")
        self._DevelopmentId = params.get("DevelopmentId")
        self._DevelopmentParams = params.get("DevelopmentParams")
        if params.get("ConnectStatus") is not None:
            self._ConnectStatus = DataSourceConnectStatus()
            self._ConnectStatus._deserialize(params.get("ConnectStatus"))
        self._DisplayType = params.get("DisplayType")
        self._Env = params.get("Env")
        self._DatasourceUrn = params.get("DatasourceUrn")
        self._Model = params.get("Model")
        if params.get("DataSourceEnvInfos") is not None:
            self._DataSourceEnvInfos = []
            for item in params.get("DataSourceEnvInfos"):
                obj = DataSourceEnvInfo()
                obj._deserialize(item)
                self._DataSourceEnvInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfoPage(AbstractModel):
    """查询数据源分页列表

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 分页大小
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Rows: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Rows: list of DataSourceInfo
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPageNumber: 总分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPageNumber: int
        """
        self._PageNumber = None
        self._PageSize = None
        self._Rows = None
        self._TotalCount = None
        self._TotalPageNumber = None

    @property
    def PageNumber(self):
        """分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Rows(self):
        """数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSourceInfo
        """
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalCount(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPageNumber(self):
        """总分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._TotalPageNumber = params.get("TotalPageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseInfo(AbstractModel):
    """数据质量数据来源数据库

    """

    def __init__(self):
        r"""
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _DatabaseId: 数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _InstanceId: 实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        :param _OriginDatabaseName: 数据库原始名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginDatabaseName: str
        :param _OriginSchemaName: schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginSchemaName: str
        :param _DsEnvType: 0或者未返回.未定义，1.生产 2.开发
注意：此字段可能返回 null，表示取不到有效值。
        :type DsEnvType: int
        :param _ClusterDeployType: EMR引擎部署方式：CVM/TKE
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterDeployType: str
        :param _SchemaName: 模式名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaName: str
        """
        self._DatasourceName = None
        self._DatasourceId = None
        self._DatabaseName = None
        self._DatabaseId = None
        self._InstanceId = None
        self._DatasourceType = None
        self._OriginDatabaseName = None
        self._OriginSchemaName = None
        self._DsEnvType = None
        self._ClusterDeployType = None
        self._SchemaName = None

    @property
    def DatasourceName(self):
        """数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        """数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseName(self):
        """数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatabaseId(self):
        """数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def InstanceId(self):
        """实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DatasourceType(self):
        """数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def OriginDatabaseName(self):
        """数据库原始名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OriginDatabaseName

    @OriginDatabaseName.setter
    def OriginDatabaseName(self, OriginDatabaseName):
        self._OriginDatabaseName = OriginDatabaseName

    @property
    def OriginSchemaName(self):
        """schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OriginSchemaName

    @OriginSchemaName.setter
    def OriginSchemaName(self, OriginSchemaName):
        self._OriginSchemaName = OriginSchemaName

    @property
    def DsEnvType(self):
        """0或者未返回.未定义，1.生产 2.开发
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DsEnvType

    @DsEnvType.setter
    def DsEnvType(self, DsEnvType):
        self._DsEnvType = DsEnvType

    @property
    def ClusterDeployType(self):
        """EMR引擎部署方式：CVM/TKE
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterDeployType

    @ClusterDeployType.setter
    def ClusterDeployType(self, ClusterDeployType):
        self._ClusterDeployType = ClusterDeployType

    @property
    def SchemaName(self):
        """模式名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName


    def _deserialize(self, params):
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseName = params.get("DatabaseName")
        self._DatabaseId = params.get("DatabaseId")
        self._InstanceId = params.get("InstanceId")
        self._DatasourceType = params.get("DatasourceType")
        self._OriginDatabaseName = params.get("OriginDatabaseName")
        self._OriginSchemaName = params.get("OriginSchemaName")
        self._DsEnvType = params.get("DsEnvType")
        self._ClusterDeployType = params.get("ClusterDeployType")
        self._SchemaName = params.get("SchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseMeta(AbstractModel):
    """数据源元数据

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _MetastoreType: 技术类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: int
        :param _ProjectName: 项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库,可用值:DB,ENGINE
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _DatabaseName: db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _ProjectDisplayName: 项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectDisplayName: str
        :param _OwnerAccountName: 责任人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccountName: str
        :param _DisplayName: 数据来源展示名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DisplayName: str
        :param _DatabaseId: 数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _Catalog: 数据来源类型：hive/mysql/hbase等
注意：此字段可能返回 null，表示取不到有效值。
        :type Catalog: str
        :param _StorageSize: 存储量大小,单位为 byte
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageSize: int
        :param _StorageSizeWithUnit: 格式化后的存储量大小，带单位，如 12B
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageSizeWithUnit: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _TableCount: 总表数
注意：此字段可能返回 null，表示取不到有效值。
        :type TableCount: int
        :param _DatasourceList: 数据源信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceList: list of GovDatasourceInfo
        :param _CollectJobId: 采集任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type CollectJobId: str
        :param _CollectJobName: 采集任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CollectJobName: str
        :param _ClusterId: 引擎id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _ClusterName: 引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ModifiedTimeByTables: 库下表的最新更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifiedTimeByTables: int
        :param _LastAccessTimeByTables: 库下表的最新访问时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastAccessTimeByTables: int
        """
        self._ProjectId = None
        self._MetastoreType = None
        self._DatasourceName = None
        self._DatasourceId = None
        self._ProjectName = None
        self._Category = None
        self._Description = None
        self._Instance = None
        self._Region = None
        self._Status = None
        self._DatabaseName = None
        self._ProjectDisplayName = None
        self._OwnerAccountName = None
        self._DisplayName = None
        self._DatabaseId = None
        self._Catalog = None
        self._StorageSize = None
        self._StorageSizeWithUnit = None
        self._CreateTime = None
        self._TableCount = None
        self._DatasourceList = None
        self._CollectJobId = None
        self._CollectJobName = None
        self._ClusterId = None
        self._ClusterName = None
        self._ModifiedTimeByTables = None
        self._LastAccessTimeByTables = None

    @property
    def ProjectId(self):
        """项目Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MetastoreType(self):
        """技术类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def DatasourceName(self):
        """数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        """数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ProjectName(self):
        """项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Category(self):
        """数据源类别：绑定引擎、绑定数据库,可用值:DB,ENGINE
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Description(self):
        """数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Instance(self):
        """数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Region(self):
        """数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Status(self):
        """数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DatabaseName(self):
        """db名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def ProjectDisplayName(self):
        """项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def OwnerAccountName(self):
        """责任人名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def DisplayName(self):
        """数据来源展示名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def DatabaseId(self):
        """数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def Catalog(self):
        """数据来源类型：hive/mysql/hbase等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def StorageSize(self):
        """存储量大小,单位为 byte
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def StorageSizeWithUnit(self):
        """格式化后的存储量大小，带单位，如 12B
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StorageSizeWithUnit

    @StorageSizeWithUnit.setter
    def StorageSizeWithUnit(self, StorageSizeWithUnit):
        self._StorageSizeWithUnit = StorageSizeWithUnit

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def TableCount(self):
        """总表数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TableCount

    @TableCount.setter
    def TableCount(self, TableCount):
        self._TableCount = TableCount

    @property
    def DatasourceList(self):
        """数据源信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GovDatasourceInfo
        """
        return self._DatasourceList

    @DatasourceList.setter
    def DatasourceList(self, DatasourceList):
        self._DatasourceList = DatasourceList

    @property
    def CollectJobId(self):
        """采集任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CollectJobId

    @CollectJobId.setter
    def CollectJobId(self, CollectJobId):
        self._CollectJobId = CollectJobId

    @property
    def CollectJobName(self):
        """采集任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CollectJobName

    @CollectJobName.setter
    def CollectJobName(self, CollectJobName):
        self._CollectJobName = CollectJobName

    @property
    def ClusterId(self):
        """引擎id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        """引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ModifiedTimeByTables(self):
        """库下表的最新更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ModifiedTimeByTables

    @ModifiedTimeByTables.setter
    def ModifiedTimeByTables(self, ModifiedTimeByTables):
        self._ModifiedTimeByTables = ModifiedTimeByTables

    @property
    def LastAccessTimeByTables(self):
        """库下表的最新访问时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LastAccessTimeByTables

    @LastAccessTimeByTables.setter
    def LastAccessTimeByTables(self, LastAccessTimeByTables):
        self._LastAccessTimeByTables = LastAccessTimeByTables


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MetastoreType = params.get("MetastoreType")
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._ProjectName = params.get("ProjectName")
        self._Category = params.get("Category")
        self._Description = params.get("Description")
        self._Instance = params.get("Instance")
        self._Region = params.get("Region")
        self._Status = params.get("Status")
        self._DatabaseName = params.get("DatabaseName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._DisplayName = params.get("DisplayName")
        self._DatabaseId = params.get("DatabaseId")
        self._Catalog = params.get("Catalog")
        self._StorageSize = params.get("StorageSize")
        self._StorageSizeWithUnit = params.get("StorageSizeWithUnit")
        self._CreateTime = params.get("CreateTime")
        self._TableCount = params.get("TableCount")
        if params.get("DatasourceList") is not None:
            self._DatasourceList = []
            for item in params.get("DatasourceList"):
                obj = GovDatasourceInfo()
                obj._deserialize(item)
                self._DatasourceList.append(obj)
        self._CollectJobId = params.get("CollectJobId")
        self._CollectJobName = params.get("CollectJobName")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ModifiedTimeByTables = params.get("ModifiedTimeByTables")
        self._LastAccessTimeByTables = params.get("LastAccessTimeByTables")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceBaseInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseNames: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseNames: list of str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _Version: 数据源版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: str
        :param _ParamsString: 数据源附带参数信息Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamsString: str
        :param _Category: 区分数据源类型自定义源还是系统源
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        """
        self._DatabaseNames = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._Version = None
        self._ParamsString = None
        self._Category = None

    @property
    def DatabaseNames(self):
        """若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._DatabaseNames

    @DatabaseNames.setter
    def DatabaseNames(self, DatabaseNames):
        self._DatabaseNames = DatabaseNames

    @property
    def Description(self):
        """数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        """数据源ID
        :rtype: int
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        """数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        """数据源名称，在相同SpaceName下，数据源名称不能为空
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        """数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        """数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        """数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Version(self):
        """数据源版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ParamsString(self):
        """数据源附带参数信息Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def Category(self):
        """区分数据源类型自定义源还是系统源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category


    def _deserialize(self, params):
        self._DatabaseNames = params.get("DatabaseNames")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._Version = params.get("Version")
        self._ParamsString = params.get("ParamsString")
        self._Category = params.get("Category")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionRequest(AbstractModel):
    """DeleteCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIdentifier: 集群实例 ID
        :type ClusterIdentifier: str
        :param _FunctionId: 函数 ID
        :type FunctionId: str
        :param _ProjectId: 项目ID，必须填
        :type ProjectId: str
        :param _FunctionName: 函数名称
        :type FunctionName: str
        :param _FunctionType: 函数类型，HIVE，SPARK，DLC，CDW_POSTGRESQL
        :type FunctionType: str
        :param _DatabaseName: 数据库名
        :type DatabaseName: str
        :param _SchemaName: 模式名
        :type SchemaName: str
        :param _CommandFormat: 函数命令格式
        :type CommandFormat: str
        """
        self._ClusterIdentifier = None
        self._FunctionId = None
        self._ProjectId = None
        self._FunctionName = None
        self._FunctionType = None
        self._DatabaseName = None
        self._SchemaName = None
        self._CommandFormat = None

    @property
    def ClusterIdentifier(self):
        """集群实例 ID
        :rtype: str
        """
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def FunctionId(self):
        """函数 ID
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ProjectId(self):
        """项目ID，必须填
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FunctionName(self):
        """函数名称
        :rtype: str
        """
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionType(self):
        """函数类型，HIVE，SPARK，DLC，CDW_POSTGRESQL
        :rtype: str
        """
        return self._FunctionType

    @FunctionType.setter
    def FunctionType(self, FunctionType):
        self._FunctionType = FunctionType

    @property
    def DatabaseName(self):
        """数据库名
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        """模式名
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def CommandFormat(self):
        """函数命令格式
        :rtype: str
        """
        return self._CommandFormat

    @CommandFormat.setter
    def CommandFormat(self, CommandFormat):
        self._CommandFormat = CommandFormat


    def _deserialize(self, params):
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._FunctionId = params.get("FunctionId")
        self._ProjectId = params.get("ProjectId")
        self._FunctionName = params.get("FunctionName")
        self._FunctionType = params.get("FunctionType")
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._CommandFormat = params.get("CommandFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionResponse(AbstractModel):
    """DeleteCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        """函数 ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DeleteDataModelRequest(AbstractModel):
    """DeleteDataModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CloudappId: 云应用的实例id
        :type CloudappId: str
        :param _DataModelId: 数据建模的实例id
        :type DataModelId: str
        :param _UserId: 用户的子账号id
        :type UserId: str
        """
        self._CloudappId = None
        self._DataModelId = None
        self._UserId = None

    @property
    def CloudappId(self):
        """云应用的实例id
        :rtype: str
        """
        return self._CloudappId

    @CloudappId.setter
    def CloudappId(self, CloudappId):
        self._CloudappId = CloudappId

    @property
    def DataModelId(self):
        """数据建模的实例id
        :rtype: str
        """
        return self._DataModelId

    @DataModelId.setter
    def DataModelId(self, DataModelId):
        self._DataModelId = DataModelId

    @property
    def UserId(self):
        """用户的子账号id
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._CloudappId = params.get("CloudappId")
        self._DataModelId = params.get("DataModelId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataModelResponse(AbstractModel):
    """DeleteDataModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否销毁成功
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否销毁成功
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteDataSourcesRequest(AbstractModel):
    """DeleteDataSources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: id列表
        :type Ids: list of int non-negative
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Ids = None
        self._ProjectId = None

    @property
    def Ids(self):
        """id列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataSourcesResponse(AbstractModel):
    """DeleteDataSources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteDsFolderRequest(AbstractModel):
    """DeleteDsFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        """
        self._ProjectId = None
        self._FolderId = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        """文件夹ID
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDsFolderResponse(AbstractModel):
    """DeleteDsFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表删除成功，false代表删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """true代表删除成功，false代表删除失败
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteFilePathRequest(AbstractModel):
    """DeleteFilePath请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _ResourceIds: 资源ID
        :type ResourceIds: list of str
        :param _UseStatus: 使用状态
- true
- false
        :type UseStatus: str
        :param _FilePaths: 文件路径
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._ResourceIds = None
        self._UseStatus = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceIds(self):
        """资源ID
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def UseStatus(self):
        """使用状态
- true
- false
        :rtype: str
        """
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def FilePaths(self):
        """文件路径
        :rtype: list of str
        """
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceIds = params.get("ResourceIds")
        self._UseStatus = params.get("UseStatus")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFilePathResponse(AbstractModel):
    """DeleteFilePath返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserFileList: 文件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type UserFileList: list of UserFileInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserFileList = None
        self._RequestId = None

    @property
    def UserFileList(self):
        """文件列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of UserFileInfo
        """
        return self._UserFileList

    @UserFileList.setter
    def UserFileList(self, UserFileList):
        self._UserFileList = UserFileList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserFileList") is not None:
            self._UserFileList = []
            for item in params.get("UserFileList"):
                obj = UserFileInfo()
                obj._deserialize(item)
                self._UserFileList.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteFileRequest(AbstractModel):
    """DeleteFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        """资源id
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFileResponse(AbstractModel):
    """DeleteFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationNodeRequest(AbstractModel):
    """DeleteIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Id = None
        self._ProjectId = None

    @property
    def Id(self):
        """节点id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationNodeResponse(AbstractModel):
    """DeleteIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除返回是否成功标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """删除返回是否成功标识
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationTaskRequest(AbstractModel):
    """DeleteIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationTaskResponse(AbstractModel):
    """DeleteIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务删除成功与否标识
        :type Data: bool
        :param _DeleteFlag: 任务删除成功与否标识
0表示删除成功
1 表示失败，失败原因见 DeleteErrInfo
100 表示running or suspend task can't be deleted失败，失败原因也会写到DeleteErrInfo里面
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlag: int
        :param _DeleteErrInfo: 删除失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteErrInfo: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._DeleteFlag = None
        self._DeleteErrInfo = None
        self._RequestId = None

    @property
    def Data(self):
        """任务删除成功与否标识
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def DeleteFlag(self):
        """任务删除成功与否标识
0表示删除成功
1 表示失败，失败原因见 DeleteErrInfo
100 表示running or suspend task can't be deleted失败，失败原因也会写到DeleteErrInfo里面
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def DeleteErrInfo(self):
        """删除失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DeleteErrInfo

    @DeleteErrInfo.setter
    def DeleteErrInfo(self, DeleteErrInfo):
        self._DeleteErrInfo = DeleteErrInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._DeleteFlag = params.get("DeleteFlag")
        self._DeleteErrInfo = params.get("DeleteErrInfo")
        self._RequestId = params.get("RequestId")


class DeleteOfflineTaskRequest(AbstractModel):
    """DeleteOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OperatorName: 操作者name
        :type OperatorName: str
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _VirtualFlag: 虚拟任务标记(跟之前调度接口保持一致默认false)
        :type VirtualFlag: bool
        """
        self._OperatorName = None
        self._ProjectId = None
        self._TaskId = None
        self._VirtualFlag = None

    @property
    def OperatorName(self):
        """操作者name
        :rtype: str
        """
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def ProjectId(self):
        """项目/工作空间id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualFlag(self):
        """虚拟任务标记(跟之前调度接口保持一致默认false)
        :rtype: bool
        """
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag


    def _deserialize(self, params):
        self._OperatorName = params.get("OperatorName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOfflineTaskResponse(AbstractModel):
    """DeleteOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectParamDsRequest(AbstractModel):
    """DeleteProjectParamDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ParamKey: 参数名
        :type ParamKey: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._ParamKey = None
        self._ProjectId = None

    @property
    def ParamKey(self):
        """参数名
        :rtype: str
        """
        return self._ParamKey

    @ParamKey.setter
    def ParamKey(self, ParamKey):
        self._ParamKey = ParamKey

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ParamKey = params.get("ParamKey")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectParamDsResponse(AbstractModel):
    """DeleteProjectParamDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果 true 删除成功
false 删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果 true 删除成功
false 删除失败
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectUsersRequest(AbstractModel):
    """DeleteProjectUsers请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _UserIds: 用户ID列表
        :type UserIds: list of str
        """
        self._ProjectId = None
        self._UserIds = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserIds(self):
        """用户ID列表
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectUsersResponse(AbstractModel):
    """DeleteProjectUsers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteResourceFileRequest(AbstractModel):
    """DeleteResourceFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        """资源id
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFileResponse(AbstractModel):
    """DeleteResourceFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 资源删除结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """资源删除结果
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceFilesRequest(AbstractModel):
    """DeleteResourceFiles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _UseStatus: 使用状态， 为ture 判断资源的使用状态，如果使用中则不能删除
        :type UseStatus: bool
        :param _ResourceIds: 资源id列表
        :type ResourceIds: list of str
        :param _FilePaths: 需要删除的资源路径列表 即资源管理中的目录结构
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._UseStatus = None
        self._ResourceIds = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UseStatus(self):
        """使用状态， 为ture 判断资源的使用状态，如果使用中则不能删除
        :rtype: bool
        """
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def ResourceIds(self):
        """资源id列表
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def FilePaths(self):
        """需要删除的资源路径列表 即资源管理中的目录结构
        :rtype: list of str
        """
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._UseStatus = params.get("UseStatus")
        self._ResourceIds = params.get("ResourceIds")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFilesResponse(AbstractModel):
    """DeleteResourceFiles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 资源批量删除结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """资源批量删除结果
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceRequest(AbstractModel):
    """DeleteResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _ResourceId: 资源ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        """资源ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceResponse(AbstractModel):
    """DeleteResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleRequest(AbstractModel):
    """DeleteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        """质量规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleResponse(AbstractModel):
    """DeleteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleTemplateRequest(AbstractModel):
    """DeleteRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Ids: 模板Id列表
        :type Ids: list of int non-negative
        """
        self._ProjectId = None
        self._Ids = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Ids(self):
        """模板Id列表
        :rtype: list of int non-negative
        """
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleTemplateResponse(AbstractModel):
    """DeleteRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskAlarmRegularRequest(AbstractModel):
    """DeleteTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 主键ID
        :type Id: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201表示实时任务，202表示离线任务)
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskId = None
        self._TaskType = None

    @property
    def Id(self):
        """主键ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        """任务类型(201表示实时任务，202表示离线任务)
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskAlarmRegularResponse(AbstractModel):
    """DeleteTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果(true表示删除成功，false表示删除失败)
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """删除结果(true表示删除成功，false表示删除失败)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskDsRequest(AbstractModel):
    """DeleteTaskDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DeleteScript: 是否删除脚本
true：删除
false：不删除
不传默认false
        :type DeleteScript: bool
        :param _OperateInform: 任务操作是否消息通知下游任务责任人true：通知
false：不通知
不传默认false
        :type OperateInform: bool
        :param _TaskId: 任务ID
和VirtualTaskId选填一个
        :type TaskId: str
        :param _VirtualTaskId: 虚拟任务id
和TaskId选填一个

        :type VirtualTaskId: str
        :param _VirtualFlag: 虚拟任务标记
true：是虚拟任务
false：不是虚拟任务
不传默认false
        :type VirtualFlag: bool
        :param _DeleteMode: 任务删除方式
true：不针对下游任务实例进行强制失败
false：针对下游任务实例进行强制失败
不传默认false

        :type DeleteMode: bool
        """
        self._ProjectId = None
        self._DeleteScript = None
        self._OperateInform = None
        self._TaskId = None
        self._VirtualTaskId = None
        self._VirtualFlag = None
        self._DeleteMode = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteScript(self):
        """是否删除脚本
true：删除
false：不删除
不传默认false
        :rtype: bool
        """
        return self._DeleteScript

    @DeleteScript.setter
    def DeleteScript(self, DeleteScript):
        self._DeleteScript = DeleteScript

    @property
    def OperateInform(self):
        """任务操作是否消息通知下游任务责任人true：通知
false：不通知
不传默认false
        :rtype: bool
        """
        return self._OperateInform

    @OperateInform.setter
    def OperateInform(self, OperateInform):
        self._OperateInform = OperateInform

    @property
    def TaskId(self):
        """任务ID
和VirtualTaskId选填一个
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualTaskId(self):
        """虚拟任务id
和TaskId选填一个

        :rtype: str
        """
        return self._VirtualTaskId

    @VirtualTaskId.setter
    def VirtualTaskId(self, VirtualTaskId):
        self._VirtualTaskId = VirtualTaskId

    @property
    def VirtualFlag(self):
        """虚拟任务标记
true：是虚拟任务
false：不是虚拟任务
不传默认false
        :rtype: bool
        """
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag

    @property
    def DeleteMode(self):
        """任务删除方式
true：不针对下游任务实例进行强制失败
false：针对下游任务实例进行强制失败
不传默认false

        :rtype: bool
        """
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeleteScript = params.get("DeleteScript")
        self._OperateInform = params.get("OperateInform")
        self._TaskId = params.get("TaskId")
        self._VirtualTaskId = params.get("VirtualTaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        self._DeleteMode = params.get("DeleteMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskDsResponse(AbstractModel):
    """DeleteTaskDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteWorkflowByIdRequest(AbstractModel):
    """DeleteWorkflowById请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DeleteMode: 删除后下游任务的处理方式，true:下游任务均正常运行 false:下游任务均运行失败
        :type DeleteMode: bool
        :param _EnableNotify: 删除任务后是否通知下游任务责任人, true:通知 false:不通知
        :type EnableNotify: bool
        """
        self._WorkflowId = None
        self._ProjectId = None
        self._DeleteMode = None
        self._EnableNotify = None

    @property
    def WorkflowId(self):
        """工作流id
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteMode(self):
        """删除后下游任务的处理方式，true:下游任务均正常运行 false:下游任务均运行失败
        :rtype: bool
        """
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        """删除任务后是否通知下游任务责任人, true:通知 false:不通知
        :rtype: bool
        """
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowByIdResponse(AbstractModel):
    """DeleteWorkflowById返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DependencyConfig(AbstractModel):
    """依赖配置

    """

    def __init__(self):
        r"""
        :param _DependConfType: 仅五种周期运行依赖配置： HOUR,DAY,WEEK,MONTH,YEAR,CRONTAB,MINUTE
        :type DependConfType: str
        :param _SubordinateCyclicType: 依赖配置从属周期类型，CURRENT_HOUR，PREVIOUS_HOUR，CURRENT_DAY，PREVIOUS_DAY，PREVIOUS_WEEK，PREVIOUS_FRIDAY，PREVIOUS_WEEKEND，CURRENT_MONTH，PREVIOUS_MONTH，PREVIOUS_END_OF_MONTH
     * PREVIOUS_BEGIN_OF_MONTH，ALL_MONTH_OF_YEAR，ALL_DAY_OF_YEAR，CURRENT_YEAR，CURRENT，CURRENT_MINUTE，PREVIOUS_MINUTE_CYCLE，PREVIOUS_HOUR_CYCLE
        :type SubordinateCyclicType: str
        :param _DependencyStrategy: WAITING，等待（默认策略）EXECUTING:执行
        :type DependencyStrategy: str
        :param _ParentTask: 父任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        :param _SonTask: 子任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SonTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        self._DependConfType = None
        self._SubordinateCyclicType = None
        self._DependencyStrategy = None
        self._ParentTask = None
        self._SonTask = None

    @property
    def DependConfType(self):
        """仅五种周期运行依赖配置： HOUR,DAY,WEEK,MONTH,YEAR,CRONTAB,MINUTE
        :rtype: str
        """
        return self._DependConfType

    @DependConfType.setter
    def DependConfType(self, DependConfType):
        self._DependConfType = DependConfType

    @property
    def SubordinateCyclicType(self):
        """依赖配置从属周期类型，CURRENT_HOUR，PREVIOUS_HOUR，CURRENT_DAY，PREVIOUS_DAY，PREVIOUS_WEEK，PREVIOUS_FRIDAY，PREVIOUS_WEEKEND，CURRENT_MONTH，PREVIOUS_MONTH，PREVIOUS_END_OF_MONTH
     * PREVIOUS_BEGIN_OF_MONTH，ALL_MONTH_OF_YEAR，ALL_DAY_OF_YEAR，CURRENT_YEAR，CURRENT，CURRENT_MINUTE，PREVIOUS_MINUTE_CYCLE，PREVIOUS_HOUR_CYCLE
        :rtype: str
        """
        return self._SubordinateCyclicType

    @SubordinateCyclicType.setter
    def SubordinateCyclicType(self, SubordinateCyclicType):
        self._SubordinateCyclicType = SubordinateCyclicType

    @property
    def DependencyStrategy(self):
        """WAITING，等待（默认策略）EXECUTING:执行
        :rtype: str
        """
        return self._DependencyStrategy

    @DependencyStrategy.setter
    def DependencyStrategy(self, DependencyStrategy):
        self._DependencyStrategy = DependencyStrategy

    @property
    def ParentTask(self):
        """父任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        return self._ParentTask

    @ParentTask.setter
    def ParentTask(self, ParentTask):
        self._ParentTask = ParentTask

    @property
    def SonTask(self):
        """子任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        return self._SonTask

    @SonTask.setter
    def SonTask(self, SonTask):
        self._SonTask = SonTask


    def _deserialize(self, params):
        self._DependConfType = params.get("DependConfType")
        self._SubordinateCyclicType = params.get("SubordinateCyclicType")
        self._DependencyStrategy = params.get("DependencyStrategy")
        if params.get("ParentTask") is not None:
            self._ParentTask = TaskInnerInfo()
            self._ParentTask._deserialize(params.get("ParentTask"))
        if params.get("SonTask") is not None:
            self._SonTask = TaskInnerInfo()
            self._SonTask._deserialize(params.get("SonTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsRequest(AbstractModel):
    """DescribeAlarmEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _Filters: 过滤条件(key可以是：AlarmLevel,AlarmIndicator,KeyWord)
        :type Filters: list of Filter
        :param _OrderFields: 排序字段（AlarmTime）
        :type OrderFields: list of OrderField
        :param _TaskType: 类型(201表示实时，202表示离线)
        :type TaskType: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """当前页
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页记录数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件(key可以是：AlarmLevel,AlarmIndicator,KeyWord)
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段（AlarmTime）
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskType(self):
        """类型(201表示实时，202表示离线)
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MonitorType(self):
        """监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :rtype: int
        """
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsResponse(AbstractModel):
    """DescribeAlarmEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmEventInfoList: 告警事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEventInfoList: list of AlarmEventInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmEventInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmEventInfoList(self):
        """告警事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AlarmEventInfo
        """
        return self._AlarmEventInfoList

    @AlarmEventInfoList.setter
    def AlarmEventInfoList(self, AlarmEventInfoList):
        self._AlarmEventInfoList = AlarmEventInfoList

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmEventInfoList") is not None:
            self._AlarmEventInfoList = []
            for item in params.get("AlarmEventInfoList"):
                obj = AlarmEventInfo()
                obj._deserialize(item)
                self._AlarmEventInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAlarmReceiverRequest(AbstractModel):
    """DescribeAlarmReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskType: 类型
        :type TaskType: int
        :param _AlarmRecipient: 告警接收人ID(逗号分隔)
        :type AlarmRecipient: str
        :param _AlarmRecipientName: 告警接收人姓名(逗号分隔)
        :type AlarmRecipientName: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        :param _MessageId: 消息ID
        :type MessageId: str
        :param _RecordId: 告警记录id
        :type RecordId: int
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._AlarmId = None
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._TaskType = None
        self._AlarmRecipient = None
        self._AlarmRecipientName = None
        self._AlarmTime = None
        self._MessageId = None
        self._RecordId = None
        self._MonitorType = None

    @property
    def AlarmId(self):
        """告警ID
        :rtype: str
        """
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def PageNumber(self):
        """当前页
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页记录数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """类型
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def AlarmRecipient(self):
        """告警接收人ID(逗号分隔)
        :rtype: str
        """
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientName(self):
        """告警接收人姓名(逗号分隔)
        :rtype: str
        """
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def AlarmTime(self):
        """告警时间
        :rtype: str
        """
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def MessageId(self):
        """消息ID
        :rtype: str
        """
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def RecordId(self):
        """告警记录id
        :rtype: int
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def MonitorType(self):
        """监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :rtype: int
        """
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._AlarmTime = params.get("AlarmTime")
        self._MessageId = params.get("MessageId")
        self._RecordId = params.get("RecordId")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmReceiverResponse(AbstractModel):
    """DescribeAlarmReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmReceiverInfoList: 告警接收人列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmReceiverInfoList: list of AlarmReceiverInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmReceiverInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmReceiverInfoList(self):
        """告警接收人列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AlarmReceiverInfo
        """
        return self._AlarmReceiverInfoList

    @AlarmReceiverInfoList.setter
    def AlarmReceiverInfoList(self, AlarmReceiverInfoList):
        self._AlarmReceiverInfoList = AlarmReceiverInfoList

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmReceiverInfoList") is not None:
            self._AlarmReceiverInfoList = []
            for item in params.get("AlarmReceiverInfoList"):
                obj = AlarmReceiverInfo()
                obj._deserialize(item)
                self._AlarmReceiverInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAllByFolderNewRequest(AbstractModel):
    """DescribeAllByFolderNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Folder: 文件夹属性
        :type Folder: :class:`tencentcloud.wedata.v20210820.models.FolderOpsDto`
        :param _Workflows: 工作流列表
        :type Workflows: list of WorkflowCanvasOpsDto
        :param _TargetFolderId: 目标文件id
        :type TargetFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _ParentsFolderId: 父文件id
        :type ParentsFolderId: str
        :param _IsAddWorkflow: 拉取文件夹列表
        :type IsAddWorkflow: str
        :param _TaskStates: 任务状态
        :type TaskStates: list of str
        :param _FindType: 搜索类型
        :type FindType: str
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Folder = None
        self._Workflows = None
        self._TargetFolderId = None
        self._KeyWords = None
        self._ParentsFolderId = None
        self._IsAddWorkflow = None
        self._TaskStates = None
        self._FindType = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Folder(self):
        """文件夹属性
        :rtype: :class:`tencentcloud.wedata.v20210820.models.FolderOpsDto`
        """
        return self._Folder

    @Folder.setter
    def Folder(self, Folder):
        self._Folder = Folder

    @property
    def Workflows(self):
        """工作流列表
        :rtype: list of WorkflowCanvasOpsDto
        """
        return self._Workflows

    @Workflows.setter
    def Workflows(self, Workflows):
        self._Workflows = Workflows

    @property
    def TargetFolderId(self):
        """目标文件id
        :rtype: str
        """
        return self._TargetFolderId

    @TargetFolderId.setter
    def TargetFolderId(self, TargetFolderId):
        self._TargetFolderId = TargetFolderId

    @property
    def KeyWords(self):
        """关键字
        :rtype: str
        """
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def ParentsFolderId(self):
        """父文件id
        :rtype: str
        """
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def IsAddWorkflow(self):
        """拉取文件夹列表
        :rtype: str
        """
        return self._IsAddWorkflow

    @IsAddWorkflow.setter
    def IsAddWorkflow(self, IsAddWorkflow):
        self._IsAddWorkflow = IsAddWorkflow

    @property
    def TaskStates(self):
        """任务状态
        :rtype: list of str
        """
        return self._TaskStates

    @TaskStates.setter
    def TaskStates(self, TaskStates):
        self._TaskStates = TaskStates

    @property
    def FindType(self):
        """搜索类型
        :rtype: str
        """
        return self._FindType

    @FindType.setter
    def FindType(self, FindType):
        self._FindType = FindType

    @property
    def OptType(self):
        """访问类型
        :rtype: str
        """
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        """操作者名称
        :rtype: str
        """
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        """操作者id
        :rtype: str
        """
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        """项目标志
        :rtype: str
        """
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        """索引页码
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        """页面大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        """数据总数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        """基础请求信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        """
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        """是否计算总数
        :rtype: bool
        """
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Folder") is not None:
            self._Folder = FolderOpsDto()
            self._Folder._deserialize(params.get("Folder"))
        if params.get("Workflows") is not None:
            self._Workflows = []
            for item in params.get("Workflows"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Workflows.append(obj)
        self._TargetFolderId = params.get("TargetFolderId")
        self._KeyWords = params.get("KeyWords")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._IsAddWorkflow = params.get("IsAddWorkflow")
        self._TaskStates = params.get("TaskStates")
        self._FindType = params.get("FindType")
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllByFolderNewResponse(AbstractModel):
    """DescribeAllByFolderNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionFolderOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果集
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CollectionFolderOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionFolderOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApply(AbstractModel):
    """申请列表

    """

    def __init__(self):
        r"""
        :param _Rows: 申请列表详情
        :type Rows: list of Apply
        :param _TotalPageNumber: 总分页页码
        :type TotalPageNumber: int
        :param _TotalCount: 总个数
        :type TotalCount: int
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        """
        self._Rows = None
        self._TotalPageNumber = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Rows(self):
        """申请列表详情
        :rtype: list of Apply
        """
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalPageNumber(self):
        """总分页页码
        :rtype: int
        """
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber

    @property
    def TotalCount(self):
        """总个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = Apply()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalPageNumber = params.get("TotalPageNumber")
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListRequest(AbstractModel):
    """DescribeApproveList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApproveClassification: 审批分类key
        :type ApproveClassification: str
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _PageNumber: 分页数
        :type PageNumber: int
        :param _Filters: 自定义条件查询
        :type Filters: list of FilterOptional
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderFieldOptional
        """
        self._ApproveClassification = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None
        self._OrderFields = None

    @property
    def ApproveClassification(self):
        """审批分类key
        :rtype: str
        """
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        """分页数
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        """自定义条件查询
        :rtype: list of FilterOptional
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderFieldOptional
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ApproveClassification = params.get("ApproveClassification")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterOptional()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderFieldOptional()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListResponse(AbstractModel):
    """DescribeApproveList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 待审批列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeApply`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """待审批列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DescribeApply`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApply()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApproveTypeListRequest(AbstractModel):
    """DescribeApproveTypeList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Classification: 类型key
        :type Classification: str
        """
        self._Classification = None

    @property
    def Classification(self):
        """类型key
        :rtype: str
        """
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveTypeListResponse(AbstractModel):
    """DescribeApproveTypeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 获取审批分类列表
        :type Data: list of ApproveType
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """获取审批分类列表
        :rtype: list of ApproveType
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ApproveType()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBatchOperateTaskDTO(AbstractModel):
    """批量操作任务列表

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _WorkflowId: 工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _WorkflowName: 工作流名
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowName: str
        :param _Status: 状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _TaskTypeId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeId: int
        :param _TaskTypeDesc: 任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeDesc: str
        :param _FolderName: 文件夹名
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderName: str
        :param _FolderId: 文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderId: str
        :param _InCharge: 负责人
注意：此字段可能返回 null，表示取不到有效值。
        :type InCharge: str
        :param _Submit: 是否提交
注意：此字段可能返回 null，表示取不到有效值。
        :type Submit: int
        :param _DataEngine: 引擎：
presto\SparkJob\SparkSql
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngine: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _CreateTime: 创造时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _CycleUnit: 周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleUnit: str
        :param _ScheduleDesc: 调度计划
注意：此字段可能返回 null，表示取不到有效值。
        :type ScheduleDesc: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: str
        """
        self._TaskId = None
        self._TaskName = None
        self._WorkflowId = None
        self._WorkflowName = None
        self._Status = None
        self._TaskTypeId = None
        self._TaskTypeDesc = None
        self._FolderName = None
        self._FolderId = None
        self._InCharge = None
        self._Submit = None
        self._DataEngine = None
        self._UpdateTime = None
        self._CreateTime = None
        self._CycleUnit = None
        self._ScheduleDesc = None
        self._DatasourceId = None
        self._DatasourceType = None

    @property
    def TaskId(self):
        """任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """任务名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def WorkflowId(self):
        """工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        """工作流名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Status(self):
        """状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskTypeId(self):
        """任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TaskTypeDesc(self):
        """任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskTypeDesc

    @TaskTypeDesc.setter
    def TaskTypeDesc(self, TaskTypeDesc):
        self._TaskTypeDesc = TaskTypeDesc

    @property
    def FolderName(self):
        """文件夹名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def FolderId(self):
        """文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def InCharge(self):
        """负责人
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def Submit(self):
        """是否提交
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Submit

    @Submit.setter
    def Submit(self, Submit):
        self._Submit = Submit

    @property
    def DataEngine(self):
        """引擎：
presto\SparkJob\SparkSql
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        """创造时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CycleUnit(self):
        """周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def ScheduleDesc(self):
        """调度计划
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScheduleDesc

    @ScheduleDesc.setter
    def ScheduleDesc(self, ScheduleDesc):
        self._ScheduleDesc = ScheduleDesc

    @property
    def DatasourceId(self):
        """数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceType(self):
        """数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        self._Status = params.get("Status")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TaskTypeDesc = params.get("TaskTypeDesc")
        self._FolderName = params.get("FolderName")
        self._FolderId = params.get("FolderId")
        self._InCharge = params.get("InCharge")
        self._Submit = params.get("Submit")
        self._DataEngine = params.get("DataEngine")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        self._CycleUnit = params.get("CycleUnit")
        self._ScheduleDesc = params.get("ScheduleDesc")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskPage(AbstractModel):
    """批量操作任务列表分页

    """

    def __init__(self):
        r"""
        :param _PageCount: 总页码数
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _Items: 内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of DescribeBatchOperateTaskDTO
        :param _TotalCount: 总个数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._PageCount = None
        self._Items = None
        self._TotalCount = None

    @property
    def PageCount(self):
        """总页码数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def Items(self):
        """内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeBatchOperateTaskDTO
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        """总个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._PageCount = params.get("PageCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = DescribeBatchOperateTaskDTO()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskRequest(AbstractModel):
    """DescribeBatchOperateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Page: 页码
        :type Page: str
        :param _Size: 页号
        :type Size: str
        :param _StatusList: 状态列表
草稿：'NS'，'N','P','R'
运行：''Y'
停止：'F'
冻结：'O'
停止中：'T'
        :type StatusList: list of str
        :param _OwnerNameList: 责任人名列表
        :type OwnerNameList: list of str
        :param _WorkflowIdList: 工作流列表
        :type WorkflowIdList: list of str
        :param _TaskNameFilter: 任务名称搜索
        :type TaskNameFilter: str
        :param _TaskTypeList: 任务类型列表
        :type TaskTypeList: list of str
        :param _FordIdList: 文件夹列表
        :type FordIdList: list of str
        :param _TaskIdFilter: 任务Id搜索
        :type TaskIdFilter: str
        :param _OwnerNameFilter: 责任人搜索
        :type OwnerNameFilter: str
        :param _SortItem: 排序字段：
UpdateTime
CreateTime
        :type SortItem: str
        :param _SortType: asc:升序
desc:降序
        :type SortType: str
        :param _DataEngineList: 引擎类型列表：三种
SparkJob
SparkSql
presto
        :type DataEngineList: list of str
        :param _UserId: 操作人名
        :type UserId: str
        :param _OwnerId: 1
        :type OwnerId: str
        :param _TenantId: 1
        :type TenantId: str
        :param _DatasourceIdList: 数据源ID列表
        :type DatasourceIdList: list of str
        :param _DatasourceTypeList: 数据源类型列表
        :type DatasourceTypeList: list of str
        :param _CycleUnitList: 调度单位类型列表
        :type CycleUnitList: list of str
        :param _CanSubmit: 是否筛选出可提交的任务
        :type CanSubmit: bool
        """
        self._ProjectId = None
        self._Page = None
        self._Size = None
        self._StatusList = None
        self._OwnerNameList = None
        self._WorkflowIdList = None
        self._TaskNameFilter = None
        self._TaskTypeList = None
        self._FordIdList = None
        self._TaskIdFilter = None
        self._OwnerNameFilter = None
        self._SortItem = None
        self._SortType = None
        self._DataEngineList = None
        self._UserId = None
        self._OwnerId = None
        self._TenantId = None
        self._DatasourceIdList = None
        self._DatasourceTypeList = None
        self._CycleUnitList = None
        self._CanSubmit = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Page(self):
        """页码
        :rtype: str
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        """页号
        :rtype: str
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def StatusList(self):
        """状态列表
草稿：'NS'，'N','P','R'
运行：''Y'
停止：'F'
冻结：'O'
停止中：'T'
        :rtype: list of str
        """
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def OwnerNameList(self):
        """责任人名列表
        :rtype: list of str
        """
        return self._OwnerNameList

    @OwnerNameList.setter
    def OwnerNameList(self, OwnerNameList):
        self._OwnerNameList = OwnerNameList

    @property
    def WorkflowIdList(self):
        """工作流列表
        :rtype: list of str
        """
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def TaskNameFilter(self):
        """任务名称搜索
        :rtype: str
        """
        return self._TaskNameFilter

    @TaskNameFilter.setter
    def TaskNameFilter(self, TaskNameFilter):
        self._TaskNameFilter = TaskNameFilter

    @property
    def TaskTypeList(self):
        """任务类型列表
        :rtype: list of str
        """
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def FordIdList(self):
        """文件夹列表
        :rtype: list of str
        """
        return self._FordIdList

    @FordIdList.setter
    def FordIdList(self, FordIdList):
        self._FordIdList = FordIdList

    @property
    def TaskIdFilter(self):
        """任务Id搜索
        :rtype: str
        """
        return self._TaskIdFilter

    @TaskIdFilter.setter
    def TaskIdFilter(self, TaskIdFilter):
        self._TaskIdFilter = TaskIdFilter

    @property
    def OwnerNameFilter(self):
        """责任人搜索
        :rtype: str
        """
        return self._OwnerNameFilter

    @OwnerNameFilter.setter
    def OwnerNameFilter(self, OwnerNameFilter):
        self._OwnerNameFilter = OwnerNameFilter

    @property
    def SortItem(self):
        """排序字段：
UpdateTime
CreateTime
        :rtype: str
        """
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        """asc:升序
desc:降序
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def DataEngineList(self):
        """引擎类型列表：三种
SparkJob
SparkSql
presto
        :rtype: list of str
        """
        return self._DataEngineList

    @DataEngineList.setter
    def DataEngineList(self, DataEngineList):
        self._DataEngineList = DataEngineList

    @property
    def UserId(self):
        """操作人名
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def OwnerId(self):
        """1
        :rtype: str
        """
        return self._OwnerId

    @OwnerId.setter
    def OwnerId(self, OwnerId):
        self._OwnerId = OwnerId

    @property
    def TenantId(self):
        """1
        :rtype: str
        """
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def DatasourceIdList(self):
        """数据源ID列表
        :rtype: list of str
        """
        return self._DatasourceIdList

    @DatasourceIdList.setter
    def DatasourceIdList(self, DatasourceIdList):
        self._DatasourceIdList = DatasourceIdList

    @property
    def DatasourceTypeList(self):
        """数据源类型列表
        :rtype: list of str
        """
        return self._DatasourceTypeList

    @DatasourceTypeList.setter
    def DatasourceTypeList(self, DatasourceTypeList):
        self._DatasourceTypeList = DatasourceTypeList

    @property
    def CycleUnitList(self):
        """调度单位类型列表
        :rtype: list of str
        """
        return self._CycleUnitList

    @CycleUnitList.setter
    def CycleUnitList(self, CycleUnitList):
        self._CycleUnitList = CycleUnitList

    @property
    def CanSubmit(self):
        """是否筛选出可提交的任务
        :rtype: bool
        """
        return self._CanSubmit

    @CanSubmit.setter
    def CanSubmit(self, CanSubmit):
        self._CanSubmit = CanSubmit


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        self._StatusList = params.get("StatusList")
        self._OwnerNameList = params.get("OwnerNameList")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._TaskNameFilter = params.get("TaskNameFilter")
        self._TaskTypeList = params.get("TaskTypeList")
        self._FordIdList = params.get("FordIdList")
        self._TaskIdFilter = params.get("TaskIdFilter")
        self._OwnerNameFilter = params.get("OwnerNameFilter")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._DataEngineList = params.get("DataEngineList")
        self._UserId = params.get("UserId")
        self._OwnerId = params.get("OwnerId")
        self._TenantId = params.get("TenantId")
        self._DatasourceIdList = params.get("DatasourceIdList")
        self._DatasourceTypeList = params.get("DatasourceTypeList")
        self._CycleUnitList = params.get("CycleUnitList")
        self._CanSubmit = params.get("CanSubmit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskResponse(AbstractModel):
    """DescribeBatchOperateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBatchOperateTaskPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DescribeBatchOperateTaskPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBatchOperateTaskPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeColumnLineageRequest(AbstractModel):
    """DescribeColumnLineage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 字段信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.ColumnLineageInfo`
        :param _InputDepth: 单次查询入度
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of RecordField
        :param _IgnoreTemp: 是否过滤临时表 默认值为true
        :type IgnoreTemp: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None

    @property
    def Direction(self):
        """查询方向，INPUT,OUTPUT,BOTH枚举值
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        """字段信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ColumnLineageInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        """单次查询入度
        :rtype: int
        """
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        """单次查询出度
        :rtype: int
        """
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        """额外参数（传递调用方信息）
        :rtype: list of RecordField
        """
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        """是否过滤临时表 默认值为true
        :rtype: bool
        """
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = ColumnLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnLineageResponse(AbstractModel):
    """DescribeColumnLineage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnAggregationLineage: 字段血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnAggregationLineage: :class:`tencentcloud.wedata.v20210820.models.ColumnAggregationLineage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnAggregationLineage = None
        self._RequestId = None

    @property
    def ColumnAggregationLineage(self):
        """字段血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ColumnAggregationLineage`
        """
        return self._ColumnAggregationLineage

    @ColumnAggregationLineage.setter
    def ColumnAggregationLineage(self, ColumnAggregationLineage):
        self._ColumnAggregationLineage = ColumnAggregationLineage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnAggregationLineage") is not None:
            self._ColumnAggregationLineage = ColumnAggregationLineage()
            self._ColumnAggregationLineage._deserialize(params.get("ColumnAggregationLineage"))
        self._RequestId = params.get("RequestId")


class DescribeColumnsMetaRequest(AbstractModel):
    """DescribeColumnsMeta请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页大小
        :type PageSize: int
        :param _FilterSet: 过滤器
        :type FilterSet: list of Filter
        :param _OrderFieldSet: 排序字段
        :type OrderFieldSet: list of OrderField
        :param _IsPartitionQuery: 是否查询分区字段，默认false
        :type IsPartitionQuery: bool
        :param _ComplianceId: 合规组ID
        :type ComplianceId: int
        """
        self._TableId = None
        self._PageNumber = None
        self._PageSize = None
        self._FilterSet = None
        self._OrderFieldSet = None
        self._IsPartitionQuery = None
        self._ComplianceId = None

    @property
    def TableId(self):
        """表ID
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FilterSet(self):
        """过滤器
        :rtype: list of Filter
        """
        return self._FilterSet

    @FilterSet.setter
    def FilterSet(self, FilterSet):
        self._FilterSet = FilterSet

    @property
    def OrderFieldSet(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFieldSet

    @OrderFieldSet.setter
    def OrderFieldSet(self, OrderFieldSet):
        self._OrderFieldSet = OrderFieldSet

    @property
    def IsPartitionQuery(self):
        """是否查询分区字段，默认false
        :rtype: bool
        """
        return self._IsPartitionQuery

    @IsPartitionQuery.setter
    def IsPartitionQuery(self, IsPartitionQuery):
        self._IsPartitionQuery = IsPartitionQuery

    @property
    def ComplianceId(self):
        """合规组ID
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("FilterSet") is not None:
            self._FilterSet = []
            for item in params.get("FilterSet"):
                obj = Filter()
                obj._deserialize(item)
                self._FilterSet.append(obj)
        if params.get("OrderFieldSet") is not None:
            self._OrderFieldSet = []
            for item in params.get("OrderFieldSet"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFieldSet.append(obj)
        self._IsPartitionQuery = params.get("IsPartitionQuery")
        self._ComplianceId = params.get("ComplianceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnsMetaResponse(AbstractModel):
    """DescribeColumnsMeta返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnMetaSet: 分页返回的
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnMetaSet: list of ColumnMeta
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnMetaSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnMetaSet(self):
        """分页返回的
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ColumnMeta
        """
        return self._ColumnMetaSet

    @ColumnMetaSet.setter
    def ColumnMetaSet(self, ColumnMetaSet):
        self._ColumnMetaSet = ColumnMetaSet

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnMetaSet") is not None:
            self._ColumnMetaSet = []
            for item in params.get("ColumnMetaSet"):
                obj = ColumnMeta()
                obj._deserialize(item)
                self._ColumnMetaSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataCheckStatRequest(AbstractModel):
    """DescribeDataCheckStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        """开始时间，时间戳到秒
        :rtype: str
        """
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        """结束时间，时间戳到秒
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataCheckStatResponse(AbstractModel):
    """DescribeDataCheckStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataCheckStat`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DataCheckStat`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataCheckStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataServicePublishedApiDetailRequest(AbstractModel):
    """DescribeDataServicePublishedApiDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 服务Id
        :type Id: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Id = None
        self._ProjectId = None

    @property
    def Id(self):
        """服务Id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataServicePublishedApiDetailResp(AbstractModel):
    """查询数据服务API的发布态信息详情出参

    """

    def __init__(self):
        r"""
        :param _ApiName: 服务Api名称
        :type ApiName: str
        :param _PathUrl: 服务请求Path
        :type PathUrl: str
        :param _OwnerName: 服务责任人名称
        :type OwnerName: str
        :param _RequestType: 服务请求方式
        :type RequestType: str
        :param _ApiTagNames: 服务标签名称集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiTagNames: str
        :param _ApiDescription: 服务描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiDescription: str
        :param _RequestExample: 服务请求返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestExample: str
        :param _RequestSuccess: 服务请求成功返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestSuccess: str
        :param _RequestError: 服务请求失败返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestError: str
        :param _RequestParam: 服务请求参数列表
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestParam: list of DataServiceRequestParam
        :param _ResponseParam: 服务响应参数列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ResponseParam: list of DataServiceResponseParam
        :param _MaxAllowQps: 最大qps
        :type MaxAllowQps: int
        :param _MaxAllowPageSize: 最大记录数
        :type MaxAllowPageSize: int
        :param _TimeoutPeriod: 超时时间，单位ms
        :type TimeoutPeriod: int
        :param _ApiId: ApiId
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiId: str
        :param _AuthType: 0:免认证 1:应用认证
        :type AuthType: int
        :param _GatewayApiUrl: 请求地址
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayApiUrl: str
        :param _ApiStatus: 服务Api状态 1:已上线  3:已下线
注意：此字段可能返回 null，表示取不到有效值。
        :type ApiStatus: int
        """
        self._ApiName = None
        self._PathUrl = None
        self._OwnerName = None
        self._RequestType = None
        self._ApiTagNames = None
        self._ApiDescription = None
        self._RequestExample = None
        self._RequestSuccess = None
        self._RequestError = None
        self._RequestParam = None
        self._ResponseParam = None
        self._MaxAllowQps = None
        self._MaxAllowPageSize = None
        self._TimeoutPeriod = None
        self._ApiId = None
        self._AuthType = None
        self._GatewayApiUrl = None
        self._ApiStatus = None

    @property
    def ApiName(self):
        """服务Api名称
        :rtype: str
        """
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def PathUrl(self):
        """服务请求Path
        :rtype: str
        """
        return self._PathUrl

    @PathUrl.setter
    def PathUrl(self, PathUrl):
        self._PathUrl = PathUrl

    @property
    def OwnerName(self):
        """服务责任人名称
        :rtype: str
        """
        return self._OwnerName

    @OwnerName.setter
    def OwnerName(self, OwnerName):
        self._OwnerName = OwnerName

    @property
    def RequestType(self):
        """服务请求方式
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def ApiTagNames(self):
        """服务标签名称集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiTagNames

    @ApiTagNames.setter
    def ApiTagNames(self, ApiTagNames):
        self._ApiTagNames = ApiTagNames

    @property
    def ApiDescription(self):
        """服务描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiDescription

    @ApiDescription.setter
    def ApiDescription(self, ApiDescription):
        self._ApiDescription = ApiDescription

    @property
    def RequestExample(self):
        """服务请求返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestExample

    @RequestExample.setter
    def RequestExample(self, RequestExample):
        self._RequestExample = RequestExample

    @property
    def RequestSuccess(self):
        """服务请求成功返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestSuccess

    @RequestSuccess.setter
    def RequestSuccess(self, RequestSuccess):
        self._RequestSuccess = RequestSuccess

    @property
    def RequestError(self):
        """服务请求失败返回示例
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestError

    @RequestError.setter
    def RequestError(self, RequestError):
        self._RequestError = RequestError

    @property
    def RequestParam(self):
        """服务请求参数列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataServiceRequestParam
        """
        return self._RequestParam

    @RequestParam.setter
    def RequestParam(self, RequestParam):
        self._RequestParam = RequestParam

    @property
    def ResponseParam(self):
        """服务响应参数列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataServiceResponseParam
        """
        return self._ResponseParam

    @ResponseParam.setter
    def ResponseParam(self, ResponseParam):
        self._ResponseParam = ResponseParam

    @property
    def MaxAllowQps(self):
        """最大qps
        :rtype: int
        """
        return self._MaxAllowQps

    @MaxAllowQps.setter
    def MaxAllowQps(self, MaxAllowQps):
        self._MaxAllowQps = MaxAllowQps

    @property
    def MaxAllowPageSize(self):
        """最大记录数
        :rtype: int
        """
        return self._MaxAllowPageSize

    @MaxAllowPageSize.setter
    def MaxAllowPageSize(self, MaxAllowPageSize):
        self._MaxAllowPageSize = MaxAllowPageSize

    @property
    def TimeoutPeriod(self):
        """超时时间，单位ms
        :rtype: int
        """
        return self._TimeoutPeriod

    @TimeoutPeriod.setter
    def TimeoutPeriod(self, TimeoutPeriod):
        self._TimeoutPeriod = TimeoutPeriod

    @property
    def ApiId(self):
        """ApiId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def AuthType(self):
        """0:免认证 1:应用认证
        :rtype: int
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def GatewayApiUrl(self):
        """请求地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayApiUrl

    @GatewayApiUrl.setter
    def GatewayApiUrl(self, GatewayApiUrl):
        self._GatewayApiUrl = GatewayApiUrl

    @property
    def ApiStatus(self):
        """服务Api状态 1:已上线  3:已下线
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus


    def _deserialize(self, params):
        self._ApiName = params.get("ApiName")
        self._PathUrl = params.get("PathUrl")
        self._OwnerName = params.get("OwnerName")
        self._RequestType = params.get("RequestType")
        self._ApiTagNames = params.get("ApiTagNames")
        self._ApiDescription = params.get("ApiDescription")
        self._RequestExample = params.get("RequestExample")
        self._RequestSuccess = params.get("RequestSuccess")
        self._RequestError = params.get("RequestError")
        if params.get("RequestParam") is not None:
            self._RequestParam = []
            for item in params.get("RequestParam"):
                obj = DataServiceRequestParam()
                obj._deserialize(item)
                self._RequestParam.append(obj)
        if params.get("ResponseParam") is not None:
            self._ResponseParam = []
            for item in params.get("ResponseParam"):
                obj = DataServiceResponseParam()
                obj._deserialize(item)
                self._ResponseParam.append(obj)
        self._MaxAllowQps = params.get("MaxAllowQps")
        self._MaxAllowPageSize = params.get("MaxAllowPageSize")
        self._TimeoutPeriod = params.get("TimeoutPeriod")
        self._ApiId = params.get("ApiId")
        self._AuthType = params.get("AuthType")
        self._GatewayApiUrl = params.get("GatewayApiUrl")
        self._ApiStatus = params.get("ApiStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataServicePublishedApiDetailResponse(AbstractModel):
    """DescribeDataServicePublishedApiDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 服务详情
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeDataServicePublishedApiDetailResp`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """服务详情
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DescribeDataServicePublishedApiDetailResp`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeDataServicePublishedApiDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataServicePublishedApiListRequest(AbstractModel):
    """DescribeDataServicePublishedApiList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页大小
        :type PageSize: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Filters: 查询参数
        :type Filters: :class:`tencentcloud.wedata.v20210820.models.DataServicePublishedApiListFilter`
        :param _OrderFields: 排序配置
        :type OrderFields: list of DataServiceRequestListOrder
        """
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Filters(self):
        """查询参数
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DataServicePublishedApiListFilter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序配置
        :rtype: list of DataServiceRequestListOrder
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("Filters") is not None:
            self._Filters = DataServicePublishedApiListFilter()
            self._Filters._deserialize(params.get("Filters"))
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = DataServiceRequestListOrder()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataServicePublishedApiListResp(AbstractModel):
    """获取数据服务API的发布态信息列表响应内容

    """

    def __init__(self):
        r"""
        :param _Id: 服务id
        :type Id: str
        :param _ApiName: 服务Api名称
        :type ApiName: str
        :param _ApiFolderName: 所属目录名称
        :type ApiFolderName: str
        :param _ApiTagNames: 服务Api标签名称集合
        :type ApiTagNames: str
        :param _OwnerName: 服务负责人
        :type OwnerName: str
        :param _CreateTime: 服务创建时间
        :type CreateTime: str
        :param _ApiId: Api的id
        :type ApiId: str
        :param _AuthType: 服务Api认证方式 0:免认证 1:应用认证
        :type AuthType: int
        :param _ApiStatus: 服务Api状态 0:创建 1:已上线 2:已删除 3:已下线
        :type ApiStatus: int
        :param _ConfigType: 配置方式 0:向导、1、脚本、2、注册Api
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigType: int
        :param _ModifyTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        """
        self._Id = None
        self._ApiName = None
        self._ApiFolderName = None
        self._ApiTagNames = None
        self._OwnerName = None
        self._CreateTime = None
        self._ApiId = None
        self._AuthType = None
        self._ApiStatus = None
        self._ConfigType = None
        self._ModifyTime = None

    @property
    def Id(self):
        """服务id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ApiName(self):
        """服务Api名称
        :rtype: str
        """
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def ApiFolderName(self):
        """所属目录名称
        :rtype: str
        """
        return self._ApiFolderName

    @ApiFolderName.setter
    def ApiFolderName(self, ApiFolderName):
        self._ApiFolderName = ApiFolderName

    @property
    def ApiTagNames(self):
        """服务Api标签名称集合
        :rtype: str
        """
        return self._ApiTagNames

    @ApiTagNames.setter
    def ApiTagNames(self, ApiTagNames):
        self._ApiTagNames = ApiTagNames

    @property
    def OwnerName(self):
        """服务负责人
        :rtype: str
        """
        return self._OwnerName

    @OwnerName.setter
    def OwnerName(self, OwnerName):
        self._OwnerName = OwnerName

    @property
    def CreateTime(self):
        """服务创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ApiId(self):
        """Api的id
        :rtype: str
        """
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def AuthType(self):
        """服务Api认证方式 0:免认证 1:应用认证
        :rtype: int
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def ApiStatus(self):
        """服务Api状态 0:创建 1:已上线 2:已删除 3:已下线
        :rtype: int
        """
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def ConfigType(self):
        """配置方式 0:向导、1、脚本、2、注册Api
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def ModifyTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ApiName = params.get("ApiName")
        self._ApiFolderName = params.get("ApiFolderName")
        self._ApiTagNames = params.get("ApiTagNames")
        self._OwnerName = params.get("OwnerName")
        self._CreateTime = params.get("CreateTime")
        self._ApiId = params.get("ApiId")
        self._AuthType = params.get("AuthType")
        self._ApiStatus = params.get("ApiStatus")
        self._ConfigType = params.get("ConfigType")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataServicePublishedApiListResponse(AbstractModel):
    """DescribeDataServicePublishedApiList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _DataSet: 服务列表
        :type DataSet: list of DescribeDataServicePublishedApiListResp
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DataSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataSet(self):
        """服务列表
        :rtype: list of DescribeDataServicePublishedApiListResp
        """
        return self._DataSet

    @DataSet.setter
    def DataSet(self, DataSet):
        self._DataSet = DataSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataSet") is not None:
            self._DataSet = []
            for item in params.get("DataSet"):
                obj = DescribeDataServicePublishedApiListResp()
                obj._deserialize(item)
                self._DataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceInfoListRequest(AbstractModel):
    """DescribeDataSourceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 页数
        :type PageSize: int
        :param _Filters: 过滤条件（暂不支持）
        :type Filters: :class:`tencentcloud.wedata.v20210820.models.Filter`
        :param _OrderFields: 排序配置
        :type OrderFields: :class:`tencentcloud.wedata.v20210820.models.OrderField`
        :param _Type: 数据源类型，必选（如MYSQL、DLC等）
        :type Type: str
        :param _DatasourceName: 数据源名称过滤
        :type DatasourceName: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._Type = None
        self._DatasourceName = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """页数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件（暂不支持）
        :rtype: :class:`tencentcloud.wedata.v20210820.models.Filter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序配置
        :rtype: :class:`tencentcloud.wedata.v20210820.models.OrderField`
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Type(self):
        """数据源类型，必选（如MYSQL、DLC等）
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DatasourceName(self):
        """数据源名称过滤
        :rtype: str
        """
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        if params.get("OrderFields") is not None:
            self._OrderFields = OrderField()
            self._OrderFields._deserialize(params.get("OrderFields"))
        self._Type = params.get("Type")
        self._DatasourceName = params.get("DatasourceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceInfoListResponse(AbstractModel):
    """DescribeDataSourceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数。
        :type TotalCount: int
        :param _DatasourceSet: 数据源信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceSet: list of DatasourceBaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DatasourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """总条数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DatasourceSet(self):
        """数据源信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DatasourceBaseInfo
        """
        return self._DatasourceSet

    @DatasourceSet.setter
    def DatasourceSet(self, DatasourceSet):
        self._DatasourceSet = DatasourceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DatasourceSet") is not None:
            self._DatasourceSet = []
            for item in params.get("DatasourceSet"):
                obj = DatasourceBaseInfo()
                obj._deserialize(item)
                self._DatasourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceListRequest(AbstractModel):
    """DescribeDataSourceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 返回数量
        :type PageSize: int
        :param _OrderFields: 排序配置
        :type OrderFields: list of OrderField
        :param _Filters: 可选过滤条件，Filter可选配置(参考): "Name": { "type": "string", "description": "数据源名称" }, "Type": { "type": "string", "description": "类型" }, "ClusterId": { "type": "string", "description": "集群id" }, "CategoryId": { "type": "string", "description": "分类，项目或空间id" }
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """返回数量
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderFields(self):
        """排序配置
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        """可选过滤条件，Filter可选配置(参考): "Name": { "type": "string", "description": "数据源名称" }, "Type": { "type": "string", "description": "类型" }, "ClusterId": { "type": "string", "description": "集群id" }, "CategoryId": { "type": "string", "description": "分类，项目或空间id" }
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceListResponse(AbstractModel):
    """DescribeDataSourceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfoPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDatabaseInfoListRequest(AbstractModel):
    """DescribeDatabaseInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        :param _ConnectionType: 连接类型
        :type ConnectionType: str
        """
        self._Filters = None
        self._ConnectionType = None

    @property
    def Filters(self):
        """过滤参数
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        """连接类型
        :rtype: str
        """
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseInfoListResponse(AbstractModel):
    """DescribeDatabaseInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseInfo: 数据库列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseInfo: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseInfo = None
        self._RequestId = None

    @property
    def DatabaseInfo(self):
        """数据库列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DatabaseInfo
        """
        return self._DatabaseInfo

    @DatabaseInfo.setter
    def DatabaseInfo(self, DatabaseInfo):
        self._DatabaseInfo = DatabaseInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseInfo") is not None:
            self._DatabaseInfo = []
            for item in params.get("DatabaseInfo"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._DatabaseInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabaseMetasRequest(AbstractModel):
    """DescribeDatabaseMetas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤字段，projectIds/msTypes/createTime/modifiedTime
        :type Filters: list of Filter
        :param _OrderFields: 排序字段，如name
        :type OrderFields: list of OrderField
        :param _PageSize: pagesize
        :type PageSize: int
        :param _PageNumber: pageNumber
        :type PageNumber: int
        """
        self._Filters = None
        self._OrderFields = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def Filters(self):
        """过滤字段，projectIds/msTypes/createTime/modifiedTime
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段，如name
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def PageSize(self):
        """pagesize
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        """pageNumber
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseMetasResponse(AbstractModel):
    """DescribeDatabaseMetas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseMeta: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseMeta: list of DatabaseMeta
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseMeta = None
        self._RequestId = None

    @property
    def DatabaseMeta(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DatabaseMeta
        """
        return self._DatabaseMeta

    @DatabaseMeta.setter
    def DatabaseMeta(self, DatabaseMeta):
        self._DatabaseMeta = DatabaseMeta

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseMeta") is not None:
            self._DatabaseMeta = []
            for item in params.get("DatabaseMeta"):
                obj = DatabaseMeta()
                obj._deserialize(item)
                self._DatabaseMeta.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatasourceRequest(AbstractModel):
    """DescribeDatasource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 对象唯一ID
        :type Id: int
        :param _Env: production：生产，development开发
        :type Env: str
        """
        self._Id = None
        self._Env = None

    @property
    def Id(self):
        """对象唯一ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Env(self):
        """production：生产，development开发
        :rtype: str
        """
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Env = params.get("Env")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatasourceResponse(AbstractModel):
    """DescribeDatasource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """数据源对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependOpsTasksRequest(AbstractModel):
    """DescribeDependOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _Deep: 上游/下游层级1-6级
        :type Deep: int
        :param _Up: 1: 表示查询上游节点；0:表示查询下游节点；2：表示查询上游和下游节点
        :type Up: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _WorkflowId: 任务工作流id
        :type WorkflowId: str
        """
        self._TaskId = None
        self._Deep = None
        self._Up = None
        self._ProjectId = None
        self._WorkflowId = None

    @property
    def TaskId(self):
        """任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Deep(self):
        """上游/下游层级1-6级
        :rtype: int
        """
        return self._Deep

    @Deep.setter
    def Deep(self, Deep):
        self._Deep = Deep

    @property
    def Up(self):
        """1: 表示查询上游节点；0:表示查询下游节点；2：表示查询上游和下游节点
        :rtype: int
        """
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        """任务工作流id
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Deep = params.get("Deep")
        self._Up = params.get("Up")
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependOpsTasksResponse(AbstractModel):
    """DescribeDependOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 画布任务和链接信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskCanvasInfoList`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """画布任务和链接信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.OpsTaskCanvasInfoList`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskCanvasInfoList()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependTaskListsRequest(AbstractModel):
    """DescribeDependTaskLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务Id列表
        :type TaskIds: list of str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        """任务Id列表
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependTaskListsResponse(AbstractModel):
    """DescribeDependTaskLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskOpsDto
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskOpsDto
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDimensionScoreRequest(AbstractModel):
    """DescribeDimensionScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        """统计日期 时间戳
        :rtype: int
        """
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        """数据来源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Filters(self):
        """过滤参数
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDimensionScoreResponse(AbstractModel):
    """DescribeDimensionScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 维度评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DimensionScore`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """维度评分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DimensionScore`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DimensionScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDrInstancePageRequest(AbstractModel):
    """DescribeDrInstancePage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskSource: 任务来源 ADHOC || WORKFLOW
        :type TaskSource: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _StartTime: 提交开始时间 yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 提交结束时间 yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _FolderIds: 文件夹id
        :type FolderIds: list of str
        :param _WorkflowIds: 工作流id
        :type WorkflowIds: list of str
        :param _JustMe: 只看我的
        :type JustMe: bool
        :param _TaskTypes: 任务类型
        :type TaskTypes: list of str
        :param _SubmitUsers: 试运行提交人userId列表
        :type SubmitUsers: list of str
        :param _StatusList: 试运行状态
        :type StatusList: list of str
        """
        self._ProjectId = None
        self._TaskSource = None
        self._PageIndex = None
        self._PageSize = None
        self._TaskName = None
        self._StartTime = None
        self._EndTime = None
        self._FolderIds = None
        self._WorkflowIds = None
        self._JustMe = None
        self._TaskTypes = None
        self._SubmitUsers = None
        self._StatusList = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskSource(self):
        """任务来源 ADHOC || WORKFLOW
        :rtype: str
        """
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def PageIndex(self):
        """索引页码
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        """页面大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def StartTime(self):
        """提交开始时间 yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """提交结束时间 yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def FolderIds(self):
        """文件夹id
        :rtype: list of str
        """
        return self._FolderIds

    @FolderIds.setter
    def FolderIds(self, FolderIds):
        self._FolderIds = FolderIds

    @property
    def WorkflowIds(self):
        """工作流id
        :rtype: list of str
        """
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def JustMe(self):
        """只看我的
        :rtype: bool
        """
        return self._JustMe

    @JustMe.setter
    def JustMe(self, JustMe):
        self._JustMe = JustMe

    @property
    def TaskTypes(self):
        """任务类型
        :rtype: list of str
        """
        return self._TaskTypes

    @TaskTypes.setter
    def TaskTypes(self, TaskTypes):
        self._TaskTypes = TaskTypes

    @property
    def SubmitUsers(self):
        """试运行提交人userId列表
        :rtype: list of str
        """
        return self._SubmitUsers

    @SubmitUsers.setter
    def SubmitUsers(self, SubmitUsers):
        self._SubmitUsers = SubmitUsers

    @property
    def StatusList(self):
        """试运行状态
        :rtype: list of str
        """
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskSource = params.get("TaskSource")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TaskName = params.get("TaskName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._FolderIds = params.get("FolderIds")
        self._WorkflowIds = params.get("WorkflowIds")
        self._JustMe = params.get("JustMe")
        self._TaskTypes = params.get("TaskTypes")
        self._SubmitUsers = params.get("SubmitUsers")
        self._StatusList = params.get("StatusList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrInstancePageResponse(AbstractModel):
    """DescribeDrInstancePage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DrInstanceOpsDtoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果集
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DrInstanceOpsDtoPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DrInstanceOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDsFolderTreeRequest(AbstractModel):
    """DescribeDsFolderTree请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FirstLevelPull: 是否一级拉取 true 是 
false 否
        :type FirstLevelPull: bool
        :param _FolderId: 文件夹ID
        :type FolderId: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _Keyword: 关键字搜索
        :type Keyword: str
        :param _IncludeWorkflow: 是否包含工作流 true 是 
false 否
        :type IncludeWorkflow: bool
        :param _IncludeTask: 是否包含任务 true 是 
false 否
        :type IncludeTask: bool
        :param _IncludeVirtualTask: 是否包含虚拟任务，当 IncludeTask 为 true 的时候，该参数才生效，默认为 true
        :type IncludeVirtualTask: bool
        :param _TaskFolderId: 任务目录id
        :type TaskFolderId: str
        :param _DisplayType: classification.分类展示  catalog.目录展示
        :type DisplayType: str
        :param _IncludeTaskFolder: 是否包含任务目录 true 是 
false 否
        :type IncludeTaskFolder: bool
        :param _NewFolderTreeMode: 是否使用最新模式展示目录树
        :type NewFolderTreeMode: bool
        :param _TaskNodeId: 节点分类ID
        :type TaskNodeId: str
        :param _WorkflowType: 工作流类型, 使用场景: 任务复制,选择工作流. 取值范围

- cycle    周期工作流
- manual    手动工作流
        :type WorkflowType: str
        """
        self._ProjectId = None
        self._FirstLevelPull = None
        self._FolderId = None
        self._WorkflowId = None
        self._Keyword = None
        self._IncludeWorkflow = None
        self._IncludeTask = None
        self._IncludeVirtualTask = None
        self._TaskFolderId = None
        self._DisplayType = None
        self._IncludeTaskFolder = None
        self._NewFolderTreeMode = None
        self._TaskNodeId = None
        self._WorkflowType = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FirstLevelPull(self):
        """是否一级拉取 true 是 
false 否
        :rtype: bool
        """
        return self._FirstLevelPull

    @FirstLevelPull.setter
    def FirstLevelPull(self, FirstLevelPull):
        self._FirstLevelPull = FirstLevelPull

    @property
    def FolderId(self):
        """文件夹ID
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def Keyword(self):
        """关键字搜索
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def IncludeWorkflow(self):
        """是否包含工作流 true 是 
false 否
        :rtype: bool
        """
        return self._IncludeWorkflow

    @IncludeWorkflow.setter
    def IncludeWorkflow(self, IncludeWorkflow):
        self._IncludeWorkflow = IncludeWorkflow

    @property
    def IncludeTask(self):
        """是否包含任务 true 是 
false 否
        :rtype: bool
        """
        return self._IncludeTask

    @IncludeTask.setter
    def IncludeTask(self, IncludeTask):
        self._IncludeTask = IncludeTask

    @property
    def IncludeVirtualTask(self):
        """是否包含虚拟任务，当 IncludeTask 为 true 的时候，该参数才生效，默认为 true
        :rtype: bool
        """
        return self._IncludeVirtualTask

    @IncludeVirtualTask.setter
    def IncludeVirtualTask(self, IncludeVirtualTask):
        self._IncludeVirtualTask = IncludeVirtualTask

    @property
    def TaskFolderId(self):
        """任务目录id
        :rtype: str
        """
        return self._TaskFolderId

    @TaskFolderId.setter
    def TaskFolderId(self, TaskFolderId):
        self._TaskFolderId = TaskFolderId

    @property
    def DisplayType(self):
        """classification.分类展示  catalog.目录展示
        :rtype: str
        """
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType

    @property
    def IncludeTaskFolder(self):
        """是否包含任务目录 true 是 
false 否
        :rtype: bool
        """
        return self._IncludeTaskFolder

    @IncludeTaskFolder.setter
    def IncludeTaskFolder(self, IncludeTaskFolder):
        self._IncludeTaskFolder = IncludeTaskFolder

    @property
    def NewFolderTreeMode(self):
        """是否使用最新模式展示目录树
        :rtype: bool
        """
        return self._NewFolderTreeMode

    @NewFolderTreeMode.setter
    def NewFolderTreeMode(self, NewFolderTreeMode):
        self._NewFolderTreeMode = NewFolderTreeMode

    @property
    def TaskNodeId(self):
        """节点分类ID
        :rtype: str
        """
        return self._TaskNodeId

    @TaskNodeId.setter
    def TaskNodeId(self, TaskNodeId):
        self._TaskNodeId = TaskNodeId

    @property
    def WorkflowType(self):
        """工作流类型, 使用场景: 任务复制,选择工作流. 取值范围

- cycle    周期工作流
- manual    手动工作流
        :rtype: str
        """
        return self._WorkflowType

    @WorkflowType.setter
    def WorkflowType(self, WorkflowType):
        self._WorkflowType = WorkflowType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FirstLevelPull = params.get("FirstLevelPull")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._Keyword = params.get("Keyword")
        self._IncludeWorkflow = params.get("IncludeWorkflow")
        self._IncludeTask = params.get("IncludeTask")
        self._IncludeVirtualTask = params.get("IncludeVirtualTask")
        self._TaskFolderId = params.get("TaskFolderId")
        self._DisplayType = params.get("DisplayType")
        self._IncludeTaskFolder = params.get("IncludeTaskFolder")
        self._NewFolderTreeMode = params.get("NewFolderTreeMode")
        self._TaskNodeId = params.get("TaskNodeId")
        self._WorkflowType = params.get("WorkflowType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsFolderTreeResponse(AbstractModel):
    """DescribeDsFolderTree返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统一树结构返回属性列表
        :type Data: list of PathNodeDsVO
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """统一树结构返回属性列表
        :rtype: list of PathNodeDsVO
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDsParentFolderTreeRequest(AbstractModel):
    """DescribeDsParentFolderTree请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _DisplayType: 任务展示形式, 示例取值
-    classification:分类展示
-    catalog:目录展示
        :type DisplayType: str
        :param _NewFolderTreeMode: 是否新模式展示目录树
        :type NewFolderTreeMode: bool
        """
        self._ProjectId = None
        self._FolderId = None
        self._WorkflowId = None
        self._TaskId = None
        self._DisplayType = None
        self._NewFolderTreeMode = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        """文件夹ID
        :rtype: str
        """
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DisplayType(self):
        """任务展示形式, 示例取值
-    classification:分类展示
-    catalog:目录展示
        :rtype: str
        """
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType

    @property
    def NewFolderTreeMode(self):
        """是否新模式展示目录树
        :rtype: bool
        """
        return self._NewFolderTreeMode

    @NewFolderTreeMode.setter
    def NewFolderTreeMode(self, NewFolderTreeMode):
        self._NewFolderTreeMode = NewFolderTreeMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskId = params.get("TaskId")
        self._DisplayType = params.get("DisplayType")
        self._NewFolderTreeMode = params.get("NewFolderTreeMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsParentFolderTreeResponse(AbstractModel):
    """DescribeDsParentFolderTree返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统一树结构返回属性列表
        :type Data: list of PathNodeDsVO
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """统一树结构返回属性列表
        :rtype: list of PathNodeDsVO
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDutyScheduleDetailsRequest(AbstractModel):
    """DescribeDutyScheduleDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 值班表id
        :type Id: int
        :param _QueryDate: 查询时间
        :type QueryDate: str
        :param _Filters: 扩展字段
        :type Filters: list of Filter
        """
        self._Id = None
        self._QueryDate = None
        self._Filters = None

    @property
    def Id(self):
        """值班表id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def QueryDate(self):
        """查询时间
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def Filters(self):
        """扩展字段
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._QueryDate = params.get("QueryDate")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDutyScheduleDetailsResponse(AbstractModel):
    """DescribeDutyScheduleDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 值班日历信息
        :type Data: list of DutyScheduleDetailsInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """值班日历信息
        :rtype: list of DutyScheduleDetailsInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DutyScheduleDetailsInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDutyScheduleListRequest(AbstractModel):
    """DescribeDutyScheduleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        :param _Name: 值班表名称
        :type Name: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Name = None

    @property
    def PageNumber(self):
        """页码，默认1
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """页大小，默认10
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Name(self):
        """值班表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDutyScheduleListResponse(AbstractModel):
    """DescribeDutyScheduleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DutySchedule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """无
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DutySchedule`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DutySchedule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventCasesRequest(AbstractModel):
    """DescribeEventCases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Category: 事件实例目录,示例取值:
- 已过期: expired
- 未过期: consuming
- 全部: all

        :type Category: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页数目
        :type PageSize: int
        :param _EventName: 事件名称
        :type EventName: str
        :param _EventType: 事件类型
        :type EventType: str
        :param _EventSubType: 事件分割类型
        :type EventSubType: str
        :param _EventBroadcastType: 事件广播类型
        :type EventBroadcastType: str
        :param _Status: 事件实例状态,示例取值:
- 已消费: COMSUMED
- 已过期: EXPIRED
- 待消费: ACTIVE
- 消费中: CONSUMING
        :type Status: str
        :param _CreationTimeStart: 事件实例最小创建时间
        :type CreationTimeStart: str
        :param _CreationTimeEnd: 事件实例最大创建时间
        :type CreationTimeEnd: str
        :param _EventTriggeredTimeStart: 事件实例最小触发时间
        :type EventTriggeredTimeStart: str
        :param _EventTriggeredTimeEnd: 事件实例最大触发时间
        :type EventTriggeredTimeEnd: str
        :param _LogTimeStart: 事件实例最小消费时间
        :type LogTimeStart: str
        :param _LogTimeEnd: 事件实例最大消费时间
        :type LogTimeEnd: str
        :param _Dimension: 事件实例数据时间
        :type Dimension: str
        :param _TimeToLive: 事件实例有效时间
        :type TimeToLive: str
        :param _SortItem: 排序字段
        :type SortItem: str
        :param _SortType: 排序顺序
        :type SortType: str
        """
        self._ProjectId = None
        self._Category = None
        self._PageNumber = None
        self._PageSize = None
        self._EventName = None
        self._EventType = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._Status = None
        self._CreationTimeStart = None
        self._CreationTimeEnd = None
        self._EventTriggeredTimeStart = None
        self._EventTriggeredTimeEnd = None
        self._LogTimeStart = None
        self._LogTimeEnd = None
        self._Dimension = None
        self._TimeToLive = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Category(self):
        """事件实例目录,示例取值:
- 已过期: expired
- 未过期: consuming
- 全部: all

        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页数目
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def EventName(self):
        """事件名称
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventType(self):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        """事件类型
        :rtype: str
        """
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        self._EventType = EventType

    @property
    def EventSubType(self):
        """事件分割类型
        :rtype: str
        """
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        """事件广播类型
        :rtype: str
        """
        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        self._EventBroadcastType = EventBroadcastType

    @property
    def Status(self):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        """事件实例状态,示例取值:
- 已消费: COMSUMED
- 已过期: EXPIRED
- 待消费: ACTIVE
- 消费中: CONSUMING
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        self._Status = Status

    @property
    def CreationTimeStart(self):
        """事件实例最小创建时间
        :rtype: str
        """
        return self._CreationTimeStart

    @CreationTimeStart.setter
    def CreationTimeStart(self, CreationTimeStart):
        self._CreationTimeStart = CreationTimeStart

    @property
    def CreationTimeEnd(self):
        """事件实例最大创建时间
        :rtype: str
        """
        return self._CreationTimeEnd

    @CreationTimeEnd.setter
    def CreationTimeEnd(self, CreationTimeEnd):
        self._CreationTimeEnd = CreationTimeEnd

    @property
    def EventTriggeredTimeStart(self):
        """事件实例最小触发时间
        :rtype: str
        """
        return self._EventTriggeredTimeStart

    @EventTriggeredTimeStart.setter
    def EventTriggeredTimeStart(self, EventTriggeredTimeStart):
        self._EventTriggeredTimeStart = EventTriggeredTimeStart

    @property
    def EventTriggeredTimeEnd(self):
        """事件实例最大触发时间
        :rtype: str
        """
        return self._EventTriggeredTimeEnd

    @EventTriggeredTimeEnd.setter
    def EventTriggeredTimeEnd(self, EventTriggeredTimeEnd):
        self._EventTriggeredTimeEnd = EventTriggeredTimeEnd

    @property
    def LogTimeStart(self):
        """事件实例最小消费时间
        :rtype: str
        """
        return self._LogTimeStart

    @LogTimeStart.setter
    def LogTimeStart(self, LogTimeStart):
        self._LogTimeStart = LogTimeStart

    @property
    def LogTimeEnd(self):
        """事件实例最大消费时间
        :rtype: str
        """
        return self._LogTimeEnd

    @LogTimeEnd.setter
    def LogTimeEnd(self, LogTimeEnd):
        self._LogTimeEnd = LogTimeEnd

    @property
    def Dimension(self):
        """事件实例数据时间
        :rtype: str
        """
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def TimeToLive(self):
        """事件实例有效时间
        :rtype: str
        """
        return self._TimeToLive

    @TimeToLive.setter
    def TimeToLive(self, TimeToLive):
        self._TimeToLive = TimeToLive

    @property
    def SortItem(self):
        """排序字段
        :rtype: str
        """
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        """排序顺序
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Category = params.get("Category")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._EventName = params.get("EventName")
        self._EventType = params.get("EventType")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._Status = params.get("Status")
        self._CreationTimeStart = params.get("CreationTimeStart")
        self._CreationTimeEnd = params.get("CreationTimeEnd")
        self._EventTriggeredTimeStart = params.get("EventTriggeredTimeStart")
        self._EventTriggeredTimeEnd = params.get("EventTriggeredTimeEnd")
        self._LogTimeStart = params.get("LogTimeStart")
        self._LogTimeEnd = params.get("LogTimeEnd")
        self._Dimension = params.get("Dimension")
        self._TimeToLive = params.get("TimeToLive")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventCasesResponse(AbstractModel):
    """DescribeEventCases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseAuditLogVOCollection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """事件实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.EventCaseAuditLogVOCollection`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseAuditLogVOCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventConsumeTasksRequest(AbstractModel):
    """DescribeEventConsumeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventCaseId: 事件实例ID
        :type EventCaseId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页数目
        :type PageSize: int
        """
        self._EventCaseId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def EventCaseId(self):
        """事件实例ID
        :rtype: str
        """
        return self._EventCaseId

    @EventCaseId.setter
    def EventCaseId(self, EventCaseId):
        self._EventCaseId = EventCaseId

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页数目
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._EventCaseId = params.get("EventCaseId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventConsumeTasksResponse(AbstractModel):
    """DescribeEventConsumeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件消费任务记录列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseConsumeLogOptDtoCollection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """事件消费任务记录列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.EventCaseConsumeLogOptDtoCollection`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseConsumeLogOptDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventRequest(AbstractModel):
    """DescribeEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _EventName: 事件名称
        :type EventName: str
        """
        self._ProjectId = None
        self._EventName = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EventName(self):
        """事件名称
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EventName = params.get("EventName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventResponse(AbstractModel):
    """DescribeEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """事件
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.EventOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeExecStrategyRequest(AbstractModel):
    """DescribeExecStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        """规则组Id
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExecStrategyResponse(AbstractModel):
    """DescribeExecStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则组执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecStrategy()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFieldBasicInfoRequest(AbstractModel):
    """DescribeFieldBasicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤字段
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFieldBasicInfoResponse(AbstractModel):
    """DescribeFieldBasicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnBasicInfoList: 字段元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnBasicInfoList: list of ColumnBasicInfo
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnBasicInfoList(self):
        """字段元数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ColumnBasicInfo
        """
        return self._ColumnBasicInfoList

    @ColumnBasicInfoList.setter
    def ColumnBasicInfoList(self, ColumnBasicInfoList):
        self._ColumnBasicInfoList = ColumnBasicInfoList

    @property
    def TotalCount(self):
        """总条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnBasicInfoList") is not None:
            self._ColumnBasicInfoList = []
            for item in params.get("ColumnBasicInfoList"):
                obj = ColumnBasicInfo()
                obj._deserialize(item)
                self._ColumnBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFolderWorkflowListData(AbstractModel):
    """文件夹分页信息

    """

    def __init__(self):
        r"""
        :param _Items: 工作流信息列表
        :type Items: list of Workflow
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        """工作流信息列表
        :rtype: list of Workflow
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        """总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        """页号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Workflow()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListRequest(AbstractModel):
    """DescribeFolderWorkflowList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        """父文件夹ID
        :rtype: str
        """
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        """关键字
        :rtype: str
        """
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        """页码，默认1
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """页大小，默认10
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListResponse(AbstractModel):
    """DescribeFolderWorkflowList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderWorkflowListData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderWorkflowListData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderWorkflowListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFunctionKindsRequest(AbstractModel):
    """DescribeFunctionKinds请求参数结构体

    """


class DescribeFunctionKindsResponse(AbstractModel):
    """DescribeFunctionKinds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Kinds: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Kinds: list of FunctionTypeOrKind
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Kinds = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Kinds(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FunctionTypeOrKind
        """
        return self._Kinds

    @Kinds.setter
    def Kinds(self, Kinds):
        self._Kinds = Kinds

    @property
    def ErrorMessage(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Kinds") is not None:
            self._Kinds = []
            for item in params.get("Kinds"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Kinds.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeFunctionTypesRequest(AbstractModel):
    """DescribeFunctionTypes请求参数结构体

    """


class DescribeFunctionTypesResponse(AbstractModel):
    """DescribeFunctionTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Types: 类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Types: list of FunctionTypeOrKind
        :param _ErrorMessage: 错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Types = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Types(self):
        """类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FunctionTypeOrKind
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def ErrorMessage(self):
        """错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Types.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeInstanceByCycleRequest(AbstractModel):
    """DescribeInstanceByCycle请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 1
        :type ProjectId: str
        :param _TenantId: 1
        :type TenantId: str
        """
        self._ProjectId = None
        self._TenantId = None

    @property
    def ProjectId(self):
        """1
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TenantId(self):
        """1
        :rtype: str
        """
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TenantId = params.get("TenantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceByCycleResponse(AbstractModel):
    """DescribeInstanceByCycle返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统计结果
        :type Data: list of TaskByCycle
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """统计结果
        :rtype: list of TaskByCycle
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceDetailInfoRequest(AbstractModel):
    """DescribeInstanceDetailInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 实例数据时间
        :type CurRunDate: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _LifeRound: 实例的第几次执行
        :type LifeRound: int
        :param _LifeRoundStartIndex: 生命周期查询起始index
        :type LifeRoundStartIndex: int
        :param _LifeRoundSize: 生命周期查询批次数量
        :type LifeRoundSize: int
        :param _TotalLifeRound: 生命周期总数，可省略
        :type TotalLifeRound: str
        :param _Dynamic: 动态加载日志标识
        :type Dynamic: bool
        """
        self._TaskId = None
        self._CurRunDate = None
        self._ProjectId = None
        self._LifeRound = None
        self._LifeRoundStartIndex = None
        self._LifeRoundSize = None
        self._TotalLifeRound = None
        self._Dynamic = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """实例数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def LifeRound(self):
        """实例的第几次执行
        :rtype: int
        """
        return self._LifeRound

    @LifeRound.setter
    def LifeRound(self, LifeRound):
        self._LifeRound = LifeRound

    @property
    def LifeRoundStartIndex(self):
        """生命周期查询起始index
        :rtype: int
        """
        return self._LifeRoundStartIndex

    @LifeRoundStartIndex.setter
    def LifeRoundStartIndex(self, LifeRoundStartIndex):
        self._LifeRoundStartIndex = LifeRoundStartIndex

    @property
    def LifeRoundSize(self):
        """生命周期查询批次数量
        :rtype: int
        """
        return self._LifeRoundSize

    @LifeRoundSize.setter
    def LifeRoundSize(self, LifeRoundSize):
        self._LifeRoundSize = LifeRoundSize

    @property
    def TotalLifeRound(self):
        """生命周期总数，可省略
        :rtype: str
        """
        return self._TotalLifeRound

    @TotalLifeRound.setter
    def TotalLifeRound(self, TotalLifeRound):
        self._TotalLifeRound = TotalLifeRound

    @property
    def Dynamic(self):
        """动态加载日志标识
        :rtype: bool
        """
        return self._Dynamic

    @Dynamic.setter
    def Dynamic(self, Dynamic):
        self._Dynamic = Dynamic


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._ProjectId = params.get("ProjectId")
        self._LifeRound = params.get("LifeRound")
        self._LifeRoundStartIndex = params.get("LifeRoundStartIndex")
        self._LifeRoundSize = params.get("LifeRoundSize")
        self._TotalLifeRound = params.get("TotalLifeRound")
        self._Dynamic = params.get("Dynamic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceDetailInfoResponse(AbstractModel):
    """DescribeInstanceDetailInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 生命周期结果
        :type Data: list of InstanceLifeCycleOpsDto
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """生命周期结果
        :rtype: list of InstanceLifeCycleOpsDto
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLifeCycleOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLastLogRequest(AbstractModel):
    """DescribeInstanceLastLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLastLogResponse(AbstractModel):
    """DescribeInstanceLastLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """日志
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInstanceListRequest(AbstractModel):
    """DescribeInstanceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 一页展示的条数
        :type PageSize: int
        :param _CycleList: 周期列表（如天，一次性），可选
        :type CycleList: list of str
        :param _OwnerList: 责任人
        :type OwnerList: list of str
        :param _InstanceType: 跟之前保持一致
        :type InstanceType: str
        :param _Sort: 排序顺序（asc，desc）
        :type Sort: str
        :param _SortCol: 排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :type SortCol: str
        :param _TaskTypeList: 类型列表（如python任务类型：30
pyspark任务类型：31
hivesql任务类型：34
shell任务类型：35
sparksql任务类型：36 jdbcsql任务类型：21 dlc任务类型：32），可选
        :type TaskTypeList: list of int
        :param _StateList: 状态列表（如成功 2，正在执行 1），可选
        :type StateList: list of int
        :param _Keyword: 任务名称
        :type Keyword: str
        """
        self._ProjectId = None
        self._PageIndex = None
        self._PageSize = None
        self._CycleList = None
        self._OwnerList = None
        self._InstanceType = None
        self._Sort = None
        self._SortCol = None
        self._TaskTypeList = None
        self._StateList = None
        self._Keyword = None

    @property
    def ProjectId(self):
        """项目/工作空间id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageIndex(self):
        """页码
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        """一页展示的条数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def CycleList(self):
        """周期列表（如天，一次性），可选
        :rtype: list of str
        """
        return self._CycleList

    @CycleList.setter
    def CycleList(self, CycleList):
        self._CycleList = CycleList

    @property
    def OwnerList(self):
        """责任人
        :rtype: list of str
        """
        return self._OwnerList

    @OwnerList.setter
    def OwnerList(self, OwnerList):
        self._OwnerList = OwnerList

    @property
    def InstanceType(self):
        """跟之前保持一致
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Sort(self):
        """排序顺序（asc，desc）
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        """排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :rtype: str
        """
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol

    @property
    def TaskTypeList(self):
        """类型列表（如python任务类型：30
pyspark任务类型：31
hivesql任务类型：34
shell任务类型：35
sparksql任务类型：36 jdbcsql任务类型：21 dlc任务类型：32），可选
        :rtype: list of int
        """
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def StateList(self):
        """状态列表（如成功 2，正在执行 1），可选
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def Keyword(self):
        """任务名称
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._CycleList = params.get("CycleList")
        self._OwnerList = params.get("OwnerList")
        self._InstanceType = params.get("InstanceType")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        self._TaskTypeList = params.get("TaskTypeList")
        self._StateList = params.get("StateList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceListResponse(AbstractModel):
    """DescribeInstanceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: str
        :param _InstanceList: 实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceList: list of InstanceList
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceList(self):
        """实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceList
        """
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def TotalCount(self):
        """总条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = InstanceList()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogDetailRequest(AbstractModel):
    """DescribeInstanceLogDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _LogLevelType: 日志级别，Info/Debug/Warn/Error/All
        :type LogLevelType: str
        :param _ExecutionFileType: 文件类型,Log/Code
        :type ExecutionFileType: str
        :param _ExecutionJobId: 统一执行平台执行id, 注意: ExecutionJobId 跟 "BrokerIp+OriginFileName" 必须有一个不为空
        :type ExecutionJobId: str
        :param _BrokerIp: 服务器Ip, 注意: "BrokerIp+OriginFileName"跟ExecutionJobId必须有一个不为空
        :type BrokerIp: str
        :param _OriginFileName: 文件Name, 注意: "BrokerIp+OriginFileName"跟ExecutionJobId必须有一个不为空
        :type OriginFileName: str
        :param _StartCount: 起始行
        :type StartCount: int
        :param _LineCount: 每次查询行数
        :type LineCount: int
        :param _ExtInfo: 查询日志扩展信息,通过统一执行平台接口分页查询日志时需要带上,第一页时为null
        :type ExtInfo: str
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _InstanceLifeDetailDtoList: 生命周期为基础数据进行日志匹配
        :type InstanceLifeDetailDtoList: list of InstanceLifeDetailDto
        :param _CurrentLifeRound: 当前生命周期
        :type CurrentLifeRound: int
        :param _MaxLifeRound: 生命周期总数
        :type MaxLifeRound: int
        :param _Tries: 当前生命周期重试次数
        :type Tries: int
        :param _Dynamic: 动态加载日志
        :type Dynamic: bool
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._LogLevelType = None
        self._ExecutionFileType = None
        self._ExecutionJobId = None
        self._BrokerIp = None
        self._OriginFileName = None
        self._StartCount = None
        self._LineCount = None
        self._ExtInfo = None
        self._RequestFromSource = None
        self._InstanceLifeDetailDtoList = None
        self._CurrentLifeRound = None
        self._MaxLifeRound = None
        self._Tries = None
        self._Dynamic = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def LogLevelType(self):
        """日志级别，Info/Debug/Warn/Error/All
        :rtype: str
        """
        return self._LogLevelType

    @LogLevelType.setter
    def LogLevelType(self, LogLevelType):
        self._LogLevelType = LogLevelType

    @property
    def ExecutionFileType(self):
        """文件类型,Log/Code
        :rtype: str
        """
        return self._ExecutionFileType

    @ExecutionFileType.setter
    def ExecutionFileType(self, ExecutionFileType):
        self._ExecutionFileType = ExecutionFileType

    @property
    def ExecutionJobId(self):
        """统一执行平台执行id, 注意: ExecutionJobId 跟 "BrokerIp+OriginFileName" 必须有一个不为空
        :rtype: str
        """
        return self._ExecutionJobId

    @ExecutionJobId.setter
    def ExecutionJobId(self, ExecutionJobId):
        self._ExecutionJobId = ExecutionJobId

    @property
    def BrokerIp(self):
        """服务器Ip, 注意: "BrokerIp+OriginFileName"跟ExecutionJobId必须有一个不为空
        :rtype: str
        """
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        """文件Name, 注意: "BrokerIp+OriginFileName"跟ExecutionJobId必须有一个不为空
        :rtype: str
        """
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def StartCount(self):
        """起始行
        :rtype: int
        """
        return self._StartCount

    @StartCount.setter
    def StartCount(self, StartCount):
        self._StartCount = StartCount

    @property
    def LineCount(self):
        """每次查询行数
        :rtype: int
        """
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount

    @property
    def ExtInfo(self):
        """查询日志扩展信息,通过统一执行平台接口分页查询日志时需要带上,第一页时为null
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def InstanceLifeDetailDtoList(self):
        """生命周期为基础数据进行日志匹配
        :rtype: list of InstanceLifeDetailDto
        """
        return self._InstanceLifeDetailDtoList

    @InstanceLifeDetailDtoList.setter
    def InstanceLifeDetailDtoList(self, InstanceLifeDetailDtoList):
        self._InstanceLifeDetailDtoList = InstanceLifeDetailDtoList

    @property
    def CurrentLifeRound(self):
        """当前生命周期
        :rtype: int
        """
        return self._CurrentLifeRound

    @CurrentLifeRound.setter
    def CurrentLifeRound(self, CurrentLifeRound):
        self._CurrentLifeRound = CurrentLifeRound

    @property
    def MaxLifeRound(self):
        """生命周期总数
        :rtype: int
        """
        return self._MaxLifeRound

    @MaxLifeRound.setter
    def MaxLifeRound(self, MaxLifeRound):
        self._MaxLifeRound = MaxLifeRound

    @property
    def Tries(self):
        """当前生命周期重试次数
        :rtype: int
        """
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def Dynamic(self):
        """动态加载日志
        :rtype: bool
        """
        return self._Dynamic

    @Dynamic.setter
    def Dynamic(self, Dynamic):
        self._Dynamic = Dynamic


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._LogLevelType = params.get("LogLevelType")
        self._ExecutionFileType = params.get("ExecutionFileType")
        self._ExecutionJobId = params.get("ExecutionJobId")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        self._StartCount = params.get("StartCount")
        self._LineCount = params.get("LineCount")
        self._ExtInfo = params.get("ExtInfo")
        self._RequestFromSource = params.get("RequestFromSource")
        if params.get("InstanceLifeDetailDtoList") is not None:
            self._InstanceLifeDetailDtoList = []
            for item in params.get("InstanceLifeDetailDtoList"):
                obj = InstanceLifeDetailDto()
                obj._deserialize(item)
                self._InstanceLifeDetailDtoList.append(obj)
        self._CurrentLifeRound = params.get("CurrentLifeRound")
        self._MaxLifeRound = params.get("MaxLifeRound")
        self._Tries = params.get("Tries")
        self._Dynamic = params.get("Dynamic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogDetailResponse(AbstractModel):
    """DescribeInstanceLogDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceLogInfoOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """日志结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceLogInfoOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceLogInfoOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogFileRequest(AbstractModel):
    """DescribeInstanceLogFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 实例数据时间
        :type CurRunDate: str
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _BrokerIp: 执行机IP
        :type BrokerIp: str
        :param _OriginFileName: 日志文件名
        :type OriginFileName: str
        :param _ExecutionJobId: 执行平台下发执行id
        :type ExecutionJobId: str
        :param _LogLevelType: 日志级别，Info/Debug/Warn/Error/All
        :type LogLevelType: str
        :param _ExecutionFileType: 文件类型,Log/Code
        :type ExecutionFileType: str
        :param _InstanceLifeDetailDtoList: 生命周期为基础数据进行日志匹配。Dynamic=true动态获取日志链路中使用
        :type InstanceLifeDetailDtoList: list of InstanceLifeDetailDto
        :param _CurrentLifeRound: 当前生命周期数
        :type CurrentLifeRound: int
        :param _Tries: 当前生命周期重试次数
        :type Tries: int
        :param _Dynamic: 动态获取日志信息标识
        :type Dynamic: bool
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._RequestFromSource = None
        self._BrokerIp = None
        self._OriginFileName = None
        self._ExecutionJobId = None
        self._LogLevelType = None
        self._ExecutionFileType = None
        self._InstanceLifeDetailDtoList = None
        self._CurrentLifeRound = None
        self._Tries = None
        self._Dynamic = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """实例数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def BrokerIp(self):
        """执行机IP
        :rtype: str
        """
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        """日志文件名
        :rtype: str
        """
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def ExecutionJobId(self):
        """执行平台下发执行id
        :rtype: str
        """
        return self._ExecutionJobId

    @ExecutionJobId.setter
    def ExecutionJobId(self, ExecutionJobId):
        self._ExecutionJobId = ExecutionJobId

    @property
    def LogLevelType(self):
        """日志级别，Info/Debug/Warn/Error/All
        :rtype: str
        """
        return self._LogLevelType

    @LogLevelType.setter
    def LogLevelType(self, LogLevelType):
        self._LogLevelType = LogLevelType

    @property
    def ExecutionFileType(self):
        """文件类型,Log/Code
        :rtype: str
        """
        return self._ExecutionFileType

    @ExecutionFileType.setter
    def ExecutionFileType(self, ExecutionFileType):
        self._ExecutionFileType = ExecutionFileType

    @property
    def InstanceLifeDetailDtoList(self):
        """生命周期为基础数据进行日志匹配。Dynamic=true动态获取日志链路中使用
        :rtype: list of InstanceLifeDetailDto
        """
        return self._InstanceLifeDetailDtoList

    @InstanceLifeDetailDtoList.setter
    def InstanceLifeDetailDtoList(self, InstanceLifeDetailDtoList):
        self._InstanceLifeDetailDtoList = InstanceLifeDetailDtoList

    @property
    def CurrentLifeRound(self):
        """当前生命周期数
        :rtype: int
        """
        return self._CurrentLifeRound

    @CurrentLifeRound.setter
    def CurrentLifeRound(self, CurrentLifeRound):
        self._CurrentLifeRound = CurrentLifeRound

    @property
    def Tries(self):
        """当前生命周期重试次数
        :rtype: int
        """
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def Dynamic(self):
        """动态获取日志信息标识
        :rtype: bool
        """
        return self._Dynamic

    @Dynamic.setter
    def Dynamic(self, Dynamic):
        self._Dynamic = Dynamic


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._RequestFromSource = params.get("RequestFromSource")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        self._ExecutionJobId = params.get("ExecutionJobId")
        self._LogLevelType = params.get("LogLevelType")
        self._ExecutionFileType = params.get("ExecutionFileType")
        if params.get("InstanceLifeDetailDtoList") is not None:
            self._InstanceLifeDetailDtoList = []
            for item in params.get("InstanceLifeDetailDtoList"):
                obj = InstanceLifeDetailDto()
                obj._deserialize(item)
                self._InstanceLifeDetailDtoList.append(obj)
        self._CurrentLifeRound = params.get("CurrentLifeRound")
        self._Tries = params.get("Tries")
        self._Dynamic = params.get("Dynamic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogFileResponse(AbstractModel):
    """DescribeInstanceLogFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 下载文件详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceDownloadLogInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """下载文件详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceDownloadLogInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceDownloadLogInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogListRequest(AbstractModel):
    """DescribeInstanceLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogListResponse(AbstractModel):
    """DescribeInstanceLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志列表
        :type Data: str
        :param _InstanceLogList: 日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogList: list of InstanceLogList
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogList = None
        self._RequestId = None

    @property
    def Data(self):
        """日志列表
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogList(self):
        """日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceLogList
        """
        return self._InstanceLogList

    @InstanceLogList.setter
    def InstanceLogList(self, InstanceLogList):
        self._InstanceLogList = InstanceLogList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogList") is not None:
            self._InstanceLogList = []
            for item in params.get("InstanceLogList"):
                obj = InstanceLogList()
                obj._deserialize(item)
                self._InstanceLogList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogRequest(AbstractModel):
    """DescribeInstanceLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _BrokerIp: 服务器Ip
        :type BrokerIp: str
        :param _OriginFileName: 文件Name
        :type OriginFileName: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        """服务器Ip
        :rtype: str
        """
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        """文件Name
        :rtype: str
        """
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogResponse(AbstractModel):
    """DescribeInstanceLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回结果
        :type Data: str
        :param _InstanceLogInfo: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationInstanceLog`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogInfo = None
        self._RequestId = None

    @property
    def Data(self):
        """返回结果
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogInfo(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.IntegrationInstanceLog`
        """
        return self._InstanceLogInfo

    @InstanceLogInfo.setter
    def InstanceLogInfo(self, InstanceLogInfo):
        self._InstanceLogInfo = InstanceLogInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogInfo") is not None:
            self._InstanceLogInfo = IntegrationInstanceLog()
            self._InstanceLogInfo._deserialize(params.get("InstanceLogInfo"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationNodeRequest(AbstractModel):
    """DescribeIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def Id(self):
        """节点id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """任务类型，201为实时任务，202为离线任务
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationNodeResponse(AbstractModel):
    """DescribeIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _SourceCheckFlag: 上游节点是否已经修改。true 已修改，需要提示；false 没有修改
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceCheckFlag: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodeInfo = None
        self._SourceCheckFlag = None
        self._RequestId = None

    @property
    def NodeInfo(self):
        """节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        """
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def SourceCheckFlag(self):
        """上游节点是否已经修改。true 已修改，需要提示；false 没有修改
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SourceCheckFlag

    @SourceCheckFlag.setter
    def SourceCheckFlag(self, SourceCheckFlag):
        self._SourceCheckFlag = SourceCheckFlag

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._SourceCheckFlag = params.get("SourceCheckFlag")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsInstanceTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        """任务类型（实时：201，离线：202）
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        """查询日期
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsInstanceTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        """统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationStatisticsTrendResult
        """
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRecordsTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        """任务类型（实时：201，离线：202）
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        """查询日期
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsRecordsTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        """统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationStatisticsTrendResult
        """
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRequest(AbstractModel):
    """DescribeIntegrationStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        """任务类型（实时：201，离线：202）
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        """查询日期
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsResponse(AbstractModel):
    """DescribeIntegrationStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalTask: 总任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalTask: int
        :param _ProdTask: 生产态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type ProdTask: int
        :param _DevTask: 开发态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type DevTask: int
        :param _TotalReadRecords: 总读取条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalReadRecords: int
        :param _TotalWriteRecords: 总写入条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalWriteRecords: int
        :param _TotalErrorRecords: 总脏数据条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalErrorRecords: int
        :param _TotalAlarmEvent: 总告警事件数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalAlarmEvent: int
        :param _IncreaseReadRecords: 当天读取增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseReadRecords: int
        :param _IncreaseWriteRecords: 当天写入增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseWriteRecords: int
        :param _IncreaseErrorRecords: 当天脏数据增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseErrorRecords: int
        :param _IncreaseAlarmEvent: 当天告警事件增长数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseAlarmEvent: int
        :param _AlarmEvent: 告警事件统计
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEvent: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalTask = None
        self._ProdTask = None
        self._DevTask = None
        self._TotalReadRecords = None
        self._TotalWriteRecords = None
        self._TotalErrorRecords = None
        self._TotalAlarmEvent = None
        self._IncreaseReadRecords = None
        self._IncreaseWriteRecords = None
        self._IncreaseErrorRecords = None
        self._IncreaseAlarmEvent = None
        self._AlarmEvent = None
        self._RequestId = None

    @property
    def TotalTask(self):
        """总任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalTask

    @TotalTask.setter
    def TotalTask(self, TotalTask):
        self._TotalTask = TotalTask

    @property
    def ProdTask(self):
        """生产态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProdTask

    @ProdTask.setter
    def ProdTask(self, ProdTask):
        self._ProdTask = ProdTask

    @property
    def DevTask(self):
        """开发态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DevTask

    @DevTask.setter
    def DevTask(self, DevTask):
        self._DevTask = DevTask

    @property
    def TotalReadRecords(self):
        """总读取条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalWriteRecords(self):
        """总写入条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalErrorRecords(self):
        """总脏数据条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def TotalAlarmEvent(self):
        """总告警事件数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalAlarmEvent

    @TotalAlarmEvent.setter
    def TotalAlarmEvent(self, TotalAlarmEvent):
        self._TotalAlarmEvent = TotalAlarmEvent

    @property
    def IncreaseReadRecords(self):
        """当天读取增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IncreaseReadRecords

    @IncreaseReadRecords.setter
    def IncreaseReadRecords(self, IncreaseReadRecords):
        self._IncreaseReadRecords = IncreaseReadRecords

    @property
    def IncreaseWriteRecords(self):
        """当天写入增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IncreaseWriteRecords

    @IncreaseWriteRecords.setter
    def IncreaseWriteRecords(self, IncreaseWriteRecords):
        self._IncreaseWriteRecords = IncreaseWriteRecords

    @property
    def IncreaseErrorRecords(self):
        """当天脏数据增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IncreaseErrorRecords

    @IncreaseErrorRecords.setter
    def IncreaseErrorRecords(self, IncreaseErrorRecords):
        self._IncreaseErrorRecords = IncreaseErrorRecords

    @property
    def IncreaseAlarmEvent(self):
        """当天告警事件增长数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IncreaseAlarmEvent

    @IncreaseAlarmEvent.setter
    def IncreaseAlarmEvent(self, IncreaseAlarmEvent):
        self._IncreaseAlarmEvent = IncreaseAlarmEvent

    @property
    def AlarmEvent(self):
        """告警事件统计
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlarmEvent

    @AlarmEvent.setter
    def AlarmEvent(self, AlarmEvent):
        self._AlarmEvent = AlarmEvent

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalTask = params.get("TotalTask")
        self._ProdTask = params.get("ProdTask")
        self._DevTask = params.get("DevTask")
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._TotalAlarmEvent = params.get("TotalAlarmEvent")
        self._IncreaseReadRecords = params.get("IncreaseReadRecords")
        self._IncreaseWriteRecords = params.get("IncreaseWriteRecords")
        self._IncreaseErrorRecords = params.get("IncreaseErrorRecords")
        self._IncreaseAlarmEvent = params.get("IncreaseAlarmEvent")
        self._AlarmEvent = params.get("AlarmEvent")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        """任务类型（实时：201，离线：202）
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        """查询日期
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StatusData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusData: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        """统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        """任务类型（实时：201，离线：202）
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        """查询日期
        :rtype: str
        """
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        """统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationStatisticsTrendResult
        """
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTaskRequest(AbstractModel):
    """DescribeIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型，201: 实时集成任务,   202：离线集成任务，不传默认值为201 实时任务类型
        :type TaskType: int
        :param _InstanceVersion: 提交版本号
        :type InstanceVersion: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None
        self._InstanceVersion = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """任务类型，201: 实时集成任务,   202：离线集成任务，不传默认值为201 实时任务类型
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InstanceVersion(self):
        """提交版本号
        :rtype: int
        """
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._InstanceVersion = params.get("InstanceVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTaskResponse(AbstractModel):
    """DescribeIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _AgentStatus: 采集器统计信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentStatus: :class:`tencentcloud.wedata.v20210820.models.AgentStatus`
        :param _TaskVersion: 任务版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskVersion: :class:`tencentcloud.wedata.v20210820.models.TaskVersionInstance`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfo = None
        self._AgentStatus = None
        self._TaskVersion = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        """任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def AgentStatus(self):
        """采集器统计信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.AgentStatus`
        """
        return self._AgentStatus

    @AgentStatus.setter
    def AgentStatus(self, AgentStatus):
        self._AgentStatus = AgentStatus

    @property
    def TaskVersion(self):
        """任务版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskVersionInstance`
        """
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        if params.get("AgentStatus") is not None:
            self._AgentStatus = AgentStatus()
            self._AgentStatus._deserialize(params.get("AgentStatus"))
        if params.get("TaskVersion") is not None:
            self._TaskVersion = TaskVersionInstance()
            self._TaskVersion._deserialize(params.get("TaskVersion"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTasksRequest(AbstractModel):
    """DescribeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页第n页
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 查询filter;默认查询任务的开发态，如需查询生产态任务需添加{"Values":["true"],"Name":"ProductionState"};如需查询查询任务状态需要查询生产态任务列表
        :type Filters: list of Filter
        :param _OrderFields: 排序字段信息
        :type OrderFields: list of OrderField
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _TaskType: 201. 实时同步, 202. 离线同步 默认实时
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """分页第n页
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """查询filter;默认查询任务的开发态，如需查询生产态任务需添加{"Values":["true"],"Name":"ProductionState"};如需查询查询任务状态需要查询生产态任务列表
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段信息
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        """201. 实时同步, 202. 离线同步 默认实时
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTasksResponse(AbstractModel):
    """DescribeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfoSet: 任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfoSet: list of IntegrationTaskInfo
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskInfoSet(self):
        """任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationTaskInfo
        """
        return self._TaskInfoSet

    @TaskInfoSet.setter
    def TaskInfoSet(self, TaskInfoSet):
        self._TaskInfoSet = TaskInfoSet

    @property
    def TotalCount(self):
        """任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfoSet") is not None:
            self._TaskInfoSet = []
            for item in params.get("TaskInfoSet"):
                obj = IntegrationTaskInfo()
                obj._deserialize(item)
                self._TaskInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationVersionNodesInfoRequest(AbstractModel):
    """DescribeIntegrationVersionNodesInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskVersionPath: 该任务选定版本的存储路径：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 TaskInfo.TaskExt.Properties 下 Base64.encode($region | $bucket | $ftp.file.name) 值
        :type TaskVersionPath: str
        :param _TaskVersion: 该任务选定版本id：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 VersionId 取值
        :type TaskVersion: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskVersionPath = None
        self._TaskVersion = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskVersionPath(self):
        """该任务选定版本的存储路径：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 TaskInfo.TaskExt.Properties 下 Base64.encode($region | $bucket | $ftp.file.name) 值
        :rtype: str
        """
        return self._TaskVersionPath

    @TaskVersionPath.setter
    def TaskVersionPath(self, TaskVersionPath):
        self._TaskVersionPath = TaskVersionPath

    @property
    def TaskVersion(self):
        """该任务选定版本id：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 VersionId 取值
        :rtype: str
        """
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskVersionPath = params.get("TaskVersionPath")
        self._TaskVersion = params.get("TaskVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationVersionNodesInfoResponse(AbstractModel):
    """DescribeIntegrationVersionNodesInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Nodes: 任务节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Nodes: list of IntegrationNodeInfo
        :param _Mappings: 任务映射信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Mappings: list of IntegrationNodeMapping
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Nodes = None
        self._Mappings = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Nodes(self):
        """任务节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationNodeInfo
        """
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def Mappings(self):
        """任务映射信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IntegrationNodeMapping
        """
        return self._Mappings

    @Mappings.setter
    def Mappings(self, Mappings):
        self._Mappings = Mappings

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = IntegrationNodeInfo()
                obj._deserialize(item)
                self._Nodes.append(obj)
        if params.get("Mappings") is not None:
            self._Mappings = []
            for item in params.get("Mappings"):
                obj = IntegrationNodeMapping()
                obj._deserialize(item)
                self._Mappings.append(obj)
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeOfflineTaskTokenRequest(AbstractModel):
    """DescribeOfflineTaskToken请求参数结构体

    """


class DescribeOfflineTaskTokenResponse(AbstractModel):
    """DescribeOfflineTaskToken返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Token: 长连接临时token
        :type Token: str
        :param _Data: 长连接临时token。与Token相同含义，优先取Data，Data为空时，取Token。
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Token = None
        self._Data = None
        self._RequestId = None

    @property
    def Token(self):
        """长连接临时token
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Data(self):
        """长连接临时token。与Token相同含义，优先取Data，Data为空时，取Token。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeOperateOpsTasksRequest(AbstractModel):
    """DescribeOperateOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderIdList: 文件夹id，多个文件夹以逗号分隔
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，多个工作流id之间以英文字符逗号分隔
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称，多个工作流名称之间以英文字符逗号分隔
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称，多个任务名称之间以英文字符逗号分隔
        :type TaskNameList: str
        :param _TaskIdList: 任务id，多个任务id之间以英文字符逗号分隔
        :type TaskIdList: str
        :param _PageNumber: 页号
        :type PageNumber: str
        :param _PageSize: 分页大小
        :type PageSize: str
        :param _SortItem: 排序字段，支持字段为FirstSubmitTime和FirstRunTime，标识最近提交和首次执行事件
        :type SortItem: str
        :param _SortType: 排序类型。两种取值 DESC、ASC
        :type SortType: str
        :param _InChargeList: 责任人，多个责任人之间以英文字符逗号分隔
        :type InChargeList: str
        :param _TaskTypeIdList: 任务类型Id字符串，多个任务类型id之间以英文字符逗号分隔
        :type TaskTypeIdList: str
        :param _StatusList: 任务状态字符串，多个任务状态之间以英文字符逗号分隔
        :type StatusList: str
        :param _TaskCycleUnitList: 任务周期类型字符串，多个任务周期之间以英文字符逗号分隔
        :type TaskCycleUnitList: str
        :param _ProductNameList: 任务所属产品类型
        :type ProductNameList: str
        :param _SourceServiceId: 数据源id或（仅针对离线同步任务）来源数据源id
        :type SourceServiceId: str
        :param _SourceServiceType: 数据源类型或（仅针对离线同步任务）来源数据源类型
        :type SourceServiceType: str
        :param _TargetServiceId: （仅针对离线同步任务）目标数据源id
        :type TargetServiceId: str
        :param _TargetServiceType: （仅针对离线同步任务）目标数据源类型
        :type TargetServiceType: str
        :param _AlarmType: 告警类型，多个类型以逗号分隔
        :type AlarmType: str
        :param _ExecutorGroupIdList: 资源组id,多个资源组id之间以英文字符逗号分隔
        :type ExecutorGroupIdList: str
        :param _TaskTags: 任务标签
        :type TaskTags: list of TaskTag
        :param _KeyWord: 查询关键字
        :type KeyWord: str
        :param _InitStrategy: 实例生成方式
        :type InitStrategy: str
        :param _RequestResourceTypes: 额外请求的资源类型
        :type RequestResourceTypes: list of str
        :param _ProjectIds: 项目ID列表
        :type ProjectIds: list of str
        """
        self._ProjectId = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StatusList = None
        self._TaskCycleUnitList = None
        self._ProductNameList = None
        self._SourceServiceId = None
        self._SourceServiceType = None
        self._TargetServiceId = None
        self._TargetServiceType = None
        self._AlarmType = None
        self._ExecutorGroupIdList = None
        self._TaskTags = None
        self._KeyWord = None
        self._InitStrategy = None
        self._RequestResourceTypes = None
        self._ProjectIds = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderIdList(self):
        """文件夹id，多个文件夹以逗号分隔
        :rtype: str
        """
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        """工作流id，多个工作流id之间以英文字符逗号分隔
        :rtype: str
        """
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        """工作流名称，多个工作流名称之间以英文字符逗号分隔
        :rtype: str
        """
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        """任务名称，多个任务名称之间以英文字符逗号分隔
        :rtype: str
        """
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        """任务id，多个任务id之间以英文字符逗号分隔
        :rtype: str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def PageNumber(self):
        """页号
        :rtype: str
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: str
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        """排序字段，支持字段为FirstSubmitTime和FirstRunTime，标识最近提交和首次执行事件
        :rtype: str
        """
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        """排序类型。两种取值 DESC、ASC
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def InChargeList(self):
        """责任人，多个责任人之间以英文字符逗号分隔
        :rtype: str
        """
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        """任务类型Id字符串，多个任务类型id之间以英文字符逗号分隔
        :rtype: str
        """
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StatusList(self):
        """任务状态字符串，多个任务状态之间以英文字符逗号分隔
        :rtype: str
        """
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def TaskCycleUnitList(self):
        """任务周期类型字符串，多个任务周期之间以英文字符逗号分隔
        :rtype: str
        """
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def ProductNameList(self):
        """任务所属产品类型
        :rtype: str
        """
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def SourceServiceId(self):
        """数据源id或（仅针对离线同步任务）来源数据源id
        :rtype: str
        """
        return self._SourceServiceId

    @SourceServiceId.setter
    def SourceServiceId(self, SourceServiceId):
        self._SourceServiceId = SourceServiceId

    @property
    def SourceServiceType(self):
        """数据源类型或（仅针对离线同步任务）来源数据源类型
        :rtype: str
        """
        return self._SourceServiceType

    @SourceServiceType.setter
    def SourceServiceType(self, SourceServiceType):
        self._SourceServiceType = SourceServiceType

    @property
    def TargetServiceId(self):
        """（仅针对离线同步任务）目标数据源id
        :rtype: str
        """
        return self._TargetServiceId

    @TargetServiceId.setter
    def TargetServiceId(self, TargetServiceId):
        self._TargetServiceId = TargetServiceId

    @property
    def TargetServiceType(self):
        """（仅针对离线同步任务）目标数据源类型
        :rtype: str
        """
        return self._TargetServiceType

    @TargetServiceType.setter
    def TargetServiceType(self, TargetServiceType):
        self._TargetServiceType = TargetServiceType

    @property
    def AlarmType(self):
        """告警类型，多个类型以逗号分隔
        :rtype: str
        """
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def ExecutorGroupIdList(self):
        """资源组id,多个资源组id之间以英文字符逗号分隔
        :rtype: str
        """
        return self._ExecutorGroupIdList

    @ExecutorGroupIdList.setter
    def ExecutorGroupIdList(self, ExecutorGroupIdList):
        self._ExecutorGroupIdList = ExecutorGroupIdList

    @property
    def TaskTags(self):
        """任务标签
        :rtype: list of TaskTag
        """
        return self._TaskTags

    @TaskTags.setter
    def TaskTags(self, TaskTags):
        self._TaskTags = TaskTags

    @property
    def KeyWord(self):
        """查询关键字
        :rtype: str
        """
        return self._KeyWord

    @KeyWord.setter
    def KeyWord(self, KeyWord):
        self._KeyWord = KeyWord

    @property
    def InitStrategy(self):
        """实例生成方式
        :rtype: str
        """
        return self._InitStrategy

    @InitStrategy.setter
    def InitStrategy(self, InitStrategy):
        self._InitStrategy = InitStrategy

    @property
    def RequestResourceTypes(self):
        """额外请求的资源类型
        :rtype: list of str
        """
        return self._RequestResourceTypes

    @RequestResourceTypes.setter
    def RequestResourceTypes(self, RequestResourceTypes):
        self._RequestResourceTypes = RequestResourceTypes

    @property
    def ProjectIds(self):
        """项目ID列表
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StatusList = params.get("StatusList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._ProductNameList = params.get("ProductNameList")
        self._SourceServiceId = params.get("SourceServiceId")
        self._SourceServiceType = params.get("SourceServiceType")
        self._TargetServiceId = params.get("TargetServiceId")
        self._TargetServiceType = params.get("TargetServiceType")
        self._AlarmType = params.get("AlarmType")
        self._ExecutorGroupIdList = params.get("ExecutorGroupIdList")
        if params.get("TaskTags") is not None:
            self._TaskTags = []
            for item in params.get("TaskTags"):
                obj = TaskTag()
                obj._deserialize(item)
                self._TaskTags.append(obj)
        self._KeyWord = params.get("KeyWord")
        self._InitStrategy = params.get("InitStrategy")
        self._RequestResourceTypes = params.get("RequestResourceTypes")
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateOpsTasksResponse(AbstractModel):
    """DescribeOperateOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务列表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskInfoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务列表信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.OpsTaskInfoPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsInstanceLogListRequest(AbstractModel):
    """DescribeOpsInstanceLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        """数据时间
        :rtype: str
        """
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsInstanceLogListResponse(AbstractModel):
    """DescribeOpsInstanceLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceLogInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """实例日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceLogInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLogInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanInstancesRequest(AbstractModel):
    """DescribeOpsMakePlanInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _TaskId: 补录任务ID
        :type TaskId: str
        :param _PageNumber: 分页页码，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        :param _StateList: 实例状态列表
        :type StateList: list of int
        """
        self._ProjectId = None
        self._PlanId = None
        self._TaskId = None
        self._PageNumber = None
        self._PageSize = None
        self._StateList = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        """补录计划ID
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def TaskId(self):
        """补录任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def PageNumber(self):
        """分页页码，默认值1
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小，默认值10
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def StateList(self):
        """实例状态列表
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._TaskId = params.get("TaskId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._StateList = params.get("StateList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanInstancesResponse(AbstractModel):
    """DescribeOpsMakePlanInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanInstanceOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """补录计划实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.MakePlanInstanceOpsDtoCollection`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanInstanceOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanTasksRequest(AbstractModel):
    """DescribeOpsMakePlanTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _StateList: 实例状态过滤条件
        :type StateList: list of int
        :param _PageNumber: 分页页码，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        """
        self._ProjectId = None
        self._PlanId = None
        self._StateList = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        """补录计划ID
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def StateList(self):
        """实例状态过滤条件
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def PageNumber(self):
        """分页页码，默认值1
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小，默认值10
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._StateList = params.get("StateList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanTasksResponse(AbstractModel):
    """DescribeOpsMakePlanTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划任务分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanTaskOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """补录计划任务分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.MakePlanTaskOpsDtoCollection`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanTaskOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlansRequest(AbstractModel):
    """DescribeOpsMakePlans请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 分页数，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _PlanName: 补录计划名称
        :type PlanName: str
        :param _TaskName: 补录任务名称
        :type TaskName: str
        :param _TaskId: 补录任务ID
        :type TaskId: str
        :param _Creator: 补录计划创建者
        :type Creator: str
        :param _MinCreateTime: 补录计划最小创建时间
        :type MinCreateTime: str
        :param _MaxCreateTime: 补录计划最大创建时间
        :type MaxCreateTime: str
        :param _StateList: 实例状态过滤条件
        :type StateList: list of int
        :param _Keyword: 模糊查询关键字
        :type Keyword: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._PlanId = None
        self._PlanName = None
        self._TaskName = None
        self._TaskId = None
        self._Creator = None
        self._MinCreateTime = None
        self._MaxCreateTime = None
        self._StateList = None
        self._Keyword = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """分页数，默认值1
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小，默认值10
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PlanId(self):
        """补录计划ID
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def PlanName(self):
        """补录计划名称
        :rtype: str
        """
        return self._PlanName

    @PlanName.setter
    def PlanName(self, PlanName):
        self._PlanName = PlanName

    @property
    def TaskName(self):
        """补录任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        """补录任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Creator(self):
        """补录计划创建者
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def MinCreateTime(self):
        """补录计划最小创建时间
        :rtype: str
        """
        return self._MinCreateTime

    @MinCreateTime.setter
    def MinCreateTime(self, MinCreateTime):
        self._MinCreateTime = MinCreateTime

    @property
    def MaxCreateTime(self):
        """补录计划最大创建时间
        :rtype: str
        """
        return self._MaxCreateTime

    @MaxCreateTime.setter
    def MaxCreateTime(self, MaxCreateTime):
        self._MaxCreateTime = MaxCreateTime

    @property
    def StateList(self):
        """实例状态过滤条件
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def Keyword(self):
        """模糊查询关键字
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._PlanId = params.get("PlanId")
        self._PlanName = params.get("PlanName")
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._Creator = params.get("Creator")
        self._MinCreateTime = params.get("MinCreateTime")
        self._MaxCreateTime = params.get("MaxCreateTime")
        self._StateList = params.get("StateList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlansResponse(AbstractModel):
    """DescribeOpsMakePlans返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """补录计划分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.MakePlanOpsDtoCollection`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsWorkflowsRequest(AbstractModel):
    """DescribeOpsWorkflows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProductNameList: 任务产品类型名称列表，以 ',' 号分割
        :type ProductNameList: str
        :param _FolderIdList: 文件id列表，以 ',' 号分割
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，以 ',' 号分割
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称列表，以 ',' 号分割
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称列表，以 ',' 号分割
        :type TaskNameList: str
        :param _TaskIdList: 任务id列表，以 ',' 号分割
        :type TaskIdList: str
        :param _StatusList: 状态列表，以 ',' 号分割
        :type StatusList: str
        :param _InChargeList: 负责人列表，以 ',' 号分割
        :type InChargeList: str
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _SortItem: 排序项
        :type SortItem: str
        :param _SortType: 排序方式，DESC或ASC
        :type SortType: str
        :param _ProjectIds: 项目ID列表，用于多项目工作流筛选
        :type ProjectIds: list of str
        :param _WorkflowTypeList: 工作流类型列表 多个用英文逗号连接 cycle,manual. 默认只查询 cycle
        :type WorkflowTypeList: list of str
        :param _KeyWord: 工作流过滤keyword，支持工作流 id/name 模糊匹配， 多个用|分割
        :type KeyWord: str
        """
        self._ProjectId = None
        self._ProductNameList = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._StatusList = None
        self._InChargeList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._ProjectIds = None
        self._WorkflowTypeList = None
        self._KeyWord = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProductNameList(self):
        """任务产品类型名称列表，以 ',' 号分割
        :rtype: str
        """
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def FolderIdList(self):
        """文件id列表，以 ',' 号分割
        :rtype: str
        """
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        """工作流id，以 ',' 号分割
        :rtype: str
        """
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        """工作流名称列表，以 ',' 号分割
        :rtype: str
        """
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        """任务名称列表，以 ',' 号分割
        :rtype: str
        """
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        """任务id列表，以 ',' 号分割
        :rtype: str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def StatusList(self):
        """状态列表，以 ',' 号分割
        :rtype: str
        """
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def InChargeList(self):
        """负责人列表，以 ',' 号分割
        :rtype: str
        """
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        """排序项
        :rtype: str
        """
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        """排序方式，DESC或ASC
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def ProjectIds(self):
        """项目ID列表，用于多项目工作流筛选
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def WorkflowTypeList(self):
        """工作流类型列表 多个用英文逗号连接 cycle,manual. 默认只查询 cycle
        :rtype: list of str
        """
        return self._WorkflowTypeList

    @WorkflowTypeList.setter
    def WorkflowTypeList(self, WorkflowTypeList):
        self._WorkflowTypeList = WorkflowTypeList

    @property
    def KeyWord(self):
        """工作流过滤keyword，支持工作流 id/name 模糊匹配， 多个用|分割
        :rtype: str
        """
        return self._KeyWord

    @KeyWord.setter
    def KeyWord(self, KeyWord):
        self._KeyWord = KeyWord


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ProductNameList = params.get("ProductNameList")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._StatusList = params.get("StatusList")
        self._InChargeList = params.get("InChargeList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._ProjectIds = params.get("ProjectIds")
        self._WorkflowTypeList = params.get("WorkflowTypeList")
        self._KeyWord = params.get("KeyWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsWorkflowsResponse(AbstractModel):
    """DescribeOpsWorkflows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 工作流列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowExtOpsDtoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """工作流列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.WorkflowExtOpsDtoPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowExtOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOrganizationalFunctionsRequest(AbstractModel):
    """DescribeOrganizationalFunctions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 场景类型：开发、使用
        :type Type: str
        :param _ProjectId: 项目 ID
        :type ProjectId: str
        :param _Name: 函数名称
        :type Name: str
        :param _DisplayName: 展示名称
        :type DisplayName: str
        :param _EnvType: 标准模式开发环境：DEV
标准模式生产环境：PROD
简单模式：ALL

        :type EnvType: str
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序条件
        :type OrderFields: list of OrderField
        """
        self._Type = None
        self._ProjectId = None
        self._Name = None
        self._DisplayName = None
        self._EnvType = None
        self._Filters = None
        self._OrderFields = None

    @property
    def Type(self):
        """场景类型：开发、使用
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        """项目 ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        """函数名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        """展示名称
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def EnvType(self):
        """标准模式开发环境：DEV
标准模式生产环境：PROD
简单模式：ALL

        :rtype: str
        """
        return self._EnvType

    @EnvType.setter
    def EnvType(self, EnvType):
        self._EnvType = EnvType

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序条件
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        self._EnvType = params.get("EnvType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationalFunctionsResponse(AbstractModel):
    """DescribeOrganizationalFunctions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 函数信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: list of OrganizationalFunction
        :param _ErrorMessage: 操作失败
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Content = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Content(self):
        """函数信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OrganizationalFunction
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ErrorMessage(self):
        """操作失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = OrganizationalFunction()
                obj._deserialize(item)
                self._Content.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribePendingSubmitTaskInfo(AbstractModel):
    """待提交任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务编号
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _ModifyType: 修改类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyType: str
        :param _TaskStatus: 任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskStatus: str
        :param _SubmitPreCheck: 提交预检查（Y/N）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubmitPreCheck: str
        :param _SubmitPreCheckDetailList: 提交预检查提交可能会失败的原因
注意：此字段可能返回 null，表示取不到有效值。
        :type SubmitPreCheckDetailList: list of TaskSubmitPreCheckDetailInfo
        :param _ExecutorGroupId: 资源组编号
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupId: str
        :param _ExecutorGroupName: 资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupName: str
        """
        self._TaskId = None
        self._TaskName = None
        self._ModifyType = None
        self._TaskStatus = None
        self._SubmitPreCheck = None
        self._SubmitPreCheckDetailList = None
        self._ExecutorGroupId = None
        self._ExecutorGroupName = None

    @property
    def TaskId(self):
        """任务编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ModifyType(self):
        """修改类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModifyType

    @ModifyType.setter
    def ModifyType(self, ModifyType):
        self._ModifyType = ModifyType

    @property
    def TaskStatus(self):
        """任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def SubmitPreCheck(self):
        """提交预检查（Y/N）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubmitPreCheck

    @SubmitPreCheck.setter
    def SubmitPreCheck(self, SubmitPreCheck):
        self._SubmitPreCheck = SubmitPreCheck

    @property
    def SubmitPreCheckDetailList(self):
        """提交预检查提交可能会失败的原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskSubmitPreCheckDetailInfo
        """
        return self._SubmitPreCheckDetailList

    @SubmitPreCheckDetailList.setter
    def SubmitPreCheckDetailList(self, SubmitPreCheckDetailList):
        self._SubmitPreCheckDetailList = SubmitPreCheckDetailList

    @property
    def ExecutorGroupId(self):
        """资源组编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ExecutorGroupName(self):
        """资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExecutorGroupName

    @ExecutorGroupName.setter
    def ExecutorGroupName(self, ExecutorGroupName):
        self._ExecutorGroupName = ExecutorGroupName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._ModifyType = params.get("ModifyType")
        self._TaskStatus = params.get("TaskStatus")
        self._SubmitPreCheck = params.get("SubmitPreCheck")
        if params.get("SubmitPreCheckDetailList") is not None:
            self._SubmitPreCheckDetailList = []
            for item in params.get("SubmitPreCheckDetailList"):
                obj = TaskSubmitPreCheckDetailInfo()
                obj._deserialize(item)
                self._SubmitPreCheckDetailList.append(obj)
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ExecutorGroupName = params.get("ExecutorGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePendingSubmitTaskListRequest(AbstractModel):
    """DescribePendingSubmitTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目编号
        :type ProjectId: str
        :param _WorkflowId: 工作流编号
        :type WorkflowId: str
        :param _TaskIdList: 任务编号列表
        :type TaskIdList: list of str
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._TaskIdList = None

    @property
    def ProjectId(self):
        """项目编号
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        """工作流编号
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskIdList(self):
        """任务编号列表
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskIdList = params.get("TaskIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePendingSubmitTaskListResponse(AbstractModel):
    """DescribePendingSubmitTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 待提交任务信息
        :type Data: list of DescribePendingSubmitTaskInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """待提交任务信息
        :rtype: list of DescribePendingSubmitTaskInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribePendingSubmitTaskInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProjectRequest(AbstractModel):
    """DescribeProject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id。一般使用项目Id来查询，与projectName必须存在一个。
        :type ProjectId: str
        :param _DescribeClusters: 是否展示关联集群信息
        :type DescribeClusters: bool
        :param _DescribeExecutors: 是否展示关联执行组的信息，仅部分信息。
        :type DescribeExecutors: bool
        :param _DescribeAdminUsers: 默认不展示项目管理员信息
        :type DescribeAdminUsers: bool
        :param _DescribeMemberCount: 默认不统计项目人员数量
        :type DescribeMemberCount: bool
        :param _DescribeCreator: 默认不查询创建者的信息
        :type DescribeCreator: bool
        :param _ProjectName: 项目名只在租户内唯一，一般用来转化为项目ID。
        :type ProjectName: str
        """
        self._ProjectId = None
        self._DescribeClusters = None
        self._DescribeExecutors = None
        self._DescribeAdminUsers = None
        self._DescribeMemberCount = None
        self._DescribeCreator = None
        self._ProjectName = None

    @property
    def ProjectId(self):
        """项目id。一般使用项目Id来查询，与projectName必须存在一个。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DescribeClusters(self):
        """是否展示关联集群信息
        :rtype: bool
        """
        return self._DescribeClusters

    @DescribeClusters.setter
    def DescribeClusters(self, DescribeClusters):
        self._DescribeClusters = DescribeClusters

    @property
    def DescribeExecutors(self):
        """是否展示关联执行组的信息，仅部分信息。
        :rtype: bool
        """
        return self._DescribeExecutors

    @DescribeExecutors.setter
    def DescribeExecutors(self, DescribeExecutors):
        self._DescribeExecutors = DescribeExecutors

    @property
    def DescribeAdminUsers(self):
        """默认不展示项目管理员信息
        :rtype: bool
        """
        return self._DescribeAdminUsers

    @DescribeAdminUsers.setter
    def DescribeAdminUsers(self, DescribeAdminUsers):
        self._DescribeAdminUsers = DescribeAdminUsers

    @property
    def DescribeMemberCount(self):
        """默认不统计项目人员数量
        :rtype: bool
        """
        return self._DescribeMemberCount

    @DescribeMemberCount.setter
    def DescribeMemberCount(self, DescribeMemberCount):
        self._DescribeMemberCount = DescribeMemberCount

    @property
    def DescribeCreator(self):
        """默认不查询创建者的信息
        :rtype: bool
        """
        return self._DescribeCreator

    @DescribeCreator.setter
    def DescribeCreator(self, DescribeCreator):
        self._DescribeCreator = DescribeCreator

    @property
    def ProjectName(self):
        """项目名只在租户内唯一，一般用来转化为项目ID。
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DescribeClusters = params.get("DescribeClusters")
        self._DescribeExecutors = params.get("DescribeExecutors")
        self._DescribeAdminUsers = params.get("DescribeAdminUsers")
        self._DescribeMemberCount = params.get("DescribeMemberCount")
        self._DescribeCreator = params.get("DescribeCreator")
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectResponse(AbstractModel):
    """DescribeProject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 项目信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Project`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """项目信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.Project`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Project()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeProjectUsersRequest(AbstractModel):
    """DescribeProjectUsers请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 【过滤参数】自定义条件查询
        :type Filters: list of FilterOptional
        :param _OrderFields: 【排序参数】排序字段
        :type OrderFields: list of OrderFieldOptional
        :param _IsProjectAdmin: 是否项目管理员
        :type IsProjectAdmin: bool
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._IsProjectAdmin = None

    @property
    def PageNumber(self):
        """分页号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """【过滤参数】自定义条件查询
        :rtype: list of FilterOptional
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """【排序参数】排序字段
        :rtype: list of OrderFieldOptional
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def IsProjectAdmin(self):
        """是否项目管理员
        :rtype: bool
        """
        return self._IsProjectAdmin

    @IsProjectAdmin.setter
    def IsProjectAdmin(self, IsProjectAdmin):
        self._IsProjectAdmin = IsProjectAdmin


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterOptional()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderFieldOptional()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._IsProjectAdmin = params.get("IsProjectAdmin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectUsersResponse(AbstractModel):
    """DescribeProjectUsers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 项目列表
        :type Data: :class:`tencentcloud.wedata.v20210820.models.ProjectUsersPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """项目列表
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ProjectUsersPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ProjectUsersPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreRequest(AbstractModel):
    """DescribeQualityScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        """统计日期
        :rtype: int
        """
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        """数据来源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        """1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :rtype: str
        """
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        """过滤参数
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreResponse(AbstractModel):
    """DescribeQualityScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScore`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """质量评分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.QualityScore`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreTrendRequest(AbstractModel):
    """DescribeQualityScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsStartDate: 统计开始日期
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 统计结束日期
        :type StatisticsEndDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsStartDate(self):
        """统计开始日期
        :rtype: int
        """
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        """统计结束日期
        :rtype: int
        """
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        """数据来源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        """1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :rtype: str
        """
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        """过滤参数
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreTrendResponse(AbstractModel):
    """DescribeQualityScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分趋势视图
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """质量评分趋势视图
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskInstanceNodeInfoRequest(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 实时任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        """实时任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskInstanceNodeInfoResponse(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RealTimeTaskInstanceNodeInfo: 实时任务实例节点相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RealTimeTaskInstanceNodeInfo: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskInstanceNodeInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RealTimeTaskInstanceNodeInfo = None
        self._RequestId = None

    @property
    def RealTimeTaskInstanceNodeInfo(self):
        """实时任务实例节点相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskInstanceNodeInfo`
        """
        return self._RealTimeTaskInstanceNodeInfo

    @RealTimeTaskInstanceNodeInfo.setter
    def RealTimeTaskInstanceNodeInfo(self, RealTimeTaskInstanceNodeInfo):
        self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RealTimeTaskInstanceNodeInfo") is not None:
            self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo()
            self._RealTimeTaskInstanceNodeInfo._deserialize(params.get("RealTimeTaskInstanceNodeInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskMetricOverviewRequest(AbstractModel):
    """DescribeRealTimeTaskMetricOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 要查看的实时任务的任务ID，可在任务列表页面中获得
        :type TaskId: str
        :param _ProjectId: 要查看的项目ID
        :type ProjectId: str
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _EndTime: 结束时间
        :type EndTime: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def TaskId(self):
        """要查看的实时任务的任务ID，可在任务列表页面中获得
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """要查看的项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        """开始时间
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskMetricOverviewResponse(AbstractModel):
    """DescribeRealTimeTaskMetricOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalRecordNumOfRead: 总读取记录数
        :type TotalRecordNumOfRead: int
        :param _TotalRecordByteNumOfRead: 总读取字节数
        :type TotalRecordByteNumOfRead: int
        :param _TotalRecordNumOfWrite: 总写入记录数
        :type TotalRecordNumOfWrite: int
        :param _TotalRecordByteNumOfWrite: 总写入字节数 单位字节
        :type TotalRecordByteNumOfWrite: int
        :param _TotalDirtyRecordNum: 总的脏记录数据
        :type TotalDirtyRecordNum: int
        :param _TotalDirtyRecordByte: 总的脏字节数 单位字节
        :type TotalDirtyRecordByte: int
        :param _TotalDuration: 运行时长 单位s
        :type TotalDuration: int
        :param _BeginRunTime: 开始运行时间
        :type BeginRunTime: str
        :param _EndRunTime: 目前运行到的时间
        :type EndRunTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalRecordNumOfRead = None
        self._TotalRecordByteNumOfRead = None
        self._TotalRecordNumOfWrite = None
        self._TotalRecordByteNumOfWrite = None
        self._TotalDirtyRecordNum = None
        self._TotalDirtyRecordByte = None
        self._TotalDuration = None
        self._BeginRunTime = None
        self._EndRunTime = None
        self._RequestId = None

    @property
    def TotalRecordNumOfRead(self):
        """总读取记录数
        :rtype: int
        """
        return self._TotalRecordNumOfRead

    @TotalRecordNumOfRead.setter
    def TotalRecordNumOfRead(self, TotalRecordNumOfRead):
        self._TotalRecordNumOfRead = TotalRecordNumOfRead

    @property
    def TotalRecordByteNumOfRead(self):
        """总读取字节数
        :rtype: int
        """
        return self._TotalRecordByteNumOfRead

    @TotalRecordByteNumOfRead.setter
    def TotalRecordByteNumOfRead(self, TotalRecordByteNumOfRead):
        self._TotalRecordByteNumOfRead = TotalRecordByteNumOfRead

    @property
    def TotalRecordNumOfWrite(self):
        """总写入记录数
        :rtype: int
        """
        return self._TotalRecordNumOfWrite

    @TotalRecordNumOfWrite.setter
    def TotalRecordNumOfWrite(self, TotalRecordNumOfWrite):
        self._TotalRecordNumOfWrite = TotalRecordNumOfWrite

    @property
    def TotalRecordByteNumOfWrite(self):
        """总写入字节数 单位字节
        :rtype: int
        """
        return self._TotalRecordByteNumOfWrite

    @TotalRecordByteNumOfWrite.setter
    def TotalRecordByteNumOfWrite(self, TotalRecordByteNumOfWrite):
        self._TotalRecordByteNumOfWrite = TotalRecordByteNumOfWrite

    @property
    def TotalDirtyRecordNum(self):
        """总的脏记录数据
        :rtype: int
        """
        return self._TotalDirtyRecordNum

    @TotalDirtyRecordNum.setter
    def TotalDirtyRecordNum(self, TotalDirtyRecordNum):
        self._TotalDirtyRecordNum = TotalDirtyRecordNum

    @property
    def TotalDirtyRecordByte(self):
        """总的脏字节数 单位字节
        :rtype: int
        """
        return self._TotalDirtyRecordByte

    @TotalDirtyRecordByte.setter
    def TotalDirtyRecordByte(self, TotalDirtyRecordByte):
        self._TotalDirtyRecordByte = TotalDirtyRecordByte

    @property
    def TotalDuration(self):
        """运行时长 单位s
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def BeginRunTime(self):
        """开始运行时间
        :rtype: str
        """
        return self._BeginRunTime

    @BeginRunTime.setter
    def BeginRunTime(self, BeginRunTime):
        self._BeginRunTime = BeginRunTime

    @property
    def EndRunTime(self):
        """目前运行到的时间
        :rtype: str
        """
        return self._EndRunTime

    @EndRunTime.setter
    def EndRunTime(self, EndRunTime):
        self._EndRunTime = EndRunTime

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalRecordNumOfRead = params.get("TotalRecordNumOfRead")
        self._TotalRecordByteNumOfRead = params.get("TotalRecordByteNumOfRead")
        self._TotalRecordNumOfWrite = params.get("TotalRecordNumOfWrite")
        self._TotalRecordByteNumOfWrite = params.get("TotalRecordByteNumOfWrite")
        self._TotalDirtyRecordNum = params.get("TotalDirtyRecordNum")
        self._TotalDirtyRecordByte = params.get("TotalDirtyRecordByte")
        self._TotalDuration = params.get("TotalDuration")
        self._BeginRunTime = params.get("BeginRunTime")
        self._EndRunTime = params.get("EndRunTime")
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskSpeedRequest(AbstractModel):
    """DescribeRealTimeTaskSpeed请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _StartTime: 带毫秒的时间戳
        :type StartTime: int
        :param _EndTime: 带毫秒的时间戳
        :type EndTime: int
        :param _Granularity: 粒度，1或者5
        :type Granularity: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._ProjectId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        """带毫秒的时间戳
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """带毫秒的时间戳
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        """粒度，1或者5
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskSpeedResponse(AbstractModel):
    """DescribeRealTimeTaskSpeed返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordsSpeedList: 同步速度条/s列表
        :type RecordsSpeedList: list of RecordsSpeed
        :param _BytesSpeedList: 同步速度字节/s列表
        :type BytesSpeedList: list of BytesSpeed
        :param _Data: 同步速度，包括了RecordsSpeedList和BytesSpeedList
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskSpeed`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecordsSpeedList = None
        self._BytesSpeedList = None
        self._Data = None
        self._RequestId = None

    @property
    def RecordsSpeedList(self):
        """同步速度条/s列表
        :rtype: list of RecordsSpeed
        """
        return self._RecordsSpeedList

    @RecordsSpeedList.setter
    def RecordsSpeedList(self, RecordsSpeedList):
        self._RecordsSpeedList = RecordsSpeedList

    @property
    def BytesSpeedList(self):
        """同步速度字节/s列表
        :rtype: list of BytesSpeed
        """
        return self._BytesSpeedList

    @BytesSpeedList.setter
    def BytesSpeedList(self, BytesSpeedList):
        self._BytesSpeedList = BytesSpeedList

    @property
    def Data(self):
        """同步速度，包括了RecordsSpeedList和BytesSpeedList
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskSpeed`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RecordsSpeedList") is not None:
            self._RecordsSpeedList = []
            for item in params.get("RecordsSpeedList"):
                obj = RecordsSpeed()
                obj._deserialize(item)
                self._RecordsSpeedList.append(obj)
        if params.get("BytesSpeedList") is not None:
            self._BytesSpeedList = []
            for item in params.get("BytesSpeedList"):
                obj = BytesSpeed()
                obj._deserialize(item)
                self._BytesSpeedList.append(obj)
        if params.get("Data") is not None:
            self._Data = RealTimeTaskSpeed()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeResourceManagePathTreesRequest(AbstractModel):
    """DescribeResourceManagePathTrees请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Name: 名字，供搜索
        :type Name: str
        :param _FileType: 文件类型
        :type FileType: str
        :param _FilePath: 文件路径
        :type FilePath: str
        :param _DirType: 文件夹类型
personal 个人
project 项目
resource 资源
        :type DirType: str
        """
        self._ProjectId = None
        self._Name = None
        self._FileType = None
        self._FilePath = None
        self._DirType = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        """名字，供搜索
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FileType(self):
        """文件类型
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FilePath(self):
        """文件路径
        :rtype: str
        """
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def DirType(self):
        """文件夹类型
personal 个人
project 项目
resource 资源
        :rtype: str
        """
        return self._DirType

    @DirType.setter
    def DirType(self, DirType):
        self._DirType = DirType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._FileType = params.get("FileType")
        self._FilePath = params.get("FilePath")
        self._DirType = params.get("DirType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceManagePathTreesResponse(AbstractModel):
    """DescribeResourceManagePathTrees返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ResourcePathTree
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ResourcePathTree
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResourcePathTree()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDimStatRequest(AbstractModel):
    """DescribeRuleDimStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        """开始时间，时间戳到秒
        :rtype: str
        """
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        """结束时间，时间戳到秒
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDimStatResponse(AbstractModel):
    """DescribeRuleDimStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleDimStat`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleDimStat`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleDimStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecDetailRequest(AbstractModel):
    """DescribeRuleExecDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行id
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        """规则执行id
        :rtype: int
        """
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecDetailResponse(AbstractModel):
    """DescribeRuleExecDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultDetail`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则执行结果详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultDetail`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecLogRequest(AbstractModel):
    """DescribeRuleExecLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleExecId: 规则执行Id
        :type RuleExecId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupExecId: 规则组执行id
        :type RuleGroupExecId: int
        """
        self._RuleExecId = None
        self._ProjectId = None
        self._RuleGroupExecId = None

    @property
    def RuleExecId(self):
        """规则执行Id
        :rtype: int
        """
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        """规则组执行id
        :rtype: int
        """
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecLogResponse(AbstractModel):
    """DescribeRuleExecLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行日志
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecLog`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则执行日志
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleExecLog`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecLog()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsRequest(AbstractModel):
    """DescribeRuleExecResults请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 规则组执行Id
        :type RuleGroupExecId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupExecId = None
        self._ProjectId = None

    @property
    def RuleGroupExecId(self):
        """规则组执行Id
        :rtype: int
        """
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsResponse(AbstractModel):
    """DescribeRuleExecResults返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecStatRequest(AbstractModel):
    """DescribeRuleExecStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        """开始时间，时间戳到秒
        :rtype: str
        """
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        """结束时间，时间戳到秒
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecStatResponse(AbstractModel):
    """DescribeRuleExecStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecStat`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleExecStat`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        """分页序号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupRequest(AbstractModel):
    """DescribeRuleGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _DatasourceId: 数据来源ID
        :type DatasourceId: str
        :param _TableId: 数据表Id
        :type TableId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _DatabaseId: 数据库ID
        :type DatabaseId: str
        """
        self._RuleGroupId = None
        self._DatasourceId = None
        self._TableId = None
        self._ProjectId = None
        self._DatabaseId = None

    @property
    def RuleGroupId(self):
        """规则组ID
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def DatasourceId(self):
        """数据来源ID
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        """数据表Id
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatabaseId(self):
        """数据库ID
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._ProjectId = params.get("ProjectId")
        self._DatabaseId = params.get("DatabaseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupResponse(AbstractModel):
    """DescribeRuleGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据质量规则组详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """数据质量规则组详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroup`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroup()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupSubscriptionRequest(AbstractModel):
    """DescribeRuleGroupSubscription请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        """规则组ID
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupSubscriptionResponse(AbstractModel):
    """DescribeRuleGroupSubscription返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组订阅信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则组订阅信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupSubscribe()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupTableRequest(AbstractModel):
    """DescribeRuleGroupTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        """
        self._TableId = None

    @property
    def TableId(self):
        """表ID
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupTableResponse(AbstractModel):
    """DescribeRuleGroupTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTable`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTable`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupTable()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupsByPageRequest(AbstractModel):
    """DescribeRuleGroupsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件,每次请求的Filters的上限为10，Filter.Values的上限为5
        :type Filters: list of Filter
        :param _OrderFields: 排序方式
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        """分页序号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件,每次请求的Filters的上限为10，Filter.Values的上限为5
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序方式
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupsByPageResponse(AbstractModel):
    """DescribeRuleGroupsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则组列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleRequest(AbstractModel):
    """DescribeRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        """质量规则ID
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleResponse(AbstractModel):
    """DescribeRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.Rule`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplateRequest(AbstractModel):
    """DescribeRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TemplateId: 规则模板Id
        :type TemplateId: int
        """
        self._ProjectId = None
        self._TemplateId = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TemplateId(self):
        """规则模板Id
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplateResponse(AbstractModel):
    """DescribeRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """模板详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleTemplate`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplate()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesByPageRequest(AbstractModel):
    """DescribeRuleTemplatesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 工作空间ID
        :type ProjectId: str
        :param _OrderFields: 通用排序字段
        :type OrderFields: list of OrderField
        :param _Filters: 通用过滤条件
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        """当前页
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页记录数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """工作空间ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def OrderFields(self):
        """通用排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        """通用过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesByPageResponse(AbstractModel):
    """DescribeRuleTemplatesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplatePage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """结果
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RuleTemplatePage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplatePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesRequest(AbstractModel):
    """DescribeRuleTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模板类型 1.系统模板 2.自定义模板
        :type Type: int
        :param _SourceObjectType: 1.常量 2.离线表级 2.离线字段级
        :type SourceObjectType: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        """
        self._Type = None
        self._SourceObjectType = None
        self._ProjectId = None
        self._SourceEngineTypes = None

    @property
    def Type(self):
        """模板类型 1.系统模板 2.自定义模板
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SourceObjectType(self):
        """1.常量 2.离线表级 2.离线字段级
        :rtype: int
        """
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SourceEngineTypes(self):
        """源端对应的引擎类型
        :rtype: list of int non-negative
        """
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SourceObjectType = params.get("SourceObjectType")
        self._ProjectId = params.get("ProjectId")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesResponse(AbstractModel):
    """DescribeRuleTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则模板列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuleTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则模板列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of RuleTemplate
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleTemplate()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesByPageRequest(AbstractModel):
    """DescribeRulesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        """分页序号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesByPageResponse(AbstractModel):
    """DescribeRulesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则质量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RulePage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则质量列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.RulePage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RulePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRulesRequest(AbstractModel):
    """DescribeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组id
        :type RuleGroupId: int
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._EngineType = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        """规则组id
        :rtype: int
        """
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def EngineType(self):
        """该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesResponse(AbstractModel):
    """DescribeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of Rule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """规则列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Rule
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = Rule()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScheduleInstancesRequest(AbstractModel):
    """DescribeScheduleInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        :param _ProjectIds: 项目ID列表，用于多项目实例列表筛选，请注意，该字段传入时 ProjectId 字段也必须传，且传入的 ProjectIds 中的项目ID必须是当前用户有权限的项目ID，否则会由于权限校验失败报错
        :type ProjectIds: list of str
        """
        self._RequestFromSource = None
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None
        self._ProjectIds = None

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def Instances(self):
        """实例列表
        :rtype: list of InstanceOpsDto
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        """检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :rtype: bool
        """
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        """重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :rtype: str
        """
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        """实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :rtype: str
        """
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        """重跑忽略事件监听与否 
        :rtype: bool
        """
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        """下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :rtype: str
        """
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        """查询条件
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        """
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        """访问类型
        :rtype: str
        """
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        """操作者名称
        :rtype: str
        """
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        """操作者id
        :rtype: str
        """
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        """项目标志
        :rtype: str
        """
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        """索引页码
        :rtype: int
        """
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        """页面大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        """数据总数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        """基础请求信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        """
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        """是否计算总数
        :rtype: bool
        """
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount

    @property
    def ProjectIds(self):
        """项目ID列表，用于多项目实例列表筛选，请注意，该字段传入时 ProjectId 字段也必须传，且传入的 ProjectIds 中的项目ID必须是当前用户有权限的项目ID，否则会由于权限校验失败报错
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._RequestFromSource = params.get("RequestFromSource")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScheduleInstancesResponse(AbstractModel):
    """DescribeScheduleInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestFromSource: str
        :param _Data: 实例结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestFromSource = None
        self._Data = None
        self._RequestId = None

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def Data(self):
        """实例结果集
        :rtype: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestFromSource = params.get("RequestFromSource")
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSchedulerInstanceStatusRequest(AbstractModel):
    """DescribeSchedulerInstanceStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskTypeId: 任务类型ID
        :type TaskTypeId: str
        :param _ExecutionGroupId: 执行资源组ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: 执行资源组名字
        :type ExecutionGroupName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InCharge: 责任人
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ProjectIds: 任务ID列表
        :type ProjectIds: list of str
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._StartTime = None
        self._EndTime = None
        self._InCharge = None
        self._WorkflowId = None
        self._ProjectIds = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        """任务类型ID
        :rtype: str
        """
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def ExecutionGroupId(self):
        """执行资源组ID
        :rtype: str
        """
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        """执行资源组名字
        :rtype: str
        """
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InCharge(self):
        """责任人
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectIds(self):
        """任务ID列表
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerInstanceStatusResponse(AbstractModel):
    """DescribeSchedulerInstanceStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ScreenInstanceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ScreenInstanceInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenInstanceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerRunTimeInstanceCntByStatusRequest(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _CycleUnit: 周期类型
        :type CycleUnit: str
        :param _TimeUnit: 时间单元 eg: 12h
        :type TimeUnit: str
        :param _StartTime: 开始日期：2023-03-02
        :type StartTime: str
        :param _EndTime: 结束日前：2023-03-20
        :type EndTime: str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _InCharge: 责任人
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _SortItem: 排序字段
        :type SortItem: str
        :param _SortType: 升序降序
        :type SortType: str
        :param _ProjectIds: 项目ID列表，如果传了 ProjectIds，则 ProjectId 不会生效，用于多项目筛选
        :type ProjectIds: list of str
        """
        self._ProjectId = None
        self._CycleUnit = None
        self._TimeUnit = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None
        self._InCharge = None
        self._WorkflowId = None
        self._SortItem = None
        self._SortType = None
        self._ProjectIds = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleUnit(self):
        """周期类型
        :rtype: str
        """
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def TimeUnit(self):
        """时间单元 eg: 12h
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def StartTime(self):
        """开始日期：2023-03-02
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日前：2023-03-20
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        """任务类型
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InCharge(self):
        """责任人
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def SortItem(self):
        """排序字段
        :rtype: str
        """
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        """升序降序
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def ProjectIds(self):
        """项目ID列表，如果传了 ProjectIds，则 ProjectId 不会生效，用于多项目筛选
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleUnit = params.get("CycleUnit")
        self._TimeUnit = params.get("TimeUnit")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerRunTimeInstanceCntByStatusResponse(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuntimeInstanceCntTop
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of RuntimeInstanceCntTop
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuntimeInstanceCntTop()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskCntByStatusRequest(AbstractModel):
    """DescribeSchedulerTaskCntByStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 1
        :type TaskType: int
        :param _TypeName: Y
        :type TypeName: str
        :param _ProjectId: 111
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ProjectIds: 项目ID列表，如果传了 ProjectIds ，ProjectId 不会生效
        :type ProjectIds: list of str
        :param _ResourceGroupIds: 资源组ID筛选
        :type ResourceGroupIds: list of str
        """
        self._TaskType = None
        self._TypeName = None
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None
        self._ProjectIds = None
        self._ResourceGroupIds = None

    @property
    def TaskType(self):
        """1
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        """Y
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def ProjectId(self):
        """111
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        """1
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectIds(self):
        """项目ID列表，如果传了 ProjectIds ，ProjectId 不会生效
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ResourceGroupIds(self):
        """资源组ID筛选
        :rtype: list of str
        """
        return self._ResourceGroupIds

    @ResourceGroupIds.setter
    def ResourceGroupIds(self, ResourceGroupIds):
        self._ResourceGroupIds = ResourceGroupIds


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectIds = params.get("ProjectIds")
        self._ResourceGroupIds = params.get("ResourceGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskCntByStatusResponse(AbstractModel):
    """DescribeSchedulerTaskCntByStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ScreenTaskInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ScreenTaskInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenTaskInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskTypeCntRequest(AbstractModel):
    """DescribeSchedulerTaskTypeCnt请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _InCharge: 责任人
        :type InCharge: str
        """
        self._ProjectId = None
        self._InCharge = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        """责任人
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskTypeCntResponse(AbstractModel):
    """DescribeSchedulerTaskTypeCnt返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: data
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskTypeCnt
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """data
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskTypeCnt
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskTypeCnt()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStatisticInstanceStatusTrendOpsRequest(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskTypeId: 任务类型Id
        :type TaskTypeId: str
        :param _TimeType: 时间类型
        :type TimeType: str
        :param _TypeName: 任务类型名称
        :type TypeName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _ExecutionGroupId: 资源组ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: 资源组名称
        :type ExecutionGroupName: str
        :param _InCharge: 1
        :type InCharge: str
        :param _TaskType: 1
        :type TaskType: int
        :param _StateList: 1
        :type StateList: list of int
        :param _AggregationUnit: D代表天，H代表小时
        :type AggregationUnit: str
        :param _AverageWindowSize: 1
        :type AverageWindowSize: int
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ProjectIds: 项目ID列表，用于多项目实例趋势筛选，当指定了 ProjectIds 的时候，ProjectId 将只用来鉴权，不做筛选
        :type ProjectIds: list of str
        :param _TimePoint: 指定时间点，当统计时常为整天的时候使用，必须小于 24
        :type TimePoint: int
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._TimeType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._InCharge = None
        self._TaskType = None
        self._StateList = None
        self._AggregationUnit = None
        self._AverageWindowSize = None
        self._WorkflowId = None
        self._ProjectIds = None
        self._TimePoint = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        """任务类型Id
        :rtype: str
        """
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TimeType(self):
        """时间类型
        :rtype: str
        """
        return self._TimeType

    @TimeType.setter
    def TimeType(self, TimeType):
        self._TimeType = TimeType

    @property
    def TypeName(self):
        """任务类型名称
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ExecutionGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        """资源组名称
        :rtype: str
        """
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def InCharge(self):
        """1
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def TaskType(self):
        """1
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StateList(self):
        """1
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def AggregationUnit(self):
        """D代表天，H代表小时
        :rtype: str
        """
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def AverageWindowSize(self):
        """1
        :rtype: int
        """
        return self._AverageWindowSize

    @AverageWindowSize.setter
    def AverageWindowSize(self, AverageWindowSize):
        self._AverageWindowSize = AverageWindowSize

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectIds(self):
        """项目ID列表，用于多项目实例趋势筛选，当指定了 ProjectIds 的时候，ProjectId 将只用来鉴权，不做筛选
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def TimePoint(self):
        """指定时间点，当统计时常为整天的时候使用，必须小于 24
        :rtype: int
        """
        return self._TimePoint

    @TimePoint.setter
    def TimePoint(self, TimePoint):
        self._TimePoint = TimePoint


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TimeType = params.get("TimeType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._InCharge = params.get("InCharge")
        self._TaskType = params.get("TaskType")
        self._StateList = params.get("StateList")
        self._AggregationUnit = params.get("AggregationUnit")
        self._AverageWindowSize = params.get("AverageWindowSize")
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectIds = params.get("ProjectIds")
        self._TimePoint = params.get("TimePoint")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStatisticInstanceStatusTrendOpsResponse(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例状态统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceStatisticInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """实例状态统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceStatisticInfo
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceStatisticInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamTaskLogListRequest(AbstractModel):
    """DescribeStreamTaskLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _JobId: 作业ID
        :type JobId: str
        :param _EndTime: 结束时间
        :type EndTime: int
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _Container: container名字
        :type Container: str
        :param _Limit: 条数
        :type Limit: int
        :param _OrderType: 排序类型 desc asc
        :type OrderType: str
        :param _RunningOrderId: 作业运行的实例ID
        :type RunningOrderId: int
        :param _Keyword: 关键字
        :type Keyword: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._JobId = None
        self._EndTime = None
        self._StartTime = None
        self._Container = None
        self._Limit = None
        self._OrderType = None
        self._RunningOrderId = None
        self._Keyword = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def JobId(self):
        """作业ID
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def EndTime(self):
        """结束时间
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        """开始时间
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Container(self):
        """container名字
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Limit(self):
        """条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        """排序类型 desc asc
        :rtype: str
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def RunningOrderId(self):
        """作业运行的实例ID
        :rtype: int
        """
        return self._RunningOrderId

    @RunningOrderId.setter
    def RunningOrderId(self, RunningOrderId):
        self._RunningOrderId = RunningOrderId

    @property
    def Keyword(self):
        """关键字
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._JobId = params.get("JobId")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._Container = params.get("Container")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._RunningOrderId = params.get("RunningOrderId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamTaskLogListResponse(AbstractModel):
    """DescribeStreamTaskLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ListOver: 是否是全量
注意：此字段可能返回 null，表示取不到有效值。
        :type ListOver: bool
        :param _LogContentList: 日志集合
注意：此字段可能返回 null，表示取不到有效值。
        :type LogContentList: list of LogContentInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ListOver = None
        self._LogContentList = None
        self._RequestId = None

    @property
    def ListOver(self):
        """是否是全量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def LogContentList(self):
        """日志集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of LogContentInfo
        """
        return self._LogContentList

    @LogContentList.setter
    def LogContentList(self, LogContentList):
        self._LogContentList = LogContentList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ListOver = params.get("ListOver")
        if params.get("LogContentList") is not None:
            self._LogContentList = []
            for item in params.get("LogContentList"):
                obj = LogContentInfo()
                obj._deserialize(item)
                self._LogContentList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSuccessorOpsTaskInfosRequest(AbstractModel):
    """DescribeSuccessorOpsTaskInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuccessorOpsTaskInfosResponse(AbstractModel):
    """DescribeSuccessorOpsTaskInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 下游任务列表
        :type Data: list of TaskOpsDto
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """下游任务列表
        :rtype: list of TaskOpsDto
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableBasicInfoRequest(AbstractModel):
    """DescribeTableBasicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤字段
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableBasicInfoResponse(AbstractModel):
    """DescribeTableBasicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBasicInfoList: 表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type TableBasicInfoList: list of TableBasicInfo
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableBasicInfoList(self):
        """表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TableBasicInfo
        """
        return self._TableBasicInfoList

    @TableBasicInfoList.setter
    def TableBasicInfoList(self, TableBasicInfoList):
        self._TableBasicInfoList = TableBasicInfoList

    @property
    def TotalCount(self):
        """总条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableBasicInfoList") is not None:
            self._TableBasicInfoList = []
            for item in params.get("TableBasicInfoList"):
                obj = TableBasicInfo()
                obj._deserialize(item)
                self._TableBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableInfoListRequest(AbstractModel):
    """DescribeTableInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 表名
        :type Filters: list of Filter
        :param _ConnectionType: 如果是hive这里写rpc，如果是其他类型不传
        :type ConnectionType: str
        :param _Catalog: 数据库源类型
        :type Catalog: str
        """
        self._Filters = None
        self._ConnectionType = None
        self._Catalog = None

    @property
    def Filters(self):
        """表名
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        """如果是hive这里写rpc，如果是其他类型不传
        :rtype: str
        """
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def Catalog(self):
        """数据库源类型
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        self._Catalog = params.get("Catalog")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableInfoListResponse(AbstractModel):
    """DescribeTableInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableInfo: 表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableInfo: list of TableInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableInfo = None
        self._RequestId = None

    @property
    def TableInfo(self):
        """表信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TableInfo
        """
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = []
            for item in params.get("TableInfo"):
                obj = TableInfo()
                obj._deserialize(item)
                self._TableInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableLineageInfoRequest(AbstractModel):
    """DescribeTableLineageInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: 单次查询入度,默认 1
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度,默认 1
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: 是否过滤临时表,默认true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: 是否递归查询二级节点数目，默认为true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        """查询方向，INPUT,OUTPUT,BOTH枚举值
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        """表信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        """单次查询入度,默认 1
        :rtype: int
        """
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        """单次查询出度,默认 1
        :rtype: int
        """
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        """额外参数（传递调用方信息）
        :rtype: list of LineageParamRecord
        """
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        """是否过滤临时表,默认true
        :rtype: bool
        """
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        """是否递归查询二级节点数目，默认为true
        :rtype: bool
        """
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageInfoResponse(AbstractModel):
    """DescribeTableLineageInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableLineageBasicInfo: 表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableLineageBasicInfo: :class:`tencentcloud.wedata.v20210820.models.TableLineageBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableLineageBasicInfo = None
        self._RequestId = None

    @property
    def TableLineageBasicInfo(self):
        """表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableLineageBaseInfo`
        """
        return self._TableLineageBasicInfo

    @TableLineageBasicInfo.setter
    def TableLineageBasicInfo(self, TableLineageBasicInfo):
        self._TableLineageBasicInfo = TableLineageBasicInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineageBasicInfo") is not None:
            self._TableLineageBasicInfo = TableLineageBaseInfo()
            self._TableLineageBasicInfo._deserialize(params.get("TableLineageBasicInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTableLineageRequest(AbstractModel):
    """DescribeTableLineage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: 单次查询入度,默认 1
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度,默认 1
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: 是否过滤临时表,默认true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: 是否递归查询二级节点数目，默认为true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        """查询方向，INPUT,OUTPUT,BOTH枚举值
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        """表信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        """单次查询入度,默认 1
        :rtype: int
        """
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        """单次查询出度,默认 1
        :rtype: int
        """
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        """额外参数（传递调用方信息）
        :rtype: list of LineageParamRecord
        """
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        """是否过滤临时表,默认true
        :rtype: bool
        """
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        """是否递归查询二级节点数目，默认为true
        :rtype: bool
        """
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageResponse(AbstractModel):
    """DescribeTableLineage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableLineage: 表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableLineage: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableLineage = None
        self._RequestId = None

    @property
    def TableLineage(self):
        """表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        """
        return self._TableLineage

    @TableLineage.setter
    def TableLineage(self, TableLineage):
        self._TableLineage = TableLineage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineage") is not None:
            self._TableLineage = TableLineageInfo()
            self._TableLineage._deserialize(params.get("TableLineage"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetaRequest(AbstractModel):
    """DescribeTableMeta请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表唯一id
        :type TableId: str
        :param _TableNameFilter: 按名称查询的条件
        :type TableNameFilter: :class:`tencentcloud.wedata.v20210820.models.TableNameFilter`
        :param _TableFilterType: 查询条件类型0按id，1按名称，默认为0
        :type TableFilterType: int
        :param _SearchNames: 查询字段列表
        :type SearchNames: list of str
        """
        self._TableId = None
        self._TableNameFilter = None
        self._TableFilterType = None
        self._SearchNames = None

    @property
    def TableId(self):
        """表唯一id
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def TableNameFilter(self):
        """按名称查询的条件
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableNameFilter`
        """
        return self._TableNameFilter

    @TableNameFilter.setter
    def TableNameFilter(self, TableNameFilter):
        self._TableNameFilter = TableNameFilter

    @property
    def TableFilterType(self):
        """查询条件类型0按id，1按名称，默认为0
        :rtype: int
        """
        return self._TableFilterType

    @TableFilterType.setter
    def TableFilterType(self, TableFilterType):
        self._TableFilterType = TableFilterType

    @property
    def SearchNames(self):
        """查询字段列表
        :rtype: list of str
        """
        return self._SearchNames

    @SearchNames.setter
    def SearchNames(self, SearchNames):
        self._SearchNames = SearchNames


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        if params.get("TableNameFilter") is not None:
            self._TableNameFilter = TableNameFilter()
            self._TableNameFilter._deserialize(params.get("TableNameFilter"))
        self._TableFilterType = params.get("TableFilterType")
        self._SearchNames = params.get("SearchNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetaResponse(AbstractModel):
    """DescribeTableMeta返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableMeta: 表的元数据信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableMeta: :class:`tencentcloud.wedata.v20210820.models.TableMeta`
        :param _LifecycleInfo: 生命周期信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LifecycleInfo: :class:`tencentcloud.wedata.v20210820.models.LifecycleInfo`
        :param _TagVoteSumList: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type TagVoteSumList: :class:`tencentcloud.wedata.v20210820.models.TagVoteSum`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableMeta = None
        self._LifecycleInfo = None
        self._TagVoteSumList = None
        self._RequestId = None

    @property
    def TableMeta(self):
        """表的元数据信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableMeta`
        """
        return self._TableMeta

    @TableMeta.setter
    def TableMeta(self, TableMeta):
        self._TableMeta = TableMeta

    @property
    def LifecycleInfo(self):
        """生命周期信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.LifecycleInfo`
        """
        return self._LifecycleInfo

    @LifecycleInfo.setter
    def LifecycleInfo(self, LifecycleInfo):
        self._LifecycleInfo = LifecycleInfo

    @property
    def TagVoteSumList(self):
        """标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TagVoteSum`
        """
        return self._TagVoteSumList

    @TagVoteSumList.setter
    def TagVoteSumList(self, TagVoteSumList):
        self._TagVoteSumList = TagVoteSumList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMeta") is not None:
            self._TableMeta = TableMeta()
            self._TableMeta._deserialize(params.get("TableMeta"))
        if params.get("LifecycleInfo") is not None:
            self._LifecycleInfo = LifecycleInfo()
            self._LifecycleInfo._deserialize(params.get("LifecycleInfo"))
        if params.get("TagVoteSumList") is not None:
            self._TagVoteSumList = TagVoteSum()
            self._TagVoteSumList._deserialize(params.get("TagVoteSumList"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetasRequest(AbstractModel):
    """DescribeTableMetas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤字段
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetasResponse(AbstractModel):
    """DescribeTableMetas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableMetas: 表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type TableMetas: list of TableMeta
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableMetas = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableMetas(self):
        """表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TableMeta
        """
        return self._TableMetas

    @TableMetas.setter
    def TableMetas(self, TableMetas):
        self._TableMetas = TableMetas

    @property
    def TotalCount(self):
        """总条数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMetas") is not None:
            self._TableMetas = []
            for item in params.get("TableMetas"):
                obj = TableMeta()
                obj._deserialize(item)
                self._TableMetas.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTablePartitionsRequest(AbstractModel):
    """DescribeTablePartitions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        :param _PageNumber: 分页number
        :type PageNumber: int
        :param _PageSize: 分页size
        :type PageSize: int
        :param _FilterSet: 过滤器
        :type FilterSet: list of Filter
        :param _OrderFieldSet: 排序字段
        :type OrderFieldSet: list of OrderField
        """
        self._TableId = None
        self._PageNumber = None
        self._PageSize = None
        self._FilterSet = None
        self._OrderFieldSet = None

    @property
    def TableId(self):
        """表ID
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def PageNumber(self):
        """分页number
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页size
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FilterSet(self):
        """过滤器
        :rtype: list of Filter
        """
        return self._FilterSet

    @FilterSet.setter
    def FilterSet(self, FilterSet):
        self._FilterSet = FilterSet

    @property
    def OrderFieldSet(self):
        """排序字段
        :rtype: list of OrderField
        """
        return self._OrderFieldSet

    @OrderFieldSet.setter
    def OrderFieldSet(self, OrderFieldSet):
        self._OrderFieldSet = OrderFieldSet


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("FilterSet") is not None:
            self._FilterSet = []
            for item in params.get("FilterSet"):
                obj = Filter()
                obj._deserialize(item)
                self._FilterSet.append(obj)
        if params.get("OrderFieldSet") is not None:
            self._OrderFieldSet = []
            for item in params.get("OrderFieldSet"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFieldSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTablePartitionsResponse(AbstractModel):
    """DescribeTablePartitions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TablePartitionSet: 分区详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TablePartitionSet: list of TablePartition
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TablePartitionSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TablePartitionSet(self):
        """分区详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TablePartition
        """
        return self._TablePartitionSet

    @TablePartitionSet.setter
    def TablePartitionSet(self, TablePartitionSet):
        self._TablePartitionSet = TablePartitionSet

    @property
    def TotalCount(self):
        """总记录数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TablePartitionSet") is not None:
            self._TablePartitionSet = []
            for item in params.get("TablePartitionSet"):
                obj = TablePartition()
                obj._deserialize(item)
                self._TablePartitionSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableQualityDetailsRequest(AbstractModel):
    """DescribeTableQualityDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤参数TableName、DatabaseId 、DatabaseName、OwnerUserName
        :type Filters: list of Filter
        :param _OrderFields: 排序参数 排序方式 DESC 或者 ASC，表得分排序 TableScore
        :type OrderFields: list of OrderField
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._DatasourceId = None
        self._ScoreType = None

    @property
    def StatisticsDate(self):
        """统计日期
        :rtype: int
        """
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """分页序号
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤参数TableName、DatabaseId 、DatabaseName、OwnerUserName
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序参数 排序方式 DESC 或者 ASC，表得分排序 TableScore
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def DatasourceId(self):
        """数据来源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        """1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :rtype: str
        """
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableQualityDetailsResponse(AbstractModel):
    """DescribeTableQualityDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表质量分详情结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableQualityDetailPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """表质量分详情结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TableQualityDetailPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TableQualityDetailPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTableSchemaInfoRequest(AbstractModel):
    """DescribeTableSchemaInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 表名称
        :type Name: str
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        :param _MsType: 数据源的类型（例如MYSQL、HIVE、KAFKA等）
        :type MsType: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _ConnectionType: 连接类型（示例值rpc）
        :type ConnectionType: str
        :param _SchemaName: 元数据Database下的Schema名称
        :type SchemaName: str
        :param _ProjectId: 项目空间ID
        :type ProjectId: str
        :param _Env: 环境信息
        :type Env: str
        :param _Model: 空间模式
        :type Model: str
        :param _DevDatasourceId: 开发态的datasourceId
        :type DevDatasourceId: str
        """
        self._Name = None
        self._DatabaseName = None
        self._MsType = None
        self._DatasourceId = None
        self._ConnectionType = None
        self._SchemaName = None
        self._ProjectId = None
        self._Env = None
        self._Model = None
        self._DevDatasourceId = None

    @property
    def Name(self):
        """表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatabaseName(self):
        """数据库名称
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def MsType(self):
        """数据源的类型（例如MYSQL、HIVE、KAFKA等）
        :rtype: str
        """
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        """数据源id
        :rtype: str
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ConnectionType(self):
        """连接类型（示例值rpc）
        :rtype: str
        """
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def SchemaName(self):
        """元数据Database下的Schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def ProjectId(self):
        """项目空间ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Env(self):
        """环境信息
        :rtype: str
        """
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env

    @property
    def Model(self):
        """空间模式
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def DevDatasourceId(self):
        """开发态的datasourceId
        :rtype: str
        """
        return self._DevDatasourceId

    @DevDatasourceId.setter
    def DevDatasourceId(self, DevDatasourceId):
        self._DevDatasourceId = DevDatasourceId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DatabaseName = params.get("DatabaseName")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._ConnectionType = params.get("ConnectionType")
        self._SchemaName = params.get("SchemaName")
        self._ProjectId = params.get("ProjectId")
        self._Env = params.get("Env")
        self._Model = params.get("Model")
        self._DevDatasourceId = params.get("DevDatasourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableSchemaInfoResponse(AbstractModel):
    """DescribeTableSchemaInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SchemaInfoList: 查询到的SchemaInfo信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaInfoList: list of SchemaDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SchemaInfoList = None
        self._RequestId = None

    @property
    def SchemaInfoList(self):
        """查询到的SchemaInfo信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SchemaDetail
        """
        return self._SchemaInfoList

    @SchemaInfoList.setter
    def SchemaInfoList(self, SchemaInfoList):
        self._SchemaInfoList = SchemaInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SchemaInfoList") is not None:
            self._SchemaInfoList = []
            for item in params.get("SchemaInfoList"):
                obj = SchemaDetail()
                obj._deserialize(item)
                self._SchemaInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableScoreTrendRequest(AbstractModel):
    """DescribeTableScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _StatisticsStartDate: 开始时间 秒级时间戳
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 结束时间 秒级时间戳
        :type StatisticsEndDate: int
        :param _TableId: 表id
        :type TableId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._ProjectId = None
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._TableId = None
        self._ScoreType = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StatisticsStartDate(self):
        """开始时间 秒级时间戳
        :rtype: int
        """
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        """结束时间 秒级时间戳
        :rtype: int
        """
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def TableId(self):
        """表id
        :rtype: str
        """
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ScoreType(self):
        """1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :rtype: str
        """
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._TableId = params.get("TableId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableScoreTrendResponse(AbstractModel):
    """DescribeTableScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表得分趋势
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """表得分趋势
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskAlarmRegulationsRequest(AbstractModel):
    """DescribeTaskAlarmRegulations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _Filters: 过滤条件(name有RegularStatus、AlarmLevel、AlarmIndicator、RegularName)
        :type Filters: list of Filter
        :param _OrderFields: 排序条件(RegularId)
        :type OrderFields: list of OrderField
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201代表实时任务，202代表离线任务)
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskId = None
        self._TaskType = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """当前页
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """每页记录数
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        """过滤条件(name有RegularStatus、AlarmLevel、AlarmIndicator、RegularName)
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序条件(RegularId)
        :rtype: list of OrderField
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        """任务类型(201代表实时任务，202代表离线任务)
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskAlarmRegulationsResponse(AbstractModel):
    """DescribeTaskAlarmRegulations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfos: 告警规则信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAlarmInfos: list of TaskAlarmInfo
        :param _TotalCount: 总记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskAlarmInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskAlarmInfos(self):
        """告警规则信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskAlarmInfo
        """
        return self._TaskAlarmInfos

    @TaskAlarmInfos.setter
    def TaskAlarmInfos(self, TaskAlarmInfos):
        self._TaskAlarmInfos = TaskAlarmInfos

    @property
    def TotalCount(self):
        """总记录数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfos") is not None:
            self._TaskAlarmInfos = []
            for item in params.get("TaskAlarmInfos"):
                obj = TaskAlarmInfo()
                obj._deserialize(item)
                self._TaskAlarmInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleReportRequest(AbstractModel):
    """DescribeTaskByCycleReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Type: 任务周期类型
        :type Type: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._ProjectId = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        """任务周期类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleReportResponse(AbstractModel):
    """DescribeTaskByCycleReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务周期增长趋势统计
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskByStatus
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务周期增长趋势统计
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskByStatus
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleRequest(AbstractModel):
    """DescribeTaskByCycle请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ProjectIds: 项目ID列表筛选
        :type ProjectIds: list of str
        :param _ResourceGroupIds: 资源组ID列表筛选
        :type ResourceGroupIds: list of str
        :param _TaskTypeIdList: 任务类型ID筛选
        :type TaskTypeIdList: list of str
        """
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None
        self._ProjectIds = None
        self._ResourceGroupIds = None
        self._TaskTypeIdList = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        """1
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectIds(self):
        """项目ID列表筛选
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ResourceGroupIds(self):
        """资源组ID列表筛选
        :rtype: list of str
        """
        return self._ResourceGroupIds

    @ResourceGroupIds.setter
    def ResourceGroupIds(self, ResourceGroupIds):
        self._ResourceGroupIds = ResourceGroupIds

    @property
    def TaskTypeIdList(self):
        """任务类型ID筛选
        :rtype: list of str
        """
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectIds = params.get("ProjectIds")
        self._ResourceGroupIds = params.get("ResourceGroupIds")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleResponse(AbstractModel):
    """DescribeTaskByCycle返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 周期任务统计值
        :type Data: list of TaskByCycle
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """周期任务统计值
        :rtype: list of TaskByCycle
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByStatusReportRequest(AbstractModel):
    """DescribeTaskByStatusReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Type: 时间类型
        :type Type: str
        :param _TaskType: 类型
        :type TaskType: str
        :param _TypeName: 类型名称
        :type TypeName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _AggregationUnit: 聚合单元，H小时
        :type AggregationUnit: str
        :param _CycleUnit: 周期
        :type CycleUnit: str
        :param _Status: 状态
        :type Status: str
        :param _InCharge: 责任人
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _ProjectIds: 项目ID列表，用于多项目实例趋势筛选，当指定了 ProjectIds 的时候，ProjectId 将只用来鉴权，不做筛选
        :type ProjectIds: list of str
        """
        self._ProjectId = None
        self._Type = None
        self._TaskType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._AggregationUnit = None
        self._CycleUnit = None
        self._Status = None
        self._InCharge = None
        self._WorkflowId = None
        self._ProjectIds = None

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        """时间类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TaskType(self):
        """类型
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        """类型名称
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        """开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AggregationUnit(self):
        """聚合单元，H小时
        :rtype: str
        """
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def CycleUnit(self):
        """周期
        :rtype: str
        """
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def Status(self):
        """状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InCharge(self):
        """责任人
        :rtype: str
        """
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        """工作流ID
        :rtype: str
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectIds(self):
        """项目ID列表，用于多项目实例趋势筛选，当指定了 ProjectIds 的时候，ProjectId 将只用来鉴权，不做筛选
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._AggregationUnit = params.get("AggregationUnit")
        self._CycleUnit = params.get("CycleUnit")
        self._Status = params.get("Status")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByStatusReportResponse(AbstractModel):
    """DescribeTaskByStatusReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务上报趋势指标
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskByStatus
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务上报趋势指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskByStatus
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskLineageRequest(AbstractModel):
    """DescribeTaskLineage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._RequestFromSource = None
        self._TaskId = None

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._RequestFromSource = params.get("RequestFromSource")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLineageResponse(AbstractModel):
    """DescribeTaskLineage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
注意：此字段可能返回 null，表示取不到有效值。
        :type RequestFromSource: str
        :param _TaskLineageInfos: 通过任务ID查询集成任务信息列表
        :type TaskLineageInfos: list of TaskLineageInfoPair
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestFromSource = None
        self._TaskLineageInfos = None
        self._RequestId = None

    @property
    def RequestFromSource(self):
        """请求来源，WEB 前端；CLIENT 客户端
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def TaskLineageInfos(self):
        """通过任务ID查询集成任务信息列表
        :rtype: list of TaskLineageInfoPair
        """
        return self._TaskLineageInfos

    @TaskLineageInfos.setter
    def TaskLineageInfos(self, TaskLineageInfos):
        self._TaskLineageInfos = TaskLineageInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestFromSource = params.get("RequestFromSource")
        if params.get("TaskLineageInfos") is not None:
            self._TaskLineageInfos = []
            for item in params.get("TaskLineageInfos"):
                obj = TaskLineageInfoPair()
                obj._deserialize(item)
                self._TaskLineageInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskLockStatusRequest(AbstractModel):
    """DescribeTaskLockStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream,   202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """任务类型：201. stream,   202. offline
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLockStatusResponse(AbstractModel):
    """DescribeTaskLockStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskLockStatus: 任务锁状态信息
        :type TaskLockStatus: :class:`tencentcloud.wedata.v20210820.models.TaskLockStatus`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskLockStatus = None
        self._RequestId = None

    @property
    def TaskLockStatus(self):
        """任务锁状态信息
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskLockStatus`
        """
        return self._TaskLockStatus

    @TaskLockStatus.setter
    def TaskLockStatus(self, TaskLockStatus):
        self._TaskLockStatus = TaskLockStatus

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskLockStatus") is not None:
            self._TaskLockStatus = TaskLockStatus()
            self._TaskLockStatus._deserialize(params.get("TaskLockStatus"))
        self._RequestId = params.get("RequestId")


class DescribeTaskRunHistoryRequest(AbstractModel):
    """DescribeTaskRunHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _SearchCondition: 检索条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceSearchCondition`
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _PageNumber: 分页页码
        :type PageNumber: int
        """
        self._ProjectId = None
        self._SearchCondition = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        """检索条件
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceSearchCondition`
        """
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def PageSize(self):
        """分页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        """分页页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceSearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskRunHistoryResponse(AbstractModel):
    """DescribeTaskRunHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 分页查询任务运行历史结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsInfoPage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """分页查询任务运行历史结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsInfoPage`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceOpsInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskScriptRequest(AbstractModel):
    """DescribeTaskScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._ProjectId = None
        self._TaskId = None

    @property
    def ProjectId(self):
        """项目Id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskScriptResponse(AbstractModel):
    """DescribeTaskScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskScriptContent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """任务脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.wedata.v20210820.models.TaskScriptContent`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskScriptContent()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskTableMetricOverviewRequest(AbstractModel):
    """DescribeTaskTableMetricOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务TaskId
        :type TaskId: str
        :param _NodeType: 来源类型，支持枚举： SOURCE、SINK
        :type NodeType: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream, 202. offline，当前只支持实时201
        :type TaskType: int
        :param _Filters: 根据SchemaName来模糊搜索
        :type Filters: list of Filter
        :param _OrderFields: 排序
        :type OrderFields: list of OrderFields
        """
        self._TaskId = None
        self._NodeType = None
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._TaskType = None
        self._Filters = None
        self._OrderFields = None

    @property
    def TaskId(self):
        """任务TaskId
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NodeType(self):
        """来源类型，支持枚举： SOURCE、SINK
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def PageNumber(self):
        """页码
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        """任务类型：201. stream, 202. offline，当前只支持实时201
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Filters(self):
        """根据SchemaName来模糊搜索
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        """排序
        :rtype: list of OrderFields
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NodeType = params.get("NodeType")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderFields()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskTableMetricOverviewResponse(AbstractModel):
    """DescribeTaskTableMetricOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskTableMetricInfos: 表粒度指标集合
        :type TaskTableMetricInfos: list of TaskTableMetricInfo
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _MetricType: 返回列表类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetricType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskTableMetricInfos = None
        self._TotalCount = None
        self._MetricType = None
        self._RequestId = None

    @property
    def TaskTableMetricInfos(self):
        """表粒度指标集合
        :rtype: list of TaskTableMetricInfo
        """
        return self._TaskTableMetricInfos

    @TaskTableMetricInfos.setter
    def TaskTableMetricInfos(self, TaskTableMetricInfos):
        self._TaskTableMetricInfos = TaskTableMetricInfos

    @property
    def TotalCount(self):
        """总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def MetricType(self):
        """返回列表类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetricType

    @MetricType.setter
    def MetricType(self, MetricType):
        self._MetricType = MetricType

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskTableMetricInfos") is not None:
            self._TaskTableMetricInfos = []
            for item in params.get("TaskTableMetricInfos"):
                obj = TaskTableMetricInfo()
                obj._deserialize(item)
                self._TaskTableMetricInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._MetricType = params.get("MetricType")
        self._RequestId = params.get("RequestId")


class DescribeTemplateDimCountRequest(AbstractModel):
    """DescribeTemplateDimCount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模板类型
        :type Type: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Type = None
        self._ProjectId = None

    @property
    def Type(self):
        """模板类型
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTemplateDimCountResponse(AbstractModel):
    """DescribeTemplateDimCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 维度统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DimensionCount
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """维度统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DimensionCount
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Reque