import * as constructs from 'constructs';
/**
 * Information about the SNS topic or AWS Chatbot client associated with a notification target.
 *
 * @stability stable
 */
export interface NotificationRuleTargetConfig {
    /**
     * The target type.
     *
     * Can be an Amazon SNS topic or AWS Chatbot client.
     *
     * @stability stable
     */
    readonly targetType: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic or AWS Chatbot client.
     *
     * @stability stable
     */
    readonly targetAddress: string;
}
/**
 * Represents a notification target That allows AWS Chatbot and SNS topic to associate with this rule target.
 *
 * @stability stable
 */
export interface INotificationRuleTarget {
    /**
     * Returns a target configuration for notification rule.
     *
     * @stability stable
     */
    bindAsNotificationRuleTarget(scope: constructs.Construct): NotificationRuleTargetConfig;
}
