import { Construct } from 'constructs';
import { JobProps } from '@aws-cdk/aws-glue-alpha';
/**
 * SynchronousGlueJob Construct to start an AWS Glue Job execution and wait for completion during CDK deploy
 */
export declare class SynchronousGlueJob extends Construct {
    /**
     * The Glue job logstream to check potential errors
     */
    readonly glueJobLogStream: string;
    /**
     * Constructs a new instance of the DataGenerator class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {JobProps} props the SynchronousGlueJob properties
     * @access public
     */
    constructor(scope: Construct, id: string, props: JobProps);
}
