import { IRole, IUser } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * Properties for the lakeFormationAdmin Construct
 */
export interface LakeFormationAdminProps {
    /**
    * The principal to declare as an AWS Lake Formation administrator
    */
    readonly principal: IRole | IUser;
    /**
    * The catalog ID to create the administrator in
    * @default - The account ID
    */
    readonly catalogId?: string;
}
/**
 * An AWS Lake Formation administrator with privileges to do all the administration tasks in AWS Lake Formation.
 * The principal is an Amazon IAM user or role and is added/removed to the list of AWS Lake Formation administrator
 * via the Data Lake Settings API.
 * Creation/deleting first retrieves the current list of administrators and then add/remove the principal to this list.
 * These steps are done outside of any transaction. Concurrent modifications between retrieving and updating can lead to inconsistent results.
 */
export declare class LakeFormationAdmin extends Construct {
    /**
    * Adds the CDK execution role to LF admins
    * It requires default cdk bootstrap
    */
    static addCdkExecRole(scope: Construct, name: string): LakeFormationAdmin;
    catalogId: string;
    principal: IRole | IUser;
    /**
     * Construct a new instance of LakeFormationAdmin.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {LakeFormationAdminProps} props the LakeFormationAdminProps properties
     * @access public
     */
    constructor(scope: Construct, id: string, props: LakeFormationAdminProps);
}
