"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_glue_alpha_1 = require("@aws-cdk/aws-glue-alpha");
const context_options_1 = require("./common/context-options");
const tracked_construct_1 = require("./common/tracked-construct");
/**
 * A Data Lake Catalog composed of 3 AWS Glue Database configured with AWS best practices:
 *  Databases for Raw/Cleaned/Transformed data,
 */
class DataLakeCatalog extends tracked_construct_1.TrackedConstruct {
    /**
       * Construct a new instance of DataLakeCatalog based on S3 buckets with best practices configuration
       * @param {Construct} scope the Scope of the CDK Construct
       * @param {string} id the ID of the CDK Construct
       * @access public
       */
    constructor(scope, id) {
        const trackedConstructProps = {
            trackingCode: context_options_1.ContextOptions.DATA_LAKE_ID,
        };
        super(scope, id, trackedConstructProps);
        this.rawDatabase = new aws_glue_alpha_1.Database(this, 'raw-database', {
            databaseName: 'raw',
        });
        this.cleanDatabase = new aws_glue_alpha_1.Database(this, 'clean-database', {
            databaseName: 'clean',
        });
        this.transformDatabase = new aws_glue_alpha_1.Database(this, 'transform-database', {
            databaseName: 'transform',
        });
    }
}
exports.DataLakeCatalog = DataLakeCatalog;
_a = JSII_RTTI_SYMBOL_1;
DataLakeCatalog[_a] = { fqn: "aws-analytics-reference-architecture.DataLakeCatalog", version: "2.8.7" };
//# sourceMappingURL=data:application/json;base64,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