"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonGlueDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_glue_alpha_1 = require("@aws-cdk/aws-glue-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * AWS Glue Database implementing the singleton pattern
 */
class SingletonGlueDatabase extends aws_glue_alpha_1.Database {
    static getOrCreate(scope, name) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${name}`;
        return stack.node.tryFindChild(id) || new aws_glue_alpha_1.Database(stack, id, {
            databaseName: name,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
SingletonGlueDatabase[_a] = { fqn: "aws-analytics-reference-architecture.SingletonGlueDatabase", version: "2.12.9" };
exports.SingletonGlueDatabase = SingletonGlueDatabase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2luZ2xldG9uLWdsdWUtZGF0YWJhc2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvc2luZ2xldG9uLWdsdWUtZGF0YWJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxRUFBcUU7QUFDckUsaUNBQWlDO0FBRWpDLDREQUFtRDtBQUNuRCw2Q0FBb0M7QUFHcEM7O0dBRUc7QUFDSCxNQUFhLHFCQUFzQixTQUFRLHlCQUFRO0lBRTFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBZ0IsRUFBRSxJQUFZO1FBQ3RELE1BQU0sS0FBSyxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlCLE1BQU0sRUFBRSxHQUFHLEdBQUcsSUFBSSxFQUFFLENBQUM7UUFDckIsT0FBTyxLQUFLLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQWEsSUFBSSxJQUFJLHlCQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUN4RSxZQUFZLEVBQUUsSUFBSTtTQUNuQixDQUFDLENBQUM7SUFDTCxDQUFDOzs7O0FBUlUsc0RBQXFCIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTUlULTBcblxuaW1wb3J0IHsgRGF0YWJhc2UgfSBmcm9tICdAYXdzLWNkay9hd3MtZ2x1ZS1hbHBoYSc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIEFXUyBHbHVlIERhdGFiYXNlIGltcGxlbWVudGluZyB0aGUgc2luZ2xldG9uIHBhdHRlcm5cbiAqL1xuZXhwb3J0IGNsYXNzIFNpbmdsZXRvbkdsdWVEYXRhYmFzZSBleHRlbmRzIERhdGFiYXNlIHtcblxuICBwdWJsaWMgc3RhdGljIGdldE9yQ3JlYXRlKHNjb3BlOiBDb25zdHJ1Y3QsIG5hbWU6IHN0cmluZykge1xuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2Yoc2NvcGUpO1xuICAgIGNvbnN0IGlkID0gYCR7bmFtZX1gO1xuICAgIHJldHVybiBzdGFjay5ub2RlLnRyeUZpbmRDaGlsZChpZCkgYXMgRGF0YWJhc2UgfHwgbmV3IERhdGFiYXNlKHN0YWNrLCBpZCwge1xuICAgICAgZGF0YWJhc2VOYW1lOiBuYW1lLFxuICAgIH0pO1xuICB9XG59Il19