"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrEksNodegroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
/**
 * @summary EmrEksNodegroup containing the default Nodegroups
 */
class EmrEksNodegroup {
}
_a = JSII_RTTI_SYMBOL_1;
EmrEksNodegroup[_a] = { fqn: "aws-analytics-reference-architecture.EmrEksNodegroup", version: "2.12.9" };
/*
 ** Default nodegroup configuration for Kubernetes applications required by EMR on EKS (e.g cert manager and cluster autoscaler)
 */
EmrEksNodegroup.TOOLING_ALL = {
    nodegroupName: 'tooling',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.medium')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 2,
    maxSize: 10,
    labels: { role: 'tooling' },
};
/**
 * Default nodegroup configuration for EMR on EKS critical workloads (both drivers and executors)
 */
EmrEksNodegroup.CRITICAL_ALL = {
    nodegroupName: 'critical',
    mountNvme: true,
    instanceTypes: [new aws_ec2_1.InstanceType('m6gd.8xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    minSize: 0,
    maxSize: 100,
    labels: {
        'role': 'critical',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'critical',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (drivers only)
 */
EmrEksNodegroup.SHARED_DRIVER = {
    nodegroupName: 'shared-driver',
    instanceTypes: [new aws_ec2_1.InstanceType('m6g.xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    minSize: 0,
    maxSize: 10,
    labels: {
        'role': 'shared',
        'spark-role': 'driver',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'shared',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (executors only)
 */
EmrEksNodegroup.SHARED_EXECUTOR = {
    nodegroupName: 'shared-executor',
    instanceTypes: [new aws_ec2_1.InstanceType('m6g.8xlarge'), new aws_ec2_1.InstanceType('m6gd.8xlarge')],
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    labels: {
        'role': 'shared',
        'spark-role': 'executor',
        'node-lifecycle': 'spot',
    },
    taints: [
        {
            key: 'role',
            value: 'shared',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
        {
            key: 'node-lifecycle',
            value: 'spot',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (executors only)
 */
EmrEksNodegroup.NOTEBOOK_EXECUTOR = {
    nodegroupName: 'notebook-executor',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.2xlarge'), new aws_ec2_1.InstanceType('t3a.2xlarge')],
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    labels: {
        'role': 'notebook',
        'spark-role': 'executor',
        'node-lifecycle': 'spot',
    },
    taints: [
        {
            key: 'role',
            value: 'notebook',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
        {
            key: 'node-lifecycle',
            value: 'spot',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (drivers only)
 */
EmrEksNodegroup.NOTEBOOK_DRIVER = {
    nodegroupName: 'notebook-driver',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.large')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 0,
    maxSize: 10,
    labels: {
        'role': 'notebook',
        'spark-role': 'driver',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'notebook',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS
 * This nodegroup is replacing [NOTEBOOK_DRIVER]{@link EmrEksNodegroup.NOTEBOOK_DRIVER}
 * and [NOTEBOOK_EXECUTOR]{@link EmrEksNodegroup.NOTEBOOK_EXECUTOR} because EMR on EKS
 * Managed Endpoint currently doesn't support Pod Template customization
 */
EmrEksNodegroup.NOTEBOOK_WITHOUT_PODTEMPLATE = {
    nodegroupName: 'notebook-without-pod-template',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.2xlarge'), new aws_ec2_1.InstanceType('t3a.2xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    labels: {
        'role': 'notebook',
        'node-lifecycle': 'spot',
    },
};
exports.EmrEksNodegroup = EmrEksNodegroup;
//# sourceMappingURL=data:application/json;base64,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