"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSchema = void 0;
const schemasafe_1 = require("@exodus/schemasafe");
/**
 * Helper function used to validate the schema of the custom configuration provided when
 * creating an EMR on EKS Managed Endpoint
 * @param overrideConfigSchema The validation schema
 * @param overrideConfigData The JSON configuration to validate
 */
function validateSchema(overrideConfigSchema, overrideConfigData) {
    if (overrideConfigData !== undefined) {
        const schemaObject = JSON.parse(overrideConfigSchema);
        const data = JSON.parse(JSON.stringify(overrideConfigData));
        const validate = (0, schemasafe_1.validator)(schemaObject);
        if (validate(data)) {
            return true;
        }
        else {
            throw new Error(`The configuration override is not valid JSON : ${overrideConfigData}`);
        }
    }
    else {
        return false;
    }
}
exports.validateSchema = validateSchema;
//# sourceMappingURL=data:application/json;base64,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