"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2SsmRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * Construct extending IAM Role with AmazonSSMManagedInstanceCore managed policy
 */
class Ec2SsmRole extends aws_iam_1.Role {
    /**
     * Constructs a new instance of the Ec2SsmRole class.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {RoleProps} props the RoleProps [properties]{@link RoleProps}
     * @since 1.0.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
    }
}
_a = JSII_RTTI_SYMBOL_1;
Ec2SsmRole[_a] = { fqn: "aws-analytics-reference-architecture.Ec2SsmRole", version: "2.12.9" };
exports.Ec2SsmRole = Ec2SsmRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWMyLXNzbS1yb2xlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2VjMi1zc20tcm9sZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlEQUFxRTtBQUdyRTs7R0FFRztBQUVILE1BQWEsVUFBVyxTQUFRLGNBQUk7SUFFbEM7Ozs7Ozs7T0FPRztJQUVILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0I7UUFDeEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHVCQUFhLENBQUMsd0JBQXdCLENBQUMsOEJBQThCLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLENBQUM7Ozs7QUFkVSxnQ0FBVSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJvbGUsIFJvbGVQcm9wcywgTWFuYWdlZFBvbGljeSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogQ29uc3RydWN0IGV4dGVuZGluZyBJQU0gUm9sZSB3aXRoIEFtYXpvblNTTU1hbmFnZWRJbnN0YW5jZUNvcmUgbWFuYWdlZCBwb2xpY3lcbiAqL1xuXG5leHBvcnQgY2xhc3MgRWMyU3NtUm9sZSBleHRlbmRzIFJvbGUge1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBFYzJTc21Sb2xlIGNsYXNzLlxuICAgKiBAcGFyYW0ge0NvbnN0cnVjdH0gc2NvcGUgdGhlIFNjb3BlIG9mIHRoZSBDREsgQ29uc3RydWN0XG4gICAqIEBwYXJhbSB7c3RyaW5nfSBpZCB0aGUgSUQgb2YgdGhlIENESyBDb25zdHJ1Y3RcbiAgICogQHBhcmFtIHtSb2xlUHJvcHN9IHByb3BzIHRoZSBSb2xlUHJvcHMgW3Byb3BlcnRpZXNde0BsaW5rIFJvbGVQcm9wc31cbiAgICogQHNpbmNlIDEuMC4wXG4gICAqIEBhY2Nlc3MgcHVibGljXG4gICAqL1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb2xlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLmFkZE1hbmFnZWRQb2xpY3koTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ0FtYXpvblNTTU1hbmFnZWRJbnN0YW5jZUNvcmUnKSk7XG4gIH1cbn0iXX0=