"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrackedConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A type of CDK Construct that is tracked via a unique code in Stack labels.
 * It is  used to measure the number of deployments and so the impact of the Analytics Reference Architecture.
 */
class TrackedConstruct extends constructs_1.Construct {
    /**
     * Constructs a new instance of the TrackedConstruct
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {TrackedConstructProps} props the TrackedConstruct [properties]{@link TrackedConstructProps}
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (!scope.node.tryGetContext('@aws-analytics-reference-architecture/disableConstructsDeploymentTracking')) {
            const stack = cdk.Stack.of(this);
            const description = `${stack.templateOptions.description} (${props.trackingCode})`;
            stack.templateOptions.description = description;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
TrackedConstruct[_a] = { fqn: "aws-analytics-reference-architecture.TrackedConstruct", version: "2.12.9" };
exports.TrackedConstruct = TrackedConstruct;
//# sourceMappingURL=data:application/json;base64,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