"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AthenaDemoSetup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_athena_1 = require("aws-cdk-lib/aws-athena");
const constructs_1 = require("constructs");
const ara_bucket_1 = require("./ara-bucket");
/**
 * AthenaDemoSetup Construct to automatically setup a new Amazon Athena Workgroup with proper configuration for out-of-the-box demo
 */
class AthenaDemoSetup extends constructs_1.Construct {
    /**
     * Constructs a new instance of the AthenaDefaultSetup class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const workgroupName = props.workgroupName || 'demo';
        // Singleton Amazon S3 bucket for Amazon Athena Query logs
        this.resultBucket = ara_bucket_1.AraBucket.getOrCreate(this, {
            bucketName: `${workgroupName}-athena-logs`,
            serverAccessLogsPrefix: `${workgroupName}-athena-logs-bucket`,
        });
        this.athenaWorkgroup = new aws_athena_1.CfnWorkGroup(this, 'athenaDemoWorkgroup', {
            name: workgroupName,
            recursiveDeleteOption: true,
            workGroupConfiguration: {
                requesterPaysEnabled: true,
                publishCloudWatchMetricsEnabled: false,
                resultConfiguration: {
                    outputLocation: this.resultBucket.s3UrlForObject('athena-console-results'),
                },
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
AthenaDemoSetup[_a] = { fqn: "aws-analytics-reference-architecture.AthenaDemoSetup", version: "2.12.9" };
exports.AthenaDemoSetup = AthenaDemoSetup;
//# sourceMappingURL=data:application/json;base64,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