# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AbortCampaignRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbortCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AbortCampaignResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AbortCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AbortCampaignResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AbortCampaignResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AbortCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AbortCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBlacklistCallTaggingRequest(TeaModel):
    def __init__(self, instance_id=None, job_id=None, number=None):
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddBlacklistCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class AddBlacklistCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddBlacklistCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBlacklistCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddBlacklistCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddBlacklistCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddBlacklistCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasesRequestCaseList(TeaModel):
    def __init__(self, caller=None, custom_variables=None, masked_callee=None, phone_number=None, reference_id=None):
        self.caller = caller  # type: str
        self.custom_variables = custom_variables  # type: str
        self.masked_callee = masked_callee  # type: str
        self.phone_number = phone_number  # type: str
        self.reference_id = reference_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasesRequestCaseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.masked_callee is not None:
            result['MaskedCallee'] = self.masked_callee
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('MaskedCallee') is not None:
            self.masked_callee = m.get('MaskedCallee')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class AddCasesRequest(TeaModel):
    def __init__(self, campaign_id=None, case_list=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.case_list = case_list  # type: list[AddCasesRequestCaseList]
        self.instance_id = instance_id  # type: str

    def validate(self):
        if self.case_list:
            for k in self.case_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddCasesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        result['CaseList'] = []
        if self.case_list is not None:
            for k in self.case_list:
                result['CaseList'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        self.case_list = []
        if m.get('CaseList') is not None:
            for k in m.get('CaseList'):
                temp_model = AddCasesRequestCaseList()
                self.case_list.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AddCasesShrinkRequest(TeaModel):
    def __init__(self, campaign_id=None, case_list_shrink=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.case_list_shrink = case_list_shrink  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.case_list_shrink is not None:
            result['CaseList'] = self.case_list_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CaseList') is not None:
            self.case_list_shrink = m.get('CaseList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AddCasesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddNumbersToSkillGroupRequest(TeaModel):
    def __init__(self, inst_number_group_id_list=None, instance_id=None, number_list=None, skill_group_id=None):
        self.inst_number_group_id_list = inst_number_group_id_list  # type: str
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inst_number_group_id_list is not None:
            result['InstNumberGroupIdList'] = self.inst_number_group_id_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstNumberGroupIdList') is not None:
            self.inst_number_group_id_list = m.get('InstNumberGroupIdList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class AddNumbersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddNumbersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddNumbersToSkillGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddNumbersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddNumbersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPersonalNumbersToUserRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddPersonalNumbersToUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPersonalNumbersToUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPersonalNumbersToUserResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPersonalNumbersToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPersonalNumbersToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumberToSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, number=None, skill_group_id_list=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.skill_group_id_list = skill_group_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class AddPhoneNumberToSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPhoneNumberToSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPhoneNumberToSkillGroupsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumberToSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPhoneNumberToSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPhoneNumbersRequest(TeaModel):
    def __init__(self, contact_flow_id=None, instance_id=None, number_group_id=None, number_list=None, usage=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number_group_id = number_group_id  # type: str
        self.number_list = number_list  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_group_id is not None:
            result['NumberGroupId'] = self.number_group_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberGroupId') is not None:
            self.number_group_id = m.get('NumberGroupId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class AddPhoneNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPhoneNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPhoneNumbersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPhoneNumbersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPhoneNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPhoneNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSkillGroupsToUserRequest(TeaModel):
    def __init__(self, instance_id=None, skill_level_list=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddSkillGroupsToUserResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSkillGroupsToUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddSkillGroupsToUserResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSkillGroupsToUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSkillGroupsToUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUsersToSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None, user_skill_level_list=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.user_skill_level_list = user_skill_level_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_skill_level_list is not None:
            result['UserSkillLevelList'] = self.user_skill_level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserSkillLevelList') is not None:
            self.user_skill_level_list = m.get('UserSkillLevelList')
        return self


class AddUsersToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUsersToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddUsersToSkillGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddUsersToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUsersToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AnswerCallRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AnswerCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_id=None, channel_state=None, channel_variables=None,
                 destination=None, index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.channel_variables = channel_variables  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: long
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.channel_variables is not None:
            result['ChannelVariables'] = self.channel_variables
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('ChannelVariables') is not None:
            self.channel_variables = m.get('ChannelVariables')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AnswerCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[AnswerCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = AnswerCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class AnswerCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class AnswerCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: AnswerCallResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: AnswerCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = AnswerCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = AnswerCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class AnswerCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: AnswerCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AnswerCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AnswerCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AnswerCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AnswerCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AnswerCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AnswerCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AppendCasesRequestBody(TeaModel):
    def __init__(self, agent_id=None, caller=None, custom_variables=None, masked_callee=None, phone_number=None,
                 reference_id=None):
        self.agent_id = agent_id  # type: str
        self.caller = caller  # type: str
        self.custom_variables = custom_variables  # type: str
        self.masked_callee = masked_callee  # type: str
        self.phone_number = phone_number  # type: str
        self.reference_id = reference_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AppendCasesRequestBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.masked_callee is not None:
            result['MaskedCallee'] = self.masked_callee
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('MaskedCallee') is not None:
            self.masked_callee = m.get('MaskedCallee')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class AppendCasesRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None, body=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str
        self.body = body  # type: list[AppendCasesRequestBody]

    def validate(self):
        if self.body:
            for k in self.body:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AppendCasesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['body'] = []
        if self.body is not None:
            for k in self.body:
                result['body'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.body = []
        if m.get('body') is not None:
            for k in m.get('body'):
                temp_model = AppendCasesRequestBody()
                self.body.append(temp_model.from_map(k))
        return self


class AppendCasesShrinkRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None, body_shrink=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str
        self.body_shrink = body_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AppendCasesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.body_shrink is not None:
            result['body'] = self.body_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('body') is not None:
            self.body_shrink = m.get('body')
        return self


class AppendCasesResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AppendCasesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AppendCasesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AppendCasesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AppendCasesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AppendCasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignUsersRequest(TeaModel):
    def __init__(self, instance_id=None, ram_id_list=None, role_id=None, skill_level_list=None, work_mode=None):
        self.instance_id = instance_id  # type: str
        self.ram_id_list = ram_id_list  # type: str
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id_list is not None:
            result['RamIdList'] = self.ram_id_list
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamIdList') is not None:
            self.ram_id_list = m.get('RamIdList')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class AssignUsersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, workflow_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.workflow_id = workflow_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignUsersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.workflow_id is not None:
            result['WorkflowId'] = self.workflow_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WorkflowId') is not None:
            self.workflow_id = m.get('WorkflowId')
        return self


class AssignUsersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssignUsersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssignUsersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssignUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BargeInCallRequest(TeaModel):
    def __init__(self, barged_user_id=None, device_id=None, instance_id=None, job_id=None, timeout_seconds=None,
                 user_id=None):
        self.barged_user_id = barged_user_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barged_user_id is not None:
            result['BargedUserId'] = self.barged_user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BargedUserId') is not None:
            self.barged_user_id = m.get('BargedUserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BargeInCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BargeInCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[BargeInCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BargeInCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class BargeInCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BargeInCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class BargeInCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: BargeInCallResponseBodyDataCallContext
        self.user_context = user_context  # type: BargeInCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BargeInCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = BargeInCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BargeInCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BargeInCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BargeInCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BargeInCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BargeInCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BargeInCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BargeInCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BargeInCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BlindTransferRequest(TeaModel):
    def __init__(self, call_priority=None, contact_flow_variables=None, device_id=None, instance_id=None,
                 job_id=None, queuing_overflow_threshold=None, queuing_timeout_seconds=None, routing_type=None,
                 strategy_name=None, strategy_params=None, tags=None, timeout_seconds=None, transferee=None, transferee_type=None,
                 transferor=None, user_id=None):
        self.call_priority = call_priority  # type: int
        self.contact_flow_variables = contact_flow_variables  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.queuing_overflow_threshold = queuing_overflow_threshold  # type: long
        self.queuing_timeout_seconds = queuing_timeout_seconds  # type: long
        self.routing_type = routing_type  # type: str
        self.strategy_name = strategy_name  # type: str
        self.strategy_params = strategy_params  # type: str
        self.tags = tags  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.transferee = transferee  # type: str
        self.transferee_type = transferee_type  # type: str
        self.transferor = transferor  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_priority is not None:
            result['CallPriority'] = self.call_priority
        if self.contact_flow_variables is not None:
            result['ContactFlowVariables'] = self.contact_flow_variables
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.queuing_overflow_threshold is not None:
            result['QueuingOverflowThreshold'] = self.queuing_overflow_threshold
        if self.queuing_timeout_seconds is not None:
            result['QueuingTimeoutSeconds'] = self.queuing_timeout_seconds
        if self.routing_type is not None:
            result['RoutingType'] = self.routing_type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.strategy_params is not None:
            result['StrategyParams'] = self.strategy_params
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.transferee_type is not None:
            result['TransfereeType'] = self.transferee_type
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallPriority') is not None:
            self.call_priority = m.get('CallPriority')
        if m.get('ContactFlowVariables') is not None:
            self.contact_flow_variables = m.get('ContactFlowVariables')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('QueuingOverflowThreshold') is not None:
            self.queuing_overflow_threshold = m.get('QueuingOverflowThreshold')
        if m.get('QueuingTimeoutSeconds') is not None:
            self.queuing_timeout_seconds = m.get('QueuingTimeoutSeconds')
        if m.get('RoutingType') is not None:
            self.routing_type = m.get('RoutingType')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('StrategyParams') is not None:
            self.strategy_params = m.get('StrategyParams')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('TransfereeType') is not None:
            self.transferee_type = m.get('TransfereeType')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BlindTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 job_id=None, originator=None, release_initiator=None, release_reason=None, timestamp=None,
                 user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BlindTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[BlindTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = BlindTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class BlindTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BlindTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class BlindTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: BlindTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: BlindTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = BlindTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = BlindTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class BlindTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BlindTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BlindTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BlindTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BlindTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BlindTransferResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BlindTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BlindTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BridgeRtcCallRequest(TeaModel):
    def __init__(self, callee=None, caller=None, device_id=None, instance_id=None, service_provider=None, tags=None,
                 timeout_seconds=None, user_id=None, video_enabled=None):
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.service_provider = service_provider  # type: str
        self.tags = tags  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str
        self.video_enabled = video_enabled  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BridgeRtcCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.service_provider is not None:
            result['ServiceProvider'] = self.service_provider
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.video_enabled is not None:
            result['VideoEnabled'] = self.video_enabled
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ServiceProvider') is not None:
            self.service_provider = m.get('ServiceProvider')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('VideoEnabled') is not None:
            self.video_enabled = m.get('VideoEnabled')
        return self


class BridgeRtcCallResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, job_id=None, token_info=None):
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.token_info = token_info  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BridgeRtcCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.token_info is not None:
            result['TokenInfo'] = self.token_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TokenInfo') is not None:
            self.token_info = m.get('TokenInfo')
        return self


class BridgeRtcCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: BridgeRtcCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BridgeRtcCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BridgeRtcCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BridgeRtcCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BridgeRtcCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BridgeRtcCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BridgeRtcCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAttendedTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CancelAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None, timestamp=None,
                 user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CancelAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CancelAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CancelAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CancelAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: CancelAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: CancelAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = CancelAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CancelAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CancelAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CancelAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelAttendedTransferResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeVisibilityRequest(TeaModel):
    def __init__(self, instance_id=None, invisible=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.invisible = invisible  # type: bool
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeVisibilityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.invisible is not None:
            result['Invisible'] = self.invisible
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Invisible') is not None:
            self.invisible = m.get('Invisible')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ChangeVisibilityResponseBodyData(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeVisibilityResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeVisibilityResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ChangeVisibilityResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ChangeVisibilityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ChangeVisibilityResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeVisibilityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeVisibilityResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeVisibilityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeVisibilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeWorkModeRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, mobile=None, signed_skill_group_id_list=None, user_id=None,
                 work_mode=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.mobile = mobile  # type: str
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeWorkModeResponseBodyData(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, instance_id=None, job_id=None,
                 outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeWorkModeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ChangeWorkModeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ChangeWorkModeResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ChangeWorkModeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeWorkModeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeWorkModeResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeWorkModeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeWorkModeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CoachCallRequest(TeaModel):
    def __init__(self, coached_user_id=None, device_id=None, instance_id=None, job_id=None, timeout_seconds=None,
                 user_id=None):
        self.coached_user_id = coached_user_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coached_user_id is not None:
            result['CoachedUserId'] = self.coached_user_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoachedUserId') is not None:
            self.coached_user_id = m.get('CoachedUserId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CoachCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CoachCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CoachCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CoachCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CoachCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, device_state=None, extension=None, heartbeat=None,
                 instance_id=None, job_id=None, mobile=None, outbound_scenario=None, reserved=None,
                 signed_skill_group_id_list=None, user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CoachCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CoachCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: CoachCallResponseBodyDataCallContext
        self.user_context = user_context  # type: CoachCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CoachCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CoachCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = CoachCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CoachCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CoachCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CoachCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CoachCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CoachCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CoachCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CoachCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CoachCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitContactFlowRequest(TeaModel):
    def __init__(self, contact_flow_id=None, definition=None, description=None, draft_id=None, instance_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.definition = definition  # type: str
        self.description = description  # type: str
        self.draft_id = draft_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitContactFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.description is not None:
            result['Description'] = self.description
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CommitContactFlowResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CommitContactFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CommitContactFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CommitContactFlowResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CommitContactFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommitContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteAttendedTransferRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, job_id=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CompleteAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CompleteAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[CompleteAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = CompleteAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CompleteAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CompleteAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: CompleteAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: CompleteAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = CompleteAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class CompleteAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CompleteAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CompleteAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CompleteAttendedTransferResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CompleteAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CompleteAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAudioFileRequest(TeaModel):
    def __init__(self, audio_file_name=None, instance_id=None, name=None, oss_file_key=None, usage=None):
        self.audio_file_name = audio_file_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.oss_file_key = oss_file_key  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAudioFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_file_name is not None:
            result['AudioFileName'] = self.audio_file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_file_key is not None:
            result['OssFileKey'] = self.oss_file_key
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFileName') is not None:
            self.audio_file_name = m.get('AudioFileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssFileKey') is not None:
            self.oss_file_key = m.get('OssFileKey')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class CreateAudioFileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAudioFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAudioFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAudioFileResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAudioFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAudioFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCallTagsRequest(TeaModel):
    def __init__(self, call_tag_name_list=None, instance_id=None):
        self.call_tag_name_list = call_tag_name_list  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCallTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_tag_name_list is not None:
            result['CallTagNameList'] = self.call_tag_name_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallTagNameList') is not None:
            self.call_tag_name_list = m.get('CallTagNameList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateCallTagsResponseBodyData(TeaModel):
    def __init__(self, item=None, reason=None):
        self.item = item  # type: str
        self.reason = reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCallTagsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item is not None:
            result['Item'] = self.item
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class CreateCallTagsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[CreateCallTagsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCallTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = CreateCallTagsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCallTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCallTagsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCallTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCallTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCampaignRequestCaseList(TeaModel):
    def __init__(self, custom_variables=None, phone_number=None, reference_id=None):
        self.custom_variables = custom_variables  # type: str
        self.phone_number = phone_number  # type: str
        self.reference_id = reference_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignRequestCaseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.reference_id is not None:
            result['ReferenceId'] = self.reference_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('ReferenceId') is not None:
            self.reference_id = m.get('ReferenceId')
        return self


class CreateCampaignRequest(TeaModel):
    def __init__(self, callable_time=None, case_file_key=None, case_list=None, contact_flow_id=None, end_time=None,
                 executing_until_timeout=None, instance_id=None, max_attempt_count=None, min_attempt_interval=None, name=None,
                 queue_id=None, simulation=None, simulation_parameters=None, start_time=None, strategy_parameters=None,
                 strategy_type=None):
        self.callable_time = callable_time  # type: str
        self.case_file_key = case_file_key  # type: str
        self.case_list = case_list  # type: list[CreateCampaignRequestCaseList]
        self.contact_flow_id = contact_flow_id  # type: str
        self.end_time = end_time  # type: str
        self.executing_until_timeout = executing_until_timeout  # type: bool
        self.instance_id = instance_id  # type: str
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.queue_id = queue_id  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.start_time = start_time  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str

    def validate(self):
        if self.case_list:
            for k in self.case_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callable_time is not None:
            result['CallableTime'] = self.callable_time
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        result['CaseList'] = []
        if self.case_list is not None:
            for k in self.case_list:
                result['CaseList'].append(k.to_map() if k else None)
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.executing_until_timeout is not None:
            result['ExecutingUntilTimeout'] = self.executing_until_timeout
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallableTime') is not None:
            self.callable_time = m.get('CallableTime')
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        self.case_list = []
        if m.get('CaseList') is not None:
            for k in m.get('CaseList'):
                temp_model = CreateCampaignRequestCaseList()
                self.case_list.append(temp_model.from_map(k))
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecutingUntilTimeout') is not None:
            self.executing_until_timeout = m.get('ExecutingUntilTimeout')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        return self


class CreateCampaignShrinkRequest(TeaModel):
    def __init__(self, callable_time=None, case_file_key=None, case_list_shrink=None, contact_flow_id=None,
                 end_time=None, executing_until_timeout=None, instance_id=None, max_attempt_count=None,
                 min_attempt_interval=None, name=None, queue_id=None, simulation=None, simulation_parameters=None, start_time=None,
                 strategy_parameters=None, strategy_type=None):
        self.callable_time = callable_time  # type: str
        self.case_file_key = case_file_key  # type: str
        self.case_list_shrink = case_list_shrink  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.end_time = end_time  # type: str
        self.executing_until_timeout = executing_until_timeout  # type: bool
        self.instance_id = instance_id  # type: str
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.queue_id = queue_id  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.start_time = start_time  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callable_time is not None:
            result['CallableTime'] = self.callable_time
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        if self.case_list_shrink is not None:
            result['CaseList'] = self.case_list_shrink
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.executing_until_timeout is not None:
            result['ExecutingUntilTimeout'] = self.executing_until_timeout
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallableTime') is not None:
            self.callable_time = m.get('CallableTime')
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        if m.get('CaseList') is not None:
            self.case_list_shrink = m.get('CaseList')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExecutingUntilTimeout') is not None:
            self.executing_until_timeout = m.get('ExecutingUntilTimeout')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        return self


class CreateCampaignResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCampaignResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCampaignResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContactFlowRequest(TeaModel):
    def __init__(self, definition=None, description=None, instance_id=None, name=None, type=None):
        self.definition = definition  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateContactFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateContactFlowResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateContactFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateContactFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateContactFlowResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateContactFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomCallTaggingRequest(TeaModel):
    def __init__(self, custom_number_list=None, instance_id=None):
        self.custom_number_list = custom_number_list  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_number_list is not None:
            result['CustomNumberList'] = self.custom_number_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomNumberList') is not None:
            self.custom_number_list = m.get('CustomNumberList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateCustomCallTaggingResponseBodyData(TeaModel):
    def __init__(self, item=None, reason=None):
        self.item = item  # type: str
        self.reason = reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomCallTaggingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item is not None:
            result['Item'] = self.item
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class CreateCustomCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[CreateCustomCallTaggingResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCustomCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = CreateCustomCallTaggingResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(self, admin_ram_id_list=None, description=None, domain_name=None, name=None, number_list=None):
        self.admin_ram_id_list = admin_ram_id_list  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.admin_ram_id_list is not None:
            result['AdminRamIdList'] = self.admin_ram_id_list
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.name is not None:
            result['Name'] = self.name
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdminRamIdList') is not None:
            self.admin_ram_id_list = m.get('AdminRamIdList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateInstanceResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSkillGroupRequest(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, media_type=None, name=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateSkillGroupResponseBodyData(TeaModel):
    def __init__(self, description=None, instance_id=None, media_type=None, name=None, skill_group_id=None):
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class CreateSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateSkillGroupResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSkillGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequest(TeaModel):
    def __init__(self, avatar_url=None, display_id=None, display_name=None, email=None, instance_id=None,
                 login_name=None, mobile=None, nickname=None, reset_password=None, role_id=None, skill_level_list=None,
                 work_mode=None):
        self.avatar_url = avatar_url  # type: str
        self.display_id = display_id  # type: str
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.nickname = nickname  # type: str
        self.reset_password = reset_password  # type: bool
        self.role_id = role_id  # type: str
        self.skill_level_list = skill_level_list  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.reset_password is not None:
            result['ResetPassword'] = self.reset_password
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.skill_level_list is not None:
            result['SkillLevelList'] = self.skill_level_list
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('ResetPassword') is not None:
            self.reset_password = m.get('ResetPassword')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('SkillLevelList') is not None:
            self.skill_level_list = m.get('SkillLevelList')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CreateUserResponseBodyData(TeaModel):
    def __init__(self, avatar_url=None, display_name=None, email=None, extension=None, login_name=None, mobile=None,
                 nickname=None, user_id=None, work_mode=None):
        self.avatar_url = avatar_url  # type: str
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.nickname = nickname  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: CreateUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUserResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAudioFileRequest(TeaModel):
    def __init__(self, audio_resource_id=None, instance_id=None):
        self.audio_resource_id = audio_resource_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAudioFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_resource_id is not None:
            result['AudioResourceId'] = self.audio_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioResourceId') is not None:
            self.audio_resource_id = m.get('AudioResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteAudioFileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAudioFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAudioFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAudioFileResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAudioFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAudioFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCallTagRequest(TeaModel):
    def __init__(self, instance_id=None, tag_name=None):
        self.instance_id = instance_id  # type: str
        self.tag_name = tag_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCallTagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class DeleteCallTagResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCallTagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCallTagResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCallTagResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCallTagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCallTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactFlowRequest(TeaModel):
    def __init__(self, contact_flow_id=None, instance_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteContactFlowResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteContactFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteContactFlowResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteContactFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomCallTaggingRequest(TeaModel):
    def __init__(self, instance_id=None, number=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class DeleteCustomCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(self, force=None, instance_id=None, skill_group_id=None):
        self.force = force  # type: bool
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSkillGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DiscardEditingContactFlowRequest(TeaModel):
    def __init__(self, contact_flow_id=None, draft_id=None, instance_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.draft_id = draft_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DiscardEditingContactFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DiscardEditingContactFlowResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DiscardEditingContactFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DiscardEditingContactFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DiscardEditingContactFlowResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DiscardEditingContactFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DiscardEditingContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EndConferenceRequest(TeaModel):
    def __init__(self, instance_id=None, job_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EndConferenceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class EndConferenceResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_id=None, channel_state=None, destination=None, job_id=None,
                 originator=None, release_initiator=None, release_reason=None, timestamp=None, user_extension=None,
                 user_id=None):
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EndConferenceResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class EndConferenceResponseBodyDataCallContext(TeaModel):
    def __init__(self, channel_contexts=None, instance_id=None, job_id=None):
        self.channel_contexts = channel_contexts  # type: list[EndConferenceResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EndConferenceResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = EndConferenceResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class EndConferenceResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, device_state=None, extension=None, instance_id=None,
                 job_id=None, outbound_scenario=None, signed_skill_group_id_list=None, user_id=None, user_state=None,
                 work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EndConferenceResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class EndConferenceResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: EndConferenceResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: EndConferenceResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(EndConferenceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = EndConferenceResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = EndConferenceResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class EndConferenceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: EndConferenceResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(EndConferenceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = EndConferenceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EndConferenceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EndConferenceResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EndConferenceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EndConferenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportCustomCallTaggingRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportCustomCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ExportCustomCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportCustomCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportCustomCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ExportCustomCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportCustomCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportCustomCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDoNotCallNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, scope=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.scope = scope  # type: str
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDoNotCallNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ExportDoNotCallNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ExportDoNotCallNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportDoNotCallNumbersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ExportDoNotCallNumbersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ExportDoNotCallNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportDoNotCallNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAccessChannelOfStagingRequest(TeaModel):
    def __init__(self, search_pattern=None):
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAccessChannelOfStagingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class GetAccessChannelOfStagingResponseBodyData(TeaModel):
    def __init__(self, token=None):
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAccessChannelOfStagingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetAccessChannelOfStagingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetAccessChannelOfStagingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAccessChannelOfStagingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAccessChannelOfStagingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAccessChannelOfStagingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAccessChannelOfStagingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAccessChannelOfStagingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAccessChannelOfStagingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAudioFileRequest(TeaModel):
    def __init__(self, audio_resource_id=None, instance_id=None):
        self.audio_resource_id = audio_resource_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_resource_id is not None:
            result['AudioResourceId'] = self.audio_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioResourceId') is not None:
            self.audio_resource_id = m.get('AudioResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAudioFileResponseBodyData(TeaModel):
    def __init__(self, audio_file_name=None, audio_resource_id=None, created_time=None, instance_id=None, name=None,
                 oss_file_key=None, updated_time=None):
        self.audio_file_name = audio_file_name  # type: str
        self.audio_resource_id = audio_resource_id  # type: str
        self.created_time = created_time  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.oss_file_key = oss_file_key  # type: str
        self.updated_time = updated_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_file_name is not None:
            result['AudioFileName'] = self.audio_file_name
        if self.audio_resource_id is not None:
            result['AudioResourceId'] = self.audio_resource_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_file_key is not None:
            result['OssFileKey'] = self.oss_file_key
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFileName') is not None:
            self.audio_file_name = m.get('AudioFileName')
        if m.get('AudioResourceId') is not None:
            self.audio_resource_id = m.get('AudioResourceId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssFileKey') is not None:
            self.oss_file_key = m.get('OssFileKey')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        return self


class GetAudioFileResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetAudioFileResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAudioFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAudioFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAudioFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAudioFileResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAudioFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAudioFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAudioFileDownloadUrlRequest(TeaModel):
    def __init__(self, audio_resource_id=None, instance_id=None):
        self.audio_resource_id = audio_resource_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileDownloadUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_resource_id is not None:
            result['AudioResourceId'] = self.audio_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioResourceId') is not None:
            self.audio_resource_id = m.get('AudioResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAudioFileDownloadUrlResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileDownloadUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAudioFileDownloadUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAudioFileDownloadUrlResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAudioFileDownloadUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAudioFileDownloadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAudioFileUploadParametersRequest(TeaModel):
    def __init__(self, audio_file_name=None, instance_id=None):
        self.audio_file_name = audio_file_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileUploadParametersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_file_name is not None:
            result['AudioFileName'] = self.audio_file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFileName') is not None:
            self.audio_file_name = m.get('AudioFileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAudioFileUploadParametersResponseBodyData(TeaModel):
    def __init__(self, access_key_id=None, expire_time=None, file_path=None, host=None, policy=None, signature=None):
        self.access_key_id = access_key_id  # type: str
        self.expire_time = expire_time  # type: int
        self.file_path = file_path  # type: str
        self.host = host  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAudioFileUploadParametersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class GetAudioFileUploadParametersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetAudioFileUploadParametersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAudioFileUploadParametersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAudioFileUploadParametersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAudioFileUploadParametersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAudioFileUploadParametersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAudioFileUploadParametersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAudioFileUploadParametersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallDetailRecordRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCallDetailRecordResponseBodyDataAgentEventsEventSequence(TeaModel):
    def __init__(self, duration=None, event=None, event_time=None):
        self.duration = duration  # type: long
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataAgentEvents(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, event_sequence=None, skill_group_id=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataAgentEventsEventSequence]
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataAgentEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataCustomerEvents(TeaModel):
    def __init__(self, customer_id=None, event_sequence=None):
        self.customer_id = customer_id  # type: str
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence]

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataCustomerEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_id is not None:
            result['CustomerId'] = self.customer_id
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomerId') is not None:
            self.customer_id = m.get('CustomerId')
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataCustomerEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        return self


class GetCallDetailRecordResponseBodyDataIvrEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataIvrEvents(TeaModel):
    def __init__(self, event_sequence=None, flow_id=None, flow_type=None):
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataIvrEventsEventSequence]
        self.flow_id = flow_id  # type: str
        self.flow_type = flow_type  # type: str

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataIvrEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_type is not None:
            result['FlowType'] = self.flow_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowType') is not None:
            self.flow_type = m.get('FlowType')
        return self


class GetCallDetailRecordResponseBodyDataQueueEventsEventSequence(TeaModel):
    def __init__(self, event=None, event_time=None):
        self.event = event  # type: str
        self.event_time = event_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEventsEventSequence, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event is not None:
            result['Event'] = self.event
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        return self


class GetCallDetailRecordResponseBodyDataQueueEvents(TeaModel):
    def __init__(self, event_sequence=None, flow_id=None, queue_id=None, queue_name=None, queue_type=None):
        self.event_sequence = event_sequence  # type: list[GetCallDetailRecordResponseBodyDataQueueEventsEventSequence]
        self.flow_id = flow_id  # type: str
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.queue_type = queue_type  # type: int

    def validate(self):
        if self.event_sequence:
            for k in self.event_sequence:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyDataQueueEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventSequence'] = []
        if self.event_sequence is not None:
            for k in self.event_sequence:
                result['EventSequence'].append(k.to_map() if k else None)
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.queue_type is not None:
            result['QueueType'] = self.queue_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_sequence = []
        if m.get('EventSequence') is not None:
            for k in m.get('EventSequence'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEventsEventSequence()
                self.event_sequence.append(temp_model.from_map(k))
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('QueueType') is not None:
            self.queue_type = m.get('QueueType')
        return self


class GetCallDetailRecordResponseBodyData(TeaModel):
    def __init__(self, agent_events=None, agent_ids=None, agent_names=None, call_duration=None, called_number=None,
                 callee_location=None, caller_location=None, calling_number=None, contact_disposition=None, contact_id=None,
                 contact_type=None, customer_events=None, early_media_state=None, established_time=None, instance_id=None,
                 ivr_events=None, queue_events=None, recording_ready=None, release_initiator=None, release_reason=None,
                 release_time=None, satisfaction=None, satisfaction_survey_channel=None, satisfaction_survey_offered=None,
                 skill_group_ids=None, skill_group_names=None, start_time=None):
        self.agent_events = agent_events  # type: list[GetCallDetailRecordResponseBodyDataAgentEvents]
        self.agent_ids = agent_ids  # type: str
        self.agent_names = agent_names  # type: str
        self.call_duration = call_duration  # type: long
        self.called_number = called_number  # type: str
        self.callee_location = callee_location  # type: str
        self.caller_location = caller_location  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.customer_events = customer_events  # type: list[GetCallDetailRecordResponseBodyDataCustomerEvents]
        self.early_media_state = early_media_state  # type: str
        self.established_time = established_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_events = ivr_events  # type: list[GetCallDetailRecordResponseBodyDataIvrEvents]
        self.queue_events = queue_events  # type: list[GetCallDetailRecordResponseBodyDataQueueEvents]
        self.recording_ready = recording_ready  # type: bool
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.release_time = release_time  # type: long
        self.satisfaction = satisfaction  # type: int
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        if self.agent_events:
            for k in self.agent_events:
                if k:
                    k.validate()
        if self.customer_events:
            for k in self.customer_events:
                if k:
                    k.validate()
        if self.ivr_events:
            for k in self.ivr_events:
                if k:
                    k.validate()
        if self.queue_events:
            for k in self.queue_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AgentEvents'] = []
        if self.agent_events is not None:
            for k in self.agent_events:
                result['AgentEvents'].append(k.to_map() if k else None)
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        result['CustomerEvents'] = []
        if self.customer_events is not None:
            for k in self.customer_events:
                result['CustomerEvents'].append(k.to_map() if k else None)
        if self.early_media_state is not None:
            result['EarlyMediaState'] = self.early_media_state
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['IvrEvents'] = []
        if self.ivr_events is not None:
            for k in self.ivr_events:
                result['IvrEvents'].append(k.to_map() if k else None)
        result['QueueEvents'] = []
        if self.queue_events is not None:
            for k in self.queue_events:
                result['QueueEvents'].append(k.to_map() if k else None)
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.satisfaction is not None:
            result['Satisfaction'] = self.satisfaction
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.agent_events = []
        if m.get('AgentEvents') is not None:
            for k in m.get('AgentEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataAgentEvents()
                self.agent_events.append(temp_model.from_map(k))
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        self.customer_events = []
        if m.get('CustomerEvents') is not None:
            for k in m.get('CustomerEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataCustomerEvents()
                self.customer_events.append(temp_model.from_map(k))
        if m.get('EarlyMediaState') is not None:
            self.early_media_state = m.get('EarlyMediaState')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.ivr_events = []
        if m.get('IvrEvents') is not None:
            for k in m.get('IvrEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataIvrEvents()
                self.ivr_events.append(temp_model.from_map(k))
        self.queue_events = []
        if m.get('QueueEvents') is not None:
            for k in m.get('QueueEvents'):
                temp_model = GetCallDetailRecordResponseBodyDataQueueEvents()
                self.queue_events.append(temp_model.from_map(k))
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('Satisfaction') is not None:
            self.satisfaction = m.get('Satisfaction')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetCallDetailRecordResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetCallDetailRecordResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCallDetailRecordResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCallDetailRecordResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCallDetailRecordResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCallDetailRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCallDetailRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCampaignRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCampaignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCampaignResponseBodyData(TeaModel):
    def __init__(self, actual_end_time=None, actual_start_time=None, campaign_id=None, cases_aborted=None,
                 cases_connected=None, cases_uncompleted=None, cases_uncompleted_after_attempt=None,
                 cases_uncompleted_after_attempted=None, completion_rate=None, max_attempt_count=None, min_attempt_interval=None, name=None,
                 planed_end_time=None, planed_start_time=None, queue_id=None, queue_name=None, simulation=None,
                 simulation_parameters=None, state=None, strategy_parameters=None, strategy_type=None, total_cases=None):
        self.actual_end_time = actual_end_time  # type: long
        self.actual_start_time = actual_start_time  # type: long
        self.campaign_id = campaign_id  # type: str
        self.cases_aborted = cases_aborted  # type: long
        self.cases_connected = cases_connected  # type: long
        self.cases_uncompleted = cases_uncompleted  # type: long
        self.cases_uncompleted_after_attempt = cases_uncompleted_after_attempt  # type: str
        self.cases_uncompleted_after_attempted = cases_uncompleted_after_attempted  # type: long
        self.completion_rate = completion_rate  # type: float
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.planed_end_time = planed_end_time  # type: long
        self.planed_start_time = planed_start_time  # type: long
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.simulation = simulation  # type: bool
        self.simulation_parameters = simulation_parameters  # type: str
        self.state = state  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str
        self.total_cases = total_cases  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCampaignResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_end_time is not None:
            result['ActualEndTime'] = self.actual_end_time
        if self.actual_start_time is not None:
            result['ActualStartTime'] = self.actual_start_time
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.cases_aborted is not None:
            result['CasesAborted'] = self.cases_aborted
        if self.cases_connected is not None:
            result['CasesConnected'] = self.cases_connected
        if self.cases_uncompleted is not None:
            result['CasesUncompleted'] = self.cases_uncompleted
        if self.cases_uncompleted_after_attempt is not None:
            result['CasesUncompletedAfterAttempt'] = self.cases_uncompleted_after_attempt
        if self.cases_uncompleted_after_attempted is not None:
            result['CasesUncompletedAfterAttempted'] = self.cases_uncompleted_after_attempted
        if self.completion_rate is not None:
            result['CompletionRate'] = self.completion_rate
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.planed_end_time is not None:
            result['PlanedEndTime'] = self.planed_end_time
        if self.planed_start_time is not None:
            result['PlanedStartTime'] = self.planed_start_time
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.simulation_parameters is not None:
            result['SimulationParameters'] = self.simulation_parameters
        if self.state is not None:
            result['State'] = self.state
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        if self.total_cases is not None:
            result['TotalCases'] = self.total_cases
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualEndTime') is not None:
            self.actual_end_time = m.get('ActualEndTime')
        if m.get('ActualStartTime') is not None:
            self.actual_start_time = m.get('ActualStartTime')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CasesAborted') is not None:
            self.cases_aborted = m.get('CasesAborted')
        if m.get('CasesConnected') is not None:
            self.cases_connected = m.get('CasesConnected')
        if m.get('CasesUncompleted') is not None:
            self.cases_uncompleted = m.get('CasesUncompleted')
        if m.get('CasesUncompletedAfterAttempt') is not None:
            self.cases_uncompleted_after_attempt = m.get('CasesUncompletedAfterAttempt')
        if m.get('CasesUncompletedAfterAttempted') is not None:
            self.cases_uncompleted_after_attempted = m.get('CasesUncompletedAfterAttempted')
        if m.get('CompletionRate') is not None:
            self.completion_rate = m.get('CompletionRate')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PlanedEndTime') is not None:
            self.planed_end_time = m.get('PlanedEndTime')
        if m.get('PlanedStartTime') is not None:
            self.planed_start_time = m.get('PlanedStartTime')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('SimulationParameters') is not None:
            self.simulation_parameters = m.get('SimulationParameters')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        if m.get('TotalCases') is not None:
            self.total_cases = m.get('TotalCases')
        return self


class GetCampaignResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetCampaignResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCampaignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCampaignResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCampaignResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCampaignResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCampaignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCampaignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCaseFileUploadUrlRequest(TeaModel):
    def __init__(self, file_name=None, instance_id=None):
        self.file_name = file_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCaseFileUploadUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetCaseFileUploadUrlResponseBodyData(TeaModel):
    def __init__(self, case_file_key=None, url=None):
        self.case_file_key = case_file_key  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_file_key is not None:
            result['CaseFileKey'] = self.case_file_key
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaseFileKey') is not None:
            self.case_file_key = m.get('CaseFileKey')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetCaseFileUploadUrlResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetCaseFileUploadUrlResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCaseFileUploadUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCaseFileUploadUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCaseFileUploadUrlResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCaseFileUploadUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCaseFileUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetContactFlowRequest(TeaModel):
    def __init__(self, contact_flow_id=None, draft_id=None, instance_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.draft_id = draft_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetContactFlowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetContactFlowResponseBodyData(TeaModel):
    def __init__(self, contact_flow_id=None, created_time=None, definition=None, description=None, draft_id=None,
                 editor=None, instance_id=None, name=None, published=None, type=None, updated_time=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.created_time = created_time  # type: str
        self.definition = definition  # type: str
        self.description = description  # type: str
        self.draft_id = draft_id  # type: str
        self.editor = editor  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.published = published  # type: bool
        self.type = type  # type: str
        self.updated_time = updated_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetContactFlowResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.description is not None:
            result['Description'] = self.description
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.editor is not None:
            result['Editor'] = self.editor
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.published is not None:
            result['Published'] = self.published
        if self.type is not None:
            result['Type'] = self.type
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('Editor') is not None:
            self.editor = m.get('Editor')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Published') is not None:
            self.published = m.get('Published')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        return self


class GetContactFlowResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetContactFlowResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetContactFlowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetContactFlowResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetContactFlowResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetContactFlowResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetContactFlowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetContactFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConversationDetailRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConversationDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConversationDetailResponseBodyPhrases(TeaModel):
    def __init__(self, begin=None, end=None, identity=None, role=None, words=None):
        self.begin = begin  # type: int
        self.end = end  # type: int
        self.identity = identity  # type: str
        self.role = role  # type: str
        self.words = words  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConversationDetailResponseBodyPhrases, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        if self.identity is not None:
            result['Identity'] = self.identity
        if self.role is not None:
            result['Role'] = self.role
        if self.words is not None:
            result['Words'] = self.words
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Identity') is not None:
            self.identity = m.get('Identity')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Words') is not None:
            self.words = m.get('Words')
        return self


class GetConversationDetailResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, phrases=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.phrases = phrases  # type: list[GetConversationDetailResponseBodyPhrases]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.phrases:
            for k in self.phrases:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetConversationDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        result['Phrases'] = []
        if self.phrases is not None:
            for k in self.phrases:
                result['Phrases'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.phrases = []
        if m.get('Phrases') is not None:
            for k in m.get('Phrases'):
                temp_model = GetConversationDetailResponseBodyPhrases()
                self.phrases.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConversationDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetConversationDetailResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetConversationDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConversationDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataChannelCredentialsRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataChannelCredentialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDataChannelCredentialsResponseBodyData(TeaModel):
    def __init__(self, client_id=None, device_id=None, endpoint=None, expired_time=None, password=None, topic=None,
                 user_name=None):
        self.client_id = client_id  # type: str
        self.device_id = device_id  # type: str
        self.endpoint = endpoint  # type: str
        self.expired_time = expired_time  # type: long
        self.password = password  # type: str
        self.topic = topic  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataChannelCredentialsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.password is not None:
            result['Password'] = self.password
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetDataChannelCredentialsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetDataChannelCredentialsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataChannelCredentialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDataChannelCredentialsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataChannelCredentialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDataChannelCredentialsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataChannelCredentialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDataChannelCredentialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDoNotCallFileUploadParametersRequest(TeaModel):
    def __init__(self, file_name=None, instance_id=None):
        self.file_name = file_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDoNotCallFileUploadParametersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDoNotCallFileUploadParametersResponseBodyData(TeaModel):
    def __init__(self, access_key_id=None, expire_time=None, file_path=None, host=None, policy=None, signature=None):
        self.access_key_id = access_key_id  # type: str
        self.expire_time = expire_time  # type: int
        self.file_path = file_path  # type: str
        self.host = host  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDoNotCallFileUploadParametersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class GetDoNotCallFileUploadParametersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDoNotCallFileUploadParametersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDoNotCallFileUploadParametersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDoNotCallFileUploadParametersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDoNotCallFileUploadParametersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDoNotCallFileUploadParametersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDoNotCallFileUploadParametersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDoNotCallFileUploadParametersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEarlyMediaRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEarlyMediaRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEarlyMediaRecordingResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEarlyMediaRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetEarlyMediaRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetEarlyMediaRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEarlyMediaRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEarlyMediaRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEarlyMediaRecordingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEarlyMediaRecordingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEarlyMediaRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEarlyMediaRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalCallerReportRequest(TeaModel):
    def __init__(self, calling_number=None, instance_id=None, start_time=None, stop_time=None):
        self.calling_number = calling_number  # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class GetHistoricalCallerReportResponseBodyData(TeaModel):
    def __init__(self, last_calling_time=None, total_calls=None):
        self.last_calling_time = last_calling_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_calling_time is not None:
            result['LastCallingTime'] = self.last_calling_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LastCallingTime') is not None:
            self.last_calling_time = m.get('LastCallingTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetHistoricalCallerReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetHistoricalCallerReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHistoricalCallerReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetHistoricalCallerReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHistoricalCallerReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalCallerReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHistoricalCallerReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalCampaignReportRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCampaignReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHistoricalCampaignReportResponseBodyData(TeaModel):
    def __init__(self, abandon_rate=None, abandoned_rate=None, answer_rate=None, calls_abandoned=None,
                 calls_connected=None, calls_dialed=None, connected_rate=None, occupancy_rate=None):
        self.abandon_rate = abandon_rate  # type: float
        self.abandoned_rate = abandoned_rate  # type: float
        self.answer_rate = answer_rate  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_connected = calls_connected  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.connected_rate = connected_rate  # type: float
        self.occupancy_rate = occupancy_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalCampaignReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        if self.abandoned_rate is not None:
            result['AbandonedRate'] = self.abandoned_rate
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_connected is not None:
            result['CallsConnected'] = self.calls_connected
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.connected_rate is not None:
            result['ConnectedRate'] = self.connected_rate
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        if m.get('AbandonedRate') is not None:
            self.abandoned_rate = m.get('AbandonedRate')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsConnected') is not None:
            self.calls_connected = m.get('CallsConnected')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('ConnectedRate') is not None:
            self.connected_rate = m.get('ConnectedRate')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        return self


class GetHistoricalCampaignReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetHistoricalCampaignReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalCampaignReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHistoricalCampaignReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetHistoricalCampaignReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHistoricalCampaignReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalCampaignReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHistoricalCampaignReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHistoricalInstanceReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, media_type=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataInboundAccessChannelTypeDetailList(TeaModel):
    def __init__(self, access_channel_type=None, calls_offered=None):
        self.access_channel_type = access_channel_type  # type: str
        self.calls_offered = calls_offered  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataInboundAccessChannelTypeDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_channel_type is not None:
            result['AccessChannelType'] = self.access_channel_type
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessChannelType') is not None:
            self.access_channel_type = m.get('AccessChannelType')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        return self


class GetHistoricalInstanceReportResponseBodyDataInbound(TeaModel):
    def __init__(self, abandon_rate=None, access_channel_type_detail_list=None, average_abandon_time=None,
                 average_abandoned_in_ivrtime=None, average_abandoned_in_queue_time=None, average_abandoned_in_ring_time=None,
                 average_first_response_time=None, average_hold_time=None, average_response_time=None, average_ring_time=None,
                 average_talk_time=None, average_wait_time=None, average_work_time=None, calls_abandoned=None,
                 calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None, calls_abandoned_in_ring=None,
                 calls_abandoned_in_voice_navigator=None, calls_attended_transferred=None, calls_blind_transferred=None,
                 calls_caused_ivrexception=None, calls_forward_to_outside_number=None, calls_handled=None, calls_hold=None,
                 calls_ivrexception=None, calls_offered=None, calls_queued=None, calls_queuing_failed=None,
                 calls_queuing_overflow=None, calls_queuing_timeout=None, calls_ringed=None, calls_to_voicemail=None,
                 calls_voicemail=None, handle_rate=None, max_abandon_time=None, max_abandoned_in_ivrtime=None,
                 max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None, max_ring_time=None, max_talk_time=None,
                 max_wait_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, service_level_15=None, service_level_20=None,
                 service_level_30=None, total_abandon_time=None, total_abandoned_in_ivrtime=None,
                 total_abandoned_in_queue_time=None, total_abandoned_in_ring_time=None, total_hold_time=None, total_messages_sent=None,
                 total_messages_sent_by_agent=None, total_messages_sent_by_customer=None, total_ring_time=None, total_talk_time=None,
                 total_wait_time=None, total_work_time=None):
        self.abandon_rate = abandon_rate  # type: float
        self.access_channel_type_detail_list = access_channel_type_detail_list  # type: list[GetHistoricalInstanceReportResponseBodyDataInboundAccessChannelTypeDetailList]
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_ivrtime = average_abandoned_in_ivrtime  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_first_response_time = average_first_response_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_response_time = average_response_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_abandoned_in_voice_navigator = calls_abandoned_in_voice_navigator  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_caused_ivrexception = calls_caused_ivrexception  # type: long
        self.calls_forward_to_outside_number = calls_forward_to_outside_number  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ivrexception = calls_ivrexception  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_to_voicemail = calls_to_voicemail  # type: long
        self.calls_voicemail = calls_voicemail  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_ivrtime = max_abandoned_in_ivrtime  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_15 = service_level_15  # type: float
        self.service_level_20 = service_level_20  # type: float
        self.service_level_30 = service_level_30  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_ivrtime = total_abandoned_in_ivrtime  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_messages_sent = total_messages_sent  # type: long
        self.total_messages_sent_by_agent = total_messages_sent_by_agent  # type: long
        self.total_messages_sent_by_customer = total_messages_sent_by_customer  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.access_channel_type_detail_list:
            for k in self.access_channel_type_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        result['AccessChannelTypeDetailList'] = []
        if self.access_channel_type_detail_list is not None:
            for k in self.access_channel_type_detail_list:
                result['AccessChannelTypeDetailList'].append(k.to_map() if k else None)
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_ivrtime is not None:
            result['AverageAbandonedInIVRTime'] = self.average_abandoned_in_ivrtime
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_first_response_time is not None:
            result['AverageFirstResponseTime'] = self.average_first_response_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_response_time is not None:
            result['AverageResponseTime'] = self.average_response_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_abandoned_in_voice_navigator is not None:
            result['CallsAbandonedInVoiceNavigator'] = self.calls_abandoned_in_voice_navigator
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_caused_ivrexception is not None:
            result['CallsCausedIVRException'] = self.calls_caused_ivrexception
        if self.calls_forward_to_outside_number is not None:
            result['CallsForwardToOutsideNumber'] = self.calls_forward_to_outside_number
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ivrexception is not None:
            result['CallsIVRException'] = self.calls_ivrexception
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_to_voicemail is not None:
            result['CallsToVoicemail'] = self.calls_to_voicemail
        if self.calls_voicemail is not None:
            result['CallsVoicemail'] = self.calls_voicemail
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_ivrtime is not None:
            result['MaxAbandonedInIVRTime'] = self.max_abandoned_in_ivrtime
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_15 is not None:
            result['ServiceLevel15'] = self.service_level_15
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.service_level_30 is not None:
            result['ServiceLevel30'] = self.service_level_30
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_ivrtime is not None:
            result['TotalAbandonedInIVRTime'] = self.total_abandoned_in_ivrtime
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_messages_sent is not None:
            result['TotalMessagesSent'] = self.total_messages_sent
        if self.total_messages_sent_by_agent is not None:
            result['TotalMessagesSentByAgent'] = self.total_messages_sent_by_agent
        if self.total_messages_sent_by_customer is not None:
            result['TotalMessagesSentByCustomer'] = self.total_messages_sent_by_customer
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        self.access_channel_type_detail_list = []
        if m.get('AccessChannelTypeDetailList') is not None:
            for k in m.get('AccessChannelTypeDetailList'):
                temp_model = GetHistoricalInstanceReportResponseBodyDataInboundAccessChannelTypeDetailList()
                self.access_channel_type_detail_list.append(temp_model.from_map(k))
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInIVRTime') is not None:
            self.average_abandoned_in_ivrtime = m.get('AverageAbandonedInIVRTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageFirstResponseTime') is not None:
            self.average_first_response_time = m.get('AverageFirstResponseTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageResponseTime') is not None:
            self.average_response_time = m.get('AverageResponseTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAbandonedInVoiceNavigator') is not None:
            self.calls_abandoned_in_voice_navigator = m.get('CallsAbandonedInVoiceNavigator')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsCausedIVRException') is not None:
            self.calls_caused_ivrexception = m.get('CallsCausedIVRException')
        if m.get('CallsForwardToOutsideNumber') is not None:
            self.calls_forward_to_outside_number = m.get('CallsForwardToOutsideNumber')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsIVRException') is not None:
            self.calls_ivrexception = m.get('CallsIVRException')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsToVoicemail') is not None:
            self.calls_to_voicemail = m.get('CallsToVoicemail')
        if m.get('CallsVoicemail') is not None:
            self.calls_voicemail = m.get('CallsVoicemail')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInIVRTime') is not None:
            self.max_abandoned_in_ivrtime = m.get('MaxAbandonedInIVRTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel15') is not None:
            self.service_level_15 = m.get('ServiceLevel15')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('ServiceLevel30') is not None:
            self.service_level_30 = m.get('ServiceLevel30')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInIVRTime') is not None:
            self.total_abandoned_in_ivrtime = m.get('TotalAbandonedInIVRTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalMessagesSent') is not None:
            self.total_messages_sent = m.get('TotalMessagesSent')
        if m.get('TotalMessagesSentByAgent') is not None:
            self.total_messages_sent_by_agent = m.get('TotalMessagesSentByAgent')
        if m.get('TotalMessagesSentByCustomer') is not None:
            self.total_messages_sent_by_customer = m.get('TotalMessagesSentByCustomer')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataInternal(TeaModel):
    def __init__(self, calls_answered=None, calls_dialed=None):
        self.calls_answered = calls_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataInternal, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        return self


class GetHistoricalInstanceReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transferred=None,
                 calls_blind_transferred=None, calls_dialed=None, calls_hold=None, calls_ringed=None, max_dialing_time=None,
                 max_hold_time=None, max_ring_time=None, max_talk_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_dialing_time=None, total_hold_time=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transferred = calls_attended_transferred  # type: long
        self.calls_blind_transferred = calls_blind_transferred  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: int
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transferred is not None:
            result['CallsAttendedTransferred'] = self.calls_attended_transferred
        if self.calls_blind_transferred is not None:
            result['CallsBlindTransferred'] = self.calls_blind_transferred
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferred') is not None:
            self.calls_attended_transferred = m.get('CallsAttendedTransferred')
        if m.get('CallsBlindTransferred') is not None:
            self.calls_blind_transferred = m.get('CallsBlindTransferred')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyDataOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, max_break_time=None, max_hold_time=None, max_logged_in_agents=None,
                 max_ready_time=None, max_talk_time=None, max_work_time=None, occupancy_rate=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_break_time=None, total_calls=None, total_hold_time=None, total_logged_in_time=None, total_ready_time=None,
                 total_talk_time=None, total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_logged_in_agents = max_logged_in_agents  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_logged_in_agents is not None:
            result['MaxLoggedInAgents'] = self.max_logged_in_agents
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxLoggedInAgents') is not None:
            self.max_logged_in_agents = m.get('MaxLoggedInAgents')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class GetHistoricalInstanceReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, internal=None, outbound=None, overall=None):
        self.inbound = inbound  # type: GetHistoricalInstanceReportResponseBodyDataInbound
        self.internal = internal  # type: GetHistoricalInstanceReportResponseBodyDataInternal
        self.outbound = outbound  # type: GetHistoricalInstanceReportResponseBodyDataOutbound
        self.overall = overall  # type: GetHistoricalInstanceReportResponseBodyDataOverall

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.internal:
            self.internal.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.internal is not None:
            result['Internal'] = self.internal.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Inbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Internal') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataInternal()
            self.internal = temp_model.from_map(m['Internal'])
        if m.get('Outbound') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyDataOverall()
            self.overall = temp_model.from_map(m['Overall'])
        return self


class GetHistoricalInstanceReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetHistoricalInstanceReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHistoricalInstanceReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetHistoricalInstanceReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHistoricalInstanceReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHistoricalInstanceReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHistoricalInstanceReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceResponseBodyDataAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetInstanceResponseBodyDataNumberListSkillGroups(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, name=None, phone_number_count=None,
                 skill_group_id=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class GetInstanceResponseBodyDataNumberList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None,
                 skill_groups=None, usage=None, user_id=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[GetInstanceResponseBodyDataNumberListSkillGroups]
        self.usage = usage  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyDataNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = GetInstanceResponseBodyDataNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, description=None, domain_name=None,
                 id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[GetInstanceResponseBodyDataAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[GetInstanceResponseBodyDataNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = GetInstanceResponseBodyDataAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = GetInstanceResponseBodyDataNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetInstanceResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetInstanceResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceTrendingReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, media_type=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetInstanceTrendingReportResponseBodyDataInbound(TeaModel):
    def __init__(self, calls_abandoned_in_ivr=None, calls_abandoned_in_queue=None, calls_abandoned_in_ring=None,
                 calls_handled=None, calls_queued=None, stats_time=None, total_calls=None):
        self.calls_abandoned_in_ivr = calls_abandoned_in_ivr  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_queued = calls_queued  # type: long
        self.stats_time = stats_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calls_abandoned_in_ivr is not None:
            result['CallsAbandonedInIVR'] = self.calls_abandoned_in_ivr
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsAbandonedInIVR') is not None:
            self.calls_abandoned_in_ivr = m.get('CallsAbandonedInIVR')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceTrendingReportResponseBodyDataOutbound(TeaModel):
    def __init__(self, calls_answered=None, stats_time=None, total_calls=None):
        self.calls_answered = calls_answered  # type: long
        self.stats_time = stats_time  # type: long
        self.total_calls = total_calls  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        return self


class GetInstanceTrendingReportResponseBodyDataOverall(TeaModel):
    def __init__(self, max_logged_in_agents=None, stats_time=None):
        self.max_logged_in_agents = max_logged_in_agents  # type: long
        self.stats_time = stats_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyDataOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_logged_in_agents is not None:
            result['MaxLoggedInAgents'] = self.max_logged_in_agents
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxLoggedInAgents') is not None:
            self.max_logged_in_agents = m.get('MaxLoggedInAgents')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        return self


class GetInstanceTrendingReportResponseBodyData(TeaModel):
    def __init__(self, inbound=None, outbound=None, overall=None):
        self.inbound = inbound  # type: list[GetInstanceTrendingReportResponseBodyDataInbound]
        self.outbound = outbound  # type: list[GetInstanceTrendingReportResponseBodyDataOutbound]
        self.overall = overall  # type: list[GetInstanceTrendingReportResponseBodyDataOverall]

    def validate(self):
        if self.inbound:
            for k in self.inbound:
                if k:
                    k.validate()
        if self.outbound:
            for k in self.outbound:
                if k:
                    k.validate()
        if self.overall:
            for k in self.overall:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inbound'] = []
        if self.inbound is not None:
            for k in self.inbound:
                result['Inbound'].append(k.to_map() if k else None)
        result['Outbound'] = []
        if self.outbound is not None:
            for k in self.outbound:
                result['Outbound'].append(k.to_map() if k else None)
        result['Overall'] = []
        if self.overall is not None:
            for k in self.overall:
                result['Overall'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.inbound = []
        if m.get('Inbound') is not None:
            for k in m.get('Inbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataInbound()
                self.inbound.append(temp_model.from_map(k))
        self.outbound = []
        if m.get('Outbound') is not None:
            for k in m.get('Outbound'):
                temp_model = GetInstanceTrendingReportResponseBodyDataOutbound()
                self.outbound.append(temp_model.from_map(k))
        self.overall = []
        if m.get('Overall') is not None:
            for k in m.get('Overall'):
                temp_model = GetInstanceTrendingReportResponseBodyDataOverall()
                self.overall.append(temp_model.from_map(k))
        return self


class GetInstanceTrendingReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetInstanceTrendingReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceTrendingReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceTrendingReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetInstanceTrendingReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceTrendingReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceTrendingReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoginDetailsRequest(TeaModel):
    def __init__(self, chat_device_id=None, instance_id=None, user_id=None):
        self.chat_device_id = chat_device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoginDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chat_device_id is not None:
            result['ChatDeviceId'] = self.chat_device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChatDeviceId') is not None:
            self.chat_device_id = m.get('ChatDeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetLoginDetailsResponseBodyData(TeaModel):
    def __init__(self, agent_server_url=None, avatar_url=None, chat_app_id=None, chat_app_key=None,
                 chat_device_id=None, chat_login_token=None, chat_server_url=None, chat_user_id=None, device_ext=None,
                 device_id=None, device_state=None, display_name=None, extension=None, nickname=None, signature=None,
                 signature_2=None, sip_server_url=None, user_id=None, user_key=None, user_key_2=None, work_mode=None):
        self.agent_server_url = agent_server_url  # type: str
        self.avatar_url = avatar_url  # type: str
        self.chat_app_id = chat_app_id  # type: str
        self.chat_app_key = chat_app_key  # type: str
        self.chat_device_id = chat_device_id  # type: str
        self.chat_login_token = chat_login_token  # type: str
        self.chat_server_url = chat_server_url  # type: str
        self.chat_user_id = chat_user_id  # type: str
        self.device_ext = device_ext  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.display_name = display_name  # type: str
        self.extension = extension  # type: str
        self.nickname = nickname  # type: str
        self.signature = signature  # type: str
        self.signature_2 = signature_2  # type: str
        self.sip_server_url = sip_server_url  # type: str
        self.user_id = user_id  # type: str
        self.user_key = user_key  # type: str
        self.user_key_2 = user_key_2  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoginDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_server_url is not None:
            result['AgentServerUrl'] = self.agent_server_url
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.chat_app_id is not None:
            result['ChatAppId'] = self.chat_app_id
        if self.chat_app_key is not None:
            result['ChatAppKey'] = self.chat_app_key
        if self.chat_device_id is not None:
            result['ChatDeviceId'] = self.chat_device_id
        if self.chat_login_token is not None:
            result['ChatLoginToken'] = self.chat_login_token
        if self.chat_server_url is not None:
            result['ChatServerUrl'] = self.chat_server_url
        if self.chat_user_id is not None:
            result['ChatUserId'] = self.chat_user_id
        if self.device_ext is not None:
            result['DeviceExt'] = self.device_ext
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.signature_2 is not None:
            result['Signature2'] = self.signature_2
        if self.sip_server_url is not None:
            result['SipServerUrl'] = self.sip_server_url
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_key is not None:
            result['UserKey'] = self.user_key
        if self.user_key_2 is not None:
            result['UserKey2'] = self.user_key_2
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentServerUrl') is not None:
            self.agent_server_url = m.get('AgentServerUrl')
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('ChatAppId') is not None:
            self.chat_app_id = m.get('ChatAppId')
        if m.get('ChatAppKey') is not None:
            self.chat_app_key = m.get('ChatAppKey')
        if m.get('ChatDeviceId') is not None:
            self.chat_device_id = m.get('ChatDeviceId')
        if m.get('ChatLoginToken') is not None:
            self.chat_login_token = m.get('ChatLoginToken')
        if m.get('ChatServerUrl') is not None:
            self.chat_server_url = m.get('ChatServerUrl')
        if m.get('ChatUserId') is not None:
            self.chat_user_id = m.get('ChatUserId')
        if m.get('DeviceExt') is not None:
            self.device_ext = m.get('DeviceExt')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Signature2') is not None:
            self.signature_2 = m.get('Signature2')
        if m.get('SipServerUrl') is not None:
            self.sip_server_url = m.get('SipServerUrl')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserKey') is not None:
            self.user_key = m.get('UserKey')
        if m.get('UserKey2') is not None:
            self.user_key_2 = m.get('UserKey2')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetLoginDetailsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetLoginDetailsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetLoginDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetLoginDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLoginDetailsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLoginDetailsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLoginDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLoginDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMonoRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, expire_seconds=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.expire_seconds = expire_seconds  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.expire_seconds is not None:
            result['ExpireSeconds'] = self.expire_seconds
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ExpireSeconds') is not None:
            self.expire_seconds = m.get('ExpireSeconds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMonoRecordingResponseBodyData(TeaModel):
    def __init__(self, duration=None, file_name=None, file_url=None):
        self.duration = duration  # type: long
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMonoRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetMonoRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMonoRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMonoRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMonoRecordingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMonoRecordingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMonoRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMonoRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMultiChannelRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMultiChannelRecordingResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetMultiChannelRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetMultiChannelRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMultiChannelRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMultiChannelRecordingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMultiChannelRecordingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMultiChannelRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMultiChannelRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumberLocationRequest(TeaModel):
    def __init__(self, instance_id=None, number=None):
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class GetNumberLocationResponseBodyData(TeaModel):
    def __init__(self, city=None, number=None, province=None):
        self.city = city  # type: str
        self.number = number  # type: str
        self.province = province  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumberLocationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class GetNumberLocationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetNumberLocationResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetNumberLocationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetNumberLocationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetNumberLocationResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNumberLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNumberLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeCampaignStatsRequest(TeaModel):
    def __init__(self, instance_id=None, queue_id=None):
        self.instance_id = instance_id  # type: str
        self.queue_id = queue_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeCampaignStatsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        return self


class GetRealtimeCampaignStatsResponseBodyData(TeaModel):
    def __init__(self, breaking_agents=None, caps=None, logged_in_agents=None,
                 outbound_scenario_breaking_agents=None, outbound_scenario_ready_agents=None, outbound_scenario_talking_agents=None,
                 outbound_scenario_working_agents=None, ready_agents=None, talking_agents=None, total_agents=None, working_agents=None):
        self.breaking_agents = breaking_agents  # type: long
        self.caps = caps  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.outbound_scenario_breaking_agents = outbound_scenario_breaking_agents  # type: long
        self.outbound_scenario_ready_agents = outbound_scenario_ready_agents  # type: long
        self.outbound_scenario_talking_agents = outbound_scenario_talking_agents  # type: long
        self.outbound_scenario_working_agents = outbound_scenario_working_agents  # type: long
        self.ready_agents = ready_agents  # type: long
        self.talking_agents = talking_agents  # type: long
        self.total_agents = total_agents  # type: long
        self.working_agents = working_agents  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeCampaignStatsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.caps is not None:
            result['Caps'] = self.caps
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.outbound_scenario_breaking_agents is not None:
            result['OutboundScenarioBreakingAgents'] = self.outbound_scenario_breaking_agents
        if self.outbound_scenario_ready_agents is not None:
            result['OutboundScenarioReadyAgents'] = self.outbound_scenario_ready_agents
        if self.outbound_scenario_talking_agents is not None:
            result['OutboundScenarioTalkingAgents'] = self.outbound_scenario_talking_agents
        if self.outbound_scenario_working_agents is not None:
            result['OutboundScenarioWorkingAgents'] = self.outbound_scenario_working_agents
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.total_agents is not None:
            result['TotalAgents'] = self.total_agents
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('Caps') is not None:
            self.caps = m.get('Caps')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('OutboundScenarioBreakingAgents') is not None:
            self.outbound_scenario_breaking_agents = m.get('OutboundScenarioBreakingAgents')
        if m.get('OutboundScenarioReadyAgents') is not None:
            self.outbound_scenario_ready_agents = m.get('OutboundScenarioReadyAgents')
        if m.get('OutboundScenarioTalkingAgents') is not None:
            self.outbound_scenario_talking_agents = m.get('OutboundScenarioTalkingAgents')
        if m.get('OutboundScenarioWorkingAgents') is not None:
            self.outbound_scenario_working_agents = m.get('OutboundScenarioWorkingAgents')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('TotalAgents') is not None:
            self.total_agents = m.get('TotalAgents')
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        return self


class GetRealtimeCampaignStatsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetRealtimeCampaignStatsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRealtimeCampaignStatsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRealtimeCampaignStatsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRealtimeCampaignStatsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRealtimeCampaignStatsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRealtimeCampaignStatsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRealtimeCampaignStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeInstanceStatesRequest(TeaModel):
    def __init__(self, instance_id=None, media_type=None):
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        return self


class GetRealtimeInstanceStatesResponseBodyDataBreakCodeDetailList(TeaModel):
    def __init__(self, break_code=None, count=None):
        self.break_code = break_code  # type: str
        self.count = count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBodyDataBreakCodeDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetRealtimeInstanceStatesResponseBodyData(TeaModel):
    def __init__(self, break_code_detail_list=None, breaking_agents=None, instance_id=None, interactive_calls=None,
                 logged_in_agents=None, longest_waiting_time=None, ready_agents=None, talking_agents=None, total_agents=None,
                 waiting_calls=None, working_agents=None):
        self.break_code_detail_list = break_code_detail_list  # type: list[GetRealtimeInstanceStatesResponseBodyDataBreakCodeDetailList]
        self.breaking_agents = breaking_agents  # type: long
        self.instance_id = instance_id  # type: str
        self.interactive_calls = interactive_calls  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.longest_waiting_time = longest_waiting_time  # type: long
        self.ready_agents = ready_agents  # type: long
        self.talking_agents = talking_agents  # type: long
        self.total_agents = total_agents  # type: long
        self.waiting_calls = waiting_calls  # type: long
        self.working_agents = working_agents  # type: long

    def validate(self):
        if self.break_code_detail_list:
            for k in self.break_code_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BreakCodeDetailList'] = []
        if self.break_code_detail_list is not None:
            for k in self.break_code_detail_list:
                result['BreakCodeDetailList'].append(k.to_map() if k else None)
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interactive_calls is not None:
            result['InteractiveCalls'] = self.interactive_calls
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.longest_waiting_time is not None:
            result['LongestWaitingTime'] = self.longest_waiting_time
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.total_agents is not None:
            result['TotalAgents'] = self.total_agents
        if self.waiting_calls is not None:
            result['WaitingCalls'] = self.waiting_calls
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.break_code_detail_list = []
        if m.get('BreakCodeDetailList') is not None:
            for k in m.get('BreakCodeDetailList'):
                temp_model = GetRealtimeInstanceStatesResponseBodyDataBreakCodeDetailList()
                self.break_code_detail_list.append(temp_model.from_map(k))
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InteractiveCalls') is not None:
            self.interactive_calls = m.get('InteractiveCalls')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('LongestWaitingTime') is not None:
            self.longest_waiting_time = m.get('LongestWaitingTime')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('TotalAgents') is not None:
            self.total_agents = m.get('TotalAgents')
        if m.get('WaitingCalls') is not None:
            self.waiting_calls = m.get('WaitingCalls')
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        return self


class GetRealtimeInstanceStatesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetRealtimeInstanceStatesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRealtimeInstanceStatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRealtimeInstanceStatesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRealtimeInstanceStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRealtimeInstanceStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupRequest(TeaModel):
    def __init__(self, instance_id=None, skill_group_id=None):
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetSkillGroupResponseBodyData(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, media_type=None, name=None,
                 skill_group_id=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnCredentialsRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetTurnCredentialsResponseBodyData(TeaModel):
    def __init__(self, password=None, user_name=None):
        self.password = password  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class GetTurnCredentialsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetTurnCredentialsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetTurnCredentialsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTurnCredentialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTurnCredentialsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnCredentialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTurnCredentialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTurnServerListRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetTurnServerListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTurnServerListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTurnServerListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTurnServerListResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTurnServerListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTurnServerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUploadAudioDataParamsRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUploadAudioDataParamsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetUploadAudioDataParamsResponseBodyData(TeaModel):
    def __init__(self, params_str=None):
        self.params_str = params_str  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUploadAudioDataParamsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params_str is not None:
            result['ParamsStr'] = self.params_str
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamsStr') is not None:
            self.params_str = m.get('ParamsStr')
        return self


class GetUploadAudioDataParamsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetUploadAudioDataParamsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetUploadAudioDataParamsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetUploadAudioDataParamsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUploadAudioDataParamsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetUploadAudioDataParamsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUploadAudioDataParamsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUploadAudioDataParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserRequest(TeaModel):
    def __init__(self, extension=None, instance_id=None, user_id=None):
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetUserResponseBodyData(TeaModel):
    def __init__(self, avatar_url=None, device_ext=None, device_id=None, device_state=None, display_id=None,
                 display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None, nickname=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.avatar_url = avatar_url  # type: str
        self.device_ext = device_ext  # type: str
        self.device_id = device_id  # type: str
        self.device_state = device_state  # type: str
        self.display_id = display_id  # type: str
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.nickname = nickname  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.device_ext is not None:
            result['DeviceExt'] = self.device_ext
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('DeviceExt') is not None:
            self.device_ext = m.get('DeviceExt')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class GetUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetUserResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVideoRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetVideoResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVideoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetVideoResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetVideoResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetVideoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetVideoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetVideoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVideoResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVideoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVideoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVoicemailRecordingRequest(TeaModel):
    def __init__(self, contact_id=None, instance_id=None):
        self.contact_id = contact_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVoicemailRecordingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetVoicemailRecordingResponseBodyData(TeaModel):
    def __init__(self, file_name=None, file_url=None):
        self.file_name = file_name  # type: str
        self.file_url = file_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetVoicemailRecordingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        return self


class GetVoicemailRecordingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: GetVoicemailRecordingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetVoicemailRecordingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetVoicemailRecordingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetVoicemailRecordingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetVoicemailRecordingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetVoicemailRecordingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetVoicemailRecordingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HoldCallRequest(TeaModel):
    def __init__(self, channel_id=None, device_id=None, instance_id=None, job_id=None, music=None, user_id=None):
        self.channel_id = channel_id  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.music = music  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.music is not None:
            result['Music'] = self.music
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Music') is not None:
            self.music = m.get('Music')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class HoldCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_id=None, channel_state=None, destination=None, job_id=None,
                 originator=None, release_initiator=None, release_reason=None, skill_group_id=None, timestamp=None,
                 user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class HoldCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[HoldCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = HoldCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HoldCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class HoldCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: HoldCallResponseBodyDataCallContext
        self.user_context = user_context  # type: HoldCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(HoldCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = HoldCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = HoldCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class HoldCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: HoldCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(HoldCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = HoldCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HoldCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HoldCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HoldCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HoldCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportAdminsRequest(TeaModel):
    def __init__(self, instance_id=None, ram_id_list=None):
        self.instance_id = instance_id  # type: str
        self.ram_id_list = ram_id_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportAdminsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id_list is not None:
            result['RamIdList'] = self.ram_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamIdList') is not None:
            self.ram_id_list = m.get('RamIdList')
        return self


class ImportAdminsResponseBodyData(TeaModel):
    def __init__(self, extension=None, instance_id=None, ram_id=None, role_id=None, user_id=None):
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.ram_id = ram_id  # type: str
        self.role_id = role_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportAdminsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_id is not None:
            result['RamId'] = self.ram_id
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RamId') is not None:
            self.ram_id = m.get('RamId')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ImportAdminsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ImportAdminsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImportAdminsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ImportAdminsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportAdminsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImportAdminsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportAdminsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportAdminsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportCustomCallTaggingRequest(TeaModel):
    def __init__(self, file_path=None, instance_id=None):
        self.file_path = file_path  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportCustomCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ImportCustomCallTaggingResponseBodyData(TeaModel):
    def __init__(self, item=None, reason=None):
        self.item = item  # type: str
        self.reason = reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportCustomCallTaggingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item is not None:
            result['Item'] = self.item
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class ImportCustomCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ImportCustomCallTaggingResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ImportCustomCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ImportCustomCallTaggingResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportCustomCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImportCustomCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportCustomCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportCustomCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDoNotCallNumbersRequest(TeaModel):
    def __init__(self, file_path=None, instance_id=None, number_list=None, remark=None):
        self.file_path = file_path  # type: str
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str
        self.remark = remark  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDoNotCallNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class ImportDoNotCallNumbersResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportDoNotCallNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportDoNotCallNumbersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImportDoNotCallNumbersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportDoNotCallNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportDoNotCallNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitiateAttendedTransferRequest(TeaModel):
    def __init__(self, call_priority=None, device_id=None, instance_id=None, job_id=None,
                 queuing_overflow_threshold=None, queuing_timeout_seconds=None, routing_type=None, strategy_name=None, strategy_params=None,
                 tags=None, timeout_seconds=None, transferee=None, transferee_type=None, transferor=None, user_id=None):
        self.call_priority = call_priority  # type: int
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.queuing_overflow_threshold = queuing_overflow_threshold  # type: long
        self.queuing_timeout_seconds = queuing_timeout_seconds  # type: long
        self.routing_type = routing_type  # type: str
        self.strategy_name = strategy_name  # type: str
        self.strategy_params = strategy_params  # type: str
        self.tags = tags  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.transferee = transferee  # type: str
        self.transferee_type = transferee_type  # type: str
        self.transferor = transferor  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_priority is not None:
            result['CallPriority'] = self.call_priority
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.queuing_overflow_threshold is not None:
            result['QueuingOverflowThreshold'] = self.queuing_overflow_threshold
        if self.queuing_timeout_seconds is not None:
            result['QueuingTimeoutSeconds'] = self.queuing_timeout_seconds
        if self.routing_type is not None:
            result['RoutingType'] = self.routing_type
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        if self.strategy_params is not None:
            result['StrategyParams'] = self.strategy_params
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.transferee is not None:
            result['Transferee'] = self.transferee
        if self.transferee_type is not None:
            result['TransfereeType'] = self.transferee_type
        if self.transferor is not None:
            result['Transferor'] = self.transferor
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallPriority') is not None:
            self.call_priority = m.get('CallPriority')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('QueuingOverflowThreshold') is not None:
            self.queuing_overflow_threshold = m.get('QueuingOverflowThreshold')
        if m.get('QueuingTimeoutSeconds') is not None:
            self.queuing_timeout_seconds = m.get('QueuingTimeoutSeconds')
        if m.get('RoutingType') is not None:
            self.routing_type = m.get('RoutingType')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        if m.get('StrategyParams') is not None:
            self.strategy_params = m.get('StrategyParams')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('Transferee') is not None:
            self.transferee = m.get('Transferee')
        if m.get('TransfereeType') is not None:
            self.transferee_type = m.get('TransfereeType')
        if m.get('Transferor') is not None:
            self.transferor = m.get('Transferor')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InitiateAttendedTransferResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InitiateAttendedTransferResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[InitiateAttendedTransferResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InitiateAttendedTransferResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class InitiateAttendedTransferResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class InitiateAttendedTransferResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: InitiateAttendedTransferResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: InitiateAttendedTransferResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = InitiateAttendedTransferResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InitiateAttendedTransferResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: InitiateAttendedTransferResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InitiateAttendedTransferResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InitiateAttendedTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InitiateAttendedTransferResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InitiateAttendedTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InitiateAttendedTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InterceptCallRequest(TeaModel):
    def __init__(self, device_id=None, instance_id=None, intercepted_user_id=None, job_id=None,
                 timeout_seconds=None, user_id=None):
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.intercepted_user_id = intercepted_user_id  # type: str
        self.job_id = job_id  # type: str
        self.timeout_seconds = timeout_seconds  # type: int
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intercepted_user_id is not None:
            result['InterceptedUserId'] = self.intercepted_user_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InterceptedUserId') is not None:
            self.intercepted_user_id = m.get('InterceptedUserId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InterceptCallResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InterceptCallResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[InterceptCallResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = InterceptCallResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class InterceptCallResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InterceptCallResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class InterceptCallResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: InterceptCallResponseBodyDataCallContext
        self.user_context = user_context  # type: InterceptCallResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = InterceptCallResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = InterceptCallResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class InterceptCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: InterceptCallResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InterceptCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InterceptCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InterceptCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InterceptCallResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InterceptCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InterceptCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchAuthenticationRequest(TeaModel):
    def __init__(self, contact_flow_id=None, contact_flow_variables=None, device_id=None, instance_id=None,
                 job_id=None, user_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.contact_flow_variables = contact_flow_variables  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.contact_flow_variables is not None:
            result['ContactFlowVariables'] = self.contact_flow_variables
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('ContactFlowVariables') is not None:
            self.contact_flow_variables = m.get('ContactFlowVariables')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchAuthenticationResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchAuthenticationResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchAuthenticationResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchAuthenticationResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class LaunchAuthenticationResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class LaunchAuthenticationResponseBodyData(TeaModel):
    def __init__(self, call_context=None, user_context=None):
        self.call_context = call_context  # type: LaunchAuthenticationResponseBodyDataCallContext
        self.user_context = user_context  # type: LaunchAuthenticationResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('UserContext') is not None:
            temp_model = LaunchAuthenticationResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchAuthenticationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: LaunchAuthenticationResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = LaunchAuthenticationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LaunchAuthenticationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: LaunchAuthenticationResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchAuthenticationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = LaunchAuthenticationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LaunchSurveyRequest(TeaModel):
    def __init__(self, contact_flow_id=None, contact_flow_variables=None, device_id=None, instance_id=None,
                 job_id=None, sms_metadata_id=None, survey_channel=None, user_id=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.contact_flow_variables = contact_flow_variables  # type: str
        self.device_id = device_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.sms_metadata_id = sms_metadata_id  # type: str
        self.survey_channel = survey_channel  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.contact_flow_variables is not None:
            result['ContactFlowVariables'] = self.contact_flow_variables
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.sms_metadata_id is not None:
            result['SmsMetadataId'] = self.sms_metadata_id
        if self.survey_channel is not None:
            result['SurveyChannel'] = self.survey_channel
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('ContactFlowVariables') is not None:
            self.contact_flow_variables = m.get('ContactFlowVariables')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SmsMetadataId') is not None:
            self.sms_metadata_id = m.get('SmsMetadataId')
        if m.get('SurveyChannel') is not None:
            self.survey_channel = m.get('SurveyChannel')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchSurveyResponseBodyDataCallContextChannelContexts(TeaModel):
    def __init__(self, call_type=None, channel_flags=None, channel_id=None, channel_state=None, destination=None,
                 index=None, job_id=None, originator=None, release_initiator=None, release_reason=None,
                 skill_group_id=None, timestamp=None, user_extension=None, user_id=None):
        self.call_type = call_type  # type: str
        self.channel_flags = channel_flags  # type: str
        self.channel_id = channel_id  # type: str
        self.channel_state = channel_state  # type: str
        self.destination = destination  # type: str
        self.index = index  # type: int
        self.job_id = job_id  # type: str
        self.originator = originator  # type: str
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.timestamp = timestamp  # type: long
        self.user_extension = user_extension  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContextChannelContexts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.channel_flags is not None:
            result['ChannelFlags'] = self.channel_flags
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_state is not None:
            result['ChannelState'] = self.channel_state
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.index is not None:
            result['Index'] = self.index
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.originator is not None:
            result['Originator'] = self.originator
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_extension is not None:
            result['UserExtension'] = self.user_extension
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('ChannelFlags') is not None:
            self.channel_flags = m.get('ChannelFlags')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelState') is not None:
            self.channel_state = m.get('ChannelState')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Originator') is not None:
            self.originator = m.get('Originator')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserExtension') is not None:
            self.user_extension = m.get('UserExtension')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LaunchSurveyResponseBodyDataCallContext(TeaModel):
    def __init__(self, call_type=None, channel_contexts=None, instance_id=None, job_id=None):
        self.call_type = call_type  # type: str
        self.channel_contexts = channel_contexts  # type: list[LaunchSurveyResponseBodyDataCallContextChannelContexts]
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        if self.channel_contexts:
            for k in self.channel_contexts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataCallContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_type is not None:
            result['CallType'] = self.call_type
        result['ChannelContexts'] = []
        if self.channel_contexts is not None:
            for k in self.channel_contexts:
                result['ChannelContexts'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        self.channel_contexts = []
        if m.get('ChannelContexts') is not None:
            for k in m.get('ChannelContexts'):
                temp_model = LaunchSurveyResponseBodyDataCallContextChannelContexts()
                self.channel_contexts.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class LaunchSurveyResponseBodyDataUserContext(TeaModel):
    def __init__(self, break_code=None, device_id=None, extension=None, heartbeat=None, instance_id=None,
                 job_id=None, mobile=None, outbound_scenario=None, reserved=None, signed_skill_group_id_list=None,
                 user_id=None, user_state=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.device_id = device_id  # type: str
        self.extension = extension  # type: str
        self.heartbeat = heartbeat  # type: long
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str
        self.mobile = mobile  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.reserved = reserved  # type: long
        self.signed_skill_group_id_list = signed_skill_group_id_list  # type: list[str]
        self.user_id = user_id  # type: str
        self.user_state = user_state  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyDataUserContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.heartbeat is not None:
            result['Heartbeat'] = self.heartbeat
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.reserved is not None:
            result['Reserved'] = self.reserved
        if self.signed_skill_group_id_list is not None:
            result['SignedSkillGroupIdList'] = self.signed_skill_group_id_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_state is not None:
            result['UserState'] = self.user_state
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Heartbeat') is not None:
            self.heartbeat = m.get('Heartbeat')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('Reserved') is not None:
            self.reserved = m.get('Reserved')
        if m.get('SignedSkillGroupIdList') is not None:
            self.signed_skill_group_id_list = m.get('SignedSkillGroupIdList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserState') is not None:
            self.user_state = m.get('UserState')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class LaunchSurveyResponseBodyData(TeaModel):
    def __init__(self, call_context=None, context_id=None, user_context=None):
        self.call_context = call_context  # type: LaunchSurveyResponseBodyDataCallContext
        self.context_id = context_id  # type: long
        self.user_context = user_context  # type: LaunchSurveyResponseBodyDataUserContext

    def validate(self):
        if self.call_context:
            self.call_context.validate()
        if self.user_context:
            self.user_context.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_context is not None:
            result['CallContext'] = self.call_context.to_map()
        if self.context_id is not None:
            result['ContextId'] = self.context_id
        if self.user_context is not None:
            result['UserContext'] = self.user_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataCallContext()
            self.call_context = temp_model.from_map(m['CallContext'])
        if m.get('ContextId') is not None:
            self.context_id = m.get('ContextId')
        if m.get('UserContext') is not None:
            temp_model = LaunchSurveyResponseBodyDataUserContext()
            self.user_context = temp_model.from_map(m['UserContext'])
        return self


class LaunchSurveyResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: LaunchSurveyResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = LaunchSurveyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LaunchSurveyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: LaunchSurveyResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(LaunchSurveyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = LaunchSurveyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStateLogsRequest(TeaModel):
    def __init__(self, agent_id=None, end_time=None, instance_id=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListAgentStateLogsResponseBodyData(TeaModel):
    def __init__(self, break_code=None, duration=None, outbound_scenario=None, start_time=None, state=None,
                 state_code=None, work_mode=None):
        self.break_code = break_code  # type: str
        self.duration = duration  # type: long
        self.outbound_scenario = outbound_scenario  # type: bool
        self.start_time = start_time  # type: long
        self.state = state  # type: str
        self.state_code = state_code  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.state_code is not None:
            result['StateCode'] = self.state_code
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StateCode') is not None:
            self.state_code = m.get('StateCode')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListAgentStateLogsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListAgentStateLogsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAgentStateLogsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAgentStateLogsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAgentStateLogsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentStateLogsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAgentStateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentStatesRequest(TeaModel):
    def __init__(self, agent_ids=None, exclude_offline_users=None, instance_id=None, page_number=None,
                 page_size=None, skill_group_id=None, state=None):
        self.agent_ids = agent_ids  # type: str
        self.exclude_offline_users = exclude_offline_users  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.exclude_offline_users is not None:
            result['ExcludeOfflineUsers'] = self.exclude_offline_users
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('ExcludeOfflineUsers') is not None:
            self.exclude_offline_users = m.get('ExcludeOfflineUsers')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAgentStatesResponseBodyDataList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, break_code=None, dn=None, instance_id=None, login_name=None,
                 outbound_scenario=None, state=None, state_duration=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.break_code = break_code  # type: str
        self.dn = dn  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.outbound_scenario = outbound_scenario  # type: bool
        self.state = state  # type: str
        self.state_duration = state_duration  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentStatesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.dn is not None:
            result['Dn'] = self.dn
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.outbound_scenario is not None:
            result['OutboundScenario'] = self.outbound_scenario
        if self.state is not None:
            result['State'] = self.state
        if self.state_duration is not None:
            result['StateDuration'] = self.state_duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Dn') is not None:
            self.dn = m.get('Dn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('OutboundScenario') is not None:
            self.outbound_scenario = m.get('OutboundScenario')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StateDuration') is not None:
            self.state_duration = m.get('StateDuration')
        return self


class ListAgentStatesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAgentStatesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentStatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAgentStatesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentStatesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListAgentStatesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAgentStatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListAgentStatesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentStatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAgentStatesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentStatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAgentStatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentSummaryReportsSinceMidnightRequest(TeaModel):
    def __init__(self, agent_ids=None, instance_id=None, page_number=None, page_size=None, skill_group_id=None):
        self.agent_ids = agent_ids  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListInbound(TeaModel):
    def __init__(self, average_ring_time=None, average_talk_time=None, average_work_time=None, calls_handled=None,
                 calls_offered=None, handle_rate=None, max_ring_time=None, max_talk_time=None, max_work_time=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_20=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.average_ring_time = average_ring_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_offered = calls_offered  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_20 = service_level_20  # type: float
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_talk_time=None, average_work_time=None,
                 calls_answered=None, calls_dialed=None, max_dialing_time=None, max_talk_time=None, max_work_time=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_dialing_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.calls_answered = calls_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: str
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOverall(TeaModel):
    def __init__(self, average_ready_time=None, average_talk_time=None, average_work_time=None,
                 max_ready_time=None, max_talk_time=None, max_work_time=None, occupancy_rate=None, one_transfer_calls=None,
                 satisfaction_index=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 total_break_time=None, total_calls=None, total_logged_in_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_ready_time = average_ready_time  # type: long
        self.average_talk_time = average_talk_time  # type: long
        self.average_work_time = average_work_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.one_transfer_calls = one_transfer_calls  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.one_transfer_calls is not None:
            result['OneTransferCalls'] = self.one_transfer_calls
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('OneTransferCalls') is not None:
            self.one_transfer_calls = m.get('OneTransferCalls')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, inbound=None, instance_id=None, login_name=None,
                 outbound=None, overall=None, skill_group_ids=None, skill_group_names=None, timestamp=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.inbound = inbound  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListInbound
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.outbound = outbound  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOutbound
        self.overall = overall  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOverall
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('Inbound') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Outbound') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReportList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAgentSummaryReportsSinceMidnightResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, paged_agent_summary_report=None,
                 request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.paged_agent_summary_report = paged_agent_summary_report  # type: ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.paged_agent_summary_report:
            self.paged_agent_summary_report.validate()

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.paged_agent_summary_report is not None:
            result['PagedAgentSummaryReport'] = self.paged_agent_summary_report.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PagedAgentSummaryReport') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBodyPagedAgentSummaryReport()
            self.paged_agent_summary_report = temp_model.from_map(m['PagedAgentSummaryReport'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentSummaryReportsSinceMidnightResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAgentSummaryReportsSinceMidnightResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentSummaryReportsSinceMidnightResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAgentSummaryReportsSinceMidnightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAttemptsRequest(TeaModel):
    def __init__(self, agent_id=None, attempt_id=None, callee=None, caller=None, campaign_id=None, case_id=None,
                 contact_id=None, criteria=None, end_time=None, instance_id=None, page_number=None, page_size=None,
                 queue_id=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.attempt_id = attempt_id  # type: str
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.campaign_id = campaign_id  # type: str
        self.case_id = case_id  # type: str
        self.contact_id = contact_id  # type: str
        self.criteria = criteria  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.queue_id = queue_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAttemptsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.attempt_id is not None:
            result['AttemptId'] = self.attempt_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AttemptId') is not None:
            self.attempt_id = m.get('AttemptId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListAttemptsResponseBodyDataList(TeaModel):
    def __init__(self, agent_established_time=None, agent_id=None, agent_ring_duration=None,
                 assign_agent_time=None, attempt_id=None, callee=None, caller=None, campaign_id=None, case_id=None, contact_id=None,
                 customer_established_time=None, customer_released_time=None, dial_duration=None, dial_time=None, enqueue_time=None,
                 enter_ivr_time=None, instance_id=None, ivr_duration=None, queue_duration=None, queue_id=None):
        self.agent_established_time = agent_established_time  # type: long
        self.agent_id = agent_id  # type: str
        self.agent_ring_duration = agent_ring_duration  # type: long
        self.assign_agent_time = assign_agent_time  # type: long
        self.attempt_id = attempt_id  # type: str
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.campaign_id = campaign_id  # type: str
        self.case_id = case_id  # type: str
        self.contact_id = contact_id  # type: str
        self.customer_established_time = customer_established_time  # type: long
        self.customer_released_time = customer_released_time  # type: long
        self.dial_duration = dial_duration  # type: long
        self.dial_time = dial_time  # type: long
        self.enqueue_time = enqueue_time  # type: long
        self.enter_ivr_time = enter_ivr_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_duration = ivr_duration  # type: long
        self.queue_duration = queue_duration  # type: long
        self.queue_id = queue_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAttemptsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_established_time is not None:
            result['AgentEstablishedTime'] = self.agent_established_time
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_ring_duration is not None:
            result['AgentRingDuration'] = self.agent_ring_duration
        if self.assign_agent_time is not None:
            result['AssignAgentTime'] = self.assign_agent_time
        if self.attempt_id is not None:
            result['AttemptId'] = self.attempt_id
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.customer_established_time is not None:
            result['CustomerEstablishedTime'] = self.customer_established_time
        if self.customer_released_time is not None:
            result['CustomerReleasedTime'] = self.customer_released_time
        if self.dial_duration is not None:
            result['DialDuration'] = self.dial_duration
        if self.dial_time is not None:
            result['DialTime'] = self.dial_time
        if self.enqueue_time is not None:
            result['EnqueueTime'] = self.enqueue_time
        if self.enter_ivr_time is not None:
            result['EnterIvrTime'] = self.enter_ivr_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ivr_duration is not None:
            result['IvrDuration'] = self.ivr_duration
        if self.queue_duration is not None:
            result['QueueDuration'] = self.queue_duration
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentEstablishedTime') is not None:
            self.agent_established_time = m.get('AgentEstablishedTime')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentRingDuration') is not None:
            self.agent_ring_duration = m.get('AgentRingDuration')
        if m.get('AssignAgentTime') is not None:
            self.assign_agent_time = m.get('AssignAgentTime')
        if m.get('AttemptId') is not None:
            self.attempt_id = m.get('AttemptId')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('CustomerEstablishedTime') is not None:
            self.customer_established_time = m.get('CustomerEstablishedTime')
        if m.get('CustomerReleasedTime') is not None:
            self.customer_released_time = m.get('CustomerReleasedTime')
        if m.get('DialDuration') is not None:
            self.dial_duration = m.get('DialDuration')
        if m.get('DialTime') is not None:
            self.dial_time = m.get('DialTime')
        if m.get('EnqueueTime') is not None:
            self.enqueue_time = m.get('EnqueueTime')
        if m.get('EnterIvrTime') is not None:
            self.enter_ivr_time = m.get('EnterIvrTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IvrDuration') is not None:
            self.ivr_duration = m.get('IvrDuration')
        if m.get('QueueDuration') is not None:
            self.queue_duration = m.get('QueueDuration')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        return self


class ListAttemptsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAttemptsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAttemptsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAttemptsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAttemptsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListAttemptsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAttemptsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListAttemptsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAttemptsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAttemptsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAttemptsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAttemptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAudioFilesRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, status=None, usage=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAudioFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListAudioFilesResponseBodyDataList(TeaModel):
    def __init__(self, audio_file_name=None, audio_resource_id=None, audit_result=None, created_time=None,
                 instance_id=None, name=None, oss_file_key=None, status=None, updated_time=None, usage=None):
        self.audio_file_name = audio_file_name  # type: str
        self.audio_resource_id = audio_resource_id  # type: str
        self.audit_result = audit_result  # type: str
        self.created_time = created_time  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.oss_file_key = oss_file_key  # type: str
        self.status = status  # type: str
        self.updated_time = updated_time  # type: str
        self.usage = usage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAudioFilesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_file_name is not None:
            result['AudioFileName'] = self.audio_file_name
        if self.audio_resource_id is not None:
            result['AudioResourceId'] = self.audio_resource_id
        if self.audit_result is not None:
            result['AuditResult'] = self.audit_result
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_file_key is not None:
            result['OssFileKey'] = self.oss_file_key
        if self.status is not None:
            result['Status'] = self.status
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFileName') is not None:
            self.audio_file_name = m.get('AudioFileName')
        if m.get('AudioResourceId') is not None:
            self.audio_resource_id = m.get('AudioResourceId')
        if m.get('AuditResult') is not None:
            self.audit_result = m.get('AuditResult')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssFileKey') is not None:
            self.oss_file_key = m.get('OssFileKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListAudioFilesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListAudioFilesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAudioFilesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListAudioFilesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAudioFilesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListAudioFilesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAudioFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListAudioFilesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAudioFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAudioFilesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAudioFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAudioFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBlacklistCallTaggingsRequest(TeaModel):
    def __init__(self, instance_id=None, number_list=None):
        self.instance_id = instance_id  # type: str
        self.number_list = number_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBlacklistCallTaggingsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        return self


class ListBlacklistCallTaggingsResponseBodyData(TeaModel):
    def __init__(self, blacklisted=None, job_id=None, number=None):
        self.blacklisted = blacklisted  # type: bool
        self.job_id = job_id  # type: str
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBlacklistCallTaggingsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.blacklisted is not None:
            result['Blacklisted'] = self.blacklisted
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Blacklisted') is not None:
            self.blacklisted = m.get('Blacklisted')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class ListBlacklistCallTaggingsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListBlacklistCallTaggingsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBlacklistCallTaggingsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListBlacklistCallTaggingsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListBlacklistCallTaggingsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListBlacklistCallTaggingsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBlacklistCallTaggingsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListBlacklistCallTaggingsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBriefSkillGroupsRequest(TeaModel):
    def __init__(self, instance_id=None, media_type=None, page_number=None, page_size=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListBriefSkillGroupsResponseBodyDataList(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, media_type=None,
                 phone_number_count=None, skill_group_id=None, skill_group_name=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class ListBriefSkillGroupsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListBriefSkillGroupsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListBriefSkillGroupsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListBriefSkillGroupsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListBriefSkillGroupsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListBriefSkillGroupsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListBriefSkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListBriefSkillGroupsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListBriefSkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListBriefSkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallDetailRecordsRequest(TeaModel):
    def __init__(self, agent_id=None, called_number=None, calling_number=None, contact_disposition=None,
                 contact_disposition_list=None, contact_id=None, contact_type=None, contact_type_list=None, criteria=None,
                 early_media_state_list=None, end_time=None, instance_id=None, order_by_field=None, page_number=None, page_size=None,
                 satisfaction_description_list=None, satisfaction_list=None, satisfaction_survey_channel=None, skill_group_id=None,
                 sort_order=None, start_time=None):
        self.agent_id = agent_id  # type: str
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_disposition_list = contact_disposition_list  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.contact_type_list = contact_type_list  # type: str
        self.criteria = criteria  # type: str
        self.early_media_state_list = early_media_state_list  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.order_by_field = order_by_field  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.satisfaction_description_list = satisfaction_description_list  # type: str
        self.satisfaction_list = satisfaction_list  # type: str
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.skill_group_id = skill_group_id  # type: str
        self.sort_order = sort_order  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_disposition_list is not None:
            result['ContactDispositionList'] = self.contact_disposition_list
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.contact_type_list is not None:
            result['ContactTypeList'] = self.contact_type_list
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.early_media_state_list is not None:
            result['EarlyMediaStateList'] = self.early_media_state_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_by_field is not None:
            result['OrderByField'] = self.order_by_field
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.satisfaction_description_list is not None:
            result['SatisfactionDescriptionList'] = self.satisfaction_description_list
        if self.satisfaction_list is not None:
            result['SatisfactionList'] = self.satisfaction_list
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactDispositionList') is not None:
            self.contact_disposition_list = m.get('ContactDispositionList')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('ContactTypeList') is not None:
            self.contact_type_list = m.get('ContactTypeList')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('EarlyMediaStateList') is not None:
            self.early_media_state_list = m.get('EarlyMediaStateList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderByField') is not None:
            self.order_by_field = m.get('OrderByField')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SatisfactionDescriptionList') is not None:
            self.satisfaction_description_list = m.get('SatisfactionDescriptionList')
        if m.get('SatisfactionList') is not None:
            self.satisfaction_list = m.get('SatisfactionList')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListCallDetailRecordsResponseBodyDataList(TeaModel):
    def __init__(self, additional_broker=None, agent_ids=None, agent_names=None, broker=None, call_duration=None,
                 called_number=None, callee_location=None, caller_location=None, calling_number=None, contact_disposition=None,
                 contact_id=None, contact_type=None, dialing_time=None, early_media_state=None, established_time=None,
                 held_time=None, instance_id=None, ivr_time=None, queue_time=None, recording_duration=None,
                 recording_ready=None, release_initiator=None, release_reason=None, release_time=None, ring_time=None,
                 satisfaction_description=None, satisfaction_index=None, satisfaction_survey_channel=None,
                 satisfaction_survey_offered=None, skill_group_ids=None, skill_group_names=None, start_time=None, talk_time=None,
                 wait_time=None):
        self.additional_broker = additional_broker  # type: str
        self.agent_ids = agent_ids  # type: str
        self.agent_names = agent_names  # type: str
        self.broker = broker  # type: str
        self.call_duration = call_duration  # type: str
        self.called_number = called_number  # type: str
        self.callee_location = callee_location  # type: str
        self.caller_location = caller_location  # type: str
        self.calling_number = calling_number  # type: str
        self.contact_disposition = contact_disposition  # type: str
        self.contact_id = contact_id  # type: str
        self.contact_type = contact_type  # type: str
        self.dialing_time = dialing_time  # type: long
        self.early_media_state = early_media_state  # type: str
        self.established_time = established_time  # type: long
        self.held_time = held_time  # type: long
        self.instance_id = instance_id  # type: str
        self.ivr_time = ivr_time  # type: long
        self.queue_time = queue_time  # type: long
        self.recording_duration = recording_duration  # type: long
        self.recording_ready = recording_ready  # type: bool
        self.release_initiator = release_initiator  # type: str
        self.release_reason = release_reason  # type: str
        self.release_time = release_time  # type: long
        self.ring_time = ring_time  # type: long
        self.satisfaction_description = satisfaction_description  # type: str
        self.satisfaction_index = satisfaction_index  # type: int
        self.satisfaction_survey_channel = satisfaction_survey_channel  # type: str
        self.satisfaction_survey_offered = satisfaction_survey_offered  # type: bool
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str
        self.start_time = start_time  # type: long
        self.talk_time = talk_time  # type: long
        self.wait_time = wait_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_broker is not None:
            result['AdditionalBroker'] = self.additional_broker
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.agent_names is not None:
            result['AgentNames'] = self.agent_names
        if self.broker is not None:
            result['Broker'] = self.broker
        if self.call_duration is not None:
            result['CallDuration'] = self.call_duration
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.callee_location is not None:
            result['CalleeLocation'] = self.callee_location
        if self.caller_location is not None:
            result['CallerLocation'] = self.caller_location
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.contact_disposition is not None:
            result['ContactDisposition'] = self.contact_disposition
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_type is not None:
            result['ContactType'] = self.contact_type
        if self.dialing_time is not None:
            result['DialingTime'] = self.dialing_time
        if self.early_media_state is not None:
            result['EarlyMediaState'] = self.early_media_state
        if self.established_time is not None:
            result['EstablishedTime'] = self.established_time
        if self.held_time is not None:
            result['HeldTime'] = self.held_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ivr_time is not None:
            result['IvrTime'] = self.ivr_time
        if self.queue_time is not None:
            result['QueueTime'] = self.queue_time
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.recording_ready is not None:
            result['RecordingReady'] = self.recording_ready
        if self.release_initiator is not None:
            result['ReleaseInitiator'] = self.release_initiator
        if self.release_reason is not None:
            result['ReleaseReason'] = self.release_reason
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.ring_time is not None:
            result['RingTime'] = self.ring_time
        if self.satisfaction_description is not None:
            result['SatisfactionDescription'] = self.satisfaction_description
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_survey_channel is not None:
            result['SatisfactionSurveyChannel'] = self.satisfaction_survey_channel
        if self.satisfaction_survey_offered is not None:
            result['SatisfactionSurveyOffered'] = self.satisfaction_survey_offered
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.talk_time is not None:
            result['TalkTime'] = self.talk_time
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionalBroker') is not None:
            self.additional_broker = m.get('AdditionalBroker')
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('AgentNames') is not None:
            self.agent_names = m.get('AgentNames')
        if m.get('Broker') is not None:
            self.broker = m.get('Broker')
        if m.get('CallDuration') is not None:
            self.call_duration = m.get('CallDuration')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalleeLocation') is not None:
            self.callee_location = m.get('CalleeLocation')
        if m.get('CallerLocation') is not None:
            self.caller_location = m.get('CallerLocation')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('ContactDisposition') is not None:
            self.contact_disposition = m.get('ContactDisposition')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactType') is not None:
            self.contact_type = m.get('ContactType')
        if m.get('DialingTime') is not None:
            self.dialing_time = m.get('DialingTime')
        if m.get('EarlyMediaState') is not None:
            self.early_media_state = m.get('EarlyMediaState')
        if m.get('EstablishedTime') is not None:
            self.established_time = m.get('EstablishedTime')
        if m.get('HeldTime') is not None:
            self.held_time = m.get('HeldTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IvrTime') is not None:
            self.ivr_time = m.get('IvrTime')
        if m.get('QueueTime') is not None:
            self.queue_time = m.get('QueueTime')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('RecordingReady') is not None:
            self.recording_ready = m.get('RecordingReady')
        if m.get('ReleaseInitiator') is not None:
            self.release_initiator = m.get('ReleaseInitiator')
        if m.get('ReleaseReason') is not None:
            self.release_reason = m.get('ReleaseReason')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('RingTime') is not None:
            self.ring_time = m.get('RingTime')
        if m.get('SatisfactionDescription') is not None:
            self.satisfaction_description = m.get('SatisfactionDescription')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionSurveyChannel') is not None:
            self.satisfaction_survey_channel = m.get('SatisfactionSurveyChannel')
        if m.get('SatisfactionSurveyOffered') is not None:
            self.satisfaction_survey_offered = m.get('SatisfactionSurveyOffered')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TalkTime') is not None:
            self.talk_time = m.get('TalkTime')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        return self


class ListCallDetailRecordsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCallDetailRecordsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCallDetailRecordsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCallDetailRecordsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCallDetailRecordsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCallDetailRecordsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCallDetailRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCallDetailRecordsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCallDetailRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCallDetailRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCallTagsRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListCallTagsResponseBodyDataList(TeaModel):
    def __init__(self, instance_id=None, tag_name=None):
        self.instance_id = instance_id  # type: str
        self.tag_name = tag_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCallTagsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class ListCallTagsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCallTagsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCallTagsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCallTagsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCallTagsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCallTagsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCallTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCallTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCallTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCallTagsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCallTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCallTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCampaignTrendingReportRequest(TeaModel):
    def __init__(self, campaign_id=None, end_time=None, instance_id=None, start_time=None):
        self.campaign_id = campaign_id  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignTrendingReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListCampaignTrendingReportResponseBodyData(TeaModel):
    def __init__(self, break_agents=None, breaking_agents=None, concurrency=None, datetime=None,
                 logged_in_agents=None, outbound_scenario_breaking_agents=None, outbound_scenario_ready_agents=None,
                 outbound_scenario_talking_agents=None, outbound_scenario_working_agents=None, ready_agents=None, stats_time=None, talk_agents=None,
                 talking_agents=None, work_agents=None, working_agents=None):
        self.break_agents = break_agents  # type: long
        self.breaking_agents = breaking_agents  # type: long
        self.concurrency = concurrency  # type: long
        self.datetime = datetime  # type: long
        self.logged_in_agents = logged_in_agents  # type: long
        self.outbound_scenario_breaking_agents = outbound_scenario_breaking_agents  # type: long
        self.outbound_scenario_ready_agents = outbound_scenario_ready_agents  # type: long
        self.outbound_scenario_talking_agents = outbound_scenario_talking_agents  # type: long
        self.outbound_scenario_working_agents = outbound_scenario_working_agents  # type: long
        self.ready_agents = ready_agents  # type: long
        self.stats_time = stats_time  # type: long
        self.talk_agents = talk_agents  # type: long
        self.talking_agents = talking_agents  # type: long
        self.work_agents = work_agents  # type: long
        self.working_agents = working_agents  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_agents is not None:
            result['BreakAgents'] = self.break_agents
        if self.breaking_agents is not None:
            result['BreakingAgents'] = self.breaking_agents
        if self.concurrency is not None:
            result['Concurrency'] = self.concurrency
        if self.datetime is not None:
            result['Datetime'] = self.datetime
        if self.logged_in_agents is not None:
            result['LoggedInAgents'] = self.logged_in_agents
        if self.outbound_scenario_breaking_agents is not None:
            result['OutboundScenarioBreakingAgents'] = self.outbound_scenario_breaking_agents
        if self.outbound_scenario_ready_agents is not None:
            result['OutboundScenarioReadyAgents'] = self.outbound_scenario_ready_agents
        if self.outbound_scenario_talking_agents is not None:
            result['OutboundScenarioTalkingAgents'] = self.outbound_scenario_talking_agents
        if self.outbound_scenario_working_agents is not None:
            result['OutboundScenarioWorkingAgents'] = self.outbound_scenario_working_agents
        if self.ready_agents is not None:
            result['ReadyAgents'] = self.ready_agents
        if self.stats_time is not None:
            result['StatsTime'] = self.stats_time
        if self.talk_agents is not None:
            result['TalkAgents'] = self.talk_agents
        if self.talking_agents is not None:
            result['TalkingAgents'] = self.talking_agents
        if self.work_agents is not None:
            result['WorkAgents'] = self.work_agents
        if self.working_agents is not None:
            result['WorkingAgents'] = self.working_agents
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakAgents') is not None:
            self.break_agents = m.get('BreakAgents')
        if m.get('BreakingAgents') is not None:
            self.breaking_agents = m.get('BreakingAgents')
        if m.get('Concurrency') is not None:
            self.concurrency = m.get('Concurrency')
        if m.get('Datetime') is not None:
            self.datetime = m.get('Datetime')
        if m.get('LoggedInAgents') is not None:
            self.logged_in_agents = m.get('LoggedInAgents')
        if m.get('OutboundScenarioBreakingAgents') is not None:
            self.outbound_scenario_breaking_agents = m.get('OutboundScenarioBreakingAgents')
        if m.get('OutboundScenarioReadyAgents') is not None:
            self.outbound_scenario_ready_agents = m.get('OutboundScenarioReadyAgents')
        if m.get('OutboundScenarioTalkingAgents') is not None:
            self.outbound_scenario_talking_agents = m.get('OutboundScenarioTalkingAgents')
        if m.get('OutboundScenarioWorkingAgents') is not None:
            self.outbound_scenario_working_agents = m.get('OutboundScenarioWorkingAgents')
        if m.get('ReadyAgents') is not None:
            self.ready_agents = m.get('ReadyAgents')
        if m.get('StatsTime') is not None:
            self.stats_time = m.get('StatsTime')
        if m.get('TalkAgents') is not None:
            self.talk_agents = m.get('TalkAgents')
        if m.get('TalkingAgents') is not None:
            self.talking_agents = m.get('TalkingAgents')
        if m.get('WorkAgents') is not None:
            self.work_agents = m.get('WorkAgents')
        if m.get('WorkingAgents') is not None:
            self.working_agents = m.get('WorkingAgents')
        return self


class ListCampaignTrendingReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListCampaignTrendingReportResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListCampaignTrendingReportResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCampaignTrendingReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCampaignTrendingReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCampaignTrendingReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCampaignTrendingReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCampaignsRequest(TeaModel):
    def __init__(self, actual_start_time_from=None, actual_start_time_to=None, instance_id=None, name=None,
                 page_number=None, page_size=None, planed_start_time_from=None, planed_start_time_to=None, queue_id=None,
                 state=None):
        self.actual_start_time_from = actual_start_time_from  # type: str
        self.actual_start_time_to = actual_start_time_to  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.planed_start_time_from = planed_start_time_from  # type: str
        self.planed_start_time_to = planed_start_time_to  # type: str
        self.queue_id = queue_id  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_start_time_from is not None:
            result['ActualStartTimeFrom'] = self.actual_start_time_from
        if self.actual_start_time_to is not None:
            result['ActualStartTimeTo'] = self.actual_start_time_to
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.planed_start_time_from is not None:
            result['PlanedStartTimeFrom'] = self.planed_start_time_from
        if self.planed_start_time_to is not None:
            result['PlanedStartTimeTo'] = self.planed_start_time_to
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualStartTimeFrom') is not None:
            self.actual_start_time_from = m.get('ActualStartTimeFrom')
        if m.get('ActualStartTimeTo') is not None:
            self.actual_start_time_to = m.get('ActualStartTimeTo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlanedStartTimeFrom') is not None:
            self.planed_start_time_from = m.get('PlanedStartTimeFrom')
        if m.get('PlanedStartTimeTo') is not None:
            self.planed_start_time_to = m.get('PlanedStartTimeTo')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCampaignsResponseBodyDataList(TeaModel):
    def __init__(self, actual_end_time=None, actual_start_time=None, campaign_id=None, cases_aborted=None,
                 cases_connected=None, cases_uncompleted=None, completion_rate=None, max_attempt_count=None,
                 min_attempt_interval=None, name=None, planed_end_time=None, planed_start_time=None, queue_id=None, queue_name=None,
                 simulation=None, state=None, strategy_parameters=None, strategy_type=None, total_cases=None):
        self.actual_end_time = actual_end_time  # type: long
        self.actual_start_time = actual_start_time  # type: long
        self.campaign_id = campaign_id  # type: str
        self.cases_aborted = cases_aborted  # type: long
        self.cases_connected = cases_connected  # type: long
        self.cases_uncompleted = cases_uncompleted  # type: long
        self.completion_rate = completion_rate  # type: float
        self.max_attempt_count = max_attempt_count  # type: long
        self.min_attempt_interval = min_attempt_interval  # type: long
        self.name = name  # type: str
        self.planed_end_time = planed_end_time  # type: long
        self.planed_start_time = planed_start_time  # type: long
        self.queue_id = queue_id  # type: str
        self.queue_name = queue_name  # type: str
        self.simulation = simulation  # type: bool
        self.state = state  # type: str
        self.strategy_parameters = strategy_parameters  # type: str
        self.strategy_type = strategy_type  # type: str
        self.total_cases = total_cases  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCampaignsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_end_time is not None:
            result['ActualEndTime'] = self.actual_end_time
        if self.actual_start_time is not None:
            result['ActualStartTime'] = self.actual_start_time
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.cases_aborted is not None:
            result['CasesAborted'] = self.cases_aborted
        if self.cases_connected is not None:
            result['CasesConnected'] = self.cases_connected
        if self.cases_uncompleted is not None:
            result['CasesUncompleted'] = self.cases_uncompleted
        if self.completion_rate is not None:
            result['CompletionRate'] = self.completion_rate
        if self.max_attempt_count is not None:
            result['MaxAttemptCount'] = self.max_attempt_count
        if self.min_attempt_interval is not None:
            result['MinAttemptInterval'] = self.min_attempt_interval
        if self.name is not None:
            result['Name'] = self.name
        if self.planed_end_time is not None:
            result['PlanedEndTime'] = self.planed_end_time
        if self.planed_start_time is not None:
            result['PlanedStartTime'] = self.planed_start_time
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.queue_name is not None:
            result['QueueName'] = self.queue_name
        if self.simulation is not None:
            result['Simulation'] = self.simulation
        if self.state is not None:
            result['State'] = self.state
        if self.strategy_parameters is not None:
            result['StrategyParameters'] = self.strategy_parameters
        if self.strategy_type is not None:
            result['StrategyType'] = self.strategy_type
        if self.total_cases is not None:
            result['TotalCases'] = self.total_cases
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualEndTime') is not None:
            self.actual_end_time = m.get('ActualEndTime')
        if m.get('ActualStartTime') is not None:
            self.actual_start_time = m.get('ActualStartTime')
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('CasesAborted') is not None:
            self.cases_aborted = m.get('CasesAborted')
        if m.get('CasesConnected') is not None:
            self.cases_connected = m.get('CasesConnected')
        if m.get('CasesUncompleted') is not None:
            self.cases_uncompleted = m.get('CasesUncompleted')
        if m.get('CompletionRate') is not None:
            self.completion_rate = m.get('CompletionRate')
        if m.get('MaxAttemptCount') is not None:
            self.max_attempt_count = m.get('MaxAttemptCount')
        if m.get('MinAttemptInterval') is not None:
            self.min_attempt_interval = m.get('MinAttemptInterval')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PlanedEndTime') is not None:
            self.planed_end_time = m.get('PlanedEndTime')
        if m.get('PlanedStartTime') is not None:
            self.planed_start_time = m.get('PlanedStartTime')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('QueueName') is not None:
            self.queue_name = m.get('QueueName')
        if m.get('Simulation') is not None:
            self.simulation = m.get('Simulation')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StrategyParameters') is not None:
            self.strategy_parameters = m.get('StrategyParameters')
        if m.get('StrategyType') is not None:
            self.strategy_type = m.get('StrategyType')
        if m.get('TotalCases') is not None:
            self.total_cases = m.get('TotalCases')
        return self


class ListCampaignsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCampaignsResponseBodyDataList]
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCampaignsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCampaignsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCampaignsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListCampaignsResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCampaignsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCampaignsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListCampaignsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCampaignsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCampaignsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCampaignsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCasesRequest(TeaModel):
    def __init__(self, campaign_id=None, instance_id=None, page_number=None, page_size=None, phone_number=None,
                 state=None):
        self.campaign_id = campaign_id  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.phone_number = phone_number  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCasesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campaign_id is not None:
            result['CampaignId'] = self.campaign_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CampaignId') is not None:
            self.campaign_id = m.get('CampaignId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCasesResponseBodyDataList(TeaModel):
    def __init__(self, abandon_phase=None, abandon_type=None, attempt_count=None, case_id=None,
                 custom_variables=None, failure_reason=None, phone_number=None, state=None):
        self.abandon_phase = abandon_phase  # type: str
        self.abandon_type = abandon_type  # type: str
        self.attempt_count = attempt_count  # type: long
        self.case_id = case_id  # type: str
        self.custom_variables = custom_variables  # type: str
        self.failure_reason = failure_reason  # type: str
        self.phone_number = phone_number  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCasesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_phase is not None:
            result['AbandonPhase'] = self.abandon_phase
        if self.abandon_type is not None:
            result['AbandonType'] = self.abandon_type
        if self.attempt_count is not None:
            result['AttemptCount'] = self.attempt_count
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.failure_reason is not None:
            result['FailureReason'] = self.failure_reason
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonPhase') is not None:
            self.abandon_phase = m.get('AbandonPhase')
        if m.get('AbandonType') is not None:
            self.abandon_type = m.get('AbandonType')
        if m.get('AttemptCount') is not None:
            self.attempt_count = m.get('AttemptCount')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('FailureReason') is not None:
            self.failure_reason = m.get('FailureReason')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListCasesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCasesResponseBodyDataList]
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCasesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCasesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCasesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCasesResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCasesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCasesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCasesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCasesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCasesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigItemsRequest(TeaModel):
    def __init__(self, instance_id=None, object_id=None, object_type=None):
        self.instance_id = instance_id  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        return self


class ListConfigItemsResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, name=None, object_id=None, object_type=None, value=None):
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.object_id = object_id  # type: str
        self.object_type = object_type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListConfigItemsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListConfigItemsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListConfigItemsResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListConfigItemsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListConfigItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListConfigItemsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListConfigItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListConfigItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListContactFlowsRequest(TeaModel):
    def __init__(self, instance_id=None, order_by_field=None, page_number=None, page_size=None, sort_order=None,
                 type=None):
        self.instance_id = instance_id  # type: str
        self.order_by_field = order_by_field  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.sort_order = sort_order  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_by_field is not None:
            result['OrderByField'] = self.order_by_field
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderByField') is not None:
            self.order_by_field = m.get('OrderByField')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListContactFlowsResponseBodyDataList(TeaModel):
    def __init__(self, contact_flow_id=None, created_time=None, definition=None, description=None, draft_id=None,
                 editor=None, instance_id=None, name=None, number_list=None, published=None, type=None, updated_time=None):
        self.contact_flow_id = contact_flow_id  # type: str
        self.created_time = created_time  # type: str
        self.definition = definition  # type: str
        self.description = description  # type: str
        self.draft_id = draft_id  # type: str
        self.editor = editor  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[str]
        self.published = published  # type: bool
        self.type = type  # type: str
        self.updated_time = updated_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.description is not None:
            result['Description'] = self.description
        if self.draft_id is not None:
            result['DraftId'] = self.draft_id
        if self.editor is not None:
            result['Editor'] = self.editor
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.number_list is not None:
            result['NumberList'] = self.number_list
        if self.published is not None:
            result['Published'] = self.published
        if self.type is not None:
            result['Type'] = self.type
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DraftId') is not None:
            self.draft_id = m.get('DraftId')
        if m.get('Editor') is not None:
            self.editor = m.get('Editor')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumberList') is not None:
            self.number_list = m.get('NumberList')
        if m.get('Published') is not None:
            self.published = m.get('Published')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        return self


class ListContactFlowsResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListContactFlowsResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListContactFlowsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListContactFlowsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListContactFlowsResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListContactFlowsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListContactFlowsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListContactFlowsResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListContactFlowsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListContactFlowsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomCallTaggingRequest(TeaModel):
    def __init__(self, call_tag_name_list=None, instance_id=None, page_number=None, page_size=None,
                 search_pattern=None):
        self.call_tag_name_list = call_tag_name_list  # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomCallTaggingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_tag_name_list is not None:
            result['CallTagNameList'] = self.call_tag_name_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallTagNameList') is not None:
            self.call_tag_name_list = m.get('CallTagNameList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListCustomCallTaggingResponseBodyDataListCallTagList(TeaModel):
    def __init__(self, instance_id=None, tag_name=None):
        self.instance_id = instance_id  # type: str
        self.tag_name = tag_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomCallTaggingResponseBodyDataListCallTagList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class ListCustomCallTaggingResponseBodyDataList(TeaModel):
    def __init__(self, call_tag_list=None, creator=None, description=None, instance_id=None, number=None,
                 update_time=None):
        self.call_tag_list = call_tag_list  # type: list[ListCustomCallTaggingResponseBodyDataListCallTagList]
        self.creator = creator  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.update_time = update_time  # type: str

    def validate(self):
        if self.call_tag_list:
            for k in self.call_tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomCallTaggingResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CallTagList'] = []
        if self.call_tag_list is not None:
            for k in self.call_tag_list:
                result['CallTagList'].append(k.to_map() if k else None)
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_tag_list = []
        if m.get('CallTagList') is not None:
            for k in m.get('CallTagList'):
                temp_model = ListCustomCallTaggingResponseBodyDataListCallTagList()
                self.call_tag_list.append(temp_model.from_map(k))
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListCustomCallTaggingResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListCustomCallTaggingResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomCallTaggingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListCustomCallTaggingResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCustomCallTaggingResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListCustomCallTaggingResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCustomCallTaggingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListCustomCallTaggingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCustomCallTaggingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomCallTaggingResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomCallTaggingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomCallTaggingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(self, instance_id=None, user_id=None):
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListDevicesResponseBodyData(TeaModel):
    def __init__(self, call_id=None, contact=None, device_id=None, device_type=None, expires=None, extension=None,
                 instance_id=None, user_id=None):
        self.call_id = call_id  # type: str
        self.contact = contact  # type: str
        self.device_id = device_id  # type: str
        self.device_type = device_type  # type: str
        self.expires = expires  # type: long
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDevicesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.expires is not None:
            result['Expires'] = self.expires
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('Expires') is not None:
            self.expires = m.get('Expires')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListDevicesResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDevicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDevicesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDevicesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDoNotCallNumbersRequest(TeaModel):
    def __init__(self, instance_id=None, page_number=None, page_size=None, scope=None, search_pattern=None):
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.scope = scope  # type: str
        self.search_pattern = search_pattern  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDoNotCallNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.search_pattern is not None:
            result['SearchPattern'] = self.search_pattern
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SearchPattern') is not None:
            self.search_pattern = m.get('SearchPattern')
        return self


class ListDoNotCallNumbersResponseBodyDataList(TeaModel):
    def __init__(self, create_time=None, created_time=None, creator=None, number=None, remark=None, scope=None):
        self.create_time = create_time  # type: long
        self.created_time = created_time  # type: long
        self.creator = creator  # type: str
        self.number = number  # type: str
        self.remark = remark  # type: str
        self.scope = scope  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDoNotCallNumbersResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.number is not None:
            result['Number'] = self.number
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class ListDoNotCallNumbersResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListDoNotCallNumbersResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDoNotCallNumbersResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListDoNotCallNumbersResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDoNotCallNumbersResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, params=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListDoNotCallNumbersResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.params = params  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDoNotCallNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListDoNotCallNumbersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDoNotCallNumbersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDoNotCallNumbersResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDoNotCallNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDoNotCallNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalAgentReportRequest(TeaModel):
    def __init__(self, agent_id_list=None, instance_id=None, media_type=None, page_number=None, page_size=None,
                 skill_group_id=None, start_time=None, stop_time=None):
        self.agent_id_list = agent_id_list  # type: str
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.start_time = start_time  # type: long
        self.stop_time = stop_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListBack2Back(TeaModel):
    def __init__(self, agent_handle_rate=None, answer_rate=None, average_customer_ring_time=None,
                 average_ring_time=None, average_talk_time=None, calls_agent_handled=None, calls_answered=None,
                 calls_customer_answered=None, calls_dialed=None, customer_answer_rate=None, max_customer_ring_time=None,
                 max_ring_time=None, max_talk_time=None, total_customer_ring_time=None, total_ring_time=None,
                 total_talk_time=None):
        self.agent_handle_rate = agent_handle_rate  # type: str
        self.answer_rate = answer_rate  # type: str
        self.average_customer_ring_time = average_customer_ring_time  # type: str
        self.average_ring_time = average_ring_time  # type: str
        self.average_talk_time = average_talk_time  # type: str
        self.calls_agent_handled = calls_agent_handled  # type: str
        self.calls_answered = calls_answered  # type: str
        self.calls_customer_answered = calls_customer_answered  # type: str
        self.calls_dialed = calls_dialed  # type: str
        self.customer_answer_rate = customer_answer_rate  # type: str
        self.max_customer_ring_time = max_customer_ring_time  # type: str
        self.max_ring_time = max_ring_time  # type: str
        self.max_talk_time = max_talk_time  # type: str
        self.total_customer_ring_time = total_customer_ring_time  # type: str
        self.total_ring_time = total_ring_time  # type: str
        self.total_talk_time = total_talk_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListBack2Back, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_handle_rate is not None:
            result['AgentHandleRate'] = self.agent_handle_rate
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_customer_ring_time is not None:
            result['AverageCustomerRingTime'] = self.average_customer_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_agent_handled is not None:
            result['CallsAgentHandled'] = self.calls_agent_handled
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_customer_answered is not None:
            result['CallsCustomerAnswered'] = self.calls_customer_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.customer_answer_rate is not None:
            result['CustomerAnswerRate'] = self.customer_answer_rate
        if self.max_customer_ring_time is not None:
            result['MaxCustomerRingTime'] = self.max_customer_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_customer_ring_time is not None:
            result['TotalCustomerRingTime'] = self.total_customer_ring_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentHandleRate') is not None:
            self.agent_handle_rate = m.get('AgentHandleRate')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageCustomerRingTime') is not None:
            self.average_customer_ring_time = m.get('AverageCustomerRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAgentHandled') is not None:
            self.calls_agent_handled = m.get('CallsAgentHandled')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsCustomerAnswered') is not None:
            self.calls_customer_answered = m.get('CallsCustomerAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CustomerAnswerRate') is not None:
            self.customer_answer_rate = m.get('CustomerAnswerRate')
        if m.get('MaxCustomerRingTime') is not None:
            self.max_customer_ring_time = m.get('MaxCustomerRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCustomerRingTime') is not None:
            self.total_customer_ring_time = m.get('TotalCustomerRingTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListInboundAccessChannelTypeDetails(TeaModel):
    def __init__(self, access_channel_type=None, calls_offered=None):
        self.access_channel_type = access_channel_type  # type: str
        self.calls_offered = calls_offered  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListInboundAccessChannelTypeDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_channel_type is not None:
            result['AccessChannelType'] = self.access_channel_type
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessChannelType') is not None:
            self.access_channel_type = m.get('AccessChannelType')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        return self


class ListHistoricalAgentReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, access_channel_type_details=None, average_first_response_time=None, average_hold_time=None,
                 average_response_time=None, average_ring_time=None, average_talk_time=None, average_work_time=None,
                 calls_attended_transfer_in=None, calls_attended_transfer_out=None, calls_blind_transfer_in=None,
                 calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None, calls_ringed=None, handle_rate=None,
                 max_hold_time=None, max_ring_time=None, max_talk_time=None, max_work_time=None, satisfaction_index=None,
                 satisfaction_rate=None, satisfaction_surveys_offered=None, satisfaction_surveys_responded=None,
                 service_level_15=None, total_hold_time=None, total_messages_sent=None, total_messages_sent_by_agent=None,
                 total_messages_sent_by_customer=None, total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.access_channel_type_details = access_channel_type_details  # type: list[ListHistoricalAgentReportResponseBodyDataListInboundAccessChannelTypeDetails]
        self.average_first_response_time = average_first_response_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_response_time = average_response_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_15 = service_level_15  # type: float
        self.total_hold_time = total_hold_time  # type: long
        self.total_messages_sent = total_messages_sent  # type: long
        self.total_messages_sent_by_agent = total_messages_sent_by_agent  # type: long
        self.total_messages_sent_by_customer = total_messages_sent_by_customer  # type: str
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.access_channel_type_details:
            for k in self.access_channel_type_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessChannelTypeDetails'] = []
        if self.access_channel_type_details is not None:
            for k in self.access_channel_type_details:
                result['AccessChannelTypeDetails'].append(k.to_map() if k else None)
        if self.average_first_response_time is not None:
            result['AverageFirstResponseTime'] = self.average_first_response_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_response_time is not None:
            result['AverageResponseTime'] = self.average_response_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_15 is not None:
            result['ServiceLevel15'] = self.service_level_15
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_messages_sent is not None:
            result['TotalMessagesSent'] = self.total_messages_sent
        if self.total_messages_sent_by_agent is not None:
            result['TotalMessagesSentByAgent'] = self.total_messages_sent_by_agent
        if self.total_messages_sent_by_customer is not None:
            result['TotalMessagesSentByCustomer'] = self.total_messages_sent_by_customer
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.access_channel_type_details = []
        if m.get('AccessChannelTypeDetails') is not None:
            for k in m.get('AccessChannelTypeDetails'):
                temp_model = ListHistoricalAgentReportResponseBodyDataListInboundAccessChannelTypeDetails()
                self.access_channel_type_details.append(temp_model.from_map(k))
        if m.get('AverageFirstResponseTime') is not None:
            self.average_first_response_time = m.get('AverageFirstResponseTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageResponseTime') is not None:
            self.average_response_time = m.get('AverageResponseTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel15') is not None:
            self.service_level_15 = m.get('ServiceLevel15')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalMessagesSent') is not None:
            self.total_messages_sent = m.get('TotalMessagesSent')
        if m.get('TotalMessagesSentByAgent') is not None:
            self.total_messages_sent_by_agent = m.get('TotalMessagesSentByAgent')
        if m.get('TotalMessagesSentByCustomer') is not None:
            self.total_messages_sent_by_customer = m.get('TotalMessagesSentByCustomer')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListInternal(TeaModel):
    def __init__(self, average_talk_time=None, calls_answered=None, calls_dialed=None, calls_handled=None,
                 calls_offered=None, calls_talked=None, max_talk_time=None, total_talk_time=None):
        self.average_talk_time = average_talk_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_talked = calls_talked  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_talk_time = total_talk_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListInternal, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_talked is not None:
            result['CallsTalked'] = self.calls_talked
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsTalked') is not None:
            self.calls_talked = m.get('CallsTalked')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataListOverallBreakCodeDetailList(TeaModel):
    def __init__(self, break_code=None, count=None, duration=None):
        self.break_code = break_code  # type: str
        self.count = count  # type: long
        self.duration = duration  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOverallBreakCodeDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.count is not None:
            result['Count'] = self.count
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListHistoricalAgentReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, break_code_detail_list=None, first_check_in_time=None,
                 last_check_out_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None, max_talk_time=None,
                 max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_off_site_logged_in_time=None,
                 total_off_site_online_time=None, total_office_phone_logged_in_time=None, total_office_phone_online_time=None,
                 total_on_site_logged_in_time=None, total_on_site_online_time=None, total_outbound_scenario_logged_in_time=None,
                 total_outbound_scenario_ready_time=None, total_outbound_scenario_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.break_code_detail_list = break_code_detail_list  # type: list[ListHistoricalAgentReportResponseBodyDataListOverallBreakCodeDetailList]
        self.first_check_in_time = first_check_in_time  # type: long
        self.last_check_out_time = last_check_out_time  # type: long
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_off_site_logged_in_time = total_off_site_logged_in_time  # type: long
        self.total_off_site_online_time = total_off_site_online_time  # type: long
        self.total_office_phone_logged_in_time = total_office_phone_logged_in_time  # type: long
        self.total_office_phone_online_time = total_office_phone_online_time  # type: long
        self.total_on_site_logged_in_time = total_on_site_logged_in_time  # type: long
        self.total_on_site_online_time = total_on_site_online_time  # type: long
        self.total_outbound_scenario_logged_in_time = total_outbound_scenario_logged_in_time  # type: long
        self.total_outbound_scenario_ready_time = total_outbound_scenario_ready_time  # type: long
        self.total_outbound_scenario_time = total_outbound_scenario_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.break_code_detail_list:
            for k in self.break_code_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        result['BreakCodeDetailList'] = []
        if self.break_code_detail_list is not None:
            for k in self.break_code_detail_list:
                result['BreakCodeDetailList'].append(k.to_map() if k else None)
        if self.first_check_in_time is not None:
            result['FirstCheckInTime'] = self.first_check_in_time
        if self.last_check_out_time is not None:
            result['LastCheckOutTime'] = self.last_check_out_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_off_site_logged_in_time is not None:
            result['TotalOffSiteLoggedInTime'] = self.total_off_site_logged_in_time
        if self.total_off_site_online_time is not None:
            result['TotalOffSiteOnlineTime'] = self.total_off_site_online_time
        if self.total_office_phone_logged_in_time is not None:
            result['TotalOfficePhoneLoggedInTime'] = self.total_office_phone_logged_in_time
        if self.total_office_phone_online_time is not None:
            result['TotalOfficePhoneOnlineTime'] = self.total_office_phone_online_time
        if self.total_on_site_logged_in_time is not None:
            result['TotalOnSiteLoggedInTime'] = self.total_on_site_logged_in_time
        if self.total_on_site_online_time is not None:
            result['TotalOnSiteOnlineTime'] = self.total_on_site_online_time
        if self.total_outbound_scenario_logged_in_time is not None:
            result['TotalOutboundScenarioLoggedInTime'] = self.total_outbound_scenario_logged_in_time
        if self.total_outbound_scenario_ready_time is not None:
            result['TotalOutboundScenarioReadyTime'] = self.total_outbound_scenario_ready_time
        if self.total_outbound_scenario_time is not None:
            result['TotalOutboundScenarioTime'] = self.total_outbound_scenario_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        self.break_code_detail_list = []
        if m.get('BreakCodeDetailList') is not None:
            for k in m.get('BreakCodeDetailList'):
                temp_model = ListHistoricalAgentReportResponseBodyDataListOverallBreakCodeDetailList()
                self.break_code_detail_list.append(temp_model.from_map(k))
        if m.get('FirstCheckInTime') is not None:
            self.first_check_in_time = m.get('FirstCheckInTime')
        if m.get('LastCheckOutTime') is not None:
            self.last_check_out_time = m.get('LastCheckOutTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalOffSiteLoggedInTime') is not None:
            self.total_off_site_logged_in_time = m.get('TotalOffSiteLoggedInTime')
        if m.get('TotalOffSiteOnlineTime') is not None:
            self.total_off_site_online_time = m.get('TotalOffSiteOnlineTime')
        if m.get('TotalOfficePhoneLoggedInTime') is not None:
            self.total_office_phone_logged_in_time = m.get('TotalOfficePhoneLoggedInTime')
        if m.get('TotalOfficePhoneOnlineTime') is not None:
            self.total_office_phone_online_time = m.get('TotalOfficePhoneOnlineTime')
        if m.get('TotalOnSiteLoggedInTime') is not None:
            self.total_on_site_logged_in_time = m.get('TotalOnSiteLoggedInTime')
        if m.get('TotalOnSiteOnlineTime') is not None:
            self.total_on_site_online_time = m.get('TotalOnSiteOnlineTime')
        if m.get('TotalOutboundScenarioLoggedInTime') is not None:
            self.total_outbound_scenario_logged_in_time = m.get('TotalOutboundScenarioLoggedInTime')
        if m.get('TotalOutboundScenarioReadyTime') is not None:
            self.total_outbound_scenario_ready_time = m.get('TotalOutboundScenarioReadyTime')
        if m.get('TotalOutboundScenarioTime') is not None:
            self.total_outbound_scenario_time = m.get('TotalOutboundScenarioTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentReportResponseBodyDataList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, back_2back=None, display_id=None, inbound=None, internal=None,
                 outbound=None, overall=None, skill_group_ids=None, skill_group_names=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.back_2back = back_2back  # type: ListHistoricalAgentReportResponseBodyDataListBack2Back
        self.display_id = display_id  # type: str
        self.inbound = inbound  # type: ListHistoricalAgentReportResponseBodyDataListInbound
        self.internal = internal  # type: ListHistoricalAgentReportResponseBodyDataListInternal
        self.outbound = outbound  # type: ListHistoricalAgentReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalAgentReportResponseBodyDataListOverall
        self.skill_group_ids = skill_group_ids  # type: str
        self.skill_group_names = skill_group_names  # type: str

    def validate(self):
        if self.back_2back:
            self.back_2back.validate()
        if self.inbound:
            self.inbound.validate()
        if self.internal:
            self.internal.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.back_2back is not None:
            result['Back2Back'] = self.back_2back.to_map()
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.internal is not None:
            result['Internal'] = self.internal.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        if self.skill_group_names is not None:
            result['SkillGroupNames'] = self.skill_group_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('Back2Back') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListBack2Back()
            self.back_2back = temp_model.from_map(m['Back2Back'])
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Internal') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListInternal()
            self.internal = temp_model.from_map(m['Internal'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        if m.get('SkillGroupNames') is not None:
            self.skill_group_names = m.get('SkillGroupNames')
        return self


class ListHistoricalAgentReportResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListHistoricalAgentReportResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalAgentReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHistoricalAgentReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListHistoricalAgentReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListHistoricalAgentReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListHistoricalAgentReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListHistoricalAgentReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHistoricalAgentReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalAgentSkillGroupReportRequest(TeaModel):
    def __init__(self, agent_id_list=None, end_time=None, instance_id=None, media_type=None, page_number=None,
                 page_size=None, skill_group_id_list=None, start_time=None):
        self.agent_id_list = agent_id_list  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id_list is not None:
            result['AgentIdList'] = self.agent_id_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIdList') is not None:
            self.agent_id_list = m.get('AgentIdList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListBack2Back(TeaModel):
    def __init__(self, agent_answer_rate=None, agent_handle_rate=None, answer_rate=None,
                 average_customer_ring_time=None, average_ring_time=None, average_talk_time=None, calls_agent_handled=None,
                 calls_answered=None, calls_customer_answered=None, calls_customer_handled=None, calls_dialed=None,
                 customer_answer_rate=None, customer_handle_rate=None, max_customer_ring_time=None, max_ring_time=None,
                 max_talk_time=None, total_customer_ring_time=None, total_ring_time=None, total_talk_time=None):
        self.agent_answer_rate = agent_answer_rate  # type: float
        self.agent_handle_rate = agent_handle_rate  # type: float
        self.answer_rate = answer_rate  # type: float
        self.average_customer_ring_time = average_customer_ring_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: long
        self.calls_agent_handled = calls_agent_handled  # type: long
        self.calls_answered = calls_answered  # type: long
        self.calls_customer_answered = calls_customer_answered  # type: long
        self.calls_customer_handled = calls_customer_handled  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.customer_answer_rate = customer_answer_rate  # type: float
        self.customer_handle_rate = customer_handle_rate  # type: float
        self.max_customer_ring_time = max_customer_ring_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_customer_ring_time = total_customer_ring_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListBack2Back, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_answer_rate is not None:
            result['AgentAnswerRate'] = self.agent_answer_rate
        if self.agent_handle_rate is not None:
            result['AgentHandleRate'] = self.agent_handle_rate
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_customer_ring_time is not None:
            result['AverageCustomerRingTime'] = self.average_customer_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_agent_handled is not None:
            result['CallsAgentHandled'] = self.calls_agent_handled
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_customer_answered is not None:
            result['CallsCustomerAnswered'] = self.calls_customer_answered
        if self.calls_customer_handled is not None:
            result['CallsCustomerHandled'] = self.calls_customer_handled
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.customer_answer_rate is not None:
            result['CustomerAnswerRate'] = self.customer_answer_rate
        if self.customer_handle_rate is not None:
            result['CustomerHandleRate'] = self.customer_handle_rate
        if self.max_customer_ring_time is not None:
            result['MaxCustomerRingTime'] = self.max_customer_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_customer_ring_time is not None:
            result['TotalCustomerRingTime'] = self.total_customer_ring_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentAnswerRate') is not None:
            self.agent_answer_rate = m.get('AgentAnswerRate')
        if m.get('AgentHandleRate') is not None:
            self.agent_handle_rate = m.get('AgentHandleRate')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageCustomerRingTime') is not None:
            self.average_customer_ring_time = m.get('AverageCustomerRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAgentHandled') is not None:
            self.calls_agent_handled = m.get('CallsAgentHandled')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsCustomerAnswered') is not None:
            self.calls_customer_answered = m.get('CallsCustomerAnswered')
        if m.get('CallsCustomerHandled') is not None:
            self.calls_customer_handled = m.get('CallsCustomerHandled')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CustomerAnswerRate') is not None:
            self.customer_answer_rate = m.get('CustomerAnswerRate')
        if m.get('CustomerHandleRate') is not None:
            self.customer_handle_rate = m.get('CustomerHandleRate')
        if m.get('MaxCustomerRingTime') is not None:
            self.max_customer_ring_time = m.get('MaxCustomerRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCustomerRingTime') is not None:
            self.total_customer_ring_time = m.get('TotalCustomerRingTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, average_first_response_time=None, average_hold_time=None, average_response_time=None,
                 average_ring_time=None, average_talk_time=None, average_work_time=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None,
                 calls_hold=None, calls_offered=None, calls_ringed=None, handle_rate=None, max_hold_time=None,
                 max_ring_time=None, max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_hold_time=None, total_messages_sent=None,
                 total_messages_sent_by_agent=None, total_messages_sent_by_customer=None, total_ring_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_first_response_time = average_first_response_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_response_time = average_response_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_messages_sent = total_messages_sent  # type: long
        self.total_messages_sent_by_agent = total_messages_sent_by_agent  # type: long
        self.total_messages_sent_by_customer = total_messages_sent_by_customer  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_first_response_time is not None:
            result['AverageFirstResponseTime'] = self.average_first_response_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_response_time is not None:
            result['AverageResponseTime'] = self.average_response_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_messages_sent is not None:
            result['TotalMessagesSent'] = self.total_messages_sent
        if self.total_messages_sent_by_agent is not None:
            result['TotalMessagesSentByAgent'] = self.total_messages_sent_by_agent
        if self.total_messages_sent_by_customer is not None:
            result['TotalMessagesSentByCustomer'] = self.total_messages_sent_by_customer
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageFirstResponseTime') is not None:
            self.average_first_response_time = m.get('AverageFirstResponseTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageResponseTime') is not None:
            self.average_response_time = m.get('AverageResponseTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalMessagesSent') is not None:
            self.total_messages_sent = m.get('TotalMessagesSent')
        if m.get('TotalMessagesSentByAgent') is not None:
            self.total_messages_sent_by_agent = m.get('TotalMessagesSentByAgent')
        if m.get('TotalMessagesSentByCustomer') is not None:
            self.total_messages_sent_by_customer = m.get('TotalMessagesSentByCustomer')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListInternal(TeaModel):
    def __init__(self, average_talk_time=None, calls_answered=None, calls_dialed=None, calls_handled=None,
                 calls_offered=None, calls_talk=None, calls_talked=None, max_talk_time=None, total_talk_time=None):
        self.average_talk_time = average_talk_time  # type: long
        self.calls_answered = calls_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_talk = calls_talk  # type: long
        self.calls_talked = calls_talked  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_talk_time = total_talk_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListInternal, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_talk is not None:
            result['CallsTalk'] = self.calls_talk
        if self.calls_talked is not None:
            result['CallsTalked'] = self.calls_talked
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsTalk') is not None:
            self.calls_talk = m.get('CallsTalk')
        if m.get('CallsTalked') is not None:
            self.calls_talked = m.get('CallsTalked')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList(TeaModel):
    def __init__(self, break_code=None, count=None, duration=None):
        self.break_code = break_code  # type: str
        self.count = count  # type: long
        self.duration = duration  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.count is not None:
            result['Count'] = self.count
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, break_code_detail_list=None, first_check_in_time=None,
                 last_check_out_time=None, max_break_time=None, max_hold_time=None, max_ready_time=None, max_talk_time=None,
                 max_work_time=None, occupancy_rate=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_break_time=None, total_calls=None,
                 total_hold_time=None, total_logged_in_time=None, total_off_site_lgged_in_time=None,
                 total_office_phone_logged_in_time=None, total_on_site_logged_in_time=None, total_outbound_scenario_logged_in_time=None,
                 total_outbound_scenario_ready_time=None, total_outbound_scenario_time=None, total_ready_time=None, total_talk_time=None,
                 total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.break_code_detail_list = break_code_detail_list  # type: list[ListHistoricalAgentSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList]
        self.first_check_in_time = first_check_in_time  # type: long
        self.last_check_out_time = last_check_out_time  # type: long
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_off_site_lgged_in_time = total_off_site_lgged_in_time  # type: long
        self.total_office_phone_logged_in_time = total_office_phone_logged_in_time  # type: long
        self.total_on_site_logged_in_time = total_on_site_logged_in_time  # type: str
        self.total_outbound_scenario_logged_in_time = total_outbound_scenario_logged_in_time  # type: long
        self.total_outbound_scenario_ready_time = total_outbound_scenario_ready_time  # type: long
        self.total_outbound_scenario_time = total_outbound_scenario_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.break_code_detail_list:
            for k in self.break_code_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        result['BreakCodeDetailList'] = []
        if self.break_code_detail_list is not None:
            for k in self.break_code_detail_list:
                result['BreakCodeDetailList'].append(k.to_map() if k else None)
        if self.first_check_in_time is not None:
            result['FirstCheckInTime'] = self.first_check_in_time
        if self.last_check_out_time is not None:
            result['LastCheckOutTime'] = self.last_check_out_time
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_off_site_lgged_in_time is not None:
            result['TotalOffSiteLggedInTime'] = self.total_off_site_lgged_in_time
        if self.total_office_phone_logged_in_time is not None:
            result['TotalOfficePhoneLoggedInTime'] = self.total_office_phone_logged_in_time
        if self.total_on_site_logged_in_time is not None:
            result['TotalOnSiteLoggedInTime'] = self.total_on_site_logged_in_time
        if self.total_outbound_scenario_logged_in_time is not None:
            result['TotalOutboundScenarioLoggedInTime'] = self.total_outbound_scenario_logged_in_time
        if self.total_outbound_scenario_ready_time is not None:
            result['TotalOutboundScenarioReadyTime'] = self.total_outbound_scenario_ready_time
        if self.total_outbound_scenario_time is not None:
            result['TotalOutboundScenarioTime'] = self.total_outbound_scenario_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        self.break_code_detail_list = []
        if m.get('BreakCodeDetailList') is not None:
            for k in m.get('BreakCodeDetailList'):
                temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList()
                self.break_code_detail_list.append(temp_model.from_map(k))
        if m.get('FirstCheckInTime') is not None:
            self.first_check_in_time = m.get('FirstCheckInTime')
        if m.get('LastCheckOutTime') is not None:
            self.last_check_out_time = m.get('LastCheckOutTime')
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalOffSiteLggedInTime') is not None:
            self.total_off_site_lgged_in_time = m.get('TotalOffSiteLggedInTime')
        if m.get('TotalOfficePhoneLoggedInTime') is not None:
            self.total_office_phone_logged_in_time = m.get('TotalOfficePhoneLoggedInTime')
        if m.get('TotalOnSiteLoggedInTime') is not None:
            self.total_on_site_logged_in_time = m.get('TotalOnSiteLoggedInTime')
        if m.get('TotalOutboundScenarioLoggedInTime') is not None:
            self.total_outbound_scenario_logged_in_time = m.get('TotalOutboundScenarioLoggedInTime')
        if m.get('TotalOutboundScenarioReadyTime') is not None:
            self.total_outbound_scenario_ready_time = m.get('TotalOutboundScenarioReadyTime')
        if m.get('TotalOutboundScenarioTime') is not None:
            self.total_outbound_scenario_time = m.get('TotalOutboundScenarioTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyDataList(TeaModel):
    def __init__(self, agent_id=None, agent_name=None, back_2back=None, display_id=None, inbound=None, internal=None,
                 outbound=None, overall=None, skill_group_id=None, skill_group_name=None):
        self.agent_id = agent_id  # type: str
        self.agent_name = agent_name  # type: str
        self.back_2back = back_2back  # type: ListHistoricalAgentSkillGroupReportResponseBodyDataListBack2Back
        self.display_id = display_id  # type: str
        self.inbound = inbound  # type: ListHistoricalAgentSkillGroupReportResponseBodyDataListInbound
        self.internal = internal  # type: ListHistoricalAgentSkillGroupReportResponseBodyDataListInternal
        self.outbound = outbound  # type: ListHistoricalAgentSkillGroupReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalAgentSkillGroupReportResponseBodyDataListOverall
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        if self.back_2back:
            self.back_2back.validate()
        if self.inbound:
            self.inbound.validate()
        if self.internal:
            self.internal.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.back_2back is not None:
            result['Back2Back'] = self.back_2back.to_map()
        if self.display_id is not None:
            result['DisplayId'] = self.display_id
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.internal is not None:
            result['Internal'] = self.internal.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('Back2Back') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListBack2Back()
            self.back_2back = temp_model.from_map(m['Back2Back'])
        if m.get('DisplayId') is not None:
            self.display_id = m.get('DisplayId')
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Internal') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListInternal()
            self.internal = temp_model.from_map(m['Internal'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class ListHistoricalAgentSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListHistoricalAgentSkillGroupReportResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalAgentSkillGroupReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHistoricalAgentSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListHistoricalAgentSkillGroupReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListHistoricalAgentSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListHistoricalAgentSkillGroupReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalAgentSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHistoricalAgentSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHistoricalSkillGroupReportRequest(TeaModel):
    def __init__(self, end_time=None, instance_id=None, media_type=None, page_number=None, page_size=None,
                 skill_group_id_list=None, start_time=None):
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.media_type = media_type  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.skill_group_id_list = skill_group_id_list  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListBack2Back(TeaModel):
    def __init__(self, agent_handle_rate=None, answer_rate=None, average_customer_ring_time=None,
                 average_ring_time=None, average_talk_time=None, calls_answered=None, calls_customer_answered=None,
                 calls_dialed=None, customer_answer_rate=None, max_customer_ring_time=None, max_ring_time=None,
                 max_talk_time=None, total_customer_ring_time=None, total_ring_time=None, total_talk_time=None):
        self.agent_handle_rate = agent_handle_rate  # type: float
        self.answer_rate = answer_rate  # type: float
        self.average_customer_ring_time = average_customer_ring_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_customer_answered = calls_customer_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.customer_answer_rate = customer_answer_rate  # type: float
        self.max_customer_ring_time = max_customer_ring_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_customer_ring_time = total_customer_ring_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListBack2Back, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_handle_rate is not None:
            result['AgentHandleRate'] = self.agent_handle_rate
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_customer_ring_time is not None:
            result['AverageCustomerRingTime'] = self.average_customer_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_customer_answered is not None:
            result['CallsCustomerAnswered'] = self.calls_customer_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.customer_answer_rate is not None:
            result['CustomerAnswerRate'] = self.customer_answer_rate
        if self.max_customer_ring_time is not None:
            result['MaxCustomerRingTime'] = self.max_customer_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_customer_ring_time is not None:
            result['TotalCustomerRingTime'] = self.total_customer_ring_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentHandleRate') is not None:
            self.agent_handle_rate = m.get('AgentHandleRate')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageCustomerRingTime') is not None:
            self.average_customer_ring_time = m.get('AverageCustomerRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsCustomerAnswered') is not None:
            self.calls_customer_answered = m.get('CallsCustomerAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CustomerAnswerRate') is not None:
            self.customer_answer_rate = m.get('CustomerAnswerRate')
        if m.get('MaxCustomerRingTime') is not None:
            self.max_customer_ring_time = m.get('MaxCustomerRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('TotalCustomerRingTime') is not None:
            self.total_customer_ring_time = m.get('TotalCustomerRingTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListInboundAccessChannelTypeDetails(TeaModel):
    def __init__(self, access_channel_type=None, calls_offered=None):
        self.access_channel_type = access_channel_type  # type: str
        self.calls_offered = calls_offered  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListInboundAccessChannelTypeDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_channel_type is not None:
            result['AccessChannelType'] = self.access_channel_type
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessChannelType') is not None:
            self.access_channel_type = m.get('AccessChannelType')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListInbound(TeaModel):
    def __init__(self, abandon_rate=None, access_channel_type_details=None, average_abandon_time=None,
                 average_abandoned_in_queue_time=None, average_abandoned_in_ring_time=None, average_first_response_time=None,
                 average_hold_time=None, average_response_time=None, average_ring_time=None, average_talk_time=None,
                 average_wait_time=None, average_work_time=None, calls_abandoned=None, calls_abandoned_in_queue=None,
                 calls_abandoned_in_ring=None, calls_attended_transfer_in=None, calls_attended_transfer_out=None,
                 calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_handled=None, calls_hold=None, calls_offered=None,
                 calls_overflow=None, calls_queued=None, calls_queuing_failed=None, calls_queuing_overflow=None,
                 calls_queuing_timeout=None, calls_ringed=None, calls_timeout=None, handle_rate=None, max_abandon_time=None,
                 max_abandoned_in_queue_time=None, max_abandoned_in_ring_time=None, max_hold_time=None, max_ring_time=None, max_talk_time=None,
                 max_wait_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, service_level_15=None, service_level_20=None,
                 service_level_30=None, total_abandon_time=None, total_abandoned_in_queue_time=None,
                 total_abandoned_in_ring_time=None, total_hold_time=None, total_messages_sent=None, total_messages_sent_by_agent=None,
                 total_messages_sent_by_customer=None, total_ring_time=None, total_talk_time=None, total_wait_time=None, total_work_time=None):
        self.abandon_rate = abandon_rate  # type: float
        self.access_channel_type_details = access_channel_type_details  # type: list[ListHistoricalSkillGroupReportResponseBodyDataListInboundAccessChannelTypeDetails]
        self.average_abandon_time = average_abandon_time  # type: float
        self.average_abandoned_in_queue_time = average_abandoned_in_queue_time  # type: float
        self.average_abandoned_in_ring_time = average_abandoned_in_ring_time  # type: float
        self.average_first_response_time = average_first_response_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_response_time = average_response_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_wait_time = average_wait_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_abandoned = calls_abandoned  # type: long
        self.calls_abandoned_in_queue = calls_abandoned_in_queue  # type: long
        self.calls_abandoned_in_ring = calls_abandoned_in_ring  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_handled = calls_handled  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_offered = calls_offered  # type: long
        self.calls_overflow = calls_overflow  # type: long
        self.calls_queued = calls_queued  # type: long
        self.calls_queuing_failed = calls_queuing_failed  # type: long
        self.calls_queuing_overflow = calls_queuing_overflow  # type: long
        self.calls_queuing_timeout = calls_queuing_timeout  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.calls_timeout = calls_timeout  # type: long
        self.handle_rate = handle_rate  # type: float
        self.max_abandon_time = max_abandon_time  # type: long
        self.max_abandoned_in_queue_time = max_abandoned_in_queue_time  # type: long
        self.max_abandoned_in_ring_time = max_abandoned_in_ring_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_wait_time = max_wait_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.service_level_15 = service_level_15  # type: float
        self.service_level_20 = service_level_20  # type: float
        self.service_level_30 = service_level_30  # type: float
        self.total_abandon_time = total_abandon_time  # type: long
        self.total_abandoned_in_queue_time = total_abandoned_in_queue_time  # type: long
        self.total_abandoned_in_ring_time = total_abandoned_in_ring_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_messages_sent = total_messages_sent  # type: long
        self.total_messages_sent_by_agent = total_messages_sent_by_agent  # type: long
        self.total_messages_sent_by_customer = total_messages_sent_by_customer  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_wait_time = total_wait_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.access_channel_type_details:
            for k in self.access_channel_type_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListInbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abandon_rate is not None:
            result['AbandonRate'] = self.abandon_rate
        result['AccessChannelTypeDetails'] = []
        if self.access_channel_type_details is not None:
            for k in self.access_channel_type_details:
                result['AccessChannelTypeDetails'].append(k.to_map() if k else None)
        if self.average_abandon_time is not None:
            result['AverageAbandonTime'] = self.average_abandon_time
        if self.average_abandoned_in_queue_time is not None:
            result['AverageAbandonedInQueueTime'] = self.average_abandoned_in_queue_time
        if self.average_abandoned_in_ring_time is not None:
            result['AverageAbandonedInRingTime'] = self.average_abandoned_in_ring_time
        if self.average_first_response_time is not None:
            result['AverageFirstResponseTime'] = self.average_first_response_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_response_time is not None:
            result['AverageResponseTime'] = self.average_response_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_wait_time is not None:
            result['AverageWaitTime'] = self.average_wait_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_abandoned is not None:
            result['CallsAbandoned'] = self.calls_abandoned
        if self.calls_abandoned_in_queue is not None:
            result['CallsAbandonedInQueue'] = self.calls_abandoned_in_queue
        if self.calls_abandoned_in_ring is not None:
            result['CallsAbandonedInRing'] = self.calls_abandoned_in_ring
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_handled is not None:
            result['CallsHandled'] = self.calls_handled
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_offered is not None:
            result['CallsOffered'] = self.calls_offered
        if self.calls_overflow is not None:
            result['CallsOverflow'] = self.calls_overflow
        if self.calls_queued is not None:
            result['CallsQueued'] = self.calls_queued
        if self.calls_queuing_failed is not None:
            result['CallsQueuingFailed'] = self.calls_queuing_failed
        if self.calls_queuing_overflow is not None:
            result['CallsQueuingOverflow'] = self.calls_queuing_overflow
        if self.calls_queuing_timeout is not None:
            result['CallsQueuingTimeout'] = self.calls_queuing_timeout
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.calls_timeout is not None:
            result['CallsTimeout'] = self.calls_timeout
        if self.handle_rate is not None:
            result['HandleRate'] = self.handle_rate
        if self.max_abandon_time is not None:
            result['MaxAbandonTime'] = self.max_abandon_time
        if self.max_abandoned_in_queue_time is not None:
            result['MaxAbandonedInQueueTime'] = self.max_abandoned_in_queue_time
        if self.max_abandoned_in_ring_time is not None:
            result['MaxAbandonedInRingTime'] = self.max_abandoned_in_ring_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.service_level_15 is not None:
            result['ServiceLevel15'] = self.service_level_15
        if self.service_level_20 is not None:
            result['ServiceLevel20'] = self.service_level_20
        if self.service_level_30 is not None:
            result['ServiceLevel30'] = self.service_level_30
        if self.total_abandon_time is not None:
            result['TotalAbandonTime'] = self.total_abandon_time
        if self.total_abandoned_in_queue_time is not None:
            result['TotalAbandonedInQueueTime'] = self.total_abandoned_in_queue_time
        if self.total_abandoned_in_ring_time is not None:
            result['TotalAbandonedInRingTime'] = self.total_abandoned_in_ring_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_messages_sent is not None:
            result['TotalMessagesSent'] = self.total_messages_sent
        if self.total_messages_sent_by_agent is not None:
            result['TotalMessagesSentByAgent'] = self.total_messages_sent_by_agent
        if self.total_messages_sent_by_customer is not None:
            result['TotalMessagesSentByCustomer'] = self.total_messages_sent_by_customer
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbandonRate') is not None:
            self.abandon_rate = m.get('AbandonRate')
        self.access_channel_type_details = []
        if m.get('AccessChannelTypeDetails') is not None:
            for k in m.get('AccessChannelTypeDetails'):
                temp_model = ListHistoricalSkillGroupReportResponseBodyDataListInboundAccessChannelTypeDetails()
                self.access_channel_type_details.append(temp_model.from_map(k))
        if m.get('AverageAbandonTime') is not None:
            self.average_abandon_time = m.get('AverageAbandonTime')
        if m.get('AverageAbandonedInQueueTime') is not None:
            self.average_abandoned_in_queue_time = m.get('AverageAbandonedInQueueTime')
        if m.get('AverageAbandonedInRingTime') is not None:
            self.average_abandoned_in_ring_time = m.get('AverageAbandonedInRingTime')
        if m.get('AverageFirstResponseTime') is not None:
            self.average_first_response_time = m.get('AverageFirstResponseTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageResponseTime') is not None:
            self.average_response_time = m.get('AverageResponseTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWaitTime') is not None:
            self.average_wait_time = m.get('AverageWaitTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAbandoned') is not None:
            self.calls_abandoned = m.get('CallsAbandoned')
        if m.get('CallsAbandonedInQueue') is not None:
            self.calls_abandoned_in_queue = m.get('CallsAbandonedInQueue')
        if m.get('CallsAbandonedInRing') is not None:
            self.calls_abandoned_in_ring = m.get('CallsAbandonedInRing')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsHandled') is not None:
            self.calls_handled = m.get('CallsHandled')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsOffered') is not None:
            self.calls_offered = m.get('CallsOffered')
        if m.get('CallsOverflow') is not None:
            self.calls_overflow = m.get('CallsOverflow')
        if m.get('CallsQueued') is not None:
            self.calls_queued = m.get('CallsQueued')
        if m.get('CallsQueuingFailed') is not None:
            self.calls_queuing_failed = m.get('CallsQueuingFailed')
        if m.get('CallsQueuingOverflow') is not None:
            self.calls_queuing_overflow = m.get('CallsQueuingOverflow')
        if m.get('CallsQueuingTimeout') is not None:
            self.calls_queuing_timeout = m.get('CallsQueuingTimeout')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('CallsTimeout') is not None:
            self.calls_timeout = m.get('CallsTimeout')
        if m.get('HandleRate') is not None:
            self.handle_rate = m.get('HandleRate')
        if m.get('MaxAbandonTime') is not None:
            self.max_abandon_time = m.get('MaxAbandonTime')
        if m.get('MaxAbandonedInQueueTime') is not None:
            self.max_abandoned_in_queue_time = m.get('MaxAbandonedInQueueTime')
        if m.get('MaxAbandonedInRingTime') is not None:
            self.max_abandoned_in_ring_time = m.get('MaxAbandonedInRingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('ServiceLevel15') is not None:
            self.service_level_15 = m.get('ServiceLevel15')
        if m.get('ServiceLevel20') is not None:
            self.service_level_20 = m.get('ServiceLevel20')
        if m.get('ServiceLevel30') is not None:
            self.service_level_30 = m.get('ServiceLevel30')
        if m.get('TotalAbandonTime') is not None:
            self.total_abandon_time = m.get('TotalAbandonTime')
        if m.get('TotalAbandonedInQueueTime') is not None:
            self.total_abandoned_in_queue_time = m.get('TotalAbandonedInQueueTime')
        if m.get('TotalAbandonedInRingTime') is not None:
            self.total_abandoned_in_ring_time = m.get('TotalAbandonedInRingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalMessagesSent') is not None:
            self.total_messages_sent = m.get('TotalMessagesSent')
        if m.get('TotalMessagesSentByAgent') is not None:
            self.total_messages_sent_by_agent = m.get('TotalMessagesSentByAgent')
        if m.get('TotalMessagesSentByCustomer') is not None:
            self.total_messages_sent_by_customer = m.get('TotalMessagesSentByCustomer')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOutbound(TeaModel):
    def __init__(self, answer_rate=None, average_dialing_time=None, average_hold_time=None, average_ring_time=None,
                 average_talk_time=None, average_work_time=None, calls_answered=None, calls_attended_transfer_in=None,
                 calls_attended_transfer_out=None, calls_blind_transfer_in=None, calls_blind_transfer_out=None, calls_dialed=None,
                 calls_hold=None, calls_ringed=None, max_dialing_time=None, max_hold_time=None, max_ring_time=None,
                 max_talk_time=None, max_work_time=None, satisfaction_index=None, satisfaction_rate=None,
                 satisfaction_surveys_offered=None, satisfaction_surveys_responded=None, total_dialing_time=None, total_hold_time=None,
                 total_ring_time=None, total_talk_time=None, total_work_time=None):
        self.answer_rate = answer_rate  # type: float
        self.average_dialing_time = average_dialing_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.calls_answered = calls_answered  # type: long
        self.calls_attended_transfer_in = calls_attended_transfer_in  # type: long
        self.calls_attended_transfer_out = calls_attended_transfer_out  # type: long
        self.calls_blind_transfer_in = calls_blind_transfer_in  # type: long
        self.calls_blind_transfer_out = calls_blind_transfer_out  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.calls_hold = calls_hold  # type: long
        self.calls_ringed = calls_ringed  # type: long
        self.max_dialing_time = max_dialing_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_dialing_time = total_dialing_time  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOutbound, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_dialing_time is not None:
            result['AverageDialingTime'] = self.average_dialing_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_attended_transfer_in is not None:
            result['CallsAttendedTransferIn'] = self.calls_attended_transfer_in
        if self.calls_attended_transfer_out is not None:
            result['CallsAttendedTransferOut'] = self.calls_attended_transfer_out
        if self.calls_blind_transfer_in is not None:
            result['CallsBlindTransferIn'] = self.calls_blind_transfer_in
        if self.calls_blind_transfer_out is not None:
            result['CallsBlindTransferOut'] = self.calls_blind_transfer_out
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.calls_hold is not None:
            result['CallsHold'] = self.calls_hold
        if self.calls_ringed is not None:
            result['CallsRinged'] = self.calls_ringed
        if self.max_dialing_time is not None:
            result['MaxDialingTime'] = self.max_dialing_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_dialing_time is not None:
            result['TotalDialingTime'] = self.total_dialing_time
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageDialingTime') is not None:
            self.average_dialing_time = m.get('AverageDialingTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsAttendedTransferIn') is not None:
            self.calls_attended_transfer_in = m.get('CallsAttendedTransferIn')
        if m.get('CallsAttendedTransferOut') is not None:
            self.calls_attended_transfer_out = m.get('CallsAttendedTransferOut')
        if m.get('CallsBlindTransferIn') is not None:
            self.calls_blind_transfer_in = m.get('CallsBlindTransferIn')
        if m.get('CallsBlindTransferOut') is not None:
            self.calls_blind_transfer_out = m.get('CallsBlindTransferOut')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CallsHold') is not None:
            self.calls_hold = m.get('CallsHold')
        if m.get('CallsRinged') is not None:
            self.calls_ringed = m.get('CallsRinged')
        if m.get('MaxDialingTime') is not None:
            self.max_dialing_time = m.get('MaxDialingTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalDialingTime') is not None:
            self.total_dialing_time = m.get('TotalDialingTime')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalRingTime') is not None:
            self.total_ring_time = m.get('TotalRingTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList(TeaModel):
    def __init__(self, break_code=None, count=None, duration=None):
        self.break_code = break_code  # type: str
        self.count = count  # type: long
        self.duration = duration  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.break_code is not None:
            result['BreakCode'] = self.break_code
        if self.count is not None:
            result['Count'] = self.count
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BreakCode') is not None:
            self.break_code = m.get('BreakCode')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataListOverall(TeaModel):
    def __init__(self, average_break_time=None, average_hold_time=None, average_ready_time=None,
                 average_talk_time=None, average_work_time=None, break_code_detail_list=None, max_break_time=None,
                 max_hold_time=None, max_ready_time=None, max_talk_time=None, max_work_time=None, occupancy_rate=None,
                 satisfaction_index=None, satisfaction_rate=None, satisfaction_surveys_offered=None,
                 satisfaction_surveys_responded=None, total_break_time=None, total_calls=None, total_hold_time=None, total_logged_in_time=None,
                 total_ready_time=None, total_talk_time=None, total_work_time=None):
        self.average_break_time = average_break_time  # type: float
        self.average_hold_time = average_hold_time  # type: float
        self.average_ready_time = average_ready_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.average_work_time = average_work_time  # type: float
        self.break_code_detail_list = break_code_detail_list  # type: list[ListHistoricalSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList]
        self.max_break_time = max_break_time  # type: long
        self.max_hold_time = max_hold_time  # type: long
        self.max_ready_time = max_ready_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.max_work_time = max_work_time  # type: long
        self.occupancy_rate = occupancy_rate  # type: float
        self.satisfaction_index = satisfaction_index  # type: float
        self.satisfaction_rate = satisfaction_rate  # type: float
        self.satisfaction_surveys_offered = satisfaction_surveys_offered  # type: long
        self.satisfaction_surveys_responded = satisfaction_surveys_responded  # type: long
        self.total_break_time = total_break_time  # type: long
        self.total_calls = total_calls  # type: long
        self.total_hold_time = total_hold_time  # type: long
        self.total_logged_in_time = total_logged_in_time  # type: long
        self.total_ready_time = total_ready_time  # type: long
        self.total_talk_time = total_talk_time  # type: long
        self.total_work_time = total_work_time  # type: long

    def validate(self):
        if self.break_code_detail_list:
            for k in self.break_code_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataListOverall, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_break_time is not None:
            result['AverageBreakTime'] = self.average_break_time
        if self.average_hold_time is not None:
            result['AverageHoldTime'] = self.average_hold_time
        if self.average_ready_time is not None:
            result['AverageReadyTime'] = self.average_ready_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.average_work_time is not None:
            result['AverageWorkTime'] = self.average_work_time
        result['BreakCodeDetailList'] = []
        if self.break_code_detail_list is not None:
            for k in self.break_code_detail_list:
                result['BreakCodeDetailList'].append(k.to_map() if k else None)
        if self.max_break_time is not None:
            result['MaxBreakTime'] = self.max_break_time
        if self.max_hold_time is not None:
            result['MaxHoldTime'] = self.max_hold_time
        if self.max_ready_time is not None:
            result['MaxReadyTime'] = self.max_ready_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.max_work_time is not None:
            result['MaxWorkTime'] = self.max_work_time
        if self.occupancy_rate is not None:
            result['OccupancyRate'] = self.occupancy_rate
        if self.satisfaction_index is not None:
            result['SatisfactionIndex'] = self.satisfaction_index
        if self.satisfaction_rate is not None:
            result['SatisfactionRate'] = self.satisfaction_rate
        if self.satisfaction_surveys_offered is not None:
            result['SatisfactionSurveysOffered'] = self.satisfaction_surveys_offered
        if self.satisfaction_surveys_responded is not None:
            result['SatisfactionSurveysResponded'] = self.satisfaction_surveys_responded
        if self.total_break_time is not None:
            result['TotalBreakTime'] = self.total_break_time
        if self.total_calls is not None:
            result['TotalCalls'] = self.total_calls
        if self.total_hold_time is not None:
            result['TotalHoldTime'] = self.total_hold_time
        if self.total_logged_in_time is not None:
            result['TotalLoggedInTime'] = self.total_logged_in_time
        if self.total_ready_time is not None:
            result['TotalReadyTime'] = self.total_ready_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        if self.total_work_time is not None:
            result['TotalWorkTime'] = self.total_work_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageBreakTime') is not None:
            self.average_break_time = m.get('AverageBreakTime')
        if m.get('AverageHoldTime') is not None:
            self.average_hold_time = m.get('AverageHoldTime')
        if m.get('AverageReadyTime') is not None:
            self.average_ready_time = m.get('AverageReadyTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('AverageWorkTime') is not None:
            self.average_work_time = m.get('AverageWorkTime')
        self.break_code_detail_list = []
        if m.get('BreakCodeDetailList') is not None:
            for k in m.get('BreakCodeDetailList'):
                temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOverallBreakCodeDetailList()
                self.break_code_detail_list.append(temp_model.from_map(k))
        if m.get('MaxBreakTime') is not None:
            self.max_break_time = m.get('MaxBreakTime')
        if m.get('MaxHoldTime') is not None:
            self.max_hold_time = m.get('MaxHoldTime')
        if m.get('MaxReadyTime') is not None:
            self.max_ready_time = m.get('MaxReadyTime')
        if m.get('MaxTalkTime') is not None:
            self.max_talk_time = m.get('MaxTalkTime')
        if m.get('MaxWorkTime') is not None:
            self.max_work_time = m.get('MaxWorkTime')
        if m.get('OccupancyRate') is not None:
            self.occupancy_rate = m.get('OccupancyRate')
        if m.get('SatisfactionIndex') is not None:
            self.satisfaction_index = m.get('SatisfactionIndex')
        if m.get('SatisfactionRate') is not None:
            self.satisfaction_rate = m.get('SatisfactionRate')
        if m.get('SatisfactionSurveysOffered') is not None:
            self.satisfaction_surveys_offered = m.get('SatisfactionSurveysOffered')
        if m.get('SatisfactionSurveysResponded') is not None:
            self.satisfaction_surveys_responded = m.get('SatisfactionSurveysResponded')
        if m.get('TotalBreakTime') is not None:
            self.total_break_time = m.get('TotalBreakTime')
        if m.get('TotalCalls') is not None:
            self.total_calls = m.get('TotalCalls')
        if m.get('TotalHoldTime') is not None:
            self.total_hold_time = m.get('TotalHoldTime')
        if m.get('TotalLoggedInTime') is not None:
            self.total_logged_in_time = m.get('TotalLoggedInTime')
        if m.get('TotalReadyTime') is not None:
            self.total_ready_time = m.get('TotalReadyTime')
        if m.get('TotalTalkTime') is not None:
            self.total_talk_time = m.get('TotalTalkTime')
        if m.get('TotalWorkTime') is not None:
            self.total_work_time = m.get('TotalWorkTime')
        return self


class ListHistoricalSkillGroupReportResponseBodyDataList(TeaModel):
    def __init__(self, back_2back=None, inbound=None, outbound=None, overall=None, skill_group_id=None,
                 skill_group_name=None):
        self.back_2back = back_2back  # type: ListHistoricalSkillGroupReportResponseBodyDataListBack2Back
        self.inbound = inbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListInbound
        self.outbound = outbound  # type: ListHistoricalSkillGroupReportResponseBodyDataListOutbound
        self.overall = overall  # type: ListHistoricalSkillGroupReportResponseBodyDataListOverall
        self.skill_group_id = skill_group_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        if self.back_2back:
            self.back_2back.validate()
        if self.inbound:
            self.inbound.validate()
        if self.outbound:
            self.outbound.validate()
        if self.overall:
            self.overall.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.back_2back is not None:
            result['Back2Back'] = self.back_2back.to_map()
        if self.inbound is not None:
            result['Inbound'] = self.inbound.to_map()
        if self.outbound is not None:
            result['Outbound'] = self.outbound.to_map()
        if self.overall is not None:
            result['Overall'] = self.overall.to_map()
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Back2Back') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListBack2Back()
            self.back_2back = temp_model.from_map(m['Back2Back'])
        if m.get('Inbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListInbound()
            self.inbound = temp_model.from_map(m['Inbound'])
        if m.get('Outbound') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOutbound()
            self.outbound = temp_model.from_map(m['Outbound'])
        if m.get('Overall') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyDataListOverall()
            self.overall = temp_model.from_map(m['Overall'])
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class ListHistoricalSkillGroupReportResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListHistoricalSkillGroupReportResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListHistoricalSkillGroupReportResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListHistoricalSkillGroupReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListHistoricalSkillGroupReportResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListHistoricalSkillGroupReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListHistoricalSkillGroupReportResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHistoricalSkillGroupReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHistoricalSkillGroupReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListInstancesResponseBodyDataListNumberList(TeaModel):
    def __init__(self, number=None):
        self.number = number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class ListInstancesResponseBodyDataList(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, create_time=None, description=None,
                 domain_name=None, id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[ListInstancesResponseBodyDataListAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[ListInstancesResponseBodyDataListNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListInstancesResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListInstancesResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListInstancesResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesOfUserRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListInstancesOfUserResponseBodyDataListAdminList(TeaModel):
    def __init__(self, display_name=None, email=None, extension=None, instance_id=None, login_name=None, mobile=None,
                 role_id=None, role_name=None, user_id=None, work_mode=None):
        self.display_name = display_name  # type: str
        self.email = email  # type: str
        self.extension = extension  # type: str
        self.instance_id = instance_id  # type: str
        self.login_name = login_name  # type: str
        self.mobile = mobile  # type: str
        self.role_id = role_id  # type: str
        self.role_name = role_name  # type: str
        self.user_id = user_id  # type: str
        self.work_mode = work_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListAdminList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.mobile is not None:
            result['Mobile'] = self.mobile
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_mode is not None:
            result['WorkMode'] = self.work_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('Mobile') is not None:
            self.mobile = m.get('Mobile')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkMode') is not None:
            self.work_mode = m.get('WorkMode')
        return self


class ListInstancesOfUserResponseBodyDataListNumberListSkillGroups(TeaModel):
    def __init__(self, description=None, display_name=None, instance_id=None, name=None, phone_number_count=None,
                 skill_group_id=None, user_count=None):
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.phone_number_count = phone_number_count  # type: int
        self.skill_group_id = skill_group_id  # type: str
        self.user_count = user_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberListSkillGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.phone_number_count is not None:
            result['PhoneNumberCount'] = self.phone_number_count
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PhoneNumberCount') is not None:
            self.phone_number_count = m.get('PhoneNumberCount')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class ListInstancesOfUserResponseBodyDataListNumberList(TeaModel):
    def __init__(self, active=None, city=None, contact_flow_id=None, instance_id=None, number=None, province=None,
                 skill_groups=None, usage=None, user_id=None):
        self.active = active  # type: bool
        self.city = city  # type: str
        self.contact_flow_id = contact_flow_id  # type: str
        self.instance_id = instance_id  # type: str
        self.number = number  # type: str
        self.province = province  # type: str
        self.skill_groups = skill_groups  # type: list[ListInstancesOfUserResponseBodyDataListNumberListSkillGroups]
        self.usage = usage  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.skill_groups:
            for k in self.skill_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataListNumberList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.city is not None:
            result['City'] = self.city
        if self.contact_flow_id is not None:
            result['ContactFlowId'] = self.contact_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.number is not None:
            result['Number'] = self.number
        if self.province is not None:
            result['Province'] = self.province
        result['SkillGroups'] = []
        if self.skill_groups is not None:
            for k in self.skill_groups:
                result['SkillGroups'].append(k.to_map() if k else None)
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ContactFlowId') is not None:
            self.contact_flow_id = m.get('ContactFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        self.skill_groups = []
        if m.get('SkillGroups') is not None:
            for k in m.get('SkillGroups'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberListSkillGroups()
                self.skill_groups.append(temp_model.from_map(k))
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListInstancesOfUserResponseBodyDataList(TeaModel):
    def __init__(self, admin_list=None, aliyun_uid=None, console_url=None, description=None, domain_name=None,
                 id=None, name=None, number_list=None, status=None):
        self.admin_list = admin_list  # type: list[ListInstancesOfUserResponseBodyDataListAdminList]
        self.aliyun_uid = aliyun_uid  # type: str
        self.console_url = console_url  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.number_list = number_list  # type: list[ListInstancesOfUserResponseBodyDataListNumberList]
        self.status = status  # type: str

    def validate(self):
        if self.admin_list:
            for k in self.admin_list:
                if k:
                    k.validate()
        if self.number_list:
            for k in self.number_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdminList'] = []
        if self.admin_list is not None:
            for k in self.admin_list:
                result['AdminList'].append(k.to_map() if k else None)
        if self.aliyun_uid is not None:
            result['AliyunUid'] = self.aliyun_uid
        if self.console_url is not None:
            result['ConsoleUrl'] = self.console_url
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['NumberList'] = []
        if self.number_list is not None:
            for k in self.number_list:
                result['NumberList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.admin_list = []
        if m.get('AdminList') is not None:
            for k in m.get('AdminList'):
                temp_model = ListInstancesOfUserResponseBodyDataListAdminList()
                self.admin_list.append(temp_model.from_map(k))
        if m.get('AliyunUid') is not None:
            self.aliyun_uid = m.get('AliyunUid')
        if m.get('ConsoleUrl') is not None:
            self.console_url = m.get('ConsoleUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.number_list = []
        if m.get('NumberList') is not None:
            for k in m.get('NumberList'):
                temp_model = ListInstancesOfUserResponseBodyDataListNumberList()
                self.number_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesOfUserResponseBodyData(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, total_count=None):
        self.list = list  # type: list[ListInstancesOfUserResponseBodyDataList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = ListInstancesOfUserResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesOfUserResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListInstancesOfUserResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListInstancesOfUserResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInstancesOfUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListInstancesOfUserResponseBody

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInstancesOfUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstancesOfUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntervalAgentReportRequest(TeaModel):
    def __init__(self, agent_id=None, end_time=None, instance_id=None, interval=None, media_type=None,
                 start_time=None):
        self.agent_id = agent_id  # type: str
        self.end_time = end_time  # type: long
        self.instance_id = instance_id  # type: str
        self.interval = interval  # type: str
        self.media_type = media_type  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListIntervalAgentReportResponseBodyDataBack2Back(TeaModel):
    def __init__(self, agent_handle_rate=None, answer_rate=None, average_customer_ring_time=None,
                 average_ring_time=None, average_talk_time=None, calls_agent_handled=None, calls_answered=None,
                 calls_customer_answered=None, calls_dialed=None, customer_answer_rate=None, max_customer_ring_time=None,
                 max_ring_time=None, max_talk_time=None, total_customer_ring_time=None, total_ring_time=None,
                 total_talk_time=None):
        self.agent_handle_rate = agent_handle_rate  # type: float
        self.answer_rate = answer_rate  # type: float
        self.average_customer_ring_time = average_customer_ring_time  # type: float
        self.average_ring_time = average_ring_time  # type: float
        self.average_talk_time = average_talk_time  # type: float
        self.calls_agent_handled = calls_agent_handled  # type: long
        self.calls_answered = calls_answered  # type: long
        self.calls_customer_answered = calls_customer_answered  # type: long
        self.calls_dialed = calls_dialed  # type: long
        self.customer_answer_rate = customer_answer_rate  # type: float
        self.max_customer_ring_time = max_customer_ring_time  # type: long
        self.max_ring_time = max_ring_time  # type: long
        self.max_talk_time = max_talk_time  # type: long
        self.total_customer_ring_time = total_customer_ring_time  # type: long
        self.total_ring_time = total_ring_time  # type: long
        self.total_talk_time = total_talk_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntervalAgentReportResponseBodyDataBack2Back, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_handle_rate is not None:
            result['AgentHandleRate'] = self.agent_handle_rate
        if self.answer_rate is not None:
            result['AnswerRate'] = self.answer_rate
        if self.average_customer_ring_time is not None:
            result['AverageCustomerRingTime'] = self.average_customer_ring_time
        if self.average_ring_time is not None:
            result['AverageRingTime'] = self.average_ring_time
        if self.average_talk_time is not None:
            result['AverageTalkTime'] = self.average_talk_time
        if self.calls_agent_handled is not None:
            result['CallsAgentHandled'] = self.calls_agent_handled
        if self.calls_answered is not None:
            result['CallsAnswered'] = self.calls_answered
        if self.calls_customer_answered is not None:
            result['CallsCustomerAnswered'] = self.calls_customer_answered
        if self.calls_dialed is not None:
            result['CallsDialed'] = self.calls_dialed
        if self.customer_answer_rate is not None:
            result['CustomerAnswerRate'] = self.customer_answer_rate
        if self.max_customer_ring_time is not None:
            result['MaxCustomerRingTime'] = self.max_customer_ring_time
        if self.max_ring_time is not None:
            result['MaxRingTime'] = self.max_ring_time
        if self.max_talk_time is not None:
            result['MaxTalkTime'] = self.max_talk_time
        if self.total_customer_ring_time is not None:
            result['TotalCustomerRingTime'] = self.total_customer_ring_time
        if self.total_ring_time is not None:
            result['TotalRingTime'] = self.total_ring_time
        if self.total_talk_time is not None:
            result['TotalTalkTime'] = self.total_talk_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentHandleRate') is not None:
            self.agent_handle_rate = m.get('AgentHandleRate')
        if m.get('AnswerRate') is not None:
            self.answer_rate = m.get('AnswerRate')
        if m.get('AverageCustomerRingTime') is not None:
            self.average_customer_ring_time = m.get('AverageCustomerRingTime')
        if m.get('AverageRingTime') is not None:
            self.average_ring_time = m.get('AverageRingTime')
        if m.get('AverageTalkTime') is not None:
            self.average_talk_time = m.get('AverageTalkTime')
        if m.get('CallsAgentHandled') is not None:
            self.calls_agent_handled = m.get('CallsAgentHandled')
        if m.get('CallsAnswered') is not None:
            self.calls_answered = m.get('CallsAnswered')
        if m.get('CallsCustomerAnswered') is not None:
            self.calls_customer_answered = m.get('CallsCustomerAnswered')
        if m.get('CallsDialed') is not None:
            self.calls_dialed = m.get('CallsDialed')
        if m.get('CustomerAnswerRate') is not None:
            self.customer_answer_rate = m.get('CustomerAnswerRate')
        if m.get('MaxCustomerRingTime') is not None:
            self.max_customer_ring_time = m.get('MaxCustomerRingTime')
        if m.get('MaxRingTime') is not None:
            self.max_ring_time = m.get('MaxRingTime')
        if m.get('MaxTalkTime') is not 