# generated by datamodel-codegen:
#   filename:  process_schema.json
#   timestamp: 2024-02-07T08:09:26+00:00

from datetime import date, datetime
from enum import Enum
from typing import List, Optional, Union

from omnipy.data.model import Model
import omnipy.util._pydantic as pyd

from . import (comment_schema,
               data_schema,
               material_schema,
               process_parameter_value_schema,
               protocol_schema,
               sample_schema,
               source_schema)
from .validators import date_to_iso_format


class FieldType(Enum):
    Process = 'Process'


class IsaProcessOrProtocolApplicationSchema(pyd.BaseModel):
    class Config:
        extra = pyd.Extra.forbid
        use_enum_values = True

    field_id: Optional[str] = pyd.Field(None, alias='@id')
    field_context: Optional[str] = pyd.Field(None, alias='@context')
    field_type: Optional[FieldType] = pyd.Field(None, alias='@type')
    name: Optional[str] = None
    executesProtocol: Optional[protocol_schema.IsaProtocolModel] = None
    parameterValues: Optional[List[
        process_parameter_value_schema.IsaProcessParameterValueModel]] = None
    performer: Optional[str] = None
    date: Optional[Union[datetime, date, pyd.constr(max_length=0)]] = None
    previousProcess: Optional['IsaProcessOrProtocolApplicationModel'] = None
    nextProcess: Optional['IsaProcessOrProtocolApplicationModel'] = None
    inputs: Optional[List[Union[
        source_schema.IsaSourceModel,
        sample_schema.IsaSampleModel,
        data_schema.IsaDataModel,
        material_schema.IsaMaterialModel,
    ]]] = None
    outputs: Optional[List[Union[
        sample_schema.IsaSampleModel,
        data_schema.IsaDataModel,
        material_schema.IsaMaterialModel,
    ]]] = None
    comments: Optional[List[comment_schema.IsaCommentModel]] = None

    _date_to_iso_format = pyd.validator('date', allow_reuse=True)(date_to_iso_format)


class IsaProcessOrProtocolApplicationModel(Model[IsaProcessOrProtocolApplicationSchema]):
    ...


IsaProcessOrProtocolApplicationSchema.update_forward_refs()
