from typing import TYPE_CHECKING, Protocol

if TYPE_CHECKING:
    from collections.abc import Iterable
    from typing import Any


class Cache(Protocol):
    def get(self, key: str, /) -> "Any | None": ...
    def set(self, key: str, value: object, /, *, ttl: int | None = None, tags: "Iterable[str]" = ()) -> None: ...
    def delete(self, key: str, /) -> None: ...
    def contains(self, key: str, /) -> bool: ...
    def expire(self, tag: "str | Iterable[str]", /) -> None: ...

    def __getitem__(self, key: str, /) -> "Any": ...
    def __setitem__(self, key: str, value: object, /) -> None: ...
    def __delitem__(self, key: str, /) -> None: ...
    def __contains__(self, key: str, /) -> bool: ...


class AsyncCache(Protocol):
    async def get(self, key: str, /) -> "Any | None": ...
    async def set(self, key: str, value: object, /, *, ttl: int | None = None, tags: "Iterable[str]" = ()) -> None: ...
    async def delete(self, key: str, /) -> None: ...
    async def contains(self, key: str, /) -> bool: ...
    async def expire(self, tag: "str | Iterable[str]", /) -> None: ...


class PurgeAPI(Protocol):
    """Protocol for the purge API object."""

    def invalidate_by_tag(self, tag: "str | Iterable[str]") -> "Any":
        """Invalidate cache entries by tag."""
        ...

    def dangerously_delete_by_tag(
        self,
        tag: "str | Iterable[str]",
        *,
        revalidation_deadline_seconds: int | None = None,
    ) -> "Any":
        """Dangerously delete cache entries by tag."""
        ...


class AsyncPurgeAPI(Protocol):
    """Protocol for the asyncio purge API object."""

    async def invalidate_by_tag(self, tag: "str | Iterable[str]") -> "Any":
        """Invalidate cache entries by tag."""
        ...

    async def dangerously_delete_by_tag(
        self,
        tag: "str | Iterable[str]",
        *,
        revalidation_deadline_seconds: int | None = None,
    ) -> "Any":
        """Dangerously delete cache entries by tag."""
        ...
