# Generated by Django Database Optimization

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_twilio_call', '0001_initial'),
    ]

    operations = [
        # Agent model optimizations
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['is_active', 'status', 'last_status_change'], name='agent_activity_idx'),
        ),
        migrations.AddIndex(
            model_name='agent',
            index=models.Index(fields=['status', 'is_active'], name='agent_routing_idx'),
        ),

        # Call model optimizations
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['status', 'created_at'], name='call_status_time_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['created_at', 'direction', 'status'], name='call_analytics_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['from_number', 'created_at'], name='call_from_lookup_idx'),
        ),
        migrations.AddIndex(
            model_name='call',
            index=models.Index(fields=['to_number', 'created_at'], name='call_to_lookup_idx'),
        ),

        # CallLog model optimizations - removed duplicates that already exist in 0001
        # AgentActivity model optimizations - removed duplicates that already exist in 0001
        # Removed raw SQL operations that referenced incorrect column names
    ]